/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include "b_common.h"

int bi_getdrform(int dno, int *inf)
{
	REGS	i_regs;
	REGS	o_regs;

	i_regs.d0 = INT_GETDRFORM;;
	i_regs.d1 = dno & 0xffff;							/* Drive number		*/

	_intbios(&i_regs, &o_regs);

	if ( (int)o_regs.d1 == 0) {							/* Normal termination		*/
		inf[0] = (int)((o_regs.d2 >> 8) & 0xff);		/* Maximum cylinder number	*/
		inf[1] = (int)(o_regs.d2 & 0xff);				/* Maximum head number		*/
		inf[2] = (int)(o_regs.d3 & 0xff);				/* Maximum sector number	*/
		inf[3] = (int)(( o_regs.d3 >> 8) & 0xff);		/* Sector size				*/
		return(0);
	} else {											/* Abnormal termination		*/
		BIOSerr = (int)o_regs.d1;						/* Set error code			*/
		return(-1);
	}
}
