/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include "b_common.h"

int bi_setdrform(int dno, int cyl, int hed, int secnt, int secsize)
{
	REGS	i_regs;
	REGS	o_regs;

	i_regs.d0 = INT_SETDRFORM;
	i_regs.d1 = dno & 0xffff;							/* Drive number		*/
	i_regs.d2 = cyl & 0xffff;							/* Cylinder number	*/
	i_regs.d2 = ( i_regs.d2 << 8) | (hed   & 0xffff);	/* Head number		*/
	i_regs.d3 = secsize & 0xffff;						/* Sector size		*/
	i_regs.d3 = ( i_regs.d3 << 8) | (secnt & 0xffff);	/* Maximum sector number	*/

	_intbios( &i_regs, &o_regs);

	if ( (int)o_regs.d1 == 0) {							/* Normal termination	*/
		return(0);
	} else {											/* Abnormal termination	*/
		BIOSerr = (int)o_regs.d1;						/* Set error code		*/
		return(-1);
	}
}
