/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include "b_common.h"

int bi_sysread(void *rbuf)
{
	REGS	i_regs;
	REGS	o_regs;

	i_regs.d0 = INT_SYSREAD;
	i_regs.d1 = 1;										/* Drive number			*/
	i_regs.a2 = (long)rbuf;								/* Read buffer address	*/

	_intbios( &i_regs, &o_regs);

	if ((int)o_regs.d1 == 0) {							/* Normal termination	*/
		return(0);
	} else {											/* Abnormal termination	*/
		BIOSerr = (int)o_regs.d1;						/* Set error code		*/
		return(-1);
	}
}
