/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include "b_common.h"

int bi_cominit(int comdev, int baud, int pulse, int timout)
{
	REGS	i_regs;
	REGS	o_regs;

	i_regs.d0 = INT_COMINIT;
	i_regs.d1 = comdev & 0xffff;						/* Communication system	*/
	i_regs.d2 = baud   & 0xffff;						/* Baud rate			*/
	if (comdev == 1) {
		i_regs.a1 = pulse & 0xffff;						/* Pulse width			*/
	}
	i_regs.a2 = timout & 0xffff;						/* Time-out value		*/

	_intbios(&i_regs, &o_regs);

	if ((int)o_regs.d1 == 0) {
		return(0);
	} else {
		BIOSerr = (int)o_regs.d1;						/* Error code			*/
		return(-1);
	}
}
