/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include "b_common.h"

int bi_complread(char *cdat, int clen)
{
	REGS	i_regs;
	REGS	o_regs;

	i_regs.d0 = INT_COMPLREAD;
	i_regs.d1 = clen & 0xffff;					/* Number of characters	*/
	i_regs.a1 = (long)cdat;						/* Received data		*/

	_intbios(&i_regs, &o_regs);

	if ((int)o_regs.d1 == 0) {					/* Normal termination	*/
		return((int)o_regs.d2);					/* Number of characters received	*/
	} else {									/* Abnormal termination	*/
		BIOSerr = (int)o_regs.d3;
		return(-1);
	}
}
