/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include "b_common.h"

int bi_complreadn(char *cdat, int clen, int *num)
{
	REGS	i_regs;
	REGS	o_regs;

	i_regs.d0 = INT_COMPLREAD;
	i_regs.d1 = clen & 0xffff;			/* Number of characters	*/
	i_regs.a1 = (long)cdat;				/* Received data		*/

	_intbios(&i_regs, &o_regs);

	if ((int)o_regs.d1 == 0) {			/* Normal termination	*/
		*num = (int)o_regs.d2;			/*  Number of characters received actually*/
		return(0);
	} else {							/* Abnormal termination	*/
		*num = (int)o_regs.d2;
		BIOSerr = (int)o_regs.d3;
		return(-1);
	}
}
