/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include "b_common.h"

int bi_complwrite(char *cdat, int clen, int *num)
{
	REGS	i_regs;
	REGS	o_regs;

	i_regs.d0 = INT_COMPLWRITE;
	i_regs.d1 = clen & 0xffff;							/* Number of characters	*/
	i_regs.a1 = (long)cdat;								/* Transmition data		*/

	_intbios(&i_regs, &o_regs);

	switch((int)o_regs.d1) {
		case	0:
			*num = (int)o_regs.d2;
			return(0);

		case	0xfffe:
			*num = (int)o_regs.d2;
			return(-2);

		case	0xffff:
			*num = (int)o_regs.d2;
			BIOSerr = (int)o_regs.d3;
			return(-1);

		default:
			break;

	}
	
	return(0);

}
