/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include "b_common.h"

int *bi_tmset(int timkind, int priority, int cnt, void (*func)())
{
	REGS	i_regs;
	REGS	o_regs;

	i_regs.d0 = INT_TMSET;
	i_regs.d1 = priority & 0xff;						/* Priority@				*/
	i_regs.d1 = (i_regs.d1 << 8) | (timkind & 0xff);	/* Timer ID					*/
	i_regs.d2 = cnt & 0xffff;							/* Timer count				*/
	i_regs.a1 = (long)func;								/* Timer routine address	*/

	_intbios(&i_regs, &o_regs);

	if ((int)o_regs.d1 == 0) {							/* Normal termination		*/
		return((int *)o_regs.a0);
	} else {											/* Abnormal termination		*/
		return((int *)-1);
	}
}
