/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include "dos.h"

/*==========================================================================*/
/*======================  Interrupt number definition   ====================*/
/*==========================================================================*/

#define INT_KEY		23 0x17
#define INT_DISK	24 0x18
#define INT_RS		25 0x19
#define INT_RTC		26 0x1a
#define INT_CLOCK	27 0x1b
#define INT_TIMER	28 0x1c
#define INT_OTHER	29 0x1d

/*==================================  KEY  ==================================*/
#define INT_GETBTN		0x117
#define INT_SENSBTN		0x217
#define INT_CLRBTN		0x317
#define INT_CHATPSBTN	0x417
#define INT_CHATJKBTN	0x517

/*=================================  DISK  ==================================*/
#define INT_SECREAD		0x118
#define INT_SECWRITE	0x218
#define INT_FORMAT		0x318
#define INT_GETDRFORM	0x418
#define INT_SETDRFORM	0x518
#define INT_WRFLUSH		0xb18
#define INT_SYSREAD		0xd18
#define INT_SYSWRITE	0xe18

/*=============================  RS-232C / IrDA  ============================*/
#define INT_COMINIT		0x119
#define INT_COMWRITE	0x219
#define INT_COMREAD		0x319
#define INT_COMPLREAD	0x419
#define INT_COMCLR		0x519
#define INT_COMRNUM		0x619
#define INT_COMOPEN		0x719
#define INT_COMCLOSE	0x819
#define INT_COMPLWRITE	0x919

/*==================================  RTC  ==================================*/
#define INT_TMREAD		0x11a
#define INT_TMWRITE		0x21a
#define INT_DTREAD		0x31a
#define INT_DTWRITE		0x41a

/*=================================  TIMER  =================================*/
#define INT_TMSET		0x11c
#define INT_TMDEL		0x21c

/*=================================  OTHER  =================================*/
#define INT_REBOOT		0x11d
#define INT_BUZZER		0x21d
#define INT_CPUSUSP		0x31d
#define INT_CPUSPEED	0x41d
#define INT_POWERREAD	0x51d
#define INT_GETCHARGE	0x61d
#define INT_CLRCHARGE	0x71d
#define INT_GETPOWER	0x81d
#define INT_POWERINC	0x91d
#define INT_EL			0xa1d
#define INT_BUZZINIT	0xb1d
#define INT_CURRENT		0xc1d
#define INT_SETPOWER	0xd1d
#define INT_MELODY		0xe1d
#define INT_CANMELODY	0xf1d
#define INT_POWERREAD2	0x101d
#define INT_27VERROR	0x111d

#define INT_VECT		0x15

/*===========================================================================*/
/*========================  Port address definition  ========================*/
/*===========================================================================*/
#define STATUS_PORT	0x50
#define KEY_PORT	0x51

/*===========================================================================*/
/*===========================  Others definition  ===========================*/
/*===========================================================================*/
#define	ON			1
#define OFF			0


/*===========================================================================*/
/*=========================  Prototype definition  ==========================*/
/*===========================================================================*/
void _intbios(void *, void *);

/*===========================================================================*/
/*======================  Public variable definition  =======================*/
/*===========================================================================*/
extern int BIOSerr;

