/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*																			*/
/* Function	: Definitions and structures formnDOS i/f, software 			*/
/*			 interrupt i/f.													*/
/*																			*/
/*==========================================================================*/


/************************************************
 * 20100 CPU registers software interrupts.		*
 ***********************************************/

typedef struct regs{
	unsigned long	d0;
	unsigned long	d1;
	unsigned long	d2;
	unsigned long	d3;
	unsigned long	a0;
	unsigned long	a1;
	unsigned long	a2;
	unsigned int	mdr;
	unsigned int	psw;
	}REGS;	
			

/************************************************
 * 8086 CPU word registers						*
 ***********************************************/
struct wordregs86 {
	unsigned int ax;
	unsigned int bx;
	unsigned int cx;
	unsigned int dx;
	unsigned int si;
	unsigned int di;
	unsigned int ds;
	unsigned int es;
	unsigned int cs;
	unsigned int cflag;
	unsigned int reserve[3];
	};
/************************************************
 * 8086 CPU byte registers						*
 ***********************************************/
struct byteregs86 {
	unsigned char al, ah;
	unsigned char bl, bh;
	unsigned char cl, ch;
	unsigned char dl, dh;
	};

/************************************************
 * 8086 CPU registers structure for dos call. 	*
 ***********************************************/
typedef union regs86 {
	struct wordregs86 x;
	struct byteregs86 h;
	}REGS86;


