/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include  "common.h"

/*======================================================================*/
/*Functoin	:fp_seg              										*/
/*																		*/
/*Feature	:Get segment address from linear address	@@ 			*/
/*																		*/
/*Syntax	:int fp_seg(void *)											*/
/*																		*/
/*Input		:Linear address@@@@@@@@@@@@@@@	@			*/
/*																		*/
/*Output	:None@@@@@@											*/
/*																		*/
/*Function value	:Segment address	@@@@@@@@@@@@@		*/
/*																		*/
/*======================================================================*/
int fp_seg(void *seg)
{
	int		temp;
	long	addr;

	addr = (long)seg & 0xffffff;

	temp = (int)((addr >> 16) & 0x0000ff);
	return(temp);
}
/*======================================================================*/
/*Function	:fp_off              										*/
/*																		*/
/*Feature	:Get offset address from linear address@@					*/
/*																		*/
/*Syntax	:int fp_off(void *)											*/
/*																		*/
/*Input		:Linear address@@@@@@@@@@@@@@@	@			*/
/*																		*/
/*Output	:None@@@@@@											*/
/*																		*/
/*Function value	:Offset address@@@@@@@@@@@@@@@@		*/
/*																		*/
/*======================================================================*/
int fp_off(void *offset)
{
	int 	temp;
	long	addr;

	addr = (long)offset & 0xffffff;

	temp = (int)(addr & 0x00ffff);
	return(temp);
}
/*======================================================================*/
/*Functon	:linear              										*/
/*																		*/
/*Feature	:Get linear address from segment address and offset address	*/
/*																		*/
/*Syntax	:long linear(int, int)										*/
/*																		*/
/*Input		:Segment address , Offset address@@@	@					*/
/*																		*/
/*Output	:None@@@@@@											*/
/*																		*/
/*Function value	:Linear address@@@@@@@@@@@@@@@@		*/
/*																		*/
/*======================================================================*/
long linear(int seg, int offset)
{
	long	addr;
	long	temp;
	long	temp2;

	temp 	= (long)(seg & 0xffff);
	temp2 	= (long)(offset & 0xffff);

	addr	= (temp << 16) & 0xffff0000;
	addr	= addr | temp2;

	return(addr);
}
