/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include  "regs.h"
#include  "common.h"

int dos_cinout(int mode, char *chcode)
{
	REGS86	i_regs86;
	
	i_regs86.h.ah = 0x06;

	switch( mode) {
		case	0	:										/* Input mode */
						i_regs86.h.dl = 0xff;

						_intdos(&i_regs86);

						if( Z_FLAG == OFF){
							*chcode = i_regs86.h.al;
							return(0);
						} else {
							return(-1);
						}

		case	1	:										/* Output mode */
						i_regs86.h.dl = *chcode;

						_intdos(&i_regs86);

						return(0);

		default		:										/* Error */
						return(-1);
	}
}

