/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include  "regs.h"
#include  "common.h"

int dos_kflush(int func, char *str, int len)
{
	REGS86	i_regs86;
	
	i_regs86.h.ah = 0xc;
	i_regs86.h.al = func;

	switch(func) {
		case 0x6	:
						i_regs86.h.dl = 0xff;
						break;
		case 0xa	:
						str[0] = (char)len;
						i_regs86.x.ds = fp_seg(str);		/*%x2*/
						i_regs86.x.dx = fp_off(str);		/*%x2*/
						break;
		default		:
						break;
	}

	_intdos(&i_regs86);

	switch(func){
		case 0x1	:
						*str = (int)i_regs86.h.al;
						return((int)i_regs86.h.al);
		case 0x6	:
						if( Z_FLAG == OFF){
							*str = i_regs86.h.al;
							return((int)i_regs86.h.al);
						} else {
							return(-1);
						}
		case 0x7	:
						*str = i_regs86.h.al;
						return((int)i_regs86.h.al);
		case 0x8	:
						*str = i_regs86.h.al;
						return((int)i_regs86.h.al);
		case 0xa	:
						return( (int)str[1]);		/*%x2*/
		default		:
						return(0);
	}
}
