/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include  "regs.h"
#include  "common.h"

void dos_gettdrive(int drv, void *drvp)
{
	REGS86	i_regs86;

	int		*idrvp;

	idrvp = (int *)drvp;

	i_regs86.h.ah = 0x1c;
	i_regs86.h.dl = (char)drv;

	_intdos(&i_regs86);

	*idrvp = (int)i_regs86.h.al;			/* Sector number per 1 cluster 	*/
	++idrvp;
	*idrvp = i_regs86.x.cx;					/* Byte per 1 sector			*/
	++idrvp;
	*idrvp = i_regs86.x.dx;					/* Cluster number per 1 drive	*/
	++idrvp;
	*idrvp = i_regs86.x.bx;					/* FAT ID address (OFFSET)		*/
	++idrvp;
	*idrvp = i_regs86.x.ds;					/* FAT ID address (SEGMENT)		*/

	return;
}

