/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include  "regs.h"
#include  "common.h"

int dos_fparse(unsigned char *fcbp, char *name, int ctrl)
{
	REGS86	i_regs86;

	i_regs86.h.ah = 0x29;
	i_regs86.h.al = (char)ctrl;			/* Code that controls the analysis operation */
	i_regs86.x.es = fp_seg(fcbp);
	i_regs86.x.di = fp_off(fcbp);
	i_regs86.x.ds = fp_seg(name);		/* Address of string to be analyzed	*/
	i_regs86.x.si = fp_off(name);

	_intdos(&i_regs86);

	switch(i_regs86.h.al) {
		case	0x00	:
							return(0);			/* wildcard is not used		*/
		case	0x01	:
							return(1);			/* wildcard is used			*/
		default			:
							return(-1);			/* Drive name is invalid	*/
	}
}
