/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include  "regs.h"
#include  "common.h"

int dos_ctrl_c( int func, int sstat, int *gstat)
{
	REGS86	i_regs86;

	i_regs86.h.ah = 0x33;
	i_regs86.h.al = (char)func;					/* Functon	  @0:get 1:set		*/
	if (func == 1) {							/* Setting mode  0:OFF 1:ON		*/
		i_regs86.h.dl = (char)sstat;
	}

	_intdos(&i_regs86);
	
	if (i_regs86.h.al != 0xff) {				/* Normal termination */
		if (func == 0) {						/* Getting mode */
			*gstat = i_regs86.h.dl & 0xff;		/* flag status */
		}
		return(0);
	} else {									/* Ubnormal termination */
		return(-1);
	}
}
