/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include  "regs.h"
#include  "common.h"

int dos_dfspace(int dno, int *dfdata)
{
	REGS86	i_regs86;

	i_regs86.h.ah = 0x36;
	i_regs86.h.dl = (char)dno;			/* Drive number				*/

	_intdos(&i_regs86);

	if(i_regs86.x.ax == 0xffff){		/* drive number Invalid		*/
		return(-1);
	} else {							/* drive number valid		*/
		*dfdata = i_regs86.x.ax;		/* Sector per 1 cluster		*/
		++dfdata;
		*dfdata = i_regs86.x.bx;		/* Possible cluster number	*/
		++dfdata;
		*dfdata = i_regs86.x.cx;		/* Byte per 1 sector    	*/
		++dfdata;
		*dfdata = i_regs86.x.dx;		/* Cluster number existed in a drive	*/
		return(0);
	}
}
