/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include  "regs.h"
#include  "common.h"

int dos_write(int handle, char *pbuffer, unsigned int nbytes)
{
	REGS86	i_regs86;

	i_regs86.h.ah = 0x40;
	i_regs86.x.ds = fp_seg(pbuffer);
	i_regs86.x.dx = fp_off(pbuffer);
	i_regs86.x.cx = nbytes;						/* Write byte				*/
	i_regs86.x.bx = handle;						/* File handle				*/

	_intdos(&i_regs86);

	if(C_FLAG == OFF){
		return(i_regs86.x.ax);					/* Written byte actually	*/
	} else {
		DOSerr = i_regs86.x.ax;					/* Set error status			*/
		return(-1);
	}
}
