/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include  "regs.h"
#include  "common.h"

long dos_seek(int handle, char mode, unsigned long offset)
{
	REGS86	i_regs86;
	long	nowoffset;
	long	temp;

	i_regs86.h.ah = 0x42;
	i_regs86.h.al = mode;						/* Mode					*/
	i_regs86.x.cx = (int)(offset >> 16);		/* Hi  16bit			*/
	i_regs86.x.dx = (int)(offset & 0xffff);		/* Low 16bit			*/
	i_regs86.x.bx = handle;						/* File handle			*/

	_intdos(&i_regs86);

	if(C_FLAG == OFF){
		temp = (long)i_regs86.x.dx;
		nowoffset = (temp * 0x10000L) + (long)i_regs86.x.ax;
		return(nowoffset);
	} else {
		DOSerr = i_regs86.x.ax;					/* Set error status			*/
		return(-1);
	}
}
