/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include  "regs.h"
#include  "common.h"

int dos_execute( int func, char *prog, char *pcmtail)
{
	REGS86	i_regs86;
	
	i_regs86.h.ah = 0x4b;
	i_regs86.h.al = (char)func;
	i_regs86.x.ds = fp_seg(prog);
	i_regs86.x.dx = fp_off(prog);
	i_regs86.x.es = fp_seg(pcmtail);
	i_regs86.x.bx = fp_off(pcmtail);

	_intdos(&i_regs86);

	if (C_FLAG == OFF){							/* Carry flag:Off			*/
		return(0);								/* Normal termination		*/
	} else {									/* Carry flag:On			*/
		DOSerr = i_regs86.x.ax;					/* Set error status			*/
		return(-1);								/* Abnormal termination		*/
	}
}
