/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include  "regs.h"
#include  "common.h"

int dos_rename(char *oldpath, char *newpath)
{
	REGS86	i_regs86;
	
	i_regs86.h.ah = 0x56;
	i_regs86.x.ds = fp_seg(oldpath);
	i_regs86.x.dx = fp_off(oldpath);
	i_regs86.x.es = fp_seg(newpath);
	i_regs86.x.di = fp_off(newpath);

	_intdos(&i_regs86);

	if (C_FLAG == OFF){							/* Carry flag:Off		 	*/
		return(0);								/* Normal termination		*/
	} else {									/* Carry flag:On			*/
		DOSerr = i_regs86.x.ax;					/* Set error status			*/
		return(-1);								/* Abnormal termination		*/
	}
}
