/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include  "regs.h"
#include  "common.h"

long dos_fltime(int handle, int func, int packdate, int packtime)
{
	REGS86	i_regs86;
	
	long	temp;
	long	temp2;

	i_regs86.h.ah = 0x57;
	i_regs86.x.bx = handle;						/* File handle				*/
	i_regs86.h.al = (char)func;					/* Function code			*/

	if (func == 0x01) {
		i_regs86.x.cx = packtime;
		i_regs86.x.dx = packdate;
	}

	_intdos(&i_regs86);

	if (func == 0x00) {							/* Obtain date and time		*/
		if (C_FLAG == OFF){
			temp 	= i_regs86.x.dx;			/* Get date					*/
			temp2	= i_regs86.x.cx;			/* Get time					*/
			
			temp = (temp << 16) & 0xffff0000;	/* Shift date to Hi-word	*/
			temp = temp | temp2;				/* Pack date and time		*/
			return(temp);
		}
	} else {									/* Setting of data and time	*/
		if (C_FLAG == OFF){
			return(0);
		}
	}
	
	DOSerr = i_regs86.x.ax;
	return(-1L);
}
