/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include  "regs.h"
#include  "common.h"

int dos_ioc_cflags(int handle, int func, int *stat)
{
	REGS86	i_regs86;

	if ( func != 0 && func != 1) {
		DOSerr = 0x01;							/* Set error status			*/
		return(-1);
	}
	i_regs86.h.ah = 0x44;
	i_regs86.h.al = (char)func;					/* Function@0:Get@1:Set	*/
	i_regs86.x.bx = handle;						/* File handle				*/
	if ( func == 1) {
		i_regs86.x.dx = *stat;
	}
	_intdos(&i_regs86);

	if (func == 0) {							/* Getting mode				*/
		if (C_FLAG == OFF){
			*stat = i_regs86.x.dx;				/* Set device information	*/
			return(0);
		}
	} else {									/* Setting mode			*/
		if(C_FLAG == OFF){
			return(0);
		}
	}
	DOSerr = i_regs86.x.ax;						/* Set error status			*/
	return(-1);
}
