/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include  "regs.h"
#include  "common.h"

/*======================================================================*/
/*Function	:dos_ioc_chctrl		44_2									*/
/*																		*/
/*Feature	:Transmit/Receive the control data of character device		*/
/*																		*/
/*Syntax	:int dos_ioc_chctrl(int, int, char *, unsigned int)			*/
/*																		*/
/*Input		:Handle number,Mode,Data buffer address, Transfer Byte		*/
/*																		*/
/*Output	:Nomne														*/
/*																		*/
/*Function value: 0:Normal termination -1:Abnormal termination			*/
/*																		*/
/*======================================================================*/
int dos_ioc_chctrl( int handle, int func, char *cp, unsigned int len)
{
	REGS86	i_regs86;

	switch( func) {
		case	0	:
						i_regs86.h.al = 0x02;	/* Data transmit	*/
						break;
		case	1	:
						i_regs86.h.al = 0x03;	/* Data Receive		*/
						break;
		default		:
						DOSerr = 0x01;			/* Set error status		*/
						return(-1);				/* Parameter error	 	*/
	}
	i_regs86.h.ah = 0x44;
	i_regs86.x.bx = handle;
	i_regs86.x.cx = len;
	i_regs86.x.ds = fp_seg(cp);
	i_regs86.x.dx = fp_off(cp);

	_intdos(&i_regs86);

	if(C_FLAG == OFF){							/* Carry flag: Off 			*/
		return(i_regs86.x.ax);					/* Read/Write Byte number	*/
	} else {									/* Carry flag: On			*/
		DOSerr = i_regs86.x.ax;					/* Set error status			*/
		return(-1);
	}
}
