/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include  "regs.h"
#include  "common.h"

/*======================================================================*/
/*Function	:dos_ioc_blctrl		44_3									*/
/*																		*/
/*Feature	:Transmit/Receive the control data of block device			*/
/*																		*/
/*Synta		:int dos_ioc_blctrl(int, int, char *, unsigned int)			*/
/*																		*/
/*Input		:Drive number,Mode,Data buffer address, Transfer Byte		*/
/*																		*/
/*Output	:None														*/
/*																		*/
/*Function value:  -1:Abnormal termination								*/
/*		Other than -1:Transmit byte number actually						*/
/*																		*/
/*======================================================================*/
int dos_ioc_blctrl(int drv,int func,char *cp,unsigned int len)
{
	REGS86	i_regs86;
	
	switch( func) {
		case	0	:
						i_regs86.h.al = 0x04;	/* Data transmit	*/
						break;
		case	1	:
						i_regs86.h.al = 0x05;	/* Data Receive 	*/
						break;
		default		:
						DOSerr = 0x01;
						return(-1);				/* Parameter error	*/
	}
	i_regs86.h.ah = 0x44;
	i_regs86.h.bl = (char)drv;
	i_regs86.x.cx = len;
	i_regs86.x.ds = fp_seg(cp);
	i_regs86.x.dx = fp_off(cp);
	
	_intdos(&i_regs86);

	if(C_FLAG == OFF){							/* Carry flag: Off 	*/
		return(i_regs86.x.ax);					/* Read/Write Byte number	*/
	} else {									/* Carry flag: On	*/
		DOSerr = i_regs86.x.ax;
		return(-1);
	}
}
