/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include  "regs.h"
#include  "common.h"

/*======================================================================*/
/*Function	:dos_ioc_chstat		44_4									*/
/*																		*/
/*Feature	:Obtain input/output status@@@@@@@@@@				*/
/*																		*/
/*Synta		:int dos_ioc_chstat(int, int)								*/
/*																		*/
/*Input		:Handle number,Mode				@@@@@@@				*/
/*																		*/
/*Output	:None														*/
/*																		*/
/*Function value:  1:Read/Write valid									*/
/*				   0:Read/Write invalid									*/
/*				  -1:Abnormal termination								*/
/*																		*/
/*======================================================================*/
int dos_ioc_chstat(int handle, int func)
{
	REGS86	i_regs86;
	
	switch(func) {
		case	0	:
						i_regs86.h.al = 0x06;	/* Getting input status		*/
						break;
		case	1	:
						i_regs86.h.al = 0x07;	/* Getting output status	*/
						break;
		default		:
						DOSerr = 0x01;			/* Set error status		*/
						return(-1);				/* Parameter error		*/
	}
	i_regs86.h.ah = 0x44;
	i_regs86.x.bx = handle;
	
	_intdos(&i_regs86);

	if (C_FLAG == OFF){							/* Carry flag:Off			*/
		if (i_regs86.h.al == 0) {
			return(0);							/* Read/Write desable		*/
		} else {
			return(1);							/* Read/Write Enable		*/
		}
	} else {									/* Carry flag:On			*/
		DOSerr = i_regs86.x.ax;					/* Set error status			*/
		return(-1);								/* Abnormal termiantion		*/
	}
}
