/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include		"lcdlib.h"
#include		"lcdfunc.h"

#include		<math.h>


VOID Calc_TrueCirclePoint( INT x, INT y, INT w, INT d, INT *cx, INT *cy)
{
	DOUBLE	rd, a ;
	INT		c1, c2 ;
	INT		dno ;

	d = d % 360 ;

	if ( d == 0) {
		*cx = x + w ;
		*cy = y ;
		return ;
	} else if ( d == 90) {
		*cx = x ;
		*cy = y + w ;
		return ;
	} else if ( d == 180) {
		*cx = x - w ;
		*cy = y ;
		return ;
	} else if ( d == 270) {
		*cx = x ;
		*cy = y - w;
		return ;
	}

	rd = ( DOUBLE)d ;
	rd = rd * 3.1415926 / 180.0 ;

	a = cos( rd) ;
	a = a * ( DOUBLE)w ;
	if ( a < 0) {
		a = a + ( -0.5) ;
	} else {
		a = a + 0.5 ;
	}

	c1 = ( UINT)a ;
	c1 = x + c1 ;
	*cx = c1 ;

	a = sin( rd) ;
	a = a * ( DOUBLE)w ;
	if ( a < 0) {
		a = a + ( -0.5) ;
	} else {
		a = a + 0.5 ;
	}

	c2 = ( UINT)a ;
	c2 = y + c2 ;

	*cy = c2 ;
}

/*===================================================================================
=	Calc_CirclePoint		ȉ~̂wxW߂
=
=	yďo`z	VOID  Calc_CirclePoint( INT x, INT y, INT xw, INT yw,
=												INT d, INT *cx, INT *cy)
=
=	ýz		INT		x ;			S_̂wW
=					INT		y ;			S_̂xW
=					INT		ww ;		wahbg
=					INT		yw ;		xahbg
=					INT		d ;			px
=					INT		*cx ;		ȉ~̂wW
=					INT		*cy ;		ȉ~̂xW
=
=	y^[lz	Ȃ
=
=	yez
=
===================================================================================*/

VOID Calc_CirclePoint( INT x, INT y, INT xw, INT yw, INT d, INT *cx, INT *cy)
{
	DOUBLE	dxw, dyw ;
	DOUBLE	tmp1, tmp2, xyw1, xyw2 ;
	DOUBLE	rd ;
	INT		td, c1, c2, vx, vy ;

	if ( d == 0) {
		*cx = x - xw ;
		*cy = y ;
		return ;
	} else if ( d == 90) {
		*cx = x ;
		*cy = y - yw ;
		return ;
	} else if ( d == 180) {
		*cx = x + xw ;
		*cy = y ;
		return ;
	} else if ( d == 270) {
		*cx = x ;
		*cy = y + yw;
		return ;
	}

	/*
	 *	a߂
	 */


	if ( xw > yw) {
		dxw = ( DOUBLE)xw ;
		dyw = ( DOUBLE)yw ;
		td = d ;
	} else {
		dyw = ( DOUBLE)xw ;
		dxw = ( DOUBLE)yw ;
		td = d + 90 ;
	}

	xyw1 = dxw / dyw ;
	xyw2 = dyw / dxw ;

	/*
	 *	WApxvZ
	 */

	td = td % 360 ;

	rd = ( DOUBLE)td ;
	rd = rd * 3.1415926 / 180.0 ;

	/*
	 *	WlZo
	 */

	tmp1 = xyw1 * tan( rd) ;
	tmp2 = atan( tmp1) ;

	tmp1 = dxw * cos( tmp2) ;

	c1 = ( UINT)( tmp1 + 0.5) ;

	tmp1 = dxw * dxw - tmp1 * tmp1 ;
	tmp1 = sqrt( tmp1) ;

	tmp2 = ( DOUBLE)dyw ;
	tmp2 = tmp1 * xyw2 ;

	c2 = ( UINT)( tmp2 + 0.5) ;

	if ( xw > yw) {
		vx = c1 ;
		vy = c2 ;
	} else {
		vx = c2 ;
		vy = c1 ;
	}

	if ( d < 90) {
		*cx = x - vx ;
		*cy = y - vy ;
	} else if ( d < 180) {
		*cx = x + vx ;
		*cy = y - vy ;
	} else if ( d < 270) {
		*cx = x + vx ;
		*cy = y + vy ;
	} else {
		*cx = x - vx ;
		*cy = y + vy ;
	}
}
