/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include		"lcdlib.h"
#include		"lcdfunc.h"


INT gv_circle( INT x, INT y, INT xw, INT yw, INT d1, INT d2, INT logic, ULONG style, UCHAR *cbuf)
{
	LONG			ret ;
	FNC_GVCIRCLE	ftbl;
	INT				cx, cy ;

	if ( ( logic & 0x0010) != 0) {
		if ( ( logic & 0x0018) == 0x0010 && ( logic & 0x0004) != 0) {
			logic |= 0x0018 ;
		}
		if ( xw == yw) {
			d1 = ( d1 + 180 ) % 360 ;
			d2 = ( d2 + 180 ) % 360 ;
			if ( d1 == d2) {
				return( _ERR) ;
			}
			Calc_TrueCirclePoint( x, y, xw, d1, &cx, &cy) ;
			ftbl.d1x = cx ;
			ftbl.d1y = cy ;
			Calc_TrueCirclePoint( x, y, xw, d2, &cx, &cy) ;
			ftbl.d2x = cx ;
			ftbl.d2y = cy ;
		} else {
			d1 = d1 % 360 ;
			d2 = d2 % 360 ;
			if ( d1 == d2) {
				return( _ERR) ;
			}
			Calc_CirclePoint( x, y, xw, yw, d1, &cx, &cy) ;
			ftbl.d1x = cx ;
			ftbl.d1y = cy ;
			Calc_CirclePoint( x, y, xw, yw, d2, &cx, &cy) ;
			ftbl.d2x = cx ;
			ftbl.d2y = cy ;
		}
	} else {
		ftbl.d1x = 0 ;
		ftbl.d1y = 0 ;
		ftbl.d1x = 0 ;
		ftbl.d1y = 0 ;
	}

	ftbl.head.func = FNO_GV_CIRCLE ;
	ftbl.x     = x ;
	ftbl.y     = y ;
	ftbl.xw    = xw ;
	ftbl.yw    = yw ;
	ftbl.logic = logic ;
	ftbl.style = style ;
	ftbl.cbuf  = cbuf ;

	ret = lcdcall( &ftbl) ;

	return( ( INT)ret) ;
}
