#======================================================================
#Project Name:RUPUTER                                                  
# Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. 
#======================================================================

.include	"address.def"
.include	"iomap.def"
.include	"biosdata.def"

#================================================================
#=		Interrupt Prototype definition							=
#================================================================

	.equ	INT_LCDBIOS	,	22


	.section	.text

#===================================================================================
#=	_lcdcall	Call LCD bios
#=
#=	<Syntax>		LONG   lcdcall( VOID *ftbl)
#=
#=	<Input>			VOID	*ftbl #		Function table
#=
#=	<Function value>	LONG	ret #		Return data
#=
#===================================================================================
 
		.global	_lcdcall

_lcdcall:
		ADD		-20,A3							#
		MOV		A0,(0,A3)						#
		MOV		A1,(4,A3)						#
		MOV		A2,(8,A3)						#
		MOVX	D2,(12,A3)						#
		MOVX	D3,(16,A3)						#
		#
		#	Interrupt number,Set function Prototype Ex & Call LCD bios
		#
		MOV		INT_LCDBIOS,D0					# functon Prototype Ex=0
#		INTSYS	D0								# Software interrupt
			####
			mov		d1,a0						####% Adapt for GNU D1A0
			####
			add		-4, a3						#
			mov		a2, (0, a3)					#
			mov		A_SWINTENT, a2				#
			jsr		(a2)						#
#
		MOV		(0,A3),A0						#
		MOV		(4,A3),A1						#
		MOV		(8,A3),A2						#
		MOVX	(12,A3),D2						#
		MOVX	(16,A3),D3						#
		ADD		20,A3							#
		RTS

#		END
