/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#if !defined(_LCDFUNC_)
#define _LCDFUNC_

/*===============================================================
=		Function table definition								=
===============================================================*/

#define		FNO_SCREEN			0	/* Screen mode settings 						*/
#define		FNO_GETSCREEN		1	/* Screen mode acquisition						*/
#define		FNO_CLS				2	/* Clear screen  								*/
#define		FNO_LCDON			3	/* LCD driver embed power control				*/
#define		FNO_GETLCDON		4	/* LCD driver embed power condition acquisition	*/
#define		FNO_MOJISIZE		6	/* Acquire the character width, height dot and liner address*/
#define		FNO_GETBUFSIZE		7	/* Acquire the graphic pattern byte on LCD		*/
#define		FNO_REVERSE			8	/* Reverse specification of LCD specified area	*/
#define		FNO_REVSTART		9	/* Resume of blink paused by revstop			*/
#define		FNO_REVSTOP			10	/* Pause of reverse specified in reverse		*/
#define		FNO_REVEND			11	/* Termination of blink specified by reverse	*/
#define		FNO_REVDRAW			12	/* Redraw of all reversed area 					*/
#define		FNO_BLINK			13	/* Blink specification of the LCD specified area*/
#define		FNO_BLSTOP			14	/* Pause of blink specified by blink 			*/
#define		FNO_BLSTART			15	/* Resume of blink paused by blstop 			*/
#define		FNO_BLEND			16	/* Termination of blink specified by blink		*/
#define		FNO_FREEZE			17	/* Screen freeze/freeze cancel					*/
#define		FNO_VOL				18	/* LCD electronic volume value setting			*/
#define		FNO_GETVOL			19	/* Acquisition of LCD electronic volume			*/

#define		FNO_LC_KPUT			20	/* Draw the specified strings on LCD coordinate	*/
#define		FNO_LC_SPUT			21	/* Draw SII code on LCD coordinate 				*/
#define		FNO_LC_APUT			22	/* Draw the font data on LCD coordinate			*/
#define		FNO_LC_LINE			24	/* Draw a straight line on LCD coordinate		*/
#define		FNO_LC_SQUARE		25	/* Draw a rectangle on LCD coordinate 			*/
#define		FNO_LC_CIRCLE		26	/* Draw a circle on LCD coordinate				*/
#define		FNO_LC_PSET			27	/* Draw a point on LCD coordinate				*/
#define		FNO_LC_POINT		28	/* Acquire a color of LCD coordinate 			*/
#define		FNO_LC_GET			29	/* Acquire a graphic pattern of LCD coordinate	*/
#define		FNO_LC_PUT			30	/* Display a graphic pattern on LCD coordinate	*/
#define		FNO_LC_REVERSE		31	/* Reverse the specified area on Work screen 	*/
#define		FNO_LC_CLEAR		32	/* Clear the specified area on Work screen  	*/

#define		FNO_GV_PLACE		60	/* Correspond the GRAM coordinate to LCD panel position	*/
#define		FNO_GV_KPUT			61	/* Draw the specified strings on GRAM coordinate*/
#define		FNO_GV_SPUT			62	/* Draw SII shift JIS code on GRAM coordinate	*/
#define		FNO_GV_APUT			63	/* Draw the font data on GRAM coordinate  		*/
#define		FNO_GV_LINE			65	/* Draw a straight line on GVRAM coordinate		*/
#define		FNO_GV_SQUARE		66	/* Draw a rectangle on GVRAM coordinate			*/
#define		FNO_GV_CIRCLE		67	/* Draw a circle on GVRAM coordinate    		*/
#define		FNO_GV_PSET			68	/* Draw a point on GVRAM coordinate 			*/
#define		FNO_GV_POINT		69	/* Acquire a color on GVRAM coordinate 			*/
#define		FNO_GV_GET			70	/* Acquire a graphic pattern on GVRAM coordinate*/
#define		FNO_GV_PUT			71	/* Display a graphic pattern on GVRAM coordinate*/
#define		FNO_GV_SCROLL		72	/* Scroll GVRAM   								*/
#define		FNO_GV_REVERSE		73	/* Reverse the specified area of GVRAM 			*/
#define		FNO_GV_CLEAR		74	/* Clear the specified area of GVRAM 			*/

/*===============================================================
=		Feature Number definition						=
===============================================================*/

typedef struct {
	INT		func ;								/* Function table					*/
} FNC_HEAD ;

/*===============================================================
=		screen function											=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			mode ;							/* Mode								*/
} FNC_SCREEN ;

/*===============================================================
=		getscreen function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
} FNC_GETSCREEN ;

/*===============================================================
=		cls function											=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			mode ;							/* Mode								*/
} FNC_CLS ;

/*===============================================================
=		lcdon function											=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			power ;							/* Power control					*/
} FNC_LCDON ;

/*===============================================================
=		getlcdon function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
} FNC_GETLCDON ;

/*===============================================================
=		mojisize function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			s_code ;						/* SII code							*/
} FNC_MOJISIZE ;

/*===============================================================
=		getbufsize function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x1 ;							/* Left upper corner X coordinate	*/
	INT			y1 ;							/* Left upper corner Y coordinate	*/
	INT			x2 ;							/* Right bottom corner X coordinate	*/
	INT			y2 ;							/* Right bottom corner Y coordinate	*/
} FNC_GETBUFSIZE ;

/*===============================================================
=		reverse function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x1 ;							/* Left upper corner X coordinate	*/
	INT			y1 ;							/* Left upper corner Y coordinate	*/
	INT			x2 ;							/* Right bottom corner X coordinate	*/
	INT			y2 ;							/* Right bottom corner Y coordinate	*/
} FNC_REVERSE ;

/*===============================================================
=		revstop function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			no ;							/* Reverse area number				*/
} FNC_REVSTOP ;

/*===============================================================
=		revstart function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			no ;							/* Reverse area number				*/
} FNC_REVSTART ;

/*===============================================================
=		revend function											=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			no ;							/* Reverse area number				*/
} FNC_REVEND ;

/*===============================================================
=		revdraw function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
} FNC_REVDRAW ;

/*===============================================================
=		blink function											=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x1 ;							/* Left upper corner X coordinate	*/
	INT			y1 ;							/* Left upper corner Y coordinate	*/
	INT			x2 ;							/* Right bottom corner X coordinate	*/
	INT			y2 ;							/* Right bottom corner Y coordinate	*/
	INT			color ;							/* Blink method specification		*/
} FNC_BLINK ;

/*===============================================================
=		blstop function											=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			no ;							/* Blink area number				*/
} FNC_BLSTOP ;

/*===============================================================
=		blstart function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			no ;							/* Blink area number				*/
} FNC_BLSTART ;

/*===============================================================
=		blend function											=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			no ;							/* Blink area number				*/
} FNC_BLEND ;

/*===============================================================
=		lcdfreeze function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			mode ;							/* Mode								*/
} FNC_LCDFREEZE ;

/*===============================================================
=		lcdvol function											=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			vol ;							/* Electrical volume amount			*/
} FNC_VOL ;

/*===============================================================
=		getlcdvol function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
} FNC_GETVOL ;

/*===============================================================
=		lc_kput function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x ;								/* LCD panel X coordinate			*/
	INT			y ;								/* LCD panel Y coordinate			*/
	CHAR		*str ;							/* Drawing string buffer address	*/
	INT			size_code ;						/* Size code						*/
	INT			dot ;							/* Character interval dot			*/
	INT			logic ;							/* Logical operation				*/
} FNC_LCKPUT ;

/*===============================================================
=		lc_sput function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x ;								/* LCD panel screen X coordinate	*/
	INT			y ;								/* LCD panel screen Y coordinate	*/
	INT			s_code ;						/* SII code							*/
	INT			logic ;							/* Logical operation				*/
} FNC_LCSPUT ;

/*===============================================================
=		lc_aput function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x ;								/* LCD panel screen X coordinate	*/
	INT			y ;								/* LCD panel screen Y coordinate	*/
	INT			w ;								/* Character width dot				*/
	INT			h ;								/* Character height dot				*/
	ULONG		add ;							/* Font data address				*/
	INT			logic ;							/* Logical operation				*/
} FNC_LCAPUT ;

/*===============================================================
=		lc_line function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x1 ;							/* Start point X coordinate			*/
	INT			y1 ;							/* Start point Y coordinate			*/
	INT			x2 ;							/* End point X coordinate			*/
	INT			y2 ;							/* End point Y coordinate 			*/
	INT			logic ;							/* Logical operation				*/
	UCHAR		style ;							/* Line style						*/
	UCHAR		rsv ;							/* No use							*/
} FNC_LCLINE ;

/*===============================================================
=		lc_square function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x1 ;							/* Left upper corner X coordinate	*/
	INT			y1 ;							/* Left upper corner Y coordinate	*/
	INT			x2 ;							/* Right bottom corner X coordinate	*/
	INT			y2 ;							/* Right bottom corner Y coordinate	*/
	INT			logic ;							/* Logical operation				*/
	ULONG		style ;							/* Line style/Tile pattern			*/
} FNC_LCSQUARE ;

/*===============================================================
=		lc_circle function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x ;								/* Center point X coordinate		*/
	INT			y ;								/* Center point Y coordinate 		*/
	INT			xw ;							/* X direction radius				*/
	INT			yw ;							/* Y direction radius 				*/
	INT			d1x ;							/* Start point X coordinate			*/
	INT			d1y ;							/* Start point Y coordinate			*/
	INT			d2x ;							/* End point X coordinate			*/
	INT			d2y ;							/* End point Y coordinate			*/
	INT			logic ;							/* Logical operation				*/
	ULONG		style ;							/* Line style						*/
	UCHAR		*cbuf ;							/* Work buffer address for fan paint*/
} FNC_LCCIRCLE ;

/*===============================================================
=		lc_pset function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x ;								/* LCD panel screen X coordinate	*/
	INT			y ;								/* LCD panel screen Y coordinate	*/
	INT			logic ;							/* Logical operation				*/
} FNC_LCPSET ;

/*===============================================================
=		lc_point function										=
===============================================================*/
	
typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x ;								/* LCD panel screen X coordinate	*/
	INT			y ;								/* LCD panel screen Y coordinate	*/
} FNC_LCPOINT ;

/*===============================================================
=		lc_get function											=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x1 ;							/* Left upper corner X coordinate	*/
	INT			y1 ;							/* Left upper corner Y coordinate	*/
	INT			x2 ;							/* Right bottom corner X coordinate	*/
	INT			y2 ;							/* Right bottom corner Y coordinate	*/
	CHAR		*buf ;							/* Store buffer address				*/
} FNC_LCGET ;

/*===============================================================
=		lc_put function											=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x ;								/* Left upper corner X coordinate	*/
	INT			y ;								/* Left upper corner Y coordinate	*/
	CHAR		*buf ;							/* Store buffer address				*/
	INT			logic ;							/* Logical operation				*/
} FNC_LCPUT ;

/*===============================================================
=		lc_reverse function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x1 ;							/* Left upper corner X coordinate	*/
	INT			y1 ;							/* Left upper corner Y coordinate	*/
	INT			x2 ;							/* Right bottom corner X coordinate	*/
	INT			y2 ;							/* Right bottom corner Y coordinate	*/
} FNC_LCREV ;

/*===============================================================
=		lc_clear function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x1 ;							/* Left upper corner X coordinate	*/
	INT			y1 ;							/* Left upper corner Y coordinate	*/
	INT			x2 ;							/* Right bottom corner X coordinate	*/
	INT			y2 ;							/* Right bottom corner Y coordinate	*/
} FNC_LCCLR ;

/*===============================================================
=		gv_place function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x ;								/* GVRAM screen X coordinate		*/
	INT			y ;								/* GVRAM screen Y coordinate		*/
} FNC_GVPLACE ;

/*===============================================================
=		gv_kput function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x ;								/* GVRAM screen X coordinate		*/
	INT			y ;								/* GVRAM screen Y coordinate		*/
	CHAR		*str ;							/* Drawing string buffer address	*/
	INT			size_code ;						/* Size code						*/
	INT			dot ;							/* Character interval dot			*/
	INT			logic ;							/* Logical operation				*/
} FNC_GVKPUT ;

/*===============================================================
=		gv_sput function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x ;								/* GVRAM screen X coordinate		*/
	INT			y ;								/* GVRAM screen Y coordinate		*/
	INT			s_code ;						/* SII code							*/
	INT			logic ;							/* Logical operation				*/
} FNC_GVSPUT ;

/*===============================================================
=		gv_aput function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x ;								/* GVRAM screen X coordinate		*/
	INT			y ;								/* GVRAM screen Y coordinate		*/
	INT			w ;								/* Character width dot				*/
	INT			h ;								/* Character height dot				*/
	ULONG		add ;							/* Font data address				*/
	INT			logic ;							/* Logical operation				*/
} FNC_GVAPUT ;

/*===============================================================
=		gv_line function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x1 ;							/* Start point X coordinate			*/
	INT			y1 ;							/* Start point Y coordinate			*/
	INT			x2 ;							/* End point X coordinate			*/
	INT			y2 ;							/* End point Y coordinate 			*/
	INT			logic ;							/* Logical operation				*/
	UCHAR		style ;							/* Line style						*/
	UCHAR		rsv ;							/* No use							*/
} FNC_GVLINE ;

/*===============================================================
=		gv_square function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x1 ;							/* Left upper corner X coordinate	*/
	INT			y1 ;							/* Left upper corner Y coordinate	*/
	INT			x2 ;							/* Right bottom corner X coordinate	*/
	INT			y2 ;							/* Right bottom corner Y coordinate	*/
	INT			logic ;							/* Logical operation				*/
	ULONG		style ;							/* Line style/Tile pattern			*/
} FNC_GVSQUARE ;

/*===============================================================
=		gv_circle function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x ;								/* Center point X coordinate		*/
	INT			y ;								/* Center point Y coordinate 		*/
	INT			xw ;							/* X direction radius				*/
	INT			yw ;							/* Y direction radius 				*/
	INT			d1x ;							/* Start point X coordinate			*/
	INT			d1y ;							/* Start point Y coordinate			*/
	INT			d2x ;							/* End point X coordinate			*/
	INT			d2y ;							/* End point Y coordinate			*/
	INT			logic ;							/* Logical operation				*/
	ULONG		style ;							/* Line style						*/
	UCHAR		*cbuf ;							/* Work buffer address for fan paint*/
} FNC_GVCIRCLE ;

/*===============================================================
=		gv_pset function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x ;								/* GVRAM screen X coordinate		*/
	INT			y ;								/* GVRAM screen Y coordinate		*/
	INT			logic ;							/* Logical operation				*/
} FNC_GVPSET ;

/*===============================================================
=		gv_point function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x ;								/* GVRAM screen X coordinate		*/
	INT			y ;								/* GVRAM screen Y coordinate		*/
} FNC_GVPOINT ;

/*===============================================================
=		gv_get function											=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x1 ;							/* Left upper corner X coordinate	*/
	INT			y1 ;							/* Left upper corner Y coordinate	*/
	INT			x2 ;							/* Right bottom corner X coordinate	*/
	INT			y2 ;							/* Right bottom corner Y coordinate	*/
	CHAR		*buf ;							/* Store buffer address				*/
} FNC_GVGET ;

/*===============================================================
=		gv_put function											=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x ;								/* Left upper corner X coordinate	*/
	INT			y ;								/* Left upper corner Y coordinate	*/
	CHAR		*buf ;							/* Store buffer address				*/
	INT			logic ;							/* Logical operation				*/
} FNC_GVPUT ;

/*===============================================================
=		gv_scroll function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			lines ;							/* Scroll line number				*/
} FNC_GVSCROLL ;

/*===============================================================
=		gv_reverse function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x1 ;							/* Left upper corner X coordinate	*/
	INT			y1 ;							/* Left upper corner Y coordinate 	*/
	INT			x2 ;							/* Right bottom corner X coordinate */
	INT			y2 ;							/* Right bottom corner Y coordinate	*/
} FNC_GVREV ;

/*===============================================================
=		gv_clear function										=
===============================================================*/

typedef struct {
	FNC_HEAD	head ;							/* Feature Number					*/
	INT			x1 ;							/* Left upper corner X coordinate	*/
	INT			y1 ;							/* Left upper corner Y coordinate	*/
	INT			x2 ;							/* Right bottom corner X coordinate	*/
	INT			y2 ;							/* Right bottom corner Y coordinate	*/
} FNC_GVCLR ;

#endif
