/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

/*===============================================================
=		Data type definition									=
===============================================================*/

#define		VOID			void
#define		CHAR			char
#define		UCHAR			unsigned char
#define		INT				int
#define		UINT			unsigned int
#define		SHORT			short
#define		USHORT			unsigned short
#define		LONG			long
#define		ULONG			unsigned long
#define		FLOAT			float
#define		DOUBLE			double

#define		REG				register

#define		EXTRN			extern
#define		LOCAL			static
#define		CONST			const

#define		_OFF			0
#define		_ON				1

#define		_OK				0
#define		_ERR			-1

#define		_NO				0
#define		_YES			1

/*===============================================================
=		LCD-BIOS screen mode definition							=
===============================================================*/

#define		LCD_MODE_LCD			0			/* LCD screen				*/
#define		LCD_MODE_GRAPHIC		1			/* GVRAM screen				*/

/*===============================================================
=		Clear screen mode										=
===============================================================*/

#define		LCD_CLS_LCD				1			/* Clear LCD screen				*/
#define		LCD_CLS_GVRAM			4			/* Clear GVRAM screen			*/

/*===============================================================
=		LCD driver power setting								=
===============================================================*/

#define		LCD_POWER_OFF			0			/* Power Off					*/
#define		LCD_POWER_ON			1			/* Power On						*/

/*===============================================================
=		mojisize function interface structure difinition		=
===============================================================*/

struct moji {
	int		w ;								/* Character width dot				*/
	int		h ;								/* Character height dot				*/
	long	add ;							/* linear address					*/
} ;

/*===============================================================
=		The physical LCD screen freeze							=
===============================================================*/

#define		LCD_FREEZE_OFF			0			/* Screen Freeze Cancel			*/
#define		LCD_FREEZE_ON			1			/* Screen Freeze				*/

/*===============================================================
=		Error code definition									=
===============================================================*/

#define		LCDERR_PARAM			-1		/* Parameter error						*/

#define		LCDERR_MODE_UNMATCH		-10		/* This function mismatch selected screen mode		*/

#define		LCDERR_BLINK_FULL		-20		/* Over 16 blink area 					*/
#define		LCDERR_BLINK_NOTUSE		-21		/* Blink area number not use			*/
#define		LCDERR_BLINK_SLEEP		-22		/* Blink area number stops temporarily	*/

#define		LCDERR_SIZE_CODE		-30		/* Invalid sizecode						*/

#define		LCDERR_TXTMODE_OUTAREA	-40		/* Specified image take out of screen	*/
#define		LCDERR_TXTMODE_LCDMODE	-41		/* This function mismatch selected LCD mode	*/

/*===============================================================
=		Prototype definition									=
===============================================================*/

INT			screen( INT) ;
INT			getscreen( VOID) ;
INT			cls( INT) ;
INT			lcdon( INT) ;
INT			getlcdon( VOID) ;
INT			mpread( CHAR *, CHAR *) ;
struct moji *mojisize( INT) ;
INT			getbufsize( INT, INT, INT, INT) ;
INT			reverse( INT, INT, INT, INT) ;
INT			revstop( INT) ;
INT			revstart( INT) ;
INT			revend( INT) ;
INT			revdraw( VOID) ;
INT			blink( INT, INT, INT, INT, INT) ;
INT			blstop( INT) ;
INT			blstart( INT) ;
INT			blend( INT) ;
INT			lcdfreeze( INT) ;
INT			lcdvol( INT) ;
INT			getlcdvol( VOID) ;

INT			lc_kput( INT, INT, CHAR *, INT, INT, INT) ;
INT			lc_sput( INT, INT, INT, INT) ;
INT			lc_aput( INT, INT, INT, INT, ULONG, INT) ;
INT			lc_mmap( INT, INT, CHAR *, INT) ;
INT			lc_line( INT, INT, INT, INT, INT, UCHAR) ;
INT			lc_square( INT, INT, INT, INT, INT, ULONG) ;
INT			lc_circle( INT, INT, INT, INT, INT, INT, INT, ULONG, UCHAR *) ;
INT			lc_pset( INT, INT, INT) ;
INT			lc_point( INT, INT) ;
INT			lc_get( INT, INT, INT, INT, CHAR *buf) ;
INT			lc_put( INT, INT, CHAR *, INT) ;
INT			lc_reverse( INT, INT, INT, INT) ;
INT			lc_clear( INT, INT, INT, INT) ;

INT			gv_place( INT, INT) ;
INT			gv_kput( INT, INT, CHAR *, INT, INT, INT) ;
INT			gv_sput( INT, INT, INT, INT) ;
INT			gv_aput( INT, INT, INT, INT, ULONG, INT) ;
INT			gv_mmap( INT, INT, CHAR *, INT) ;
INT			gv_line( INT, INT, INT, INT, INT, UCHAR) ;
INT			gv_square( INT, INT, INT, INT, INT, ULONG) ;
INT			gv_circle( INT, INT, INT, INT, INT, INT, INT, ULONG, UCHAR *) ;
INT			gv_pset( INT, INT, INT) ;
INT			gv_point( INT, INT) ;
INT			gv_get( INT, INT, INT, INT, CHAR *) ;
INT			gv_put( INT, INT, CHAR *, INT) ;
INT			gv_scroll( INT) ;
INT			gv_reverse( INT, INT, INT, INT) ;
INT			gv_clear( INT, INT, INT, INT) ;

LONG		lcdcall( VOID *) ;

VOID		Calc_TrueCirclePoint( INT, INT, INT, INT, INT *, INT *) ;

