/*==========================================================================*/
/*Project Name:RUPUTER                                                      */
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved.     */
/*==========================================================================*/

#include		"lcdlib.h"
#include		"sii_lcd.h"
#include		"lcdfunc.h"

/*===============================================================
=		Monomap format											=
===============================================================*/

typedef struct {
	INT		xw ;					/* width dots					*/
	INT		yw ;					/* height dots					*/
	UCHAR	gptn[ 1024] ;			/* Graphic pattern				*/
} MPFMT ;

LOCAL	MPFMT		mpbuf ;


INT  pc_mmap( MMAP_PUT *mmp)
{
	INT		ret ;

	/*
	 *	Read monomap format file
	 */

	if ( mpread( ( CHAR *)&mpbuf, mmp->name) != _OK) {
		return( _ERR) ;
	}

	/*
	 *	Display to screen call on lc_aput
	 */

	ret = lc_aput( mmp->pos.x, mmp->pos.y, mpbuf.xw, mpbuf.yw, ( ULONG)mpbuf.gptn, mmp->lop) ;

	return( ret) ;
}
