/*==========================================================================*/
/*Project Name:RUPUTER                                                 		*/
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. 	*/
/*==========================================================================*/

#include <stdio.h>
#include <string.h>

#define SNDFILENAMESIZE 8
#define PATHSIZE        32
typedef struct {
    unsigned short year;
    unsigned short month;
    unsigned short day;
    unsigned short hour;
    unsigned short min;
    char snd[SNDFILENAMESIZE];
    char exf[PATHSIZE];
} EVENTTABLE;

void main(int argc,char *argv[])
{
    FILE *fp;
    EVENTTABLE ev;

/* Acquisition of schedule alarm information     */
    if (!(fp = fopen("ALARM.INI","rb"))) return;
    fread(&ev,1,sizeof(EVENTTABLE),fp);
    fclose(fp);

    if (!(fp = fopen("ALARM.INI","wb"))) return;

/* schedule alarm                                   */
    fwrite(&ev,1,sizeof(EVENTTABLE),fp);

/* user alarm 1                                     */
/* alarm time 1999.10.28 AM9:00                     */
/* sound name   BIRTH.snd                           */
/* execution application   B:\MYPROG\BIRTHDAY.exf   */
    ev.year  = 1999;
    ev.month = 10;
    ev.day   = 28;
    ev.hour  =  9;
    ev.min   =  0;
    memset(ev.snd,0,SNDFILENAMESIZE);
    memcpy(ev.snd,"BIRTH",sizeof("BIRTH"));
    memset(ev.exf,0,PATHSIZE);
    memcpy(ev.exf,"B:\\MYPROG\\BIRTHDAY.EXF",sizeof("B:\\MYPROG\\BIRTHDAY.EXF"));
    fwrite(&ev,1,sizeof(EVENTTABLE),fp);

/* user alarm 2                                 */
/* alarm time 1999.7.24 PM11:00                 */
/* sound name   ALARM2.snd                      */
/* execution application   B:\MYPROG\REMOTE.exf */
    ev.year  = 1999;
    ev.month = 7;
    ev.day   = 24;
    ev.hour  = 23;
    ev.min   =  0;
    memset(ev.snd,0,SNDFILENAMESIZE);
    memcpy(ev.snd,"ALARM2",sizeof("ALARM2"));
    memset(ev.exf,0,PATHSIZE);
    memcpy(ev.exf,"B:\\MYPROG\\REMOTE.EXF",sizeof("B:\\MYPROG\\REMOTE.EXF"));
    fwrite(&ev,1,sizeof(EVENTTABLE),fp);

/* user alarm 3                                     */
/* alarm time 2000.1.1 AM0:00                       */
/* sound name   ALARM4.snd                          */
/* execution application   B:\MYPROG\NEWYEAR.exf    */
    ev.year  = 2000;
    ev.month = 1;
    ev.day   = 1;
    ev.hour  = 0;
    ev.min   = 0;
    memset(ev.snd,0,SNDFILENAMESIZE);
    memcpy(ev.snd,"ALARM4",sizeof("ALARM4"));
    memset(ev.exf,0,PATHSIZE);
    memcpy(ev.exf,"B:\\MYPROG\\NEWYEAR.EXF",sizeof("B:\\MYPROG\\NEWYEAR.EXF"));
    fwrite(&ev,1,sizeof(EVENTTABLE),fp);

    fclose(fp);
}

