/*==========================================================================*/
/*Project Name:RUPUTER                                                 		*/
/* Copyright (c) Seiko Instruments Inc. 1998-1999. All rights reserved. 	*/
/*==========================================================================*/

#include <stdio.h>
#include <string.h>
#include <memory.h>
#include "font.h"

/* Definition of file association
	suffix			Extension (. is included)
	icon			Display icon
	id				Selection value of icon
					 0=Font and mono map are valid
					 1=Font and large icon of ICO file are valid
					 2=Mono map and small icons are valid.
					 3=Small and large icons of ICO file are valid
	font			Font (small iconsj
	mmp				Mono map (large iconsj
	file			ICO file name
					 ".ICO" in B:\SYSTEM is not included in the file
	app				An application file name to be executed
					 NULL, drive name (fixed to B), extension (fixed to .EXF)
					 and within 32 characters
*/
#define	PATHSIZE 32
typedef	struct {
	char suffix[4];
	short attr;
	unsigned short id;
	unsigned short font;
	unsigned long mmp;
	char file[8];
	char app[PATHSIZE];
} RELATED; 

void	main()
{
	FILE *fp;
	int i;
	RELATED rEL;

	fp = fopen("FILER.INI","wb");

	/* Unknown file */
	for(i = 0;i < 4;i++) rEL.suffix[i] = (char)NULL;
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picETC;
	rEL.mmp = mmpETC;
	memset(rEL.file,0,8);
	strcpy(rEL.file,"USER");	/* Small icon is defined to [0].  You need to make corrections. */
	for(i = 0;i < PATHSIZE;i++) rEL.app[i] = (char)NULL;
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* Direcotry */
	for(i = 0;i < 4;i++) rEL.suffix[i] = (char)NULL;
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picFOLDA;
	rEL.mmp = mmpFOLDA;
	memset(rEL.file,0,8);
	for(i = 0;i < PATHSIZE;i++) rEL.app[i] = (char)NULL;
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* Direcotry (return) */
	for(i = 0;i < 4;i++) rEL.suffix[i] = (char)NULL;
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picFOLDA;
	rEL.mmp = mmpRET;
	memset(rEL.file,0,8);
	for(i = 0;i < PATHSIZE;i++) rEL.app[i] = (char)NULL;
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* Executable progaram */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".EXF"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picEXF;
	rEL.mmp = mmpEXF;
	memset(rEL.file,0,8);
	for(i = 0;i < PATHSIZE;i++) rEL.app[i] = (char)NULL;
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* Text viewer */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".TXT"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picTXT;
	rEL.mmp = mmpTXT;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	strcpy(rEL.app,"\\SYSTEM\\APPS\\TXTVIEW.EXF");
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* MMP viewer */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".MMP"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picMMP;
	rEL.mmp = mmpMMP;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	strcpy(rEL.app,"\\SYSTEM\\APPS\\MMPVIEW.EXF");
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* SND viewer */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".SND"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picSND;
	rEL.mmp = mmpSND;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	strcpy(rEL.app,"\\SYSTEM\\APPS\\SNDVIEW.EXF");
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* CSV viewer */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".CSV"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picCSV;
	rEL.mmp = mmpCSV;
	memset(rEL.file,0,8);
	for(i = 0;i < PATHSIZE;i++) rEL.app[i] = (char)NULL;
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* SCH viewer */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".SCL"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picSCH;
	rEL.mmp = mmpSCH;
	for(i = 0;i < 6;i++) rEL.file[i] = "ICON01"[i];
	for(;i < 8;i++) rEL.file[i] = (char)NULL;
	memset(rEL.app,0,PATHSIZE);
	strcpy(rEL.app,"\\SYSTEM\\APPS\\SCLVIEW.EXF");
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* ADR viewer */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".ADR"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picADR;
	rEL.mmp = mmpADR;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	strcpy(rEL.app,"\\SYSTEM\\APPS\\ADRVIEW.EXF");
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* STW viewer */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".STW"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picSTW;
	rEL.mmp = mmpSTW;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	strcpy(rEL.app,"\\SYSTEM\\APPS\\STWVIEW.EXF");
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* DFM viewer */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".DFM"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picDFM;
	rEL.mmp = mmpDFM;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	strcpy(rEL.app,"\\SYSTEM\\APPS\\DFMVIEW.EXF");
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* Viewer */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".FMM"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picFMM;
	rEL.mmp = mmpFMM;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	strcpy(rEL.app,"\\SYSTEM\\APPS\\FMMVIEW.EXF");
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* INI (definition file)*/
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".INI"[i];
	rEL.attr = 1;			/* Hide */	
	rEL.id = 0;
	rEL.font = picINI;
	rEL.mmp = mmpINI;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* ICO (ion/file)*/
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".ICO"[i];
	rEL.attr = 1;			/* Hide */	
	rEL.id = 0;
	rEL.font = picETC;
	rEL.mmp = mmpETC;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* EXE */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".EXE"[i];
	rEL.attr = 0;			/* Hide */	
	rEL.id = 0;
	rEL.font = picEXE;
	rEL.mmp = mmpEXE;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* SYS */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".SYS"[i];
	rEL.attr = 0;			/* Hide */	
	rEL.id = 0;
	rEL.font = picSYS;
	rEL.mmp = mmpSYS;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* BAT */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".BAT"[i];
	rEL.attr = 0;			/* Hide */	
	rEL.id = 0;
	rEL.font = picBAT;
	rEL.mmp = mmpBAT;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* FON */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".FON"[i];
	rEL.attr = 0;			/* Hide */	
	rEL.id = 0;
	rEL.font = picFON;
	rEL.mmp = mmpFON;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* DOC */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".DOC"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picDOC;
	rEL.mmp = mmpDOC;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* HLP */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".HLP"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picHLP;
	rEL.mmp = mmpHLP;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* XLS */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".XLS"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picXLS;
	rEL.mmp = mmpXLS;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* BMP */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".BMP"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picBMP;
	rEL.mmp = mmpBMP;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* JPG */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".JPG"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picJPG;
	rEL.mmp = mmpJPG;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* GIF */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".GIF"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picGIF;
	rEL.mmp = mmpGIF;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* WAV */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".WAV"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picWAV;
	rEL.mmp = mmpWAV;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* MID */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".MID"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picMID;
	rEL.mmp = mmpMID;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* AVI */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".AVI"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picAVI;
	rEL.mmp = mmpAVI;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* MOV */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".MOV"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picMOV;
	rEL.mmp = mmpMOV;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* MBX */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".MBX"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picMBX;
	rEL.mmp = mmpMBX;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* HTM */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".HTM"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picHTM;
	rEL.mmp = mmpHTM;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* ZIP */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".ZIP"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picZIP;
	rEL.mmp = mmpZIP;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* LZH */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".LZH"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picZIP;
	rEL.mmp = mmpZIP;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* PPT */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".PPT"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picPPT;
	rEL.mmp = mmpPPT;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* FCE */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".FCE"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picFCE;
	rEL.mmp = mmpFCE;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* PRS */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".PRS"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picPRS;
	rEL.mmp = mmpPRS;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	strcpy(rEL.app,"\\SYSTEM\\APPS\\PRSVIEW.EXF");
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* CRD */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".CRD"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picCARDFILE;
	rEL.mmp = mmpCARDFILE;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	strcpy(rEL.app,"\\SYSTEM\\APPS\\CARDVIEW.EXF");
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* TXM */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".TXM"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picTXM;
	rEL.mmp = mmpTXM;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	strcpy(rEL.app,"\\SYSTEM\\APPS\\TXMVIEW.EXF");
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);
	/* TDO */
	for(i = 0;i < 4;i++) rEL.suffix[i] = ".TDO"[i];
	rEL.attr = 0;
	rEL.id = 0;
	rEL.font = picTDO;
	rEL.mmp = mmpTDO;
	memset(rEL.file,0,8);
	memset(rEL.app,0,PATHSIZE);
	strcpy(rEL.app,"\\SYSTEM\\APPS\\TDOVIEW.EXF");
	fwrite((char *)&rEL,1,sizeof(RELATED),fp);

	fclose(fp);
}


