# warning: autogenerated code; don't bother to change this, change mktypeset.b or abc.b instead
implement Abc;
include "sys.m";
	sys: Sys;
include "draw.m";
include "sh.m";
include "alphabet/reports.m";
include "alphabet.m";
include "abc.m";
mkabc(a: Alphabet): ref Value.VA
{
	r := chan[1] of int;
	r <-= 1;
	return ref Value.VA((r, a));
}

valuec := array[] of {
	tagof(Value.Vm) => 'm',
	tagof(Value.Vt) => 't',
	tagof(Value.VA) => 'A',
	tagof(Value.Vw) => 'w',
	tagof(Value.Vc) => 'c',
	tagof(Value.Vr) => 'r',
	tagof(Value.Vf) => 'f',
	tagof(Value.Vs) => 's',
};

init()
{
	sys = load Sys Sys->PATH;
}

Value.type2s(c: int): string
{
	case c {
	'm' =>
		return "vmods";
	't' =>
		return "vtypes";
	'A' =>
		return "abc";
	'w' =>
		return "wfd";
	'c' =>
		return "cmd";
	'r' =>
		return "status";
	'f' =>
		return "fd";
	's' =>
		return "string";
	* =>
		return sys->sprint("unknowntype('%c')", c);
	}
}

typeerror(tc: int, v: ref Value): string
{
	sys->fprint(sys->fildes(2), "fs: bad type conversion, expected %s, was actually %s\n", Value.type2s(tc), Value.type2s(valuec[tagof v]));
	return "type conversion error";
}

Value.m(v: self ref Value): ref Value.Vm
{
	pick xv := v {Vm => return xv;}
	raise typeerror('m', v);
}

Value.t(v: self ref Value): ref Value.Vt
{
	pick xv := v {Vt => return xv;}
	raise typeerror('t', v);
}

Value.A(v: self ref Value): ref Value.VA
{
	pick xv := v {VA => return xv;}
	raise typeerror('A', v);
}

Value.w(v: self ref Value): ref Value.Vw
{
	pick xv := v {Vw => return xv;}
	raise typeerror('w', v);
}

Value.c(v: self ref Value): ref Value.Vc
{
	pick xv := v {Vc => return xv;}
	raise typeerror('c', v);
}

Value.r(v: self ref Value): ref Value.Vr
{
	pick xv := v {Vr => return xv;}
	raise typeerror('r', v);
}

Value.f(v: self ref Value): ref Value.Vf
{
	pick xv := v {Vf => return xv;}
	raise typeerror('f', v);
}

Value.s(v: self ref Value): ref Value.Vs
{
	pick xv := v {Vs => return xv;}
	raise typeerror('s', v);
}

Value.typec(v: self ref Value): int
{
	return valuec[tagof v];
}

Value.dup(xv: self ref Value): ref Value
{
	if(xv == nil)
		return nil;
	pick v := xv {
	Vm =>
		v = nil;
		xv = v;
	Vt =>
		v = nil;
		xv = v;
	VA =>
		a := v.A().i;
		a.refcount <-= <-a.refcount + 1;
		xv = v;
	Vw =>
		v = nil;
		xv = v;
	Vr =>
		v = nil;
		xv = v;
	Vf =>
		v = nil;
		xv = v;
	}
	return xv;
}

Value.free(xv: self ref Value, used: int)
{
	if(xv == nil)
		return;
	pick v := xv {
	Vm =>
		if(!used){
			v.i.abc.free(0);
		}
	Vt =>
		if(!used){
			v.i.abc.free(0);
		}
	VA =>
		r := v.i.refcount <-= <-v.i.refcount - 1;
		if(r == 0){
			v.i.alphabet->quit();
			v.i.alphabet = nil;
			v.i.refcount = nil;
		}
	Vw =>
		if(!used){
			<-v.i;
			v.i <-= nil;
		}
	Vr =>
		if(!used){
			v.i <-= "stop";
		}
	Vf =>
		if(!used){
			<-v.i;
			v.i <-= nil;
		}
	}
}

