# generate the Big5 character set converter data file
implement GenBIG5;

include "sys.m";
include "draw.m";

BIG5DATA: con "/lib/convcs/big5";

GenBIG5 : module {
	init : fn (ctxt : ref Draw->Context, args : list of string);
};

init(nil : ref Draw->Context, nil : list of string)
{
	sys := load Sys Sys->PATH;
	fd := sys->create(BIG5DATA, Sys->OWRITE, 8r644);
	if (fd == nil) {
		sys->print("cannot create %s: %r\n", BIG5DATA);
		return;
	}
	s := "";
	for (i := 0; i < len tabbig5; i++)
		s[len s] = tabbig5[i];

	buf := array of byte s;
	for (i = 0; i < len buf;) {
		towrite := Sys->ATOMICIO;
		if (len buf - i < Sys->ATOMICIO)
			towrite = len buf -i;
		n := sys->write(fd, buf[i:], towrite);
		if (n <= 0) {
			sys->print("error writing %s: %r", BIG5DATA);
			return;
		}
		i += n;
	}
}


ERRchar : con 16rFFFD;

tabbig5 := array[] of {
16r3000,16rff0c,16r3001,16r3002,16rff0e,16r30fb,16rff1b,16rff1a,
16rff1f,16rff01,16rfe30,16r2026,16r2025,16rfe50,16rfe51,16rfe52,
16r00b7,16rfe54,16rfe55,16rfe56,16rfe57,16rfe32,16r2013,16rfe31,
16r2014,16rfe33,ERRchar,16rfe34,16rfe4f,16rff08,16rff09,16rfe35,
16rfe36,16rff5b,16rff5d,16rfe37,16rfe38,16r3014,16r3015,16rfe39,
16rfe3a,16r3010,16r3011,16rfe3b,16rfe3c,16r300a,16r300b,16rfe3d,
16rfe3e,16r3008,16r3009,16rfe3f,16rfe40,16r300c,16r300d,16rfe41,
16rfe42,16r300e,16r300f,16rfe43,16rfe44,16rfe59,16rfe5a,16rfe5b,
16rfe5c,16rfe5d,16rfe5e,16r2018,16r2019,16r201c,16r201d,16r301d,
16r301e,16r2035,16r2032,16rff03,16rff06,16rff0a,16r203b,16r00a7,
16r3003,16r25cb,16r25cf,16r25b3,16r25b2,16r25ce,16r2606,16r2605,
16r25c7,16r25c6,16r25a1,16r25a0,16r25bd,16r25bc,16r32a3,16r2105,
16r203e,ERRchar,16rff3f,ERRchar,16rfe49,16rfe4a,16rfe4d,16rfe4e,
16rfe4b,16rfe4c,16r0023,16r0026,16r002a,16rff0b,16rff0d,16r00d7,
16r00f7,16r00b1,16r221a,16rff1c,16rff1e,16rff1d,16r2264,16r2265,
16r2260,16r221e,16r2252,16r2261,16rfe62,16rfe63,16rfe64,16rfe65,
16rfe66,16r223c,16r2229,16r222a,16r22a5,16r2220,16r221f,16r22bf,
16r33d2,16r33d1,16r222b,16r222e,16r2235,16r2234,16r2640,16r2642,
16r2641,16r2609,16r2191,16r2193,16r2190,16r2192,16r2196,16r2197,
16r2199,16r2198,16r2225,16r2223,ERRchar,ERRchar,16rff0f,16rff3c,
16rff04,16r00a5,16r3012,16r00a2,16r00a3,16rff05,16rff20,16r2103,
16r2109,16r0024,16r0025,16r0040,16r33d5,16r339c,16r339d,16r339e,
16r33ce,16r33a1,16r338e,16r338f,16r33c4,16r00b0,16r5159,16r515b,
16r515e,16r515d,16r5161,16r5163,16r55e7,16r74e9,16r7cce,16r2581,
16r2582,16r2583,16r2584,16r2585,16r2586,16r2587,16r2588,16r258f,
16r258e,16r258d,16r258c,16r258b,16r258a,16r2589,16r253c,16r2534,
16r252c,16r2524,16r251c,16r2594,16r2500,16r2502,16r2595,16r250c,
16r2510,16r2514,16r2518,16r256d,16r256e,16r2570,16r256f,16r2550,
16r255e,16r256a,16r2561,16r25e2,16r25e3,16r25e5,16r25e4,16r2571,
16r2572,16r2573,16rff10,16rff11,16rff12,16rff13,16rff14,16rff15,
16rff16,16rff17,16rff18,16rff19,16r2160,16r2161,16r2162,16r2163,
16r2164,16r2165,16r2166,16r2167,16r2168,16r2169,16r3021,16r3022,
16r3023,16r3024,16r3025,16r3026,16r3027,16r3028,16r3029,ERRchar,
16r5344,ERRchar,16rff21,16rff22,16rff23,16rff24,16rff25,16rff26,
16rff27,16rff28,16rff29,16rff2a,16rff2b,16rff2c,16rff2d,16rff2e,
16rff2f,16rff30,16rff31,16rff32,16rff33,16rff34,16rff35,16rff36,
16rff37,16rff38,16rff39,16rff3a,16rff41,16rff42,16rff43,16rff44,
16rff45,16rff46,16rff47,16rff48,16rff49,16rff4a,16rff4b,16rff4c,
16rff4d,16rff4e,16rff4f,16rff50,16rff51,16rff52,16rff53,16rff54,
16rff55,16rff56,16rff57,16rff58,16rff59,16rff5a,16r0391,16r0392,
16r0393,16r0394,16r0395,16r0396,16r0397,16r0398,16r0399,16r039a,
16r039b,16r039c,16r039d,16r039e,16r039f,16r03a0,16r03a1,16r03a3,
16r03a4,16r03a5,16r03a6,16r03a7,16r03a8,16r03a9,16r03b1,16r03b2,
16r03b3,16r03b4,16r03b5,16r03b6,16r03b7,16r03b8,16r03b9,16r03ba,
16r03bb,16r03bc,16r03bd,16r03be,16r03bf,16r03c0,16r03c1,16r03c3,
16r03c4,16r03c5,16r03c6,16r03c7,16r03c8,16r03c9,16r3105,16r3106,
16r3107,16r3108,16r3109,16r310a,16r310b,16r310c,16r310d,16r310e,
16r310f,16r3110,16r3111,16r3112,16r3113,16r3114,16r3115,16r3116,
16r3117,16r3118,16r3119,16r311a,16r311b,16r311c,16r311d,16r311e,
16r311f,16r3120,16r3121,16r3122,16r3123,16r3124,16r3125,16r3126,
16r3127,16r3128,16r3129,16r02d9,16r02c9,16r02ca,16r02c7,16r02cb,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r4e00,
16r4e59,16r4e01,16r4e03,16r4e43,16r4e5d,16r4e86,16r4e8c,16r4eba,
16r513f,16r5165,16r516b,16r51e0,16r5200,16r5201,16r529b,16r5315,
16r5341,16r535c,16r53c8,16r4e09,16r4e0b,16r4e08,16r4e0a,16r4e2b,
16r4e38,16r51e1,16r4e45,16r4e48,16r4e5f,16r4e5e,16r4e8e,16r4ea1,
16r5140,16r5203,16r52fa,16r5343,16r53c9,16r53e3,16r571f,16r58eb,
16r5915,16r5927,16r5973,16r5b50,16r5b51,16r5b53,16r5bf8,16r5c0f,
16r5c22,16r5c38,16r5c71,16r5ddd,16r5de5,16r5df1,16r5df2,16r5df3,
16r5dfe,16r5e72,16r5efe,16r5f0b,16r5f13,16r624d,16r4e11,16r4e10,
16r4e0d,16r4e2d,16r4e30,16r4e39,16r4e4b,16r5c39,16r4e88,16r4e91,
16r4e95,16r4e92,16r4e94,16r4ea2,16r4ec1,16r4ec0,16r4ec3,16r4ec6,
16r4ec7,16r4ecd,16r4eca,16r4ecb,16r4ec4,16r5143,16r5141,16r5167,
16r516d,16r516e,16r516c,16r5197,16r51f6,16r5206,16r5207,16r5208,
16r52fb,16r52fe,16r52ff,16r5316,16r5339,16r5348,16r5347,16r5345,
16r535e,16r5384,16r53cb,16r53ca,16r53cd,16r58ec,16r5929,16r592b,
16r592a,16r592d,16r5b54,16r5c11,16r5c24,16r5c3a,16r5c6f,16r5df4,
16r5e7b,16r5eff,16r5f14,16r5f15,16r5fc3,16r6208,16r6236,16r624b,
16r624e,16r652f,16r6587,16r6597,16r65a4,16r65b9,16r65e5,16r66f0,
16r6708,16r6728,16r6b20,16r6b62,16r6b79,16r6bcb,16r6bd4,16r6bdb,
16r6c0f,16r6c34,16r706b,16r722a,16r7236,16r723b,16r7247,16r7259,
16r725b,16r72ac,16r738b,16r4e19,16r4e16,16r4e15,16r4e14,16r4e18,
16r4e3b,16r4e4d,16r4e4f,16r4e4e,16r4ee5,16r4ed8,16r4ed4,16r4ed5,
16r4ed6,16r4ed7,16r4ee3,16r4ee4,16r4ed9,16r4ede,16r5145,16r5144,
16r5189,16r518a,16r51ac,16r51f9,16r51fa,16r51f8,16r520a,16r52a0,
16r529f,16r5305,16r5306,16r5317,16r531d,16r4edf,16r534a,16r5349,
16r5361,16r5360,16r536f,16r536e,16r53bb,16r53ef,16r53e4,16r53f3,
16r53ec,16r53ee,16r53e9,16r53e8,16r53fc,16r53f8,16r53f5,16r53eb,
16r53e6,16r53ea,16r53f2,16r53f1,16r53f0,16r53e5,16r53ed,16r53fb,
16r56db,16r56da,16r5916,16r592e,16r5931,16r5974,16r5976,16r5b55,
16r5b83,16r5c3c,16r5de8,16r5de7,16r5de6,16r5e02,16r5e03,16r5e73,
16r5e7c,16r5f01,16r5f18,16r5f17,16r5fc5,16r620a,16r6253,16r6254,
16r6252,16r6251,16r65a5,16r65e6,16r672e,16r672c,16r672a,16r672b,
16r672d,16r6b63,16r6bcd,16r6c11,16r6c10,16r6c38,16r6c41,16r6c40,
16r6c3e,16r72af,16r7384,16r7389,16r74dc,16r74e6,16r7518,16r751f,
16r7528,16r7529,16r7530,16r7531,16r7532,16r7533,16r758b,16r767d,
16r76ae,16r76bf,16r76ee,16r77db,16r77e2,16r77f3,16r793a,16r79be,
16r7a74,16r7acb,16r4e1e,16r4e1f,16r4e52,16r4e53,16r4e69,16r4e99,
16r4ea4,16r4ea6,16r4ea5,16r4eff,16r4f09,16r4f19,16r4f0a,16r4f15,
16r4f0d,16r4f10,16r4f11,16r4f0f,16r4ef2,16r4ef6,16r4efb,16r4ef0,
16r4ef3,16r4efd,16r4f01,16r4f0b,16r5149,16r5147,16r5146,16r5148,
16r5168,16r5171,16r518d,16r51b0,16r5217,16r5211,16r5212,16r520e,
16r5216,16r52a3,16r5308,16r5321,16r5320,16r5370,16r5371,16r5409,
16r540f,16r540c,16r540a,16r5410,16r5401,16r540b,16r5404,16r5411,
16r540d,16r5408,16r5403,16r540e,16r5406,16r5412,16r56e0,16r56de,
16r56dd,16r5733,16r5730,16r5728,16r572d,16r572c,16r572f,16r5729,
16r5919,16r591a,16r5937,16r5938,16r5984,16r5978,16r5983,16r597d,
16r5979,16r5982,16r5981,16r5b57,16r5b58,16r5b87,16r5b88,16r5b85,
16r5b89,16r5bfa,16r5c16,16r5c79,16r5dde,16r5e06,16r5e76,16r5e74,
16r5f0f,16r5f1b,16r5fd9,16r5fd6,16r620e,16r620c,16r620d,16r6210,
16r6263,16r625b,16r6258,16r6536,16r65e9,16r65e8,16r65ec,16r65ed,
16r66f2,16r66f3,16r6709,16r673d,16r6734,16r6731,16r6735,16r6b21,
16r6b64,16r6b7b,16r6c16,16r6c5d,16r6c57,16r6c59,16r6c5f,16r6c60,
16r6c50,16r6c55,16r6c61,16r6c5b,16r6c4d,16r6c4e,16r7070,16r725f,
16r725d,16r767e,16r7af9,16r7c73,16r7cf8,16r7f36,16r7f8a,16r7fbd,
16r8001,16r8003,16r800c,16r8012,16r8033,16r807f,16r8089,16r808b,
16r808c,16r81e3,16r81ea,16r81f3,16r81fc,16r820c,16r821b,16r821f,
16r826e,16r8272,16r827e,16r866b,16r8840,16r884c,16r8863,16r897f,
16r9621,16r4e32,16r4ea8,16r4f4d,16r4f4f,16r4f47,16r4f57,16r4f5e,
16r4f34,16r4f5b,16r4f55,16r4f30,16r4f50,16r4f51,16r4f3d,16r4f3a,
16r4f38,16r4f43,16r4f54,16r4f3c,16r4f46,16r4f63,16r4f5c,16r4f60,
16r4f2f,16r4f4e,16r4f36,16r4f59,16r4f5d,16r4f48,16r4f5a,16r514c,
16r514b,16r514d,16r5175,16r51b6,16r51b7,16r5225,16r5224,16r5229,
16r522a,16r5228,16r52ab,16r52a9,16r52aa,16r52ac,16r5323,16r5373,
16r5375,16r541d,16r542d,16r541e,16r543e,16r5426,16r544e,16r5427,
16r5446,16r5443,16r5433,16r5448,16r5442,16r541b,16r5429,16r544a,
16r5439,16r543b,16r5438,16r542e,16r5435,16r5436,16r5420,16r543c,
16r5440,16r5431,16r542b,16r541f,16r542c,16r56ea,16r56f0,16r56e4,
16r56eb,16r574a,16r5751,16r5740,16r574d,16r5747,16r574e,16r573e,
16r5750,16r574f,16r573b,16r58ef,16r593e,16r599d,16r5992,16r59a8,
16r599e,16r59a3,16r5999,16r5996,16r598d,16r59a4,16r5993,16r598a,
16r59a5,16r5b5d,16r5b5c,16r5b5a,16r5b5b,16r5b8c,16r5b8b,16r5b8f,
16r5c2c,16r5c40,16r5c41,16r5c3f,16r5c3e,16r5c90,16r5c91,16r5c94,
16r5c8c,16r5deb,16r5e0c,16r5e8f,16r5e87,16r5e8a,16r5ef7,16r5f04,
16r5f1f,16r5f64,16r5f62,16r5f77,16r5f79,16r5fd8,16r5fcc,16r5fd7,
16r5fcd,16r5ff1,16r5feb,16r5ff8,16r5fea,16r6212,16r6211,16r6284,
16r6297,16r6296,16r6280,16r6276,16r6289,16r626d,16r628a,16r627c,
16r627e,16r6279,16r6273,16r6292,16r626f,16r6298,16r626e,16r6295,
16r6293,16r6291,16r6286,16r6539,16r653b,16r6538,16r65f1,16r66f4,
16r675f,16r674e,16r674f,16r6750,16r6751,16r675c,16r6756,16r675e,
16r6749,16r6746,16r6760,16r6753,16r6757,16r6b65,16r6bcf,16r6c42,
16r6c5e,16r6c99,16r6c81,16r6c88,16r6c89,16r6c85,16r6c9b,16r6c6a,
16r6c7a,16r6c90,16r6c70,16r6c8c,16r6c68,16r6c96,16r6c92,16r6c7d,
16r6c83,16r6c72,16r6c7e,16r6c74,16r6c86,16r6c76,16r6c8d,16r6c94,
16r6c98,16r6c82,16r7076,16r707c,16r707d,16r7078,16r7262,16r7261,
16r7260,16r72c4,16r72c2,16r7396,16r752c,16r752b,16r7537,16r7538,
16r7682,16r76ef,16r77e3,16r79c1,16r79c0,16r79bf,16r7a76,16r7cfb,
16r7f55,16r8096,16r8093,16r809d,16r8098,16r809b,16r809a,16r80b2,
16r826f,16r8292,16r828b,16r828d,16r898b,16r89d2,16r8a00,16r8c37,
16r8c46,16r8c55,16r8c9d,16r8d64,16r8d70,16r8db3,16r8eab,16r8eca,
16r8f9b,16r8fb0,16r8fc2,16r8fc6,16r8fc5,16r8fc4,16r5de1,16r9091,
16r90a2,16r90aa,16r90a6,16r90a3,16r9149,16r91c6,16r91cc,16r9632,
16r962e,16r9631,16r962a,16r962c,16r4e26,16r4e56,16r4e73,16r4e8b,
16r4e9b,16r4e9e,16r4eab,16r4eac,16r4f6f,16r4f9d,16r4f8d,16r4f73,
16r4f7f,16r4f6c,16r4f9b,16r4f8b,16r4f86,16r4f83,16r4f70,16r4f75,
16r4f88,16r4f69,16r4f7b,16r4f96,16r4f7e,16r4f8f,16r4f91,16r4f7a,
16r5154,16r5152,16r5155,16r5169,16r5177,16r5176,16r5178,16r51bd,
16r51fd,16r523b,16r5238,16r5237,16r523a,16r5230,16r522e,16r5236,
16r5241,16r52be,16r52bb,16r5352,16r5354,16r5353,16r5351,16r5366,
16r5377,16r5378,16r5379,16r53d6,16r53d4,16r53d7,16r5473,16r5475,
16r5496,16r5478,16r5495,16r5480,16r547b,16r5477,16r5484,16r5492,
16r5486,16r547c,16r5490,16r5471,16r5476,16r548c,16r549a,16r5462,
16r5468,16r548b,16r547d,16r548e,16r56fa,16r5783,16r5777,16r576a,
16r5769,16r5761,16r5766,16r5764,16r577c,16r591c,16r5949,16r5947,
16r5948,16r5944,16r5954,16r59be,16r59bb,16r59d4,16r59b9,16r59ae,
16r59d1,16r59c6,16r59d0,16r59cd,16r59cb,16r59d3,16r59ca,16r59af,
16r59b3,16r59d2,16r59c5,16r5b5f,16r5b64,16r5b63,16r5b97,16r5b9a,
16r5b98,16r5b9c,16r5b99,16r5b9b,16r5c1a,16r5c48,16r5c45,16r5c46,
16r5cb7,16r5ca1,16r5cb8,16r5ca9,16r5cab,16r5cb1,16r5cb3,16r5e18,
16r5e1a,16r5e16,16r5e15,16r5e1b,16r5e11,16r5e78,16r5e9a,16r5e97,
16r5e9c,16r5e95,16r5e96,16r5ef6,16r5f26,16r5f27,16r5f29,16r5f80,
16r5f81,16r5f7f,16r5f7c,16r5fdd,16r5fe0,16r5ffd,16r5ff5,16r5fff,
16r600f,16r6014,16r602f,16r6035,16r6016,16r602a,16r6015,16r6021,
16r6027,16r6029,16r602b,16r601b,16r6216,16r6215,16r623f,16r623e,
16r6240,16r627f,16r62c9,16r62cc,16r62c4,16r62bf,16r62c2,16r62b9,
16r62d2,16r62db,16r62ab,16r62d3,16r62d4,16r62cb,16r62c8,16r62a8,
16r62bd,16r62bc,16r62d0,16r62d9,16r62c7,16r62cd,16r62b5,16r62da,
16r62b1,16r62d8,16r62d6,16r62d7,16r62c6,16r62ac,16r62ce,16r653e,
16r65a7,16r65bc,16r65fa,16r6614,16r6613,16r660c,16r6606,16r6602,
16r660e,16r6600,16r660f,16r6615,16r660a,16r6607,16r670d,16r670b,
16r676d,16r678b,16r6795,16r6771,16r679c,16r6773,16r6777,16r6787,
16r679d,16r6797,16r676f,16r6770,16r677f,16r6789,16r677e,16r6790,
16r6775,16r679a,16r6793,16r677c,16r676a,16r6772,16r6b23,16r6b66,
16r6b67,16r6b7f,16r6c13,16r6c1b,16r6ce3,16r6ce8,16r6cf3,16r6cb1,
16r6ccc,16r6ce5,16r6cb3,16r6cbd,16r6cbe,16r6cbc,16r6ce2,16r6cab,
16r6cd5,16r6cd3,16r6cb8,16r6cc4,16r6cb9,16r6cc1,16r6cae,16r6cd7,
16r6cc5,16r6cf1,16r6cbf,16r6cbb,16r6ce1,16r6cdb,16r6cca,16r6cac,
16r6cef,16r6cdc,16r6cd6,16r6ce0,16r7095,16r708e,16r7092,16r708a,
16r7099,16r722c,16r722d,16r7238,16r7248,16r7267,16r7269,16r72c0,
16r72ce,16r72d9,16r72d7,16r72d0,16r73a9,16r73a8,16r739f,16r73ab,
16r73a5,16r753d,16r759d,16r7599,16r759a,16r7684,16r76c2,16r76f2,
16r76f4,16r77e5,16r77fd,16r793e,16r7940,16r7941,16r79c9,16r79c8,
16r7a7a,16r7a79,16r7afa,16r7cfe,16r7f54,16r7f8c,16r7f8b,16r8005,
16r80ba,16r80a5,16r80a2,16r80b1,16r80a1,16r80ab,16r80a9,16r80b4,
16r80aa,16r80af,16r81e5,16r81fe,16r820d,16r82b3,16r829d,16r8299,
16r82ad,16r82bd,16r829f,16r82b9,16r82b1,16r82ac,16r82a5,16r82af,
16r82b8,16r82a3,16r82b0,16r82be,16r82b7,16r864e,16r8671,16r521d,
16r8868,16r8ecb,16r8fce,16r8fd4,16r8fd1,16r90b5,16r90b8,16r90b1,
16r90b6,16r91c7,16r91d1,16r9577,16r9580,16r961c,16r9640,16r963f,
16r963b,16r9644,16r9642,16r96b9,16r96e8,16r9752,16r975e,16r4e9f,
16r4ead,16r4eae,16r4fe1,16r4fb5,16r4faf,16r4fbf,16r4fe0,16r4fd1,
16r4fcf,16r4fdd,16r4fc3,16r4fb6,16r4fd8,16r4fdf,16r4fca,16r4fd7,
16r4fae,16r4fd0,16r4fc4,16r4fc2,16r4fda,16r4fce,16r4fde,16r4fb7,
16r5157,16r5192,16r5191,16r51a0,16r524e,16r5243,16r524a,16r524d,
16r524c,16r524b,16r5247,16r52c7,16r52c9,16r52c3,16r52c1,16r530d,
16r5357,16r537b,16r539a,16r53db,16r54ac,16r54c0,16r54a8,16r54ce,
16r54c9,16r54b8,16r54a6,16r54b3,16r54c7,16r54c2,16r54bd,16r54aa,
16r54c1,16r54c4,16r54c8,16r54af,16r54ab,16r54b1,16r54bb,16r54a9,
16r54a7,16r54bf,16r56ff,16r5782,16r578b,16r57a0,16r57a3,16r57a2,
16r57ce,16r57ae,16r5793,16r5955,16r5951,16r594f,16r594e,16r5950,
16r59dc,16r59d8,16r59ff,16r59e3,16r59e8,16r5a03,16r59e5,16r59ea,
16r59da,16r59e6,16r5a01,16r59fb,16r5b69,16r5ba3,16r5ba6,16r5ba4,
16r5ba2,16r5ba5,16r5c01,16r5c4e,16r5c4f,16r5c4d,16r5c4b,16r5cd9,
16r5cd2,16r5df7,16r5e1d,16r5e25,16r5e1f,16r5e7d,16r5ea0,16r5ea6,
16r5efa,16r5f08,16r5f2d,16r5f65,16r5f88,16r5f85,16r5f8a,16r5f8b,
16r5f87,16r5f8c,16r5f89,16r6012,16r601d,16r6020,16r6025,16r600e,
16r6028,16r604d,16r6070,16r6068,16r6062,16r6046,16r6043,16r606c,
16r606b,16r606a,16r6064,16r6241,16r62dc,16r6316,16r6309,16r62fc,
16r62ed,16r6301,16r62ee,16r62fd,16r6307,16r62f1,16r62f7,16r62ef,
16r62ec,16r62fe,16r62f4,16r6311,16r6302,16r653f,16r6545,16r65ab,
16r65bd,16r65e2,16r6625,16r662d,16r6620,16r6627,16r662f,16r661f,
16r6628,16r6631,16r6624,16r66f7,16r67ff,16r67d3,16r67f1,16r67d4,
16r67d0,16r67ec,16r67b6,16r67af,16r67f5,16r67e9,16r67ef,16r67c4,
16r67d1,16r67b4,16r67da,16r67e5,16r67b8,16r67cf,16r67de,16r67f3,
16r67b0,16r67d9,16r67e2,16r67dd,16r67d2,16r6b6a,16r6b83,16r6b86,
16r6bb5,16r6bd2,16r6bd7,16r6c1f,16r6cc9,16r6d0b,16r6d32,16r6d2a,
16r6d41,16r6d25,16r6d0c,16r6d31,16r6d1e,16r6d17,16r6d3b,16r6d3d,
16r6d3e,16r6d36,16r6d1b,16r6cf5,16r6d39,16r6d27,16r6d38,16r6d29,
16r6d2e,16r6d35,16r6d0e,16r6d2b,16r70ab,16r70ba,16r70b3,16r70ac,
16r70af,16r70ad,16r70b8,16r70ae,16r70a4,16r7230,16r7272,16r726f,
16r7274,16r72e9,16r72e0,16r72e1,16r73b7,16r73ca,16r73bb,16r73b2,
16r73cd,16r73c0,16r73b3,16r751a,16r752d,16r754f,16r754c,16r754e,
16r754b,16r75ab,16r75a4,16r75a5,16r75a2,16r75a3,16r7678,16r7686,
16r7687,16r7688,16r76c8,16r76c6,16r76c3,16r76c5,16r7701,16r76f9,
16r76f8,16r7709,16r770b,16r76fe,16r76fc,16r7707,16r77dc,16r7802,
16r7814,16r780c,16r780d,16r7946,16r7949,16r7948,16r7947,16r79b9,
16r79ba,16r79d1,16r79d2,16r79cb,16r7a7f,16r7a81,16r7aff,16r7afd,
16r7c7d,16r7d02,16r7d05,16r7d00,16r7d09,16r7d07,16r7d04,16r7d06,
16r7f38,16r7f8e,16r7fbf,16r8004,16r8010,16r800d,16r8011,16r8036,
16r80d6,16r80e5,16r80da,16r80c3,16r80c4,16r80cc,16r80e1,16r80db,
16r80ce,16r80de,16r80e4,16r80dd,16r81f4,16r8222,16r82e7,16r8303,
16r8305,16r82e3,16r82db,16r82e6,16r8304,16r82e5,16r8302,16r8309,
16r82d2,16r82d7,16r82f1,16r8301,16r82dc,16r82d4,16r82d1,16r82de,
16r82d3,16r82df,16r82ef,16r8306,16r8650,16r8679,16r867b,16r867a,
16r884d,16r886b,16r8981,16r89d4,16r8a08,16r8a02,16r8a03,16r8c9e,
16r8ca0,16r8d74,16r8d73,16r8db4,16r8ecd,16r8ecc,16r8ff0,16r8fe6,
16r8fe2,16r8fea,16r8fe5,16r8fed,16r8feb,16r8fe4,16r8fe8,16r90ca,
16r90ce,16r90c1,16r90c3,16r914b,16r914a,16r91cd,16r9582,16r9650,
16r964b,16r964c,16r964d,16r9762,16r9769,16r97cb,16r97ed,16r97f3,
16r9801,16r98a8,16r98db,16r98df,16r9996,16r9999,16r4e58,16r4eb3,
16r500c,16r500d,16r5023,16r4fef,16r5026,16r5025,16r4ff8,16r5029,
16r5016,16r5006,16r503c,16r501f,16r501a,16r5012,16r5011,16r4ffa,
16r5000,16r5014,16r5028,16r4ff1,16r5021,16r500b,16r5019,16r5018,
16r4ff3,16r4fee,16r502d,16r502a,16r4ffe,16r502b,16r5009,16r517c,
16r51a4,16r51a5,16r51a2,16r51cd,16r51cc,16r51c6,16r51cb,16r5256,
16r525c,16r5254,16r525b,16r525d,16r532a,16r537f,16r539f,16r539d,
16r53df,16r54e8,16r5510,16r5501,16r5537,16r54fc,16r54e5,16r54f2,
16r5506,16r54fa,16r5514,16r54e9,16r54ed,16r54e1,16r5509,16r54ee,
16r54ea,16r54e6,16r5527,16r5507,16r54fd,16r550f,16r5703,16r5704,
16r57c2,16r57d4,16r57cb,16r57c3,16r5809,16r590f,16r5957,16r5958,
16r595a,16r5a11,16r5a18,16r5a1c,16r5a1f,16r5a1b,16r5a13,16r59ec,
16r5a20,16r5a23,16r5a29,16r5a25,16r5a0c,16r5a09,16r5b6b,16r5c58,
16r5bb0,16r5bb3,16r5bb6,16r5bb4,16r5bae,16r5bb5,16r5bb9,16r5bb8,
16r5c04,16r5c51,16r5c55,16r5c50,16r5ced,16r5cfd,16r5cfb,16r5cea,
16r5ce8,16r5cf0,16r5cf6,16r5d01,16r5cf4,16r5dee,16r5e2d,16r5e2b,
16r5eab,16r5ead,16r5ea7,16r5f31,16r5f92,16r5f91,16r5f90,16r6059,
16r6063,16r6065,16r6050,16r6055,16r606d,16r6069,16r606f,16r6084,
16r609f,16r609a,16r608d,16r6094,16r608c,16r6085,16r6096,16r6247,
16r62f3,16r6308,16r62ff,16r634e,16r633e,16r632f,16r6355,16r6342,
16r6346,16r634f,16r6349,16r633a,16r6350,16r633d,16r632a,16r632b,
16r6328,16r634d,16r634c,16r6548,16r6549,16r6599,16r65c1,16r65c5,
16r6642,16r6649,16r664f,16r6643,16r6652,16r664c,16r6645,16r6641,
16r66f8,16r6714,16r6715,16r6717,16r6821,16r6838,16r6848,16r6846,
16r6853,16r6839,16r6842,16r6854,16r6829,16r68b3,16r6817,16r684c,
16r6851,16r683d,16r67f4,16r6850,16r6840,16r683c,16r6843,16r682a,
16r6845,16r6813,16r6818,16r6841,16r6b8a,16r6b89,16r6bb7,16r6c23,
16r6c27,16r6c28,16r6c26,16r6c24,16r6cf0,16r6d6a,16r6d95,16r6d88,
16r6d87,16r6d66,16r6d78,16r6d77,16r6d59,16r6d93,16r6d6c,16r6d89,
16r6d6e,16r6d5a,16r6d74,16r6d69,16r6d8c,16r6d8a,16r6d79,16r6d85,
16r6d65,16r6d94,16r70ca,16r70d8,16r70e4,16r70d9,16r70c8,16r70cf,
16r7239,16r7279,16r72fc,16r72f9,16r72fd,16r72f8,16r72f7,16r7386,
16r73ed,16r7409,16r73ee,16r73e0,16r73ea,16r73de,16r7554,16r755d,
16r755c,16r755a,16r7559,16r75be,16r75c5,16r75c7,16r75b2,16r75b3,
16r75bd,16r75bc,16r75b9,16r75c2,16r75b8,16r768b,16r76b0,16r76ca,
16r76cd,16r76ce,16r7729,16r771f,16r7720,16r7728,16r77e9,16r7830,
16r7827,16r7838,16r781d,16r7834,16r7837,16r7825,16r782d,16r7820,
16r781f,16r7832,16r7955,16r7950,16r7960,16r795f,16r7956,16r795e,
16r795d,16r7957,16r795a,16r79e4,16r79e3,16r79e7,16r79df,16r79e6,
16r79e9,16r79d8,16r7a84,16r7a88,16r7ad9,16r7b06,16r7b11,16r7c89,
16r7d21,16r7d17,16r7d0b,16r7d0a,16r7d20,16r7d22,16r7d14,16r7d10,
16r7d15,16r7d1a,16r7d1c,16r7d0d,16r7d19,16r7d1b,16r7f3a,16r7f5f,
16r7f94,16r7fc5,16r7fc1,16r8006,16r8018,16r8015,16r8019,16r8017,
16r803d,16r803f,16r80f1,16r8102,16r80f0,16r8105,16r80ed,16r80f4,
16r8106,16r80f8,16r80f3,16r8108,16r80fd,16r810a,16r80fc,16r80ef,
16r81ed,16r81ec,16r8200,16r8210,16r822a,16r822b,16r8228,16r822c,
16r82bb,16r832b,16r8352,16r8354,16r834a,16r8338,16r8350,16r8349,
16r8335,16r8334,16r834f,16r8332,16r8339,16r8336,16r8317,16r8340,
16r8331,16r8328,16r8343,16r8654,16r868a,16r86aa,16r8693,16r86a4,
16r86a9,16r868c,16r86a3,16r869c,16r8870,16r8877,16r8881,16r8882,
16r887d,16r8879,16r8a18,16r8a10,16r8a0e,16r8a0c,16r8a15,16r8a0a,
16r8a17,16r8a13,16r8a16,16r8a0f,16r8a11,16r8c48,16r8c7a,16r8c79,
16r8ca1,16r8ca2,16r8d77,16r8eac,16r8ed2,16r8ed4,16r8ecf,16r8fb1,
16r9001,16r9006,16r8ff7,16r9000,16r8ffa,16r8ff4,16r9003,16r8ffd,
16r9005,16r8ff8,16r9095,16r90e1,16r90dd,16r90e2,16r9152,16r914d,
16r914c,16r91d8,16r91dd,16r91d7,16r91dc,16r91d9,16r9583,16r9662,
16r9663,16r9661,16r965b,16r965d,16r9664,16r9658,16r965e,16r96bb,
16r98e2,16r99ac,16r9aa8,16r9ad8,16r9b25,16r9b32,16r9b3c,16r4e7e,
16r507a,16r507d,16r505c,16r5047,16r5043,16r504c,16r505a,16r5049,
16r5065,16r5076,16r504e,16r5055,16r5075,16r5074,16r5077,16r504f,
16r500f,16r506f,16r506d,16r515c,16r5195,16r51f0,16r526a,16r526f,
16r52d2,16r52d9,16r52d8,16r52d5,16r5310,16r530f,16r5319,16r533f,
16r5340,16r533e,16r53c3,16r66fc,16r5546,16r556a,16r5566,16r5544,
16r555e,16r5561,16r5543,16r554a,16r5531,16r5556,16r554f,16r5555,
16r552f,16r5564,16r5538,16r552e,16r555c,16r552c,16r5563,16r5533,
16r5541,16r5557,16r5708,16r570b,16r5709,16r57df,16r5805,16r580a,
16r5806,16r57e0,16r57e4,16r57fa,16r5802,16r5835,16r57f7,16r57f9,
16r5920,16r5962,16r5a36,16r5a41,16r5a49,16r5a66,16r5a6a,16r5a40,
16r5a3c,16r5a62,16r5a5a,16r5a46,16r5a4a,16r5b70,16r5bc7,16r5bc5,
16r5bc4,16r5bc2,16r5bbf,16r5bc6,16r5c09,16r5c08,16r5c07,16r5c60,
16r5c5c,16r5c5d,16r5d07,16r5d06,16r5d0e,16r5d1b,16r5d16,16r5d22,
16r5d11,16r5d29,16r5d14,16r5d19,16r5d24,16r5d27,16r5d17,16r5de2,
16r5e38,16r5e36,16r5e33,16r5e37,16r5eb7,16r5eb8,16r5eb6,16r5eb5,
16r5ebe,16r5f35,16r5f37,16r5f57,16r5f6c,16r5f69,16r5f6b,16r5f97,
16r5f99,16r5f9e,16r5f98,16r5fa1,16r5fa0,16r5f9c,16r607f,16r60a3,
16r6089,16r60a0,16r60a8,16r60cb,16r60b4,16r60e6,16r60bd,16r60c5,
16r60bb,16r60b5,16r60dc,16r60bc,16r60d8,16r60d5,16r60c6,16r60df,
16r60b8,16r60da,16r60c7,16r621a,16r621b,16r6248,16r63a0,16r63a7,
16r6372,16r6396,16r63a2,16r63a5,16r6377,16r6367,16r6398,16r63aa,
16r6371,16r63a9,16r6389,16r6383,16r639b,16r636b,16r63a8,16r6384,
16r6388,16r6399,16r63a1,16r63ac,16r6392,16r638f,16r6380,16r637b,
16r6369,16r6368,16r637a,16r655d,16r6556,16r6551,16r6559,16r6557,
16r555f,16r654f,16r6558,16r6555,16r6554,16r659c,16r659b,16r65ac,
16r65cf,16r65cb,16r65cc,16r65ce,16r665d,16r665a,16r6664,16r6668,
16r6666,16r665e,16r66f9,16r52d7,16r671b,16r6881,16r68af,16r68a2,
16r6893,16r68b5,16r687f,16r6876,16r68b1,16r68a7,16r6897,16r68b0,
16r6883,16r68c4,16r68ad,16r6886,16r6885,16r6894,16r689d,16r68a8,
16r689f,16r68a1,16r6882,16r6b32,16r6bba,16r6beb,16r6bec,16r6c2b,
16r6d8e,16r6dbc,16r6df3,16r6dd9,16r6db2,16r6de1,16r6dcc,16r6de4,
16r6dfb,16r6dfa,16r6e05,16r6dc7,16r6dcb,16r6daf,16r6dd1,16r6dae,
16r6dde,16r6df9,16r6db8,16r6df7,16r6df5,16r6dc5,16r6dd2,16r6e1a,
16r6db5,16r6dda,16r6deb,16r6dd8,16r6dea,16r6df1,16r6dee,16r6de8,
16r6dc6,16r6dc4,16r6daa,16r6dec,16r6dbf,16r6de6,16r70f9,16r7109,
16r710a,16r70fd,16r70ef,16r723d,16r727d,16r7281,16r731c,16r731b,
16r7316,16r7313,16r7319,16r7387,16r7405,16r740a,16r7403,16r7406,
16r73fe,16r740d,16r74e0,16r74f6,16r74f7,16r751c,16r7522,16r7565,
16r7566,16r7562,16r7570,16r758f,16r75d4,16r75d5,16r75b5,16r75ca,
16r75cd,16r768e,16r76d4,16r76d2,16r76db,16r7737,16r773e,16r773c,
16r7736,16r7738,16r773a,16r786b,16r7843,16r784e,16r7965,16r7968,
16r796d,16r79fb,16r7a92,16r7a95,16r7b20,16r7b28,16r7b1b,16r7b2c,
16r7b26,16r7b19,16r7b1e,16r7b2e,16r7c92,16r7c97,16r7c95,16r7d46,
16r7d43,16r7d71,16r7d2e,16r7d39,16r7d3c,16r7d40,16r7d30,16r7d33,
16r7d44,16r7d2f,16r7d42,16r7d32,16r7d31,16r7f3d,16r7f9e,16r7f9a,
16r7fcc,16r7fce,16r7fd2,16r801c,16r804a,16r8046,16r812f,16r8116,
16r8123,16r812b,16r8129,16r8130,16r8124,16r8202,16r8235,16r8237,
16r8236,16r8239,16r838e,16r839e,16r8398,16r8378,16r83a2,16r8396,
16r83bd,16r83ab,16r8392,16r838a,16r8393,16r8389,16r83a0,16r8377,
16r837b,16r837c,16r8386,16r83a7,16r8655,16r5f6a,16r86c7,16r86c0,
16r86b6,16r86c4,16r86b5,16r86c6,16r86cb,16r86b1,16r86af,16r86c9,
16r8853,16r889e,16r8888,16r88ab,16r8892,16r8896,16r888d,16r888b,
16r8993,16r898f,16r8a2a,16r8a1d,16r8a23,16r8a25,16r8a31,16r8a2d,
16r8a1f,16r8a1b,16r8a22,16r8c49,16r8c5a,16r8ca9,16r8cac,16r8cab,
16r8ca8,16r8caa,16r8ca7,16r8d67,16r8d66,16r8dbe,16r8dba,16r8edb,
16r8edf,16r9019,16r900d,16r901a,16r9017,16r9023,16r901f,16r901d,
16r9010,16r9015,16r901e,16r9020,16r900f,16r9022,16r9016,16r901b,
16r9014,16r90e8,16r90ed,16r90fd,16r9157,16r91ce,16r91f5,16r91e6,
16r91e3,16r91e7,16r91ed,16r91e9,16r9589,16r966a,16r9675,16r9673,
16r9678,16r9670,16r9674,16r9676,16r9677,16r966c,16r96c0,16r96ea,
16r96e9,16r7ae0,16r7adf,16r9802,16r9803,16r9b5a,16r9ce5,16r9e75,
16r9e7f,16r9ea5,16r9ebb,16r50a2,16r508d,16r5085,16r5099,16r5091,
16r5080,16r5096,16r5098,16r509a,16r6700,16r51f1,16r5272,16r5274,
16r5275,16r5269,16r52de,16r52dd,16r52db,16r535a,16r53a5,16r557b,
16r5580,16r55a7,16r557c,16r558a,16r559d,16r5598,16r5582,16r559c,
16r55aa,16r5594,16r5587,16r558b,16r5583,16r55b3,16r55ae,16r559f,
16r553e,16r55b2,16r559a,16r55bb,16r55ac,16r55b1,16r557e,16r5589,
16r55ab,16r5599,16r570d,16r582f,16r582a,16r5834,16r5824,16r5830,
16r5831,16r5821,16r581d,16r5820,16r58f9,16r58fa,16r5960,16r5a77,
16r5a9a,16r5a7f,16r5a92,16r5a9b,16r5aa7,16r5b73,16r5b71,16r5bd2,
16r5bcc,16r5bd3,16r5bd0,16r5c0a,16r5c0b,16r5c31,16r5d4c,16r5d50,
16r5d34,16r5d47,16r5dfd,16r5e45,16r5e3d,16r5e40,16r5e43,16r5e7e,
16r5eca,16r5ec1,16r5ec2,16r5ec4,16r5f3c,16r5f6d,16r5fa9,16r5faa,
16r5fa8,16r60d1,16r60e1,16r60b2,16r60b6,16r60e0,16r611c,16r6123,
16r60fa,16r6115,16r60f0,16r60fb,16r60f4,16r6168,16r60f1,16r610e,
16r60f6,16r6109,16r6100,16r6112,16r621f,16r6249,16r63a3,16r638c,
16r63cf,16r63c0,16r63e9,16r63c9,16r63c6,16r63cd,16r63d2,16r63e3,
16r63d0,16r63e1,16r63d6,16r63ed,16r63ee,16r6376,16r63f4,16r63ea,
16r63db,16r6452,16r63da,16r63f9,16r655e,16r6566,16r6562,16r6563,
16r6591,16r6590,16r65af,16r666e,16r6670,16r6674,16r6676,16r666f,
16r6691,16r667a,16r667e,16r6677,16r66fe,16r66ff,16r671f,16r671d,
16r68fa,16r68d5,16r68e0,16r68d8,16r68d7,16r6905,16r68df,16r68f5,
16r68ee,16r68e7,16r68f9,16r68d2,16r68f2,16r68e3,16r68cb,16r68cd,
16r690d,16r6912,16r690e,16r68c9,16r68da,16r696e,16r68fb,16r6b3e,
16r6b3a,16r6b3d,16r6b98,16r6b96,16r6bbc,16r6bef,16r6c2e,16r6c2f,
16r6c2c,16r6e2f,16r6e38,16r6e54,16r6e21,16r6e32,16r6e67,16r6e4a,
16r6e20,16r6e25,16r6e23,16r6e1b,16r6e5b,16r6e58,16r6e24,16r6e56,
16r6e6e,16r6e2d,16r6e26,16r6e6f,16r6e34,16r6e4d,16r6e3a,16r6e2c,
16r6e43,16r6e1d,16r6e3e,16r6ecb,16r6e89,16r6e19,16r6e4e,16r6e63,
16r6e44,16r6e72,16r6e69,16r6e5f,16r7119,16r711a,16r7126,16r7130,
16r7121,16r7136,16r716e,16r711c,16r724c,16r7284,16r7280,16r7336,
16r7325,16r7334,16r7329,16r743a,16r742a,16r7433,16r7422,16r7425,
16r7435,16r7436,16r7434,16r742f,16r741b,16r7426,16r7428,16r7525,
16r7526,16r756b,16r756a,16r75e2,16r75db,16r75e3,16r75d9,16r75d8,
16r75de,16r75e0,16r767b,16r767c,16r7696,16r7693,16r76b4,16r76dc,
16r774f,16r77ed,16r785d,16r786c,16r786f,16r7a0d,16r7a08,16r7a0b,
16r7a05,16r7a00,16r7a98,16r7a97,16r7a96,16r7ae5,16r7ae3,16r7b49,
16r7b56,16r7b46,16r7b50,16r7b52,16r7b54,16r7b4d,16r7b4b,16r7b4f,
16r7b51,16r7c9f,16r7ca5,16r7d5e,16r7d50,16r7d68,16r7d55,16r7d2b,
16r7d6e,16r7d72,16r7d61,16r7d66,16r7d62,16r7d70,16r7d73,16r5584,
16r7fd4,16r7fd5,16r800b,16r8052,16r8085,16r8155,16r8154,16r814b,
16r8151,16r814e,16r8139,16r8146,16r813e,16r814c,16r8153,16r8174,
16r8212,16r821c,16r83e9,16r8403,16r83f8,16r840d,16r83e0,16r83c5,
16r840b,16r83c1,16r83ef,16r83f1,16r83f4,16r8457,16r840a,16r83f0,
16r840c,16r83cc,16r83fd,16r83f2,16r83ca,16r8438,16r840e,16r8404,
16r83dc,16r8407,16r83d4,16r83df,16r865b,16r86df,16r86d9,16r86ed,
16r86d4,16r86db,16r86e4,16r86d0,16r86de,16r8857,16r88c1,16r88c2,
16r88b1,16r8983,16r8996,16r8a3b,16r8a60,16r8a55,16r8a5e,16r8a3c,
16r8a41,16r8a54,16r8a5b,16r8a50,16r8a46,16r8a34,16r8a3a,16r8a36,
16r8a56,16r8c61,16r8c82,16r8caf,16r8cbc,16r8cb3,16r8cbd,16r8cc1,
16r8cbb,16r8cc0,16r8cb4,16r8cb7,16r8cb6,16r8cbf,16r8cb8,16r8d8a,
16r8d85,16r8d81,16r8dce,16r8ddd,16r8dcb,16r8dda,16r8dd1,16r8dcc,
16r8ddb,16r8dc6,16r8efb,16r8ef8,16r8efc,16r8f9c,16r902e,16r9035,
16r9031,16r9038,16r9032,16r9036,16r9102,16r90f5,16r9109,16r90fe,
16r9163,16r9165,16r91cf,16r9214,16r9215,16r9223,16r9209,16r921e,
16r920d,16r9210,16r9207,16r9211,16r9594,16r958f,16r958b,16r9591,
16r9593,16r9592,16r958e,16r968a,16r968e,16r968b,16r967d,16r9685,
16r9686,16r968d,16r9672,16r9684,16r96c1,16r96c5,16r96c4,16r96c6,
16r96c7,16r96ef,16r96f2,16r97cc,16r9805,16r9806,16r9808,16r98e7,
16r98ea,16r98ef,16r98e9,16r98f2,16r98ed,16r99ae,16r99ad,16r9ec3,
16r9ecd,16r9ed1,16r4e82,16r50ad,16r50b5,16r50b2,16r50b3,16r50c5,
16r50be,16r50ac,16r50b7,16r50bb,16r50af,16r50c7,16r527f,16r5277,
16r527d,16r52df,16r52e6,16r52e4,16r52e2,16r52e3,16r532f,16r55df,
16r55e8,16r55d3,16r55e6,16r55ce,16r55dc,16r55c7,16r55d1,16r55e3,
16r55e4,16r55ef,16r55da,16r55e1,16r55c5,16r55c6,16r55e5,16r55c9,
16r5712,16r5713,16r585e,16r5851,16r5858,16r5857,16r585a,16r5854,
16r586b,16r584c,16r586d,16r584a,16r5862,16r5852,16r584b,16r5967,
16r5ac1,16r5ac9,16r5acc,16r5abe,16r5abd,16r5abc,16r5ab3,16r5ac2,
16r5ab2,16r5d69,16r5d6f,16r5e4c,16r5e79,16r5ec9,16r5ec8,16r5f12,
16r5f59,16r5fac,16r5fae,16r611a,16r610f,16r6148,16r611f,16r60f3,
16r611b,16r60f9,16r6101,16r6108,16r614e,16r614c,16r6144,16r614d,
16r613e,16r6134,16r6127,16r610d,16r6106,16r6137,16r6221,16r6222,
16r6413,16r643e,16r641e,16r642a,16r642d,16r643d,16r642c,16r640f,
16r641c,16r6414,16r640d,16r6436,16r6416,16r6417,16r6406,16r656c,
16r659f,16r65b0,16r6697,16r6689,16r6687,16r6688,16r6696,16r6684,
16r6698,16r668d,16r6703,16r6994,16r696d,16r695a,16r6977,16r6960,
16r6954,16r6975,16r6930,16r6982,16r694a,16r6968,16r696b,16r695e,
16r6953,16r6979,16r6986,16r695d,16r6963,16r695b,16r6b47,16r6b72,
16r6bc0,16r6bbf,16r6bd3,16r6bfd,16r6ea2,16r6eaf,16r6ed3,16r6eb6,
16r6ec2,16r6e90,16r6e9d,16r6ec7,16r6ec5,16r6ea5,16r6e98,16r6ebc,
16r6eba,16r6eab,16r6ed1,16r6e96,16r6e9c,16r6ec4,16r6ed4,16r6eaa,
16r6ea7,16r6eb4,16r714e,16r7159,16r7169,16r7164,16r7149,16r7167,
16r715c,16r716c,16r7166,16r714c,16r7165,16r715e,16r7146,16r7168,
16r7156,16r723a,16r7252,16r7337,16r7345,16r733f,16r733e,16r746f,
16r745a,16r7455,16r745f,16r745e,16r7441,16r743f,16r7459,16r745b,
16r745c,16r7576,16r7578,16r7600,16r75f0,16r7601,16r75f2,16r75f1,
16r75fa,16r75ff,16r75f4,16r75f3,16r76de,16r76df,16r775b,16r776b,
16r7766,16r775e,16r7763,16r7779,16r776a,16r776c,16r775c,16r7765,
16r7768,16r7762,16r77ee,16r788e,16r78b0,16r7897,16r7898,16r788c,
16r7889,16r787c,16r7891,16r7893,16r787f,16r797a,16r797f,16r7981,
16r842c,16r79bd,16r7a1c,16r7a1a,16r7a20,16r7a14,16r7a1f,16r7a1e,
16r7a9f,16r7aa0,16r7b77,16r7bc0,16r7b60,16r7b6e,16r7b67,16r7cb1,
16r7cb3,16r7cb5,16r7d93,16r7d79,16r7d91,16r7d81,16r7d8f,16r7d5b,
16r7f6e,16r7f69,16r7f6a,16r7f72,16r7fa9,16r7fa8,16r7fa4,16r8056,
16r8058,16r8086,16r8084,16r8171,16r8170,16r8178,16r8165,16r816e,
16r8173,16r816b,16r8179,16r817a,16r8166,16r8205,16r8247,16r8482,
16r8477,16r843d,16r8431,16r8475,16r8466,16r846b,16r8449,16r846c,
16r845b,16r843c,16r8435,16r8461,16r8463,16r8469,16r846d,16r8446,
16r865e,16r865c,16r865f,16r86f9,16r8713,16r8708,16r8707,16r8700,
16r86fe,16r86fb,16r8702,16r8703,16r8706,16r870a,16r8859,16r88df,
16r88d4,16r88d9,16r88dc,16r88d8,16r88dd,16r88e1,16r88ca,16r88d5,
16r88d2,16r899c,16r89e3,16r8a6b,16r8a72,16r8a73,16r8a66,16r8a69,
16r8a70,16r8a87,16r8a7c,16r8a63,16r8aa0,16r8a71,16r8a85,16r8a6d,
16r8a62,16r8a6e,16r8a6c,16r8a79,16r8a7b,16r8a3e,16r8a68,16r8c62,
16r8c8a,16r8c89,16r8cca,16r8cc7,16r8cc8,16r8cc4,16r8cb2,16r8cc3,
16r8cc2,16r8cc5,16r8de1,16r8ddf,16r8de8,16r8def,16r8df3,16r8dfa,
16r8dea,16r8de4,16r8de6,16r8eb2,16r8f03,16r8f09,16r8efe,16r8f0a,
16r8f9f,16r8fb2,16r904b,16r904a,16r9053,16r9042,16r9054,16r903c,
16r9055,16r9050,16r9047,16r904f,16r904e,16r904d,16r9051,16r903e,
16r9041,16r9112,16r9117,16r916c,16r916a,16r9169,16r91c9,16r9237,
16r9257,16r9238,16r923d,16r9240,16r923e,16r925b,16r924b,16r9264,
16r9251,16r9234,16r9249,16r924d,16r9245,16r9239,16r923f,16r925a,
16r9598,16r9698,16r9694,16r9695,16r96cd,16r96cb,16r96c9,16r96ca,
16r96f7,16r96fb,16r96f9,16r96f6,16r9756,16r9774,16r9776,16r9810,
16r9811,16r9813,16r980a,16r9812,16r980c,16r98fc,16r98f4,16r98fd,
16r98fe,16r99b3,16r99b1,16r99b4,16r9ae1,16r9ce9,16r9e82,16r9f0e,
16r9f13,16r9f20,16r50e7,16r50ee,16r50e5,16r50d6,16r50ed,16r50da,
16r50d5,16r50cf,16r50d1,16r50f1,16r50ce,16r50e9,16r5162,16r51f3,
16r5283,16r5282,16r5331,16r53ad,16r55fe,16r5600,16r561b,16r5617,
16r55fd,16r5614,16r5606,16r5609,16r560d,16r560e,16r55f7,16r5616,
16r561f,16r5608,16r5610,16r55f6,16r5718,16r5716,16r5875,16r587e,
16r5883,16r5893,16r588a,16r5879,16r5885,16r587d,16r58fd,16r5925,
16r5922,16r5924,16r596a,16r5969,16r5ae1,16r5ae6,16r5ae9,16r5ad7,
16r5ad6,16r5ad8,16r5ae3,16r5b75,16r5bde,16r5be7,16r5be1,16r5be5,
16r5be6,16r5be8,16r5be2,16r5be4,16r5bdf,16r5c0d,16r5c62,16r5d84,
16r5d87,16r5e5b,16r5e63,16r5e55,16r5e57,16r5e54,16r5ed3,16r5ed6,
16r5f0a,16r5f46,16r5f70,16r5fb9,16r6147,16r613f,16r614b,16r6177,
16r6162,16r6163,16r615f,16r615a,16r6158,16r6175,16r622a,16r6487,
16r6458,16r6454,16r64a4,16r6478,16r645f,16r647a,16r6451,16r6467,
16r6434,16r646d,16r647b,16r6572,16r65a1,16r65d7,16r65d6,16r66a2,
16r66a8,16r669d,16r699c,16r69a8,16r6995,16r69c1,16r69ae,16r69d3,
16r69cb,16r699b,16r69b7,16r69bb,16r69ab,16r69b4,16r69d0,16r69cd,
16r69ad,16r69cc,16r69a6,16r69c3,16r69a3,16r6b49,16r6b4c,16r6c33,
16r6f33,16r6f14,16r6efe,16r6f13,16r6ef4,16r6f29,16r6f3e,16r6f20,
16r6f2c,16r6f0f,16r6f02,16r6f22,16r6eff,16r6eef,16r6f06,16r6f31,
16r6f38,16r6f32,16r6f23,16r6f15,16r6f2b,16r6f2f,16r6f88,16r6f2a,
16r6eec,16r6f01,16r6ef2,16r6ecc,16r6ef7,16r7194,16r7199,16r717d,
16r718a,16r7184,16r7192,16r723e,16r7292,16r7296,16r7344,16r7350,
16r7464,16r7463,16r746a,16r7470,16r746d,16r7504,16r7591,16r7627,
16r760d,16r760b,16r7609,16r7613,16r76e1,16r76e3,16r7784,16r777d,
16r777f,16r7761,16r78c1,16r789f,16r78a7,16r78b3,16r78a9,16r78a3,
16r798e,16r798f,16r798d,16r7a2e,16r7a31,16r7aaa,16r7aa9,16r7aed,
16r7aef,16r7ba1,16r7b95,16r7b8b,16r7b75,16r7b97,16r7b9d,16r7b94,
16r7b8f,16r7bb8,16r7b87,16r7b84,16r7cb9,16r7cbd,16r7cbe,16r7dbb,
16r7db0,16r7d9c,16r7dbd,16r7dbe,16r7da0,16r7dca,16r7db4,16r7db2,
16r7db1,16r7dba,16r7da2,16r7dbf,16r7db5,16r7db8,16r7dad,16r7dd2,
16r7dc7,16r7dac,16r7f70,16r7fe0,16r7fe1,16r7fdf,16r805e,16r805a,
16r8087,16r8150,16r8180,16r818f,16r8188,16r818a,16r817f,16r8182,
16r81e7,16r81fa,16r8207,16r8214,16r821e,16r824b,16r84c9,16r84bf,
16r84c6,16r84c4,16r8499,16r849e,16r84b2,16r849c,16r84cb,16r84b8,
16r84c0,16r84d3,16r8490,16r84bc,16r84d1,16r84ca,16r873f,16r871c,
16r873b,16r8722,16r8725,16r8734,16r8718,16r8755,16r8737,16r8729,
16r88f3,16r8902,16r88f4,16r88f9,16r88f8,16r88fd,16r88e8,16r891a,
16r88ef,16r8aa6,16r8a8c,16r8a9e,16r8aa3,16r8a8d,16r8aa1,16r8a93,
16r8aa4,16r8aaa,16r8aa5,16r8aa8,16r8a98,16r8a91,16r8a9a,16r8aa7,
16r8c6a,16r8c8d,16r8c8c,16r8cd3,16r8cd1,16r8cd2,16r8d6b,16r8d99,
16r8d95,16r8dfc,16r8f14,16r8f12,16r8f15,16r8f13,16r8fa3,16r9060,
16r9058,16r905c,16r9063,16r9059,16r905e,16r9062,16r905d,16r905b,
16r9119,16r9118,16r911e,16r9175,16r9178,16r9177,16r9174,16r9278,
16r9280,16r9285,16r9298,16r9296,16r927b,16r9293,16r929c,16r92a8,
16r927c,16r9291,16r95a1,16r95a8,16r95a9,16r95a3,16r95a5,16r95a4,
16r9699,16r969c,16r969b,16r96cc,16r96d2,16r9700,16r977c,16r9785,
16r97f6,16r9817,16r9818,16r98af,16r98b1,16r9903,16r9905,16r990c,
16r9909,16r99c1,16r9aaf,16r9ab0,16r9ae6,16r9b41,16r9b42,16r9cf4,
16r9cf6,16r9cf3,16r9ebc,16r9f3b,16r9f4a,16r5104,16r5100,16r50fb,
16r50f5,16r50f9,16r5102,16r5108,16r5109,16r5105,16r51dc,16r5287,
16r5288,16r5289,16r528d,16r528a,16r52f0,16r53b2,16r562e,16r563b,
16r5639,16r5632,16r563f,16r5634,16r5629,16r5653,16r564e,16r5657,
16r5674,16r5636,16r562f,16r5630,16r5880,16r589f,16r589e,16r58b3,
16r589c,16r58ae,16r58a9,16r58a6,16r596d,16r5b09,16r5afb,16r5b0b,
16r5af5,16r5b0c,16r5b08,16r5bee,16r5bec,16r5be9,16r5beb,16r5c64,
16r5c65,16r5d9d,16r5d94,16r5e62,16r5e5f,16r5e61,16r5ee2,16r5eda,
16r5edf,16r5edd,16r5ee3,16r5ee0,16r5f48,16r5f71,16r5fb7,16r5fb5,
16r6176,16r6167,16r616e,16r615d,16r6155,16r6182,16r617c,16r6170,
16r616b,16r617e,16r61a7,16r6190,16r61ab,16r618e,16r61ac,16r619a,
16r61a4,16r6194,16r61ae,16r622e,16r6469,16r646f,16r6479,16r649e,
16r64b2,16r6488,16r6490,16r64b0,16r64a5,16r6493,16r6495,16r64a9,
16r6492,16r64ae,16r64ad,16r64ab,16r649a,16r64ac,16r6499,16r64a2,
16r64b3,16r6575,16r6577,16r6578,16r66ae,16r66ab,16r66b4,16r66b1,
16r6a23,16r6a1f,16r69e8,16r6a01,16r6a1e,16r6a19,16r69fd,16r6a21,
16r6a13,16r6a0a,16r69f3,16r6a02,16r6a05,16r69ed,16r6a11,16r6b50,
16r6b4e,16r6ba4,16r6bc5,16r6bc6,16r6f3f,16r6f7c,16r6f84,16r6f51,
16r6f66,16r6f54,16r6f86,16r6f6d,16r6f5b,16r6f78,16r6f6e,16r6f8e,
16r6f7a,16r6f70,16r6f64,16r6f97,16r6f58,16r6ed5,16r6f6f,16r6f60,
16r6f5f,16r719f,16r71ac,16r71b1,16r71a8,16r7256,16r729b,16r734e,
16r7357,16r7469,16r748b,16r7483,16r747e,16r7480,16r757f,16r7620,
16r7629,16r761f,16r7624,16r7626,16r7621,16r7622,16r769a,16r76ba,
16r76e4,16r778e,16r7787,16r778c,16r7791,16r778b,16r78cb,16r78c5,
16r78ba,16r78ca,16r78be,16r78d5,16r78bc,16r78d0,16r7a3f,16r7a3c,
16r7a40,16r7a3d,16r7a37,16r7a3b,16r7aaf,16r7aae,16r7bad,16r7bb1,
16r7bc4,16r7bb4,16r7bc6,16r7bc7,16r7bc1,16r7ba0,16r7bcc,16r7cca,
16r7de0,16r7df4,16r7def,16r7dfb,16r7dd8,16r7dec,16r7ddd,16r7de8,
16r7de3,16r7dda,16r7dde,16r7de9,16r7d9e,16r7dd9,16r7df2,16r7df9,
16r7f75,16r7f77,16r7faf,16r7fe9,16r8026,16r819b,16r819c,16r819d,
16r81a0,16r819a,16r8198,16r8517,16r853d,16r851a,16r84ee,16r852c,
16r852d,16r8513,16r8511,16r8523,16r8521,16r8514,16r84ec,16r8525,
16r84ff,16r8506,16r8782,16r8774,16r8776,16r8760,16r8766,16r8778,
16r8768,16r8759,16r8757,16r874c,16r8753,16r885b,16r885d,16r8910,
16r8907,16r8912,16r8913,16r8915,16r890a,16r8abc,16r8ad2,16r8ac7,
16r8ac4,16r8a95,16r8acb,16r8af8,16r8ab2,16r8ac9,16r8ac2,16r8abf,
16r8ab0,16r8ad6,16r8acd,16r8ab6,16r8ab9,16r8adb,16r8c4c,16r8c4e,
16r8c6c,16r8ce0,16r8cde,16r8ce6,16r8ce4,16r8cec,16r8ced,16r8ce2,
16r8ce3,16r8cdc,16r8cea,16r8ce1,16r8d6d,16r8d9f,16r8da3,16r8e2b,
16r8e10,16r8e1d,16r8e22,16r8e0f,16r8e29,16r8e1f,16r8e21,16r8e1e,
16r8eba,16r8f1d,16r8f1b,16r8f1f,16r8f29,16r8f26,16r8f2a,16r8f1c,
16r8f1e,16r8f25,16r9069,16r906e,16r9068,16r906d,16r9077,16r9130,
16r912d,16r9127,16r9131,16r9187,16r9189,16r918b,16r9183,16r92c5,
16r92bb,16r92b7,16r92ea,16r92ac,16r92e4,16r92c1,16r92b3,16r92bc,
16r92d2,16r92c7,16r92f0,16r92b2,16r95ad,16r95b1,16r9704,16r9706,
16r9707,16r9709,16r9760,16r978d,16r978b,16r978f,16r9821,16r982b,
16r981c,16r98b3,16r990a,16r9913,16r9912,16r9918,16r99dd,16r99d0,
16r99df,16r99db,16r99d1,16r99d5,16r99d2,16r99d9,16r9ab7,16r9aee,
16r9aef,16r9b27,16r9b45,16r9b44,16r9b77,16r9b6f,16r9d06,16r9d09,
16r9d03,16r9ea9,16r9ebe,16r9ece,16r58a8,16r9f52,16r5112,16r5118,
16r5114,16r5110,16r5115,16r5180,16r51aa,16r51dd,16r5291,16r5293,
16r52f3,16r5659,16r566b,16r5679,16r5669,16r5664,16r5678,16r566a,
16r5668,16r5665,16r5671,16r566f,16r566c,16r5662,16r5676,16r58c1,
16r58be,16r58c7,16r58c5,16r596e,16r5b1d,16r5b34,16r5b78,16r5bf0,
16r5c0e,16r5f4a,16r61b2,16r6191,16r61a9,16r618a,16r61cd,16r61b6,
16r61be,16r61ca,16r61c8,16r6230,16r64c5,16r64c1,16r64cb,16r64bb,
16r64bc,16r64da,16r64c4,16r64c7,16r64c2,16r64cd,16r64bf,16r64d2,
16r64d4,16r64be,16r6574,16r66c6,16r66c9,16r66b9,16r66c4,16r66c7,
16r66b8,16r6a3d,16r6a38,16r6a3a,16r6a59,16r6a6b,16r6a58,16r6a39,
16r6a44,16r6a62,16r6a61,16r6a4b,16r6a47,16r6a35,16r6a5f,16r6a48,
16r6b59,16r6b77,16r6c05,16r6fc2,16r6fb1,16r6fa1,16r6fc3,16r6fa4,
16r6fc1,16r6fa7,16r6fb3,16r6fc0,16r6fb9,16r6fb6,16r6fa6,16r6fa0,
16r6fb4,16r71be,16r71c9,16r71d0,16r71d2,16r71c8,16r71d5,16r71b9,
16r71ce,16r71d9,16r71dc,16r71c3,16r71c4,16r7368,16r749c,16r74a3,
16r7498,16r749f,16r749e,16r74e2,16r750c,16r750d,16r7634,16r7638,
16r763a,16r76e7,16r76e5,16r77a0,16r779e,16r779f,16r77a5,16r78e8,
16r78da,16r78ec,16r78e7,16r79a6,16r7a4d,16r7a4e,16r7a46,16r7a4c,
16r7a4b,16r7aba,16r7bd9,16r7c11,16r7bc9,16r7be4,16r7bdb,16r7be1,
16r7be9,16r7be6,16r7cd5,16r7cd6,16r7e0a,16r7e11,16r7e08,16r7e1b,
16r7e23,16r7e1e,16r7e1d,16r7e09,16r7e10,16r7f79,16r7fb2,16r7ff0,
16r7ff1,16r7fee,16r8028,16r81b3,16r81a9,16r81a8,16r81fb,16r8208,
16r8258,16r8259,16r854a,16r8559,16r8548,16r8568,16r8569,16r8543,
16r8549,16r856d,16r856a,16r855e,16r8783,16r879f,16r879e,16r87a2,
16r878d,16r8861,16r892a,16r8932,16r8925,16r892b,16r8921,16r89aa,
16r89a6,16r8ae6,16r8afa,16r8aeb,16r8af1,16r8b00,16r8adc,16r8ae7,
16r8aee,16r8afe,16r8b01,16r8b02,16r8af7,16r8aed,16r8af3,16r8af6,
16r8afc,16r8c6b,16r8c6d,16r8c93,16r8cf4,16r8e44,16r8e31,16r8e34,
16r8e42,16r8e39,16r8e35,16r8f3b,16r8f2f,16r8f38,16r8f33,16r8fa8,
16r8fa6,16r9075,16r9074,16r9078,16r9072,16r907c,16r907a,16r9134,
16r9192,16r9320,16r9336,16r92f8,16r9333,16r932f,16r9322,16r92fc,
16r932b,16r9304,16r931a,16r9310,16r9326,16r9321,16r9315,16r932e,
16r9319,16r95bb,16r96a7,16r96a8,16r96aa,16r96d5,16r970e,16r9711,
16r9716,16r970d,16r9713,16r970f,16r975b,16r975c,16r9766,16r9798,
16r9830,16r9838,16r983b,16r9837,16r982d,16r9839,16r9824,16r9910,
16r9928,16r991e,16r991b,16r9921,16r991a,16r99ed,16r99e2,16r99f1,
16r9ab8,16r9abc,16r9afb,16r9aed,16r9b28,16r9b91,16r9d15,16r9d23,
16r9d26,16r9d28,16r9d12,16r9d1b,16r9ed8,16r9ed4,16r9f8d,16r9f9c,
16r512a,16r511f,16r5121,16r5132,16r52f5,16r568e,16r5680,16r5690,
16r5685,16r5687,16r568f,16r58d5,16r58d3,16r58d1,16r58ce,16r5b30,
16r5b2a,16r5b24,16r5b7a,16r5c37,16r5c68,16r5dbc,16r5dba,16r5dbd,
16r5db8,16r5e6b,16r5f4c,16r5fbd,16r61c9,16r61c2,16r61c7,16r61e6,
16r61cb,16r6232,16r6234,16r64ce,16r64ca,16r64d8,16r64e0,16r64f0,
16r64e6,16r64ec,16r64f1,16r64e2,16r64ed,16r6582,16r6583,16r66d9,
16r66d6,16r6a80,16r6a94,16r6a84,16r6aa2,16r6a9c,16r6adb,16r6aa3,
16r6a7e,16r6a97,16r6a90,16r6aa0,16r6b5c,16r6bae,16r6bda,16r6c08,
16r6fd8,16r6ff1,16r6fdf,16r6fe0,16r6fdb,16r6fe4,16r6feb,16r6fef,
16r6f80,16r6fec,16r6fe1,16r6fe9,16r6fd5,16r6fee,16r6ff0,16r71e7,
16r71df,16r71ee,16r71e6,16r71e5,16r71ed,16r71ec,16r71f4,16r71e0,
16r7235,16r7246,16r7370,16r7372,16r74a9,16r74b0,16r74a6,16r74a8,
16r7646,16r7642,16r764c,16r76ea,16r77b3,16r77aa,16r77b0,16r77ac,
16r77a7,16r77ad,16r77ef,16r78f7,16r78fa,16r78f4,16r78ef,16r7901,
16r79a7,16r79aa,16r7a57,16r7abf,16r7c07,16r7c0d,16r7bfe,16r7bf7,
16r7c0c,16r7be0,16r7ce0,16r7cdc,16r7cde,16r7ce2,16r7cdf,16r7cd9,
16r7cdd,16r7e2e,16r7e3e,16r7e46,16r7e37,16r7e32,16r7e43,16r7e2b,
16r7e3d,16r7e31,16r7e45,16r7e41,16r7e34,16r7e39,16r7e48,16r7e35,
16r7e3f,16r7e2f,16r7f44,16r7ff3,16r7ffc,16r8071,16r8072,16r8070,
16r806f,16r8073,16r81c6,16r81c3,16r81ba,16r81c2,16r81c0,16r81bf,
16r81bd,16r81c9,16r81be,16r81e8,16r8209,16r8271,16r85aa,16r8584,
16r857e,16r859c,16r8591,16r8594,16r85af,16r859b,16r8587,16r85a8,
16r858a,16r8667,16r87c0,16r87d1,16r87b3,16r87d2,16r87c6,16r87ab,
16r87bb,16r87ba,16r87c8,16r87cb,16r893b,16r8936,16r8944,16r8938,
16r893d,16r89ac,16r8b0e,16r8b17,16r8b19,16r8b1b,16r8b0a,16r8b20,
16r8b1d,16r8b04,16r8b10,16r8c41,16r8c3f,16r8c73,16r8cfa,16r8cfd,
16r8cfc,16r8cf8,16r8cfb,16r8da8,16r8e49,16r8e4b,16r8e48,16r8e4a,
16r8f44,16r8f3e,16r8f42,16r8f45,16r8f3f,16r907f,16r907d,16r9084,
16r9081,16r9082,16r9080,16r9139,16r91a3,16r919e,16r919c,16r934d,
16r9382,16r9328,16r9375,16r934a,16r9365,16r934b,16r9318,16r937e,
16r936c,16r935b,16r9370,16r935a,16r9354,16r95ca,16r95cb,16r95cc,
16r95c8,16r95c6,16r96b1,16r96b8,16r96d6,16r971c,16r971e,16r97a0,
16r97d3,16r9846,16r98b6,16r9935,16r9a01,16r99ff,16r9bae,16r9bab,
16r9baa,16r9bad,16r9d3b,16r9d3f,16r9e8b,16r9ecf,16r9ede,16r9edc,
16r9edd,16r9edb,16r9f3e,16r9f4b,16r53e2,16r5695,16r56ae,16r58d9,
16r58d8,16r5b38,16r5f5d,16r61e3,16r6233,16r64f4,16r64f2,16r64fe,
16r6506,16r64fa,16r64fb,16r64f7,16r65b7,16r66dc,16r6726,16r6ab3,
16r6aac,16r6ac3,16r6abb,16r6ab8,16r6ac2,16r6aae,16r6aaf,16r6b5f,
16r6b78,16r6baf,16r7009,16r700b,16r6ffe,16r7006,16r6ffa,16r7011,
16r700f,16r71fb,16r71fc,16r71fe,16r71f8,16r7377,16r7375,16r74a7,
16r74bf,16r7515,16r7656,16r7658,16r7652,16r77bd,16r77bf,16r77bb,
16r77bc,16r790e,16r79ae,16r7a61,16r7a62,16r7a60,16r7ac4,16r7ac5,
16r7c2b,16r7c27,16r7c2a,16r7c1e,16r7c23,16r7c21,16r7ce7,16r7e54,
16r7e55,16r7e5e,16r7e5a,16r7e61,16r7e52,16r7e59,16r7f48,16r7ff9,
16r7ffb,16r8077,16r8076,16r81cd,16r81cf,16r820a,16r85cf,16r85a9,
16r85cd,16r85d0,16r85c9,16r85b0,16r85ba,16r85b9,16r85a6,16r87ef,
16r87ec,16r87f2,16r87e0,16r8986,16r89b2,16r89f4,16r8b28,16r8b39,
16r8b2c,16r8b2b,16r8c50,16r8d05,16r8e59,16r8e63,16r8e66,16r8e64,
16r8e5f,16r8e55,16r8ec0,16r8f49,16r8f4d,16r9087,16r9083,16r9088,
16r91ab,16r91ac,16r91d0,16r9394,16r938a,16r9396,16r93a2,16r93b3,
16r93ae,16r93ac,16r93b0,16r9398,16r939a,16r9397,16r95d4,16r95d6,
16r95d0,16r95d5,16r96e2,16r96dc,16r96d9,16r96db,16r96de,16r9724,
16r97a3,16r97a6,16r97ad,16r97f9,16r984d,16r984f,16r984c,16r984e,
16r9853,16r98ba,16r993e,16r993f,16r993d,16r992e,16r99a5,16r9a0e,
16r9ac1,16r9b03,16r9b06,16r9b4f,16r9b4e,16r9b4d,16r9bca,16r9bc9,
16r9bfd,16r9bc8,16r9bc0,16r9d51,16r9d5d,16r9d60,16r9ee0,16r9f15,
16r9f2c,16r5133,16r56a5,16r58de,16r58df,16r58e2,16r5bf5,16r9f90,
16r5eec,16r61f2,16r61f7,16r61f6,16r61f5,16r6500,16r650f,16r66e0,
16r66dd,16r6ae5,16r6add,16r6ada,16r6ad3,16r701b,16r701f,16r7028,
16r701a,16r701d,16r7015,16r7018,16r7206,16r720d,16r7258,16r72a2,
16r7378,16r737a,16r74bd,16r74ca,16r74e3,16r7587,16r7586,16r765f,
16r7661,16r77c7,16r7919,16r79b1,16r7a6b,16r7a69,16r7c3e,16r7c3f,
16r7c38,16r7c3d,16r7c37,16r7c40,16r7e6b,16r7e6d,16r7e79,16r7e69,
16r7e6a,16r7f85,16r7e73,16r7fb6,16r7fb9,16r7fb8,16r81d8,16r85e9,
16r85dd,16r85ea,16r85d5,16r85e4,16r85e5,16r85f7,16r87fb,16r8805,
16r880d,16r87f9,16r87fe,16r8960,16r895f,16r8956,16r895e,16r8b41,
16r8b5c,16r8b58,16r8b49,16r8b5a,16r8b4e,16r8b4f,16r8b46,16r8b59,
16r8d08,16r8d0a,16r8e7c,16r8e72,16r8e87,16r8e76,16r8e6c,16r8e7a,
16r8e74,16r8f54,16r8f4e,16r8fad,16r908a,16r908b,16r91b1,16r91ae,
16r93e1,16r93d1,16r93df,16r93c3,16r93c8,16r93dc,16r93dd,16r93d6,
16r93e2,16r93cd,16r93d8,16r93e4,16r93d7,16r93e8,16r95dc,16r96b4,
16r96e3,16r972a,16r9727,16r9761,16r97dc,16r97fb,16r985e,16r9858,
16r985b,16r98bc,16r9945,16r9949,16r9a16,16r9a19,16r9b0d,16r9be8,
16r9be7,16r9bd6,16r9bdb,16r9d89,16r9d61,16r9d72,16r9d6a,16r9d6c,
16r9e92,16r9e97,16r9e93,16r9eb4,16r52f8,16r56a8,16r56b7,16r56b6,
16r56b4,16r56bc,16r58e4,16r5b40,16r5b43,16r5b7d,16r5bf6,16r5dc9,
16r61f8,16r61fa,16r6518,16r6514,16r6519,16r66e6,16r6727,16r6aec,
16r703e,16r7030,16r7032,16r7210,16r737b,16r74cf,16r7662,16r7665,
16r7926,16r792a,16r792c,16r792b,16r7ac7,16r7af6,16r7c4c,16r7c43,
16r7c4d,16r7cef,16r7cf0,16r8fae,16r7e7d,16r7e7c,16r7e82,16r7f4c,
16r8000,16r81da,16r8266,16r85fb,16r85f9,16r8611,16r85fa,16r8606,
16r860b,16r8607,16r860a,16r8814,16r8815,16r8964,16r89ba,16r89f8,
16r8b70,16r8b6c,16r8b66,16r8b6f,16r8b5f,16r8b6b,16r8d0f,16r8d0d,
16r8e89,16r8e81,16r8e85,16r8e82,16r91b4,16r91cb,16r9418,16r9403,
16r93fd,16r95e1,16r9730,16r98c4,16r9952,16r9951,16r99a8,16r9a2b,
16r9a30,16r9a37,16r9a35,16r9c13,16r9c0d,16r9e79,16r9eb5,16r9ee8,
16r9f2f,16r9f5f,16r9f63,16r9f61,16r5137,16r5138,16r56c1,16r56c0,
16r56c2,16r5914,16r5c6c,16r5dcd,16r61fc,16r61fe,16r651d,16r651c,
16r6595,16r66e9,16r6afb,16r6b04,16r6afa,16r6bb2,16r704c,16r721b,
16r72a7,16r74d6,16r74d4,16r7669,16r77d3,16r7c50,16r7e8f,16r7e8c,
16r7fbc,16r8617,16r862d,16r861a,16r8823,16r8822,16r8821,16r881f,
16r896a,16r896c,16r89bd,16r8b74,16r8b77,16r8b7d,16r8d13,16r8e8a,
16r8e8d,16r8e8b,16r8f5f,16r8faf,16r91ba,16r942e,16r9433,16r9435,
16r943a,16r9438,16r9432,16r942b,16r95e2,16r9738,16r9739,16r9732,
16r97ff,16r9867,16r9865,16r9957,16r9a45,16r9a43,16r9a40,16r9a3e,
16r9acf,16r9b54,16r9b51,16r9c2d,16r9c25,16r9daf,16r9db4,16r9dc2,
16r9db8,16r9e9d,16r9eef,16r9f19,16r9f5c,16r9f66,16r9f67,16r513c,
16r513b,16r56c8,16r56ca,16r56c9,16r5b7f,16r5dd4,16r5dd2,16r5f4e,
16r61ff,16r6524,16r6b0a,16r6b61,16r7051,16r7058,16r7380,16r74e4,
16r758a,16r766e,16r766c,16r79b3,16r7c60,16r7c5f,16r807e,16r807d,
16r81df,16r8972,16r896f,16r89fc,16r8b80,16r8d16,16r8d17,16r8e91,
16r8e93,16r8f61,16r9148,16r9444,16r9451,16r9452,16r973d,16r973e,
16r97c3,16r97c1,16r986b,16r9955,16r9a55,16r9a4d,16r9ad2,16r9b1a,
16r9c49,16r9c31,16r9c3e,16r9c3b,16r9dd3,16r9dd7,16r9f34,16r9f6c,
16r9f6a,16r9f94,16r56cc,16r5dd6,16r6200,16r6523,16r652b,16r652a,
16r66ec,16r6b10,16r74da,16r7aca,16r7c64,16r7c63,16r7c65,16r7e93,
16r7e96,16r7e94,16r81e2,16r8638,16r863f,16r8831,16r8b8a,16r9090,
16r908f,16r9463,16r9460,16r9464,16r9768,16r986f,16r995c,16r9a5a,
16r9a5b,16r9a57,16r9ad3,16r9ad4,16r9ad1,16r9c54,16r9c57,16r9c56,
16r9de5,16r9e9f,16r9ef4,16r56d1,16r58e9,16r652c,16r705e,16r7671,
16r7672,16r77d7,16r7f50,16r7f88,16r8836,16r8839,16r8862,16r8b93,
16r8b92,16r8b96,16r8277,16r8d1b,16r91c0,16r946a,16r9742,16r9748,
16r9744,16r97c6,16r9870,16r9a5f,16r9b22,16r9b58,16r9c5f,16r9df9,
16r9dfa,16r9e7c,16r9e7d,16r9f07,16r9f77,16r9f72,16r5ef3,16r6b16,
16r7063,16r7c6c,16r7c6e,16r883b,16r89c0,16r8ea1,16r91c1,16r9472,
16r9470,16r9871,16r995e,16r9ad6,16r9b23,16r9ecc,16r7064,16r77da,
16r8b9a,16r9477,16r97c9,16r9a62,16r9a65,16r7e9c,16r8b9c,16r8eaa,
16r91c5,16r947d,16r947e,16r947c,16r9c77,16r9c78,16r9ef7,16r8c54,
16r947f,16r9e1a,16r7228,16r9a6a,16r9b31,16r9e1b,16r9e1e,16r7c72,
16r30fe,16r309d,16r309e,16r3005,16r3041,16r3042,16r3043,16r3044,
16r3045,16r3046,16r3047,16r3048,16r3049,16r304a,16r304b,16r304c,
16r304d,16r304e,16r304f,16r3050,16r3051,16r3052,16r3053,16r3054,
16r3055,16r3056,16r3057,16r3058,16r3059,16r305a,16r305b,16r305c,
16r305d,16r305e,16r305f,16r3060,16r3061,16r3062,16r3063,16r3064,
16r3065,16r3066,16r3067,16r3068,16r3069,16r306a,16r306b,16r306c,
16r306d,16r306e,16r306f,16r3070,16r3071,16r3072,16r3073,16r3074,
16r3075,16r3076,16r3077,16r3078,16r3079,16r307a,16r307b,16r307c,
16r307d,16r307e,16r307f,16r3080,16r3081,16r3082,16r3083,16r3084,
16r3085,16r3086,16r3087,16r3088,16r3089,16r308a,16r308b,16r308c,
16r308d,16r308e,16r308f,16r3090,16r3091,16r3092,16r3093,16r30a1,
16r30a2,16r30a3,16r30a4,16r30a5,16r30a6,16r30a7,16r30a8,16r30a9,
16r30aa,16r30ab,16r30ac,16r30ad,16r30ae,16r30af,16r30b0,16r30b1,
16r30b2,16r30b3,16r30b4,16r30b5,16r30b6,16r30b7,16r30b8,16r30b9,
16r30ba,16r30bb,16r30bc,16r30bd,16r30be,16r30bf,16r30c0,16r30c1,
16r30c2,16r30c3,16r30c4,16r30c5,16r30c6,16r30c7,16r30c8,16r30c9,
16r30ca,16r30cb,16r30cc,16r30cd,16r30ce,16r30cf,16r30d0,16r30d1,
16r30d2,16r30d3,16r30d4,16r30d5,16r30d6,16r30d7,16r30d8,16r30d9,
16r30da,16r30db,16r30dc,16r30dd,16r30de,16r30df,16r30e0,16r30e1,
16r30e2,16r30e3,16r30e4,16r30e5,16r30e6,16r30e7,16r30e8,16r30e9,
16r30ea,16r30eb,16r30ec,16r30ed,16r30ee,16r30ef,16r30f0,16r30f1,
16r30f2,16r30f3,16r30f4,16r30f5,16r30f6,16r0414,16r0415,16r0401,
16r0416,16r0417,16r0418,16r0419,16r041a,16r041b,16r041c,16r0423,
16r0424,16r0425,16r0426,16r0427,16r0428,16r0429,16r042a,16r042b,
16r042c,16r042d,16r042e,16r042f,16r0430,16r0431,16r0432,16r0433,
16r0434,16r0435,16r0451,16r0436,16r0437,16r0438,16r0439,16r043a,
16r043b,16r043c,16r043d,16r043e,16r043f,16r0440,16r0441,16r0442,
16r0443,16r0444,16r0445,16r0446,16r0447,16r0448,16r0449,16r044a,
16r044b,16r044c,16r044d,16r044e,16r044f,16r2460,16r2461,16r2462,
16r2463,16r2464,16r2465,16r2466,16r2467,16r2468,16r2469,16r2474,
16r2475,16r2476,16r2477,16r2478,16r2479,16r247a,16r247b,16r247c,
16r247d,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
16r4e42,16r4e5c,16r51f5,16r531a,16r5382,16r4e07,16r4e0c,16r4e47,
16r4e8d,16r56d7,16rfa0c,16r5c6e,16r5f73,16r4e0f,16r5187,16r4e0e,
16r4e2e,16r4e93,16r4ec2,16r4ec9,16r4ec8,16r5198,16r52fc,16r536c,
16r53b9,16r5720,16r5903,16r592c,16r5c10,16r5dff,16r65e1,16r6bb3,
16r6bcc,16r6c14,16r723f,16r4e31,16r4e3c,16r4ee8,16r4edc,16r4ee9,
16r4ee1,16r4edd,16r4eda,16r520c,16r531c,16r534c,16r5722,16r5723,
16r5917,16r592f,16r5b81,16r5b84,16r5c12,16r5c3b,16r5c74,16r5c73,
16r5e04,16r5e80,16r5e82,16r5fc9,16r6209,16r6250,16r6c15,16r6c36,
16r6c43,16r6c3f,16r6c3b,16r72ae,16r72b0,16r738a,16r79b8,16r808a,
16r961e,16r4f0e,16r4f18,16r4f2c,16r4ef5,16r4f14,16r4ef1,16r4f00,
16r4ef7,16r4f08,16r4f1d,16r4f02,16r4f05,16r4f22,16r4f13,16r4f04,
16r4ef4,16r4f12,16r51b1,16r5213,16r5209,16r5210,16r52a6,16r5322,
16r531f,16r534d,16r538a,16r5407,16r56e1,16r56df,16r572e,16r572a,
16r5734,16r593c,16r5980,16r597c,16r5985,16r597b,16r597e,16r5977,
16r597f,16r5b56,16r5c15,16r5c25,16r5c7c,16r5c7a,16r5c7b,16r5c7e,
16r5ddf,16r5e75,16r5e84,16r5f02,16r5f1a,16r5f74,16r5fd5,16r5fd4,
16r5fcf,16r625c,16r625e,16r6264,16r6261,16r6266,16r6262,16r6259,
16r6260,16r625a,16r6265,16r65ef,16r65ee,16r673e,16r6739,16r6738,
16r673b,16r673a,16r673f,16r673c,16r6733,16r6c18,16r6c46,16r6c52,
16r6c5c,16r6c4f,16r6c4a,16r6c54,16r6c4b,16r6c4c,16r7071,16r725e,
16r72b4,16r72b5,16r738e,16r752a,16r767f,16r7a75,16r7f51,16r8278,
16r827c,16r8280,16r827d,16r827f,16r864d,16r897e,16r9099,16r9097,
16r9098,16r909b,16r9094,16r9622,16r9624,16r9620,16r9623,16r4f56,
16r4f3b,16r4f62,16r4f49,16r4f53,16r4f64,16r4f3e,16r4f67,16r4f52,
16r4f5f,16r4f41,16r4f58,16r4f2d,16r4f33,16r4f3f,16r4f61,16r518f,
16r51b9,16r521c,16r521e,16r5221,16r52ad,16r52ae,16r5309,16r5363,
16r5372,16r538e,16r538f,16r5430,16r5437,16r542a,16r5454,16r5445,
16r5419,16r541c,16r5425,16r5418,16r543d,16r544f,16r5441,16r5428,
16r5424,16r5447,16r56ee,16r56e7,16r56e5,16r5741,16r5745,16r574c,
16r5749,16r574b,16r5752,16r5906,16r5940,16r59a6,16r5998,16r59a0,
16r5997,16r598e,16r59a2,16r5990,16r598f,16r59a7,16r59a1,16r5b8e,
16r5b92,16r5c28,16r5c2a,16r5c8d,16r5c8f,16r5c88,16r5c8b,16r5c89,
16r5c92,16r5c8a,16r5c86,16r5c93,16r5c95,16r5de0,16r5e0a,16r5e0e,
16r5e8b,16r5e89,16r5e8c,16r5e88,16r5e8d,16r5f05,16r5f1d,16r5f78,
16r5f76,16r5fd2,16r5fd1,16r5fd0,16r5fed,16r5fe8,16r5fee,16r5ff3,
16r5fe1,16r5fe4,16r5fe3,16r5ffa,16r5fef,16r5ff7,16r5ffb,16r6000,
16r5ff4,16r623a,16r6283,16r628c,16r628e,16r628f,16r6294,16r6287,
16r6271,16r627b,16r627a,16r6270,16r6281,16r6288,16r6277,16r627d,
16r6272,16r6274,16r6537,16r65f0,16r65f4,16r65f3,16r65f2,16r65f5,
16r6745,16r6747,16r6759,16r6755,16r674c,16r6748,16r675d,16r674d,
16r675a,16r674b,16r6bd0,16r6c19,16r6c1a,16r6c78,16r6c67,16r6c6b,
16r6c84,16r6c8b,16r6c8f,16r6c71,16r6c6f,16r6c69,16r6c9a,16r6c6d,
16r6c87,16r6c95,16r6c9c,16r6c66,16r6c73,16r6c65,16r6c7b,16r6c8e,
16r7074,16r707a,16r7263,16r72bf,16r72bd,16r72c3,16r72c6,16r72c1,
16r72ba,16r72c5,16r7395,16r7397,16r7393,16r7394,16r7392,16r753a,
16r7539,16r7594,16r7595,16r7681,16r793d,16r8034,16r8095,16r8099,
16r8090,16r8092,16r809c,16r8290,16r828f,16r8285,16r828e,16r8291,
16r8293,16r828a,16r8283,16r8284,16r8c78,16r8fc9,16r8fbf,16r909f,
16r90a1,16r90a5,16r909e,16r90a7,16r90a0,16r9630,16r9628,16r962f,
16r962d,16r4e33,16r4f98,16r4f7c,16r4f85,16r4f7d,16r4f80,16r4f87,
16r4f76,16r4f74,16r4f89,16r4f84,16r4f77,16r4f4c,16r4f97,16r4f6a,
16r4f9a,16r4f79,16r4f81,16r4f78,16r4f90,16r4f9c,16r4f94,16r4f9e,
16r4f92,16r4f82,16r4f95,16r4f6b,16r4f6e,16r519e,16r51bc,16r51be,
16r5235,16r5232,16r5233,16r5246,16r5231,16r52bc,16r530a,16r530b,
16r533c,16r5392,16r5394,16r5487,16r547f,16r5481,16r5491,16r5482,
16r5488,16r546b,16r547a,16r547e,16r5465,16r546c,16r5474,16r5466,
16r548d,16r546f,16r5461,16r5460,16r5498,16r5463,16r5467,16r5464,
16r56f7,16r56f9,16r576f,16r5772,16r576d,16r576b,16r5771,16r5770,
16r5776,16r5780,16r5775,16r577b,16r5773,16r5774,16r5762,16r5768,
16r577d,16r590c,16r5945,16r59b5,16r59ba,16r59cf,16r59ce,16r59b2,
16r59cc,16r59c1,16r59b6,16r59bc,16r59c3,16r59d6,16r59b1,16r59bd,
16r59c0,16r59c8,16r59b4,16r59c7,16r5b62,16r5b65,16r5b93,16r5b95,
16r5c44,16r5c47,16r5cae,16r5ca4,16r5ca0,16r5cb5,16r5caf,16r5ca8,
16r5cac,16r5c9f,16r5ca3,16r5cad,16r5ca2,16r5caa,16r5ca7,16r5c9d,
16r5ca5,16r5cb6,16r5cb0,16r5ca6,16r5e17,16r5e14,16r5e19,16r5f28,
16r5f22,16r5f23,16r5f24,16r5f54,16r5f82,16r5f7e,16r5f7d,16r5fde,
16r5fe5,16r602d,16r6026,16r6019,16r6032,16r600b,16r6034,16r600a,
16r6017,16r6033,16r601a,16r601e,16r602c,16r6022,16r600d,16r6010,
16r602e,16r6013,16r6011,16r600c,16r6009,16r601c,16r6214,16r623d,
16r62ad,16r62b4,16r62d1,16r62be,16r62aa,16r62b6,16r62ca,16r62ae,
16r62b3,16r62af,16r62bb,16r62a9,16r62b0,16r62b8,16r653d,16r65a8,
16r65bb,16r6609,16r65fc,16r6604,16r6612,16r6608,16r65fb,16r6603,
16r660b,16r660d,16r6605,16r65fd,16r6611,16r6610,16r66f6,16r670a,
16r6785,16r676c,16r678e,16r6792,16r6776,16r677b,16r6798,16r6786,
16r6784,16r6774,16r678d,16r678c,16r677a,16r679f,16r6791,16r6799,
16r6783,16r677d,16r6781,16r6778,16r6779,16r6794,16r6b25,16r6b80,
16r6b7e,16r6bde,16r6c1d,16r6c93,16r6cec,16r6ceb,16r6cee,16r6cd9,
16r6cb6,16r6cd4,16r6cad,16r6ce7,16r6cb7,16r6cd0,16r6cc2,16r6cba,
16r6cc3,16r6cc6,16r6ced,16r6cf2,16r6cd2,16r6cdd,16r6cb4,16r6c8a,
16r6c9d,16r6c80,16r6cde,16r6cc0,16r6d30,16r6ccd,16r6cc7,16r6cb0,
16r6cf9,16r6ccf,16r6ce9,16r6cd1,16r7094,16r7098,16r7085,16r7093,
16r7086,16r7084,16r7091,16r7096,16r7082,16r709a,16r7083,16r726a,
16r72d6,16r72cb,16r72d8,16r72c9,16r72dc,16r72d2,16r72d4,16r72da,
16r72cc,16r72d1,16r73a4,16r73a1,16r73ad,16r73a6,16r73a2,16r73a0,
16r73ac,16r739d,16r74dd,16r74e8,16r753f,16r7540,16r753e,16r758c,
16r7598,16r76af,16r76f3,16r76f1,16r76f0,16r76f5,16r77f8,16r77fc,
16r77f9,16r77fb,16r77fa,16r77f7,16r7942,16r793f,16r79c5,16r7a78,
16r7a7b,16r7afb,16r7c75,16r7cfd,16r8035,16r808f,16r80ae,16r80a3,
16r80b8,16r80b5,16r80ad,16r8220,16r82a0,16r82c0,16r82ab,16r829a,
16r8298,16r829b,16r82b5,16r82a7,16r82ae,16r82bc,16r829e,16r82ba,
16r82b4,16r82a8,16r82a1,16r82a9,16r82c2,16r82a4,16r82c3,16r82b6,
16r82a2,16r8670,16r866f,16r866d,16r866e,16r8c56,16r8fd2,16r8fcb,
16r8fd3,16r8fcd,16r8fd6,16r8fd5,16r8fd7,16r90b2,16r90b4,16r90af,
16r90b3,16r90b0,16r9639,16r963d,16r963c,16r963a,16r9643,16r4fcd,
16r4fc5,16r4fd3,16r4fb2,16r4fc9,16r4fcb,16r4fc1,16r4fd4,16r4fdc,
16r4fd9,16r4fbb,16r4fb3,16r4fdb,16r4fc7,16r4fd6,16r4fba,16r4fc0,
16r4fb9,16r4fec,16r5244,16r5249,16r52c0,16r52c2,16r533d,16r537c,
16r5397,16r5396,16r5399,16r5398,16r54ba,16r54a1,16r54ad,16r54a5,
16r54cf,16r54c3,16r830d,16r54b7,16r54ae,16r54d6,16r54b6,16r54c5,
16r54c6,16r54a0,16r5470,16r54bc,16r54a2,16r54be,16r5472,16r54de,
16r54b0,16r57b5,16r579e,16r579f,16r57a4,16r578c,16r5797,16r579d,
16r579b,16r5794,16r5798,16r578f,16r5799,16r57a5,16r579a,16r5795,
16r58f4,16r590d,16r5953,16r59e1,16r59de,16r59ee,16r5a00,16r59f1,
16r59dd,16r59fa,16r59fd,16r59fc,16r59f6,16r59e4,16r59f2,16r59f7,
16r59db,16r59e9,16r59f3,16r59f5,16r59e0,16r59fe,16r59f4,16r59ed,
16r5ba8,16r5c4c,16r5cd0,16r5cd8,16r5ccc,16r5cd7,16r5ccb,16r5cdb,
16r5cde,16r5cda,16r5cc9,16r5cc7,16r5cca,16r5cd6,16r5cd3,16r5cd4,
16r5ccf,16r5cc8,16r5cc6,16r5cce,16r5cdf,16r5cf8,16r5df9,16r5e21,
16r5e22,16r5e23,16r5e20,16r5e24,16r5eb0,16r5ea4,16r5ea2,16r5e9b,
16r5ea3,16r5ea5,16r5f07,16r5f2e,16r5f56,16r5f86,16r6037,16r6039,
16r6054,16r6072,16r605e,16r6045,16r6053,16r6047,16r6049,16r605b,
16r604c,16r6040,16r6042,16r605f,16r6024,16r6044,16r6058,16r6066,
16r606e,16r6242,16r6243,16r62cf,16r630d,16r630b,16r62f5,16r630e,
16r6303,16r62eb,16r62f9,16r630f,16r630c,16r62f8,16r62f6,16r6300,
16r6313,16r6314,16r62fa,16r6315,16r62fb,16r62f0,16r6541,16r6543,
16r65aa,16r65bf,16r6636,16r6621,16r6632,16r6635,16r661c,16r6626,
16r6622,16r6633,16r662b,16r663a,16r661d,16r6634,16r6639,16r662e,
16r670f,16r6710,16r67c1,16r67f2,16r67c8,16r67ba,16r67dc,16r67bb,
16r67f8,16r67d8,16r67c0,16r67b7,16r67c5,16r67eb,16r67e4,16r67df,
16r67b5,16r67cd,16r67b3,16r67f7,16r67f6,16r67ee,16r67e3,16r67c2,
16r67b9,16r67ce,16r67e7,16r67f0,16r67b2,16r67fc,16r67c6,16r67ed,
16r67cc,16r67ae,16r67e6,16r67db,16r67fa,16r67c9,16r67ca,16r67c3,
16r67ea,16r67cb,16r6b28,16r6b82,16r6b84,16r6bb6,16r6bd6,16r6bd8,
16r6be0,16r6c20,16r6c21,16r6d28,16r6d34,16r6d2d,16r6d1f,16r6d3c,
16r6d3f,16r6d12,16r6d0a,16r6cda,16r6d33,16r6d04,16r6d19,16r6d3a,
16r6d1a,16r6d11,16r6d00,16r6d1d,16r6d42,16r6d01,16r6d18,16r6d37,
16r6d03,16r6d0f,16r6d40,16r6d07,16r6d20,16r6d2c,16r6d08,16r6d22,
16r6d09,16r6d10,16r70b7,16r709f,16r70be,16r70b1,16r70b0,16r70a1,
16r70b4,16r70b5,16r70a9,16r7241,16r7249,16r724a,16r726c,16r7270,
16r7273,16r726e,16r72ca,16r72e4,16r72e8,16r72eb,16r72df,16r72ea,
16r72e6,16r72e3,16r7385,16r73cc,16r73c2,16r73c8,16r73c5,16r73b9,
16r73b6,16r73b5,16r73b4,16r73eb,16r73bf,16r73c7,16r73be,16r73c3,
16r73c6,16r73b8,16r73cb,16r74ec,16r74ee,16r752e,16r7547,16r7548,
16r75a7,16r75aa,16r7679,16r76c4,16r7708,16r7703,16r7704,16r7705,
16r770a,16r76f7,16r76fb,16r76fa,16r77e7,16r77e8,16r7806,16r7811,
16r7812,16r7805,16r7810,16r780f,16r780e,16r7809,16r7803,16r7813,
16r794a,16r794c,16r794b,16r7945,16r7944,16r79d5,16r79cd,16r79cf,
16r79d6,16r79ce,16r7a80,16r7a7e,16r7ad1,16r7b00,16r7b01,16r7c7a,
16r7c78,16r7c79,16r7c7f,16r7c80,16r7c81,16r7d03,16r7d08,16r7d01,
16r7f58,16r7f91,16r7f8d,16r7fbe,16r8007,16r800e,16r800f,16r8014,
16r8037,16r80d8,16r80c7,16r80e0,16r80d1,16r80c8,16r80c2,16r80d0,
16r80c5,16r80e3,16r80d9,16r80dc,16r80ca,16r80d5,16r80c9,16r80cf,
16r80d7,16r80e6,16r80cd,16r81ff,16r8221,16r8294,16r82d9,16r82fe,
16r82f9,16r8307,16r82e8,16r8300,16r82d5,16r833a,16r82eb,16r82d6,
16r82f4,16r82ec,16r82e1,16r82f2,16r82f5,16r830c,16r82fb,16r82f6,
16r82f0,16r82ea,16r82e4,16r82e0,16r82fa,16r82f3,16r82ed,16r8677,
16r8674,16r867c,16r8673,16r8841,16r884e,16r8867,16r886a,16r8869,
16r89d3,16r8a04,16r8a07,16r8d72,16r8fe3,16r8fe1,16r8fee,16r8fe0,
16r90f1,16r90bd,16r90bf,16r90d5,16r90c5,16r90be,16r90c7,16r90cb,
16r90c8,16r91d4,16r91d3,16r9654,16r964f,16r9651,16r9653,16r964a,
16r964e,16r501e,16r5005,16r5007,16r5013,16r5022,16r5030,16r501b,
16r4ff5,16r4ff4,16r5033,16r5037,16r502c,16r4ff6,16r4ff7,16r5017,
16r501c,16r5020,16r5027,16r5035,16r502f,16r5031,16r500e,16r515a,
16r5194,16r5193,16r51ca,16r51c4,16r51c5,16r51c8,16r51ce,16r5261,
16r525a,16r5252,16r525e,16r525f,16r5255,16r5262,16r52cd,16r530e,
16r539e,16r5526,16r54e2,16r5517,16r5512,16r54e7,16r54f3,16r54e4,
16r551a,16r54ff,16r5504,16r5508,16r54eb,16r5511,16r5505,16r54f1,
16r550a,16r54fb,16r54f7,16r54f8,16r54e0,16r550e,16r5503,16r550b,
16r5701,16r5702,16r57cc,16r5832,16r57d5,16r57d2,16r57ba,16r57c6,
16r57bd,16r57bc,16r57b8,16r57b6,16r57bf,16r57c7,16r57d0,16r57b9,
16r57c1,16r590e,16r594a,16r5a19,16r5a16,16r5a2d,16r5a2e,16r5a15,
16r5a0f,16r5a17,16r5a0a,16r5a1e,16r5a33,16r5b6c,16r5ba7,16r5bad,
16r5bac,16r5c03,16r5c56,16r5c54,16r5cec,16r5cff,16r5cee,16r5cf1,
16r5cf7,16r5d00,16r5cf9,16r5e29,16r5e28,16r5ea8,16r5eae,16r5eaa,
16r5eac,16r5f33,16r5f30,16r5f67,16r605d,16r605a,16r6067,16r6041,
16r60a2,16r6088,16r6080,16r6092,16r6081,16r609d,16r6083,16r6095,
16r609b,16r6097,16r6087,16r609c,16r608e,16r6219,16r6246,16r62f2,
16r6310,16r6356,16r632c,16r6344,16r6345,16r6336,16r6343,16r63e4,
16r6339,16r634b,16r634a,16r633c,16r6329,16r6341,16r6334,16r6358,
16r6354,16r6359,16r632d,16r6347,16r6333,16r635a,16r6351,16r6338,
16r6357,16r6340,16r6348,16r654a,16r6546,16r65c6,16r65c3,16r65c4,
16r65c2,16r664a,16r665f,16r6647,16r6651,16r6712,16r6713,16r681f,
16r681a,16r6849,16r6832,16r6833,16r683b,16r684b,16r684f,16r6816,
16r6831,16r681c,16r6835,16r682b,16r682d,16r682f,16r684e,16r6844,
16r6834,16r681d,16r6812,16r6814,16r6826,16r6828,16r682e,16r684d,
16r683a,16r6825,16r6820,16r6b2c,16r6b2f,16r6b2d,16r6b31,16r6b34,
16r6b6d,16r8082,16r6b88,16r6be6,16r6be4,16r6be8,16r6be3,16r6be2,
16r6be7,16r6c25,16r6d7a,16r6d63,16r6d64,16r6d76,16r6d0d,16r6d61,
16r6d92,16r6d58,16r6d62,16r6d6d,16r6d6f,16r6d91,16r6d8d,16r6def,
16r6d7f,16r6d86,16r6d5e,16r6d67,16r6d60,16r6d97,16r6d70,16r6d7c,
16r6d5f,16r6d82,16r6d98,16r6d2f,16r6d68,16r6d8b,16r6d7e,16r6d80,
16r6d84,16r6d16,16r6d83,16r6d7b,16r6d7d,16r6d75,16r6d90,16r70dc,
16r70d3,16r70d1,16r70dd,16r70cb,16r7f39,16r70e2,16r70d7,16r70d2,
16r70de,16r70e0,16r70d4,16r70cd,16r70c5,16r70c6,16r70c7,16r70da,
16r70ce,16r70e1,16r7242,16r7278,16r7277,16r7276,16r7300,16r72fa,
16r72f4,16r72fe,16r72f6,16r72f3,16r72fb,16r7301,16r73d3,16r73d9,
16r73e5,16r73d6,16r73bc,16r73e7,16r73e3,16r73e9,16r73dc,16r73d2,
16r73db,16r73d4,16r73dd,16r73da,16r73d7,16r73d8,16r73e8,16r74de,
16r74df,16r74f4,16r74f5,16r7521,16r755b,16r755f,16r75b0,16r75c1,
16r75bb,16r75c4,16r75c0,16r75bf,16r75b6,16r75ba,16r768a,16r76c9,
16r771d,16r771b,16r7710,16r7713,16r7712,16r7723,16r7711,16r7715,
16r7719,16r771a,16r7722,16r7727,16r7823,16r782c,16r7822,16r7835,
16r782f,16r7828,16r782e,16r782b,16r7821,16r7829,16r7833,16r782a,
16r7831,16r7954,16r795b,16r794f,16r795c,16r7953,16r7952,16r7951,
16r79eb,16r79ec,16r79e0,16r79ee,16r79ed,16r79ea,16r79dc,16r79de,
16r79dd,16r7a86,16r7a89,16r7a85,16r7a8b,16r7a8c,16r7a8a,16r7a87,
16r7ad8,16r7b10,16r7b04,16r7b13,16r7b05,16r7b0f,16r7b08,16r7b0a,
16r7b0e,16r7b09,16r7b12,16r7c84,16r7c91,16r7c8a,16r7c8c,16r7c88,
16r7c8d,16r7c85,16r7d1e,16r7d1d,16r7d11,16r7d0e,16r7d18,16r7d16,
16r7d13,16r7d1f,16r7d12,16r7d0f,16r7d0c,16r7f5c,16r7f61,16r7f5e,
16r7f60,16r7f5d,16r7f5b,16r7f96,16r7f92,16r7fc3,16r7fc2,16r7fc0,
16r8016,16r803e,16r8039,16r80fa,16r80f2,16r80f9,16r80f5,16r8101,
16r80fb,16r8100,16r8201,16r822f,16r8225,16r8333,16r832d,16r8344,
16r8319,16r8351,16r8325,16r8356,16r833f,16r8341,16r8326,16r831c,
16r8322,16r8342,16r834e,16r831b,16r832a,16r8308,16r833c,16r834d,
16r8316,16r8324,16r8320,16r8337,16r832f,16r8329,16r8347,16r8345,
16r834c,16r8353,16r831e,16r832c,16r834b,16r8327,16r8348,16r8653,
16r8652,16r86a2,16r86a8,16r8696,16r868d,16r8691,16r869e,16r8687,
16r8697,16r8686,16r868b,16r869a,16r8685,16r86a5,16r8699,16r86a1,
16r86a7,16r8695,16r8698,16r868e,16r869d,16r8690,16r8694,16r8843,
16r8844,16r886d,16r8875,16r8876,16r8872,16r8880,16r8871,16r887f,
16r886f,16r8883,16r887e,16r8874,16r887c,16r8a12,16r8c47,16r8c57,
16r8c7b,16r8ca4,16r8ca3,16r8d76,16r8d78,16r8db5,16r8db7,16r8db6,
16r8ed1,16r8ed3,16r8ffe,16r8ff5,16r9002,16r8fff,16r8ffb,16r9004,
16r8ffc,16r8ff6,16r90d6,16r90e0,16r90d9,16r90da,16r90e3,16r90df,
16r90e5,16r90d8,16r90db,16r90d7,16r90dc,16r90e4,16r9150,16r914e,
16r914f,16r91d5,16r91e2,16r91da,16r965c,16r965f,16r96bc,16r98e3,
16r9adf,16r9b2f,16r4e7f,16r5070,16r506a,16r5061,16r505e,16r5060,
16r5053,16r504b,16r505d,16r5072,16r5048,16r504d,16r5041,16r505b,
16r504a,16r5062,16r5015,16r5045,16r505f,16r5069,16r506b,16r5063,
16r5064,16r5046,16r5040,16r506e,16r5073,16r5057,16r5051,16r51d0,
16r526b,16r526d,16r526c,16r526e,16r52d6,16r52d3,16r532d,16r539c,
16r5575,16r5576,16r553c,16r554d,16r5550,16r5534,16r552a,16r5551,
16r5562,16r5536,16r5535,16r5530,16r5552,16r5545,16r550c,16r5532,
16r5565,16r554e,16r5539,16r5548,16r552d,16r553b,16r5540,16r554b,
16r570a,16r5707,16r57fb,16r5814,16r57e2,16r57f6,16r57dc,16r57f4,
16r5800,16r57ed,16r57fd,16r5808,16r57f8,16r580b,16r57f3,16r57cf,
16r5807,16r57ee,16r57e3,16r57f2,16r57e5,16r57ec,16r57e1,16r580e,
16r57fc,16r5810,16r57e7,16r5801,16r580c,16r57f1,16r57e9,16r57f0,
16r580d,16r5804,16r595c,16r5a60,16r5a58,16r5a55,16r5a67,16r5a5e,
16r5a38,16r5a35,16r5a6d,16r5a50,16r5a5f,16r5a65,16r5a6c,16r5a53,
16r5a64,16r5a57,16r5a43,16r5a5d,16r5a52,16r5a44,16r5a5b,16r5a48,
16r5a8e,16r5a3e,16r5a4d,16r5a39,16r5a4c,16r5a70,16r5a69,16r5a47,
16r5a51,16r5a56,16r5a42,16r5a5c,16r5b72,16r5b6e,16r5bc1,16r5bc0,
16r5c59,16r5d1e,16r5d0b,16r5d1d,16r5d1a,16r5d20,16r5d0c,16r5d28,
16r5d0d,16r5d26,16r5d25,16r5d0f,16r5d30,16r5d12,16r5d23,16r5d1f,
16r5d2e,16r5e3e,16r5e34,16r5eb1,16r5eb4,16r5eb9,16r5eb2,16r5eb3,
16r5f36,16r5f38,16r5f9b,16r5f96,16r5f9f,16r608a,16r6090,16r6086,
16r60be,16r60b0,16r60ba,16r60d3,16r60d4,16r60cf,16r60e4,16r60d9,
16r60dd,16r60c8,16r60b1,16r60db,16r60b7,16r60ca,16r60bf,16r60c3,
16r60cd,16r60c0,16r6332,16r6365,16r638a,16r6382,16r637d,16r63bd,
16r639e,16r63ad,16r639d,16r6397,16r63ab,16r638e,16r636f,16r6387,
16r6390,16r636e,16r63af,16r6375,16r639c,16r636d,16r63ae,16r637c,
16r63a4,16r633b,16r639f,16r6378,16r6385,16r6381,16r6391,16r638d,
16r6370,16r6553,16r65cd,16r6665,16r6661,16r665b,16r6659,16r665c,
16r6662,16r6718,16r6879,16r6887,16r6890,16r689c,16r686d,16r686e,
16r68ae,16r68ab,16r6956,16r686f,16r68a3,16r68ac,16r68a9,16r6875,
16r6874,16r68b2,16r688f,16r6877,16r6892,16r687c,16r686b,16r6872,
16r68aa,16r6880,16r6871,16r687e,16r689b,16r6896,16r688b,16r68a0,
16r6889,16r68a4,16r6878,16r687b,16r6891,16r688c,16r688a,16r687d,
16r6b36,16r6b33,16r6b37,16r6b38,16r6b91,16r6b8f,16r6b8d,16r6b8e,
16r6b8c,16r6c2a,16r6dc0,16r6dab,16r6db4,16r6db3,16r6e74,16r6dac,
16r6de9,16r6de2,16r6db7,16r6df6,16r6dd4,16r6e00,16r6dc8,16r6de0,
16r6ddf,16r6dd6,16r6dbe,16r6de5,16r6ddc,16r6ddd,16r6ddb,16r6df4,
16r6dca,16r6dbd,16r6ded,16r6df0,16r6dba,16r6dd5,16r6dc2,16r6dcf,
16r6dc9,16r6dd0,16r6df2,16r6dd3,16r6dfd,16r6dd7,16r6dcd,16r6de3,
16r6dbb,16r70fa,16r710d,16r70f7,16r7117,16r70f4,16r710c,16r70f0,
16r7104,16r70f3,16r7110,16r70fc,16r70ff,16r7106,16r7113,16r7100,
16r70f8,16r70f6,16r710b,16r7102,16r710e,16r727e,16r727b,16r727c,
16r727f,16r731d,16r7317,16r7307,16r7311,16r7318,16r730a,16r7308,
16r72ff,16r730f,16r731e,16r7388,16r73f6,16r73f8,16r73f5,16r7404,
16r7401,16r73fd,16r7407,16r7400,16r73fa,16r73fc,16r73ff,16r740c,
16r740b,16r73f4,16r7408,16r7564,16r7563,16r75ce,16r75d2,16r75cf,
16r75cb,16r75cc,16r75d1,16r75d0,16r768f,16r7689,16r76d3,16r7739,
16r772f,16r772d,16r7731,16r7732,16r7734,16r7733,16r773d,16r7725,
16r773b,16r7735,16r7848,16r7852,16r7849,16r784d,16r784a,16r784c,
16r7826,16r7845,16r7850,16r7964,16r7967,16r7969,16r796a,16r7963,
16r796b,16r7961,16r79bb,16r79fa,16r79f8,16r79f6,16r79f7,16r7a8f,
16r7a94,16r7a90,16r7b35,16r7b47,16r7b34,16r7b25,16r7b30,16r7b22,
16r7b24,16r7b33,16r7b18,16r7b2a,16r7b1d,16r7b31,16r7b2b,16r7b2d,
16r7b2f,16r7b32,16r7b38,16r7b1a,16r7b23,16r7c94,16r7c98,16r7c96,
16r7ca3,16r7d35,16r7d3d,16r7d38,16r7d36,16r7d3a,16r7d45,16r7d2c,
16r7d29,16r7d41,16r7d47,16r7d3e,16r7d3f,16r7d4a,16r7d3b,16r7d28,
16r7f63,16r7f95,16r7f9c,16r7f9d,16r7f9b,16r7fca,16r7fcb,16r7fcd,
16r7fd0,16r7fd1,16r7fc7,16r7fcf,16r7fc9,16r801f,16r801e,16r801b,
16r8047,16r8043,16r8048,16r8118,16r8125,16r8119,16r811b,16r812d,
16r811f,16r812c,16r811e,16r8121,16r8115,16r8127,16r811d,16r8122,
16r8211,16r8238,16r8233,16r823a,16r8234,16r8232,16r8274,16r8390,
16r83a3,16r83a8,16r838d,16r837a,16r8373,16r83a4,16r8374,16r838f,
16r8381,16r8395,16r8399,16r8375,16r8394,16r83a9,16r837d,16r8383,
16r838c,16r839d,16r839b,16r83aa,16r838b,16r837e,16r83a5,16r83af,
16r8388,16r8397,16r83b0,16r837f,16r83a6,16r8387,16r83ae,16r8376,
16r839a,16r8659,16r8656,16r86bf,16r86b7,16r86c2,16r86c1,16r86c5,
16r86ba,16r86b0,16r86c8,16r86b9,16r86b3,16r86b8,16r86cc,16r86b4,
16r86bb,16r86bc,16r86c3,16r86bd,16r86be,16r8852,16r8889,16r8895,
16r88a8,16r88a2,16r88aa,16r889a,16r8891,16r88a1,16r889f,16r8898,
16r88a7,16r8899,16r889b,16r8897,16r88a4,16r88ac,16r888c,16r8893,
16r888e,16r8982,16r89d6,16r89d9,16r89d5,16r8a30,16r8a27,16r8a2c,
16r8a1e,16r8c39,16r8c3b,16r8c5c,16r8c5d,16r8c7d,16r8ca5,16r8d7d,
16r8d7b,16r8d79,16r8dbc,16r8dc2,16r8db9,16r8dbf,16r8dc1,16r8ed8,
16r8ede,16r8edd,16r8edc,16r8ed7,16r8ee0,16r8ee1,16r9024,16r900b,
16r9011,16r901c,16r900c,16r9021,16r90ef,16r90ea,16r90f0,16r90f4,
16r90f2,16r90f3,16r90d4,16r90eb,16r90ec,16r90e9,16r9156,16r9158,
16r915a,16r9153,16r9155,16r91ec,16r91f4,16r91f1,16r91f3,16r91f8,
16r91e4,16r91f9,16r91ea,16r91eb,16r91f7,16r91e8,16r91ee,16r957a,
16r9586,16r9588,16r967c,16r966d,16r966b,16r9671,16r966f,16r96bf,
16r976a,16r9804,16r98e5,16r9997,16r509b,16r5095,16r5094,16r509e,
16r508b,16r50a3,16r5083,16r508c,16r508e,16r509d,16r5068,16r509c,
16r5092,16r5082,16r5087,16r515f,16r51d4,16r5312,16r5311,16r53a4,
16r53a7,16r5591,16r55a8,16r55a5,16r55ad,16r5577,16r5645,16r55a2,
16r5593,16r5588,16r558f,16r55b5,16r5581,16r55a3,16r5592,16r55a4,
16r557d,16r558c,16r55a6,16r557f,16r5595,16r55a1,16r558e,16r570c,
16r5829,16r5837,16r5819,16r581e,16r5827,16r5823,16r5828,16r57f5,
16r5848,16r5825,16r581c,16r581b,16r5833,16r583f,16r5836,16r582e,
16r5839,16r5838,16r582d,16r582c,16r583b,16r5961,16r5aaf,16r5a94,
16r5a9f,16r5a7a,16r5aa2,16r5a9e,16r5a78,16r5aa6,16r5a7c,16r5aa5,
16r5aac,16r5a95,16r5aae,16r5a37,16r5a84,16r5a8a,16r5a97,16r5a83,
16r5a8b,16r5aa9,16r5a7b,16r5a7d,16r5a8c,16r5a9c,16r5a8f,16r5a93,
16r5a9d,16r5bea,16r5bcd,16r5bcb,16r5bd4,16r5bd1,16r5bca,16r5bce,
16r5c0c,16r5c30,16r5d37,16r5d43,16r5d6b,16r5d41,16r5d4b,16r5d3f,
16r5d35,16r5d51,16r5d4e,16r5d55,16r5d33,16r5d3a,16r5d52,16r5d3d,
16r5d31,16r5d59,16r5d42,16r5d39,16r5d49,16r5d38,16r5d3c,16r5d32,
16r5d36,16r5d40,16r5d45,16r5e44,16r5e41,16r5f58,16r5fa6,16r5fa5,
16r5fab,16r60c9,16r60b9,16r60cc,16r60e2,16r60ce,16r60c4,16r6114,
16r60f2,16r610a,16r6116,16r6105,16r60f5,16r6113,16r60f8,16r60fc,
16r60fe,16r60c1,16r6103,16r6118,16r611d,16r6110,16r60ff,16r6104,
16r610b,16r624a,16r6394,16r63b1,16r63b0,16r63ce,16r63e5,16r63e8,
16r63ef,16r63c3,16r649d,16r63f3,16r63ca,16r63e0,16r63f6,16r63d5,
16r63f2,16r63f5,16r6461,16r63df,16r63be,16r63dd,16r63dc,16r63c4,
16r63d8,16r63d3,16r63c2,16r63c7,16r63cc,16r63cb,16r63c8,16r63f0,
16r63d7,16r63d9,16r6532,16r6567,16r656a,16r6564,16r655c,16r6568,
16r6565,16r658c,16r659d,16r659e,16r65ae,16r65d0,16r65d2,16r667c,
16r666c,16r667b,16r6680,16r6671,16r6679,16r666a,16r6672,16r6701,
16r690c,16r68d3,16r6904,16r68dc,16r692a,16r68ec,16r68ea,16r68f1,
16r690f,16r68d6,16r68f7,16r68eb,16r68e4,16r68f6,16r6913,16r6910,
16r68f3,16r68e1,16r6907,16r68cc,16r6908,16r6970,16r68b4,16r6911,
16r68ef,16r68c6,16r6914,16r68f8,16r68d0,16r68fd,16r68fc,16r68e8,
16r690b,16r690a,16r6917,16r68ce,16r68c8,16r68dd,16r68de,16r68e6,
16r68f4,16r68d1,16r6906,16r68d4,16r68e9,16r6915,16r6925,16r68c7,
16r6b39,16r6b3b,16r6b3f,16r6b3c,16r6b94,16r6b97,16r6b99,16r6b95,
16r6bbd,16r6bf0,16r6bf2,16r6bf3,16r6c30,16r6dfc,16r6e46,16r6e47,
16r6e1f,16r6e49,16r6e88,16r6e3c,16r6e3d,16r6e45,16r6e62,16r6e2b,
16r6e3f,16r6e41,16r6e5d,16r6e73,16r6e1c,16r6e33,16r6e4b,16r6e40,
16r6e51,16r6e3b,16r6e03,16r6e2e,16r6e5e,16r6e68,16r6e5c,16r6e61,
16r6e31,16r6e28,16r6e60,16r6e71,16r6e6b,16r6e39,16r6e22,16r6e30,
16r6e53,16r6e65,16r6e27,16r6e78,16r6e64,16r6e77,16r6e55,16r6e79,
16r6e52,16r6e66,16r6e35,16r6e36,16r6e5a,16r7120,16r711e,16r712f,
16r70fb,16r712e,16r7131,16r7123,16r7125,16r7122,16r7132,16r711f,
16r7128,16r713a,16r711b,16r724b,16r725a,16r7288,16r7289,16r7286,
16r7285,16r728b,16r7312,16r730b,16r7330,16r7322,16r7331,16r7333,
16r7327,16r7332,16r732d,16r7326,16r7323,16r7335,16r730c,16r742e,
16r742c,16r7430,16r742b,16r7416,16r741a,16r7421,16r742d,16r7431,
16r7424,16r7423,16r741d,16r7429,16r7420,16r7432,16r74fb,16r752f,
16r756f,16r756c,16r75e7,16r75da,16r75e1,16r75e6,16r75dd,16r75df,
16r75e4,16r75d7,16r7695,16r7692,16r76da,16r7746,16r7747,16r7744,
16r774d,16r7745,16r774a,16r774e,16r774b,16r774c,16r77de,16r77ec,
16r7860,16r7864,16r7865,16r785c,16r786d,16r7871,16r786a,16r786e,
16r7870,16r7869,16r7868,16r785e,16r7862,16r7974,16r7973,16r7972,
16r7970,16r7a02,16r7a0a,16r7a03,16r7a0c,16r7a04,16r7a99,16r7ae6,
16r7ae4,16r7b4a,16r7b3b,16r7b44,16r7b48,16r7b4c,16r7b4e,16r7b40,
16r7b58,16r7b45,16r7ca2,16r7c9e,16r7ca8,16r7ca1,16r7d58,16r7d6f,
16r7d63,16r7d53,16r7d56,16r7d67,16r7d6a,16r7d4f,16r7d6d,16r7d5c,
16r7d6b,16r7d52,16r7d54,16r7d69,16r7d51,16r7d5f,16r7d4e,16r7f3e,
16r7f3f,16r7f65,16r7f66,16r7fa2,16r7fa0,16r7fa1,16r7fd7,16r8051,
16r804f,16r8050,16r80fe,16r80d4,16r8143,16r814a,16r8152,16r814f,
16r8147,16r813d,16r814d,16r813a,16r81e6,16r81ee,16r81f7,16r81f8,
16r81f9,16r8204,16r823c,16r823d,16r823f,16r8275,16r833b,16r83cf,
16r83f9,16r8423,16r83c0,16r83e8,16r8412,16r83e7,16r83e4,16r83fc,
16r83f6,16r8410,16r83c6,16r83c8,16r83eb,16r83e3,16r83bf,16r8401,
16r83dd,16r83e5,16r83d8,16r83ff,16r83e1,16r83cb,16r83ce,16r83d6,
16r83f5,16r83c9,16r8409,16r840f,16r83de,16r8411,16r8406,16r83c2,
16r83f3,16r83d5,16r83fa,16r83c7,16r83d1,16r83ea,16r8413,16r83c3,
16r83ec,16r83ee,16r83c4,16r83fb,16r83d7,16r83e2,16r841b,16r83db,
16r83fe,16r86d8,16r86e2,16r86e6,16r86d3,16r86e3,16r86da,16r86ea,
16r86dd,16r86eb,16r86dc,16r86ec,16r86e9,16r86d7,16r86e8,16r86d1,
16r8848,16r8856,16r8855,16r88ba,16r88d7,16r88b9,16r88b8,16r88c0,
16r88be,16r88b6,16r88bc,16r88b7,16r88bd,16r88b2,16r8901,16r88c9,
16r8995,16r8998,16r8997,16r89dd,16r89da,16r89db,16r8a4e,16r8a4d,
16r8a39,16r8a59,16r8a40,16r8a57,16r8a58,16r8a44,16r8a45,16r8a52,
16r8a48,16r8a51,16r8a4a,16r8a4c,16r8a4f,16r8c5f,16r8c81,16r8c80,
16r8cba,16r8cbe,16r8cb0,16r8cb9,16r8cb5,16r8d84,16r8d80,16r8d89,
16r8dd8,16r8dd3,16r8dcd,16r8dc7,16r8dd6,16r8ddc,16r8dcf,16r8dd5,
16r8dd9,16r8dc8,16r8dd7,16r8dc5,16r8eef,16r8ef7,16r8efa,16r8ef9,
16r8ee6,16r8eee,16r8ee5,16r8ef5,16r8ee7,16r8ee8,16r8ef6,16r8eeb,
16r8ef1,16r8eec,16r8ef4,16r8ee9,16r902d,16r9034,16r902f,16r9106,
16r912c,16r9104,16r90ff,16r90fc,16r9108,16r90f9,16r90fb,16r9101,
16r9100,16r9107,16r9105,16r9103,16r9161,16r9164,16r915f,16r9162,
16r9160,16r9201,16r920a,16r9225,16r9203,16r921a,16r9226,16r920f,
16r920c,16r9200,16r9212,16r91ff,16r91fd,16r9206,16r9204,16r9227,
16r9202,16r921c,16r9224,16r9219,16r9217,16r9205,16r9216,16r957b,
16r958d,16r958c,16r9590,16r9687,16r967e,16r9688,16r9689,16r9683,
16r9680,16r96c2,16r96c8,16r96c3,16r96f1,16r96f0,16r976c,16r9770,
16r976e,16r9807,16r98a9,16r98eb,16r9ce6,16r9ef9,16r4e83,16r4e84,
16r4eb6,16r50bd,16r50bf,16r50c6,16r50ae,16r50c4,16r50ca,16r50b4,
16r50c8,16r50c2,16r50b0,16r50c1,16r50ba,16r50b1,16r50cb,16r50c9,
16r50b6,16r50b8,16r51d7,16r527a,16r5278,16r527b,16r527c,16r55c3,
16r55db,16r55cc,16r55d0,16r55cb,16r55ca,16r55dd,16r55c0,16r55d4,
16r55c4,16r55e9,16r55bf,16r55d2,16r558d,16r55cf,16r55d5,16r55e2,
16r55d6,16r55c8,16r55f2,16r55cd,16r55d9,16r55c2,16r5714,16r5853,
16r5868,16r5864,16r584f,16r584d,16r5849,16r586f,16r5855,16r584e,
16r585d,16r5859,16r5865,16r585b,16r583d,16r5863,16r5871,16r58fc,
16r5ac7,16r5ac4,16r5acb,16r5aba,16r5ab8,16r5ab1,16r5ab5,16r5ab0,
16r5abf,16r5ac8,16r5abb,16r5ac6,16r5ab7,16r5ac0,16r5aca,16r5ab4,
16r5ab6,16r5acd,16r5ab9,16r5a90,16r5bd6,16r5bd8,16r5bd9,16r5c1f,
16r5c33,16r5d71,16r5d63,16r5d4a,16r5d65,16r5d72,16r5d6c,16r5d5e,
16r5d68,16r5d67,16r5d62,16r5df0,16r5e4f,16r5e4e,16r5e4a,16r5e4d,
16r5e4b,16r5ec5,16r5ecc,16r5ec6,16r5ecb,16r5ec7,16r5f40,16r5faf,
16r5fad,16r60f7,16r6149,16r614a,16r612b,16r6145,16r6136,16r6132,
16r612e,16r6146,16r612f,16r614f,16r6129,16r6140,16r6220,16r9168,
16r6223,16r6225,16r6224,16r63c5,16r63f1,16r63eb,16r6410,16r6412,
16r6409,16r6420,16r6424,16r6433,16r6443,16r641f,16r6415,16r6418,
16r6439,16r6437,16r6422,16r6423,16r640c,16r6426,16r6430,16r6428,
16r6441,16r6435,16r642f,16r640a,16r641a,16r6440,16r6425,16r6427,
16r640b,16r63e7,16r641b,16r642e,16r6421,16r640e,16r656f,16r6592,
16r65d3,16r6686,16r668c,16r6695,16r6690,16r668b,16r668a,16r6699,
16r6694,16r6678,16r6720,16r6966,16r695f,16r6938,16r694e,16r6962,
16r6971,16r693f,16r6945,16r696a,16r6939,16r6942,16r6957,16r6959,
16r697a,16r6948,16r6949,16r6935,16r696c,16r6933,16r693d,16r6965,
16r68f0,16r6978,16r6934,16r6969,16r6940,16r696f,16r6944,16r6976,
16r6958,16r6941,16r6974,16r694c,16r693b,16r694b,16r6937,16r695c,
16r694f,16r6951,16r6932,16r6952,16r692f,16r697b,16r693c,16r6b46,
16r6b45,16r6b43,16r6b42,16r6b48,16r6b41,16r6b9b,16rfa0d,16r6bfb,
16r6bfc,16r6bf9,16r6bf7,16r6bf8,16r6e9b,16r6ed6,16r6ec8,16r6e8f,
16r6ec0,16r6e9f,16r6e93,16r6e94,16r6ea0,16r6eb1,16r6eb9,16r6ec6,
16r6ed2,16r6ebd,16r6ec1,16r6e9e,16r6ec9,16r6eb7,16r6eb0,16r6ecd,
16r6ea6,16r6ecf,16r6eb2,16r6ebe,16r6ec3,16r6edc,16r6ed8,16r6e99,
16r6e92,16r6e8e,16r6e8d,16r6ea4,16r6ea1,16r6ebf,16r6eb3,16r6ed0,
16r6eca,16r6e97,16r6eae,16r6ea3,16r7147,16r7154,16r7152,16r7163,
16r7160,16r7141,16r715d,16r7162,16r7172,16r7178,16r716a,16r7161,
16r7142,16r7158,16r7143,16r714b,16r7170,16r715f,16r7150,16r7153,
16r7144,16r714d,16r715a,16r724f,16r728d,16r728c,16r7291,16r7290,
16r728e,16r733c,16r7342,16r733b,16r733a,16r7340,16r734a,16r7349,
16r7444,16r744a,16r744b,16r7452,16r7451,16r7457,16r7440,16r744f,
16r7450,16r744e,16r7442,16r7446,16r744d,16r7454,16r74e1,16r74ff,
16r74fe,16r74fd,16r751d,16r7579,16r7577,16r6983,16r75ef,16r760f,
16r7603,16r75f7,16r75fe,16r75fc,16r75f9,16r75f8,16r7610,16r75fb,
16r75f6,16r75ed,16r75f5,16r75fd,16r7699,16r76b5,16r76dd,16r7755,
16r775f,16r7760,16r7752,16r7756,16r775a,16r7769,16r7767,16r7754,
16r7759,16r776d,16r77e0,16r7887,16r789a,16r7894,16r788f,16r7884,
16r7895,16r7885,16r7886,16r78a1,16r7883,16r7879,16r7899,16r7880,
16r7896,16r787b,16r797c,16r7982,16r797d,16r7979,16r7a11,16r7a18,
16r7a19,16r7a12,16r7a17,16r7a15,16r7a22,16r7a13,16r7a1b,16r7a10,
16r7aa3,16r7aa2,16r7a9e,16r7aeb,16r7b66,16r7b64,16r7b6d,16r7b74,
16r7b69,16r7b72,16r7b65,16r7b73,16r7b71,16r7b70,16r7b61,16r7b78,
16r7b76,16r7b63,16r7cb2,16r7cb4,16r7caf,16r7d88,16r7d86,16r7d80,
16r7d8d,16r7d7f,16r7d85,16r7d7a,16r7d8e,16r7d7b,16r7d83,16r7d7c,
16r7d8c,16r7d94,16r7d84,16r7d7d,16r7d92,16r7f6d,16r7f6b,16r7f67,
16r7f68,16r7f6c,16r7fa6,16r7fa5,16r7fa7,16r7fdb,16r7fdc,16r8021,
16r8164,16r8160,16r8177,16r815c,16r8169,16r815b,16r8162,16r8172,
16r6721,16r815e,16r8176,16r8167,16r816f,16r8144,16r8161,16r821d,
16r8249,16r8244,16r8240,16r8242,16r8245,16r84f1,16r843f,16r8456,
16r8476,16r8479,16r848f,16r848d,16r8465,16r8451,16r8440,16r8486,
16r8467,16r8430,16r844d,16r847d,16r845a,16r8459,16r8474,16r8473,
16r845d,16r8507,16r845e,16r8437,16r843a,16r8434,16r847a,16r8443,
16r8478,16r8432,16r8445,16r8429,16r83d9,16r844b,16r842f,16r8442,
16r842d,16r845f,16r8470,16r8439,16r844e,16r844c,16r8452,16r846f,
16r84c5,16r848e,16r843b,16r8447,16r8436,16r8433,16r8468,16r847e,
16r8444,16r842b,16r8460,16r8454,16r846e,16r8450,16r870b,16r8704,
16r86f7,16r870c,16r86fa,16r86d6,16r86f5,16r874d,16r86f8,16r870e,
16r8709,16r8701,16r86f6,16r870d,16r8705,16r88d6,16r88cb,16r88cd,
16r88ce,16r88de,16r88db,16r88da,16r88cc,16r88d0,16r8985,16r899b,
16r89df,16r89e5,16r89e4,16r89e1,16r89e0,16r89e2,16r89dc,16r89e6,
16r8a76,16r8a86,16r8a7f,16r8a61,16r8a3f,16r8a77,16r8a82,16r8a84,
16r8a75,16r8a83,16r8a81,16r8a74,16r8a7a,16r8c3c,16r8c4b,16r8c4a,
16r8c65,16r8c64,16r8c66,16r8c86,16r8c84,16r8c85,16r8ccc,16r8d68,
16r8d69,16r8d91,16r8d8c,16r8d8e,16r8d8f,16r8d8d,16r8d93,16r8d94,
16r8d90,16r8d92,16r8df0,16r8de0,16r8dec,16r8df1,16r8dee,16r8dd0,
16r8de9,16r8de3,16r8de2,16r8de7,16r8df2,16r8deb,16r8df4,16r8f06,
16r8eff,16r8f01,16r8f00,16r8f05,16r8f07,16r8f08,16r8f02,16r8f0b,
16r9052,16r903f,16r9044,16r9049,16r903d,16r9110,16r910d,16r910f,
16r9111,16r9116,16r9114,16r910b,16r910e,16r916e,16r916f,16r9248,
16r9252,16r9230,16r923a,16r9266,16r9233,16r9265,16r925e,16r9283,
16r922e,16r924a,16r9246,16r926d,16r926c,16r924f,16r9260,16r9267,
16r926f,16r9236,16r9261,16r9270,16r9231,16r9254,16r9263,16r9250,
16r9272,16r924e,16r9253,16r924c,16r9256,16r9232,16r959f,16r959c,
16r959e,16r959b,16r9692,16r9693,16r9691,16r9697,16r96ce,16r96fa,
16r96fd,16r96f8,16r96f5,16r9773,16r9777,16r9778,16r9772,16r980f,
16r980d,16r980e,16r98ac,16r98f6,16r98f9,16r99af,16r99b2,16r99b0,
16r99b5,16r9aad,16r9aab,16r9b5b,16r9cea,16r9ced,16r9ce7,16r9e80,
16r9efd,16r50e6,16r50d4,16r50d7,16r50e8,16r50f3,16r50db,16r50ea,
16r50dd,16r50e4,16r50d3,16r50ec,16r50f0,16r50ef,16r50e3,16r50e0,
16r51d8,16r5280,16r5281,16r52e9,16r52eb,16r5330,16r53ac,16r5627,
16r5615,16r560c,16r5612,16r55fc,16r560f,16r561c,16r5601,16r5613,
16r5602,16r55fa,16r561d,16r5604,16r55ff,16r55f9,16r5889,16r587c,
16r5890,16r5898,16r5886,16r5881,16r587f,16r5874,16r588b,16r587a,
16r5887,16r5891,16r588e,16r5876,16r5882,16r5888,16r587b,16r5894,
16r588f,16r58fe,16r596b,16r5adc,16r5aee,16r5ae5,16r5ad5,16r5aea,
16r5ada,16r5aed,16r5aeb,16r5af3,16r5ae2,16r5ae0,16r5adb,16r5aec,
16r5ade,16r5add,16r5ad9,16r5ae8,16r5adf,16r5b77,16r5be0,16r5be3,
16r5c63,16r5d82,16r5d80,16r5d7d,16r5d86,16r5d7a,16r5d81,16r5d77,
16r5d8a,16r5d89,16r5d88,16r5d7e,16r5d7c,16r5d8d,16r5d79,16r5d7f,
16r5e58,16r5e59,16r5e53,16r5ed8,16r5ed1,16r5ed7,16r5ece,16r5edc,
16r5ed5,16r5ed9,16r5ed2,16r5ed4,16r5f44,16r5f43,16r5f6f,16r5fb6,
16r612c,16r6128,16r6141,16r615e,16r6171,16r6173,16r6152,16r6153,
16r6172,16r616c,16r6180,16r6174,16r6154,16r617a,16r615b,16r6165,
16r613b,16r616a,16r6161,16r6156,16r6229,16r6227,16r622b,16r642b,
16r644d,16r645b,16r645d,16r6474,16r6476,16r6472,16r6473,16r647d,
16r6475,16r6466,16r64a6,16r644e,16r6482,16r645e,16r645c,16r644b,
16r6453,16r6460,16r6450,16r647f,16r643f,16r646c,16r646b,16r6459,
16r6465,16r6477,16r6573,16r65a0,16r66a1,16r66a0,16r669f,16r6705,
16r6704,16r6722,16r69b1,16r69b6,16r69c9,16r69a0,16r69ce,16r6996,
16r69b0,16r69ac,16r69bc,16r6991,16r6999,16r698e,16r69a7,16r698d,
16r69a9,16r69be,16r69af,16r69bf,16r69c4,16r69bd,16r69a4,16r69d4,
16r69b9,16r69ca,16r699a,16r69cf,16r69b3,16r6993,16r69aa,16r69a1,
16r699e,16r69d9,16r6997,16r6990,16r69c2,16r69b5,16r69a5,16r69c6,
16r6b4a,16r6b4d,16r6b4b,16r6b9e,16r6b9f,16r6ba0,16r6bc3,16r6bc4,
16r6bfe,16r6ece,16r6ef5,16r6ef1,16r6f03,16r6f25,16r6ef8,16r6f37,
16r6efb,16r6f2e,16r6f09,16r6f4e,16r6f19,16r6f1a,16r6f27,16r6f18,
16r6f3b,16r6f12,16r6eed,16r6f0a,16r6f36,16r6f73,16r6ef9,16r6eee,
16r6f2d,16r6f40,16r6f30,16r6f3c,16r6f35,16r6eeb,16r6f07,16r6f0e,
16r6f43,16r6f05,16r6efd,16r6ef6,16r6f39,16r6f1c,16r6efc,16r6f3a,
16r6f1f,16r6f0d,16r6f1e,16r6f08,16r6f21,16r7187,16r7190,16r7189,
16r7180,16r7185,16r7182,16r718f,16r717b,16r7186,16r7181,16r7197,
16r7244,16r7253,16r7297,16r7295,16r7293,16r7343,16r734d,16r7351,
16r734c,16r7462,16r7473,16r7471,16r7475,16r7472,16r7467,16r746e,
16r7500,16r7502,16r7503,16r757d,16r7590,16r7616,16r7608,16r760c,
16r7615,16r7611,16r760a,16r7614,16r76b8,16r7781,16r777c,16r7785,
16r7782,16r776e,16r7780,16r776f,16r777e,16r7783,16r78b2,16r78aa,
16r78b4,16r78ad,16r78a8,16r787e,16r78ab,16r789e,16r78a5,16r78a0,
16r78ac,16r78a2,16r78a4,16r7998,16r798a,16r798b,16r7996,16r7995,
16r7994,16r7993,16r7997,16r7988,16r7992,16r7990,16r7a2b,16r7a4a,
16r7a30,16r7a2f,16r7a28,16r7a26,16r7aa8,16r7aab,16r7aac,16r7aee,
16r7b88,16r7b9c,16r7b8a,16r7b91,16r7b90,16r7b96,16r7b8d,16r7b8c,
16r7b9b,16r7b8e,16r7b85,16r7b98,16r5284,16r7b99,16r7ba4,16r7b82,
16r7cbb,16r7cbf,16r7cbc,16r7cba,16r7da7,16r7db7,16r7dc2,16r7da3,
16r7daa,16r7dc1,16r7dc0,16r7dc5,16r7d9d,16r7dce,16r7dc4,16r7dc6,
16r7dcb,16r7dcc,16r7daf,16r7db9,16r7d96,16r7dbc,16r7d9f,16r7da6,
16r7dae,16r7da9,16r7da1,16r7dc9,16r7f73,16r7fe2,16r7fe3,16r7fe5,
16r7fde,16r8024,16r805d,16r805c,16r8189,16r8186,16r8183,16r8187,
16r818d,16r818c,16r818b,16r8215,16r8497,16r84a4,16r84a1,16r849f,
16r84ba,16r84ce,16r84c2,16r84ac,16r84ae,16r84ab,16r84b9,16r84b4,
16r84c1,16r84cd,16r84aa,16r849a,16r84b1,16r84d0,16r849d,16r84a7,
16r84bb,16r84a2,16r8494,16r84c7,16r84cc,16r849b,16r84a9,16r84af,
16r84a8,16r84d6,16r8498,16r84b6,16r84cf,16r84a0,16r84d7,16r84d4,
16r84d2,16r84db,16r84b0,16r8491,16r8661,16r8733,16r8723,16r8728,
16r876b,16r8740,16r872e,16r871e,16r8721,16r8719,16r871b,16r8743,
16r872c,16r8741,16r873e,16r8746,16r8720,16r8732,16r872a,16r872d,
16r873c,16r8712,16r873a,16r8731,16r8735,16r8742,16r8726,16r8727,
16r8738,16r8724,16r871a,16r8730,16r8711,16r88f7,16r88e7,16r88f1,
16r88f2,16r88fa,16r88fe,16r88ee,16r88fc,16r88f6,16r88fb,16r88f0,
16r88ec,16r88eb,16r899d,16r89a1,16r899f,16r899e,16r89e9,16r89eb,
16r89e8,16r8aab,16r8a99,16r8a8b,16r8a92,16r8a8f,16r8a96,16r8c3d,
16r8c68,16r8c69,16r8cd5,16r8ccf,16r8cd7,16r8d96,16r8e09,16r8e02,
16r8dff,16r8e0d,16r8dfd,16r8e0a,16r8e03,16r8e07,16r8e06,16r8e05,
16r8dfe,16r8e00,16r8e04,16r8f10,16r8f11,16r8f0e,16r8f0d,16r9123,
16r911c,16r9120,16r9122,16r911f,16r911d,16r911a,16r9124,16r9121,
16r911b,16r917a,16r9172,16r9179,16r9173,16r92a5,16r92a4,16r9276,
16r929b,16r927a,16r92a0,16r9294,16r92aa,16r928d,16r92a6,16r929a,
16r92ab,16r9279,16r9297,16r927f,16r92a3,16r92ee,16r928e,16r9282,
16r9295,16r92a2,16r927d,16r9288,16r92a1,16r928a,16r9286,16r928c,
16r9299,16r92a7,16r927e,16r9287,16r92a9,16r929d,16r928b,16r922d,
16r969e,16r96a1,16r96ff,16r9758,16r977d,16r977a,16r977e,16r9783,
16r9780,16r9782,16r977b,16r9784,16r9781,16r977f,16r97ce,16r97cd,
16r9816,16r98ad,16r98ae,16r9902,16r9900,16r9907,16r999d,16r999c,
16r99c3,16r99b9,16r99bb,16r99ba,16r99c2,16r99bd,16r99c7,16r9ab1,
16r9ae3,16r9ae7,16r9b3e,16r9b3f,16r9b60,16r9b61,16r9b5f,16r9cf1,
16r9cf2,16r9cf5,16r9ea7,16r50ff,16r5103,16r5130,16r50f8,16r5106,
16r5107,16r50f6,16r50fe,16r510b,16r510c,16r50fd,16r510a,16r528b,
16r528c,16r52f1,16r52ef,16r5648,16r5642,16r564c,16r5635,16r5641,
16r564a,16r5649,16r5646,16r5658,16r565a,16r5640,16r5633,16r563d,
16r562c,16r563e,16r5638,16r562a,16r563a,16r571a,16r58ab,16r589d,
16r58b1,16r58a0,16r58a3,16r58af,16r58ac,16r58a5,16r58a1,16r58ff,
16r5aff,16r5af4,16r5afd,16r5af7,16r5af6,16r5b03,16r5af8,16r5b02,
16r5af9,16r5b01,16r5b07,16r5b05,16r5b0f,16r5c67,16r5d99,16r5d97,
16r5d9f,16r5d92,16r5da2,16r5d93,16r5d95,16r5da0,16r5d9c,16r5da1,
16r5d9a,16r5d9e,16r5e69,16r5e5d,16r5e60,16r5e5c,16r7df3,16r5edb,
16r5ede,16r5ee1,16r5f49,16r5fb2,16r618b,16r6183,16r6179,16r61b1,
16r61b0,16r61a2,16r6189,16r619b,16r6193,16r61af,16r61ad,16r619f,
16r6192,16r61aa,16r61a1,16r618d,16r6166,16r61b3,16r622d,16r646e,
16r6470,16r6496,16r64a0,16r6485,16r6497,16r649c,16r648f,16r648b,
16r648a,16r648c,16r64a3,16r649f,16r6468,16r64b1,16r6498,16r6576,
16r657a,16r6579,16r657b,16r65b2,16r65b3,16r66b5,16r66b0,16r66a9,
16r66b2,16r66b7,16r66aa,16r66af,16r6a00,16r6a06,16r6a17,16r69e5,
16r69f8,16r6a15,16r69f1,16r69e4,16r6a20,16r69ff,16r69ec,16r69e2,
16r6a1b,16r6a1d,16r69fe,16r6a27,16r69f2,16r69ee,16r6a14,16r69f7,
16r69e7,16r6a40,16r6a08,16r69e6,16r69fb,16r6a0d,16r69fc,16r69eb,
16r6a09,16r6a04,16r6a18,16r6a25,16r6a0f,16r69f6,16r6a26,16r6a07,
16r69f4,16r6a16,16r6b51,16r6ba5,16r6ba3,16r6ba2,16r6ba6,16r6c01,
16r6c00,16r6bff,16r6c02,16r6f41,16r6f26,16r6f7e,16r6f87,16r6fc6,
16r6f92,16r6f8d,16r6f89,16r6f8c,16r6f62,16r6f4f,16r6f85,16r6f5a,
16r6f96,16r6f76,16r6f6c,16r6f82,16r6f55,16r6f72,16r6f52,16r6f50,
16r6f57,16r6f94,16r6f93,16r6f5d,16r6f00,16r6f61,16r6f6b,16r6f7d,
16r6f67,16r6f90,16r6f53,16r6f8b,16r6f69,16r6f7f,16r6f95,16r6f63,
16r6f77,16r6f6a,16r6f7b,16r71b2,16r71af,16r719b,16r71b0,16r71a0,
16r719a,16r71a9,16r71b5,16r719d,16r71a5,16r719e,16r71a4,16r71a1,
16r71aa,16r719c,16r71a7,16r71b3,16r7298,16r729a,16r7358,16r7352,
16r735e,16r735f,16r7360,16r735d,16r735b,16r7361,16r735a,16r7359,
16r7362,16r7487,16r7489,16r748a,16r7486,16r7481,16r747d,16r7485,
16r7488,16r747c,16r7479,16r7508,16r7507,16r757e,16r7625,16r761e,
16r7619,16r761d,16r761c,16r7623,16r761a,16r7628,16r761b,16r769c,
16r769d,16r769e,16r769b,16r778d,16r778f,16r7789,16r7788,16r78cd,
16r78bb,16r78cf,16r78cc,16r78d1,16r78ce,16r78d4,16r78c8,16r78c3,
16r78c4,16r78c9,16r799a,16r79a1,16r79a0,16r799c,16r79a2,16r799b,
16r6b76,16r7a39,16r7ab2,16r7ab4,16r7ab3,16r7bb7,16r7bcb,16r7bbe,
16r7bac,16r7bce,16r7baf,16r7bb9,16r7bca,16r7bb5,16r7cc5,16r7cc8,
16r7ccc,16r7ccb,16r7df7,16r7ddb,16r7dea,16r7de7,16r7dd7,16r7de1,
16r7e03,16r7dfa,16r7de6,16r7df6,16r7df1,16r7df0,16r7dee,16r7ddf,
16r7f76,16r7fac,16r7fb0,16r7fad,16r7fed,16r7feb,16r7fea,16r7fec,
16r7fe6,16r7fe8,16r8064,16r8067,16r81a3,16r819f,16r819e,16r8195,
16r81a2,16r8199,16r8197,16r8216,16r824f,16r8253,16r8252,16r8250,
16r824e,16r8251,16r8524,16r853b,16r850f,16r8500,16r8529,16r850e,
16r8509,16r850d,16r851f,16r850a,16r8527,16r851c,16r84fb,16r852b,
16r84fa,16r8508,16r850c,16r84f4,16r852a,16r84f2,16r8515,16r84f7,
16r84eb,16r84f3,16r84fc,16r8512,16r84ea,16r84e9,16r8516,16r84fe,
16r8528,16r851d,16r852e,16r8502,16r84fd,16r851e,16r84f6,16r8531,
16r8526,16r84e7,16r84e8,16r84f0,16r84ef,16r84f9,16r8518,16r8520,
16r8530,16r850b,16r8519,16r852f,16r8662,16r8756,16r8763,16r8764,
16r8777,16r87e1,16r8773,16r8758,16r8754,16r875b,16r8752,16r8761,
16r875a,16r8751,16r875e,16r876d,16r876a,16r8750,16r874e,16r875f,
16r875d,16r876f,16r876c,16r877a,16r876e,16r875c,16r8765,16r874f,
16r877b,16r8775,16r8762,16r8767,16r8769,16r885a,16r8905,16r890c,
16r8914,16r890b,16r8917,16r8918,16r8919,16r8906,16r8916,16r8911,
16r890e,16r8909,16r89a2,16r89a4,16r89a3,16r89ed,16r89f0,16r89ec,
16r8acf,16r8ac6,16r8ab8,16r8ad3,16r8ad1,16r8ad4,16r8ad5,16r8abb,
16r8ad7,16r8abe,16r8ac0,16r8ac5,16r8ad8,16r8ac3,16r8aba,16r8abd,
16r8ad9,16r8c3e,16r8c4d,16r8c8f,16r8ce5,16r8cdf,16r8cd9,16r8ce8,
16r8cda,16r8cdd,16r8ce7,16r8da0,16r8d9c,16r8da1,16r8d9b,16r8e20,
16r8e23,16r8e25,16r8e24,16r8e2e,16r8e15,16r8e1b,16r8e16,16r8e11,
16r8e19,16r8e26,16r8e27,16r8e14,16r8e12,16r8e18,16r8e13,16r8e1c,
16r8e17,16r8e1a,16r8f2c,16r8f24,16r8f18,16r8f1a,16r8f20,16r8f23,
16r8f16,16r8f17,16r9073,16r9070,16r906f,16r9067,16r906b,16r912f,
16r912b,16r9129,16r912a,16r9132,16r9126,16r912e,16r9185,16r9186,
16r918a,16r9181,16r9182,16r9184,16r9180,16r92d0,16r92c3,16r92c4,
16r92c0,16r92d9,16r92b6,16r92cf,16r92f1,16r92df,16r92d8,16r92e9,
16r92d7,16r92dd,16r92cc,16r92ef,16r92c2,16r92e8,16r92ca,16r92c8,
16r92ce,16r92e6,16r92cd,16r92d5,16r92c9,16r92e0,16r92de,16r92e7,
16r92d1,16r92d3,16r92b5,16r92e1,16r92c6,16r92b4,16r957c,16r95ac,
16r95ab,16r95ae,16r95b0,16r96a4,16r96a2,16r96d3,16r9705,16r9708,
16r9702,16r975a,16r978a,16r978e,16r9788,16r97d0,16r97cf,16r981e,
16r981d,16r9826,16r9829,16r9828,16r9820,16r981b,16r9827,16r98b2,
16r9908,16r98fa,16r9911,16r9914,16r9916,16r9917,16r9915,16r99dc,
16r99cd,16r99cf,16r99d3,16r99d4,16r99ce,16r99c9,16r99d6,16r99d8,
16r99cb,16r99d7,16r99cc,16r9ab3,16r9aec,16r9aeb,16r9af3,16r9af2,
16r9af1,16r9b46,16r9b43,16r9b67,16r9b74,16r9b71,16r9b66,16r9b76,
16r9b75,16r9b70,16r9b68,16r9b64,16r9b6c,16r9cfc,16r9cfa,16r9cfd,
16r9cff,16r9cf7,16r9d07,16r9d00,16r9cf9,16r9cfb,16r9d08,16r9d05,
16r9d04,16r9e83,16r9ed3,16r9f0f,16r9f10,16r511c,16r5113,16r5117,
16r511a,16r5111,16r51de,16r5334,16r53e1,16r5670,16r5660,16r566e,
16r5673,16r5666,16r5663,16r566d,16r5672,16r565e,16r5677,16r571c,
16r571b,16r58c8,16r58bd,16r58c9,16r58bf,16r58ba,16r58c2,16r58bc,
16r58c6,16r5b17,16r5b19,16r5b1b,16r5b21,16r5b14,16r5b13,16r5b10,
16r5b16,16r5b28,16r5b1a,16r5b20,16r5b1e,16r5bef,16r5dac,16r5db1,
16r5da9,16r5da7,16r5db5,16r5db0,16r5dae,16r5daa,16r5da8,16r5db2,
16r5dad,16r5daf,16r5db4,16r5e67,16r5e68,16r5e66,16r5e6f,16r5ee9,
16r5ee7,16r5ee6,16r5ee8,16r5ee5,16r5f4b,16r5fbc,16r619d,16r61a8,
16r6196,16r61c5,16r61b4,16r61c6,16r61c1,16r61cc,16r61ba,16r61bf,
16r61b8,16r618c,16r64d7,16r64d6,16r64d0,16r64cf,16r64c9,16r64bd,
16r6489,16r64c3,16r64db,16r64f3,16r64d9,16r6533,16r657f,16r657c,
16r65a2,16r66c8,16r66be,16r66c0,16r66ca,16r66cb,16r66cf,16r66bd,
16r66bb,16r66ba,16r66cc,16r6723,16r6a34,16r6a66,16r6a49,16r6a67,
16r6a32,16r6a68,16r6a3e,16r6a5d,16r6a6d,16r6a76,16r6a5b,16r6a51,
16r6a28,16r6a5a,16r6a3b,16r6a3f,16r6a41,16r6a6a,16r6a64,16r6a50,
16r6a4f,16r6a54,16r6a6f,16r6a69,16r6a60,16r6a3c,16r6a5e,16r6a56,
16r6a55,16r6a4d,16r6a4e,16r6a46,16r6b55,16r6b54,16r6b56,16r6ba7,
16r6baa,16r6bab,16r6bc8,16r6bc7,16r6c04,16r6c03,16r6c06,16r6fad,
16r6fcb,16r6fa3,16r6fc7,16r6fbc,16r6fce,16r6fc8,16r6f5e,16r6fc4,
16r6fbd,16r6f9e,16r6fca,16r6fa8,16r7004,16r6fa5,16r6fae,16r6fba,
16r6fac,16r6faa,16r6fcf,16r6fbf,16r6fb8,16r6fa2,16r6fc9,16r6fab,
16r6fcd,16r6faf,16r6fb2,16r6fb0,16r71c5,16r71c2,16r71bf,16r71b8,
16r71d6,16r71c0,16r71c1,16r71cb,16r71d4,16r71ca,16r71c7,16r71cf,
16r71bd,16r71d8,16r71bc,16r71c6,16r71da,16r71db,16r729d,16r729e,
16r7369,16r7366,16r7367,16r736c,16r7365,16r736b,16r736a,16r747f,
16r749a,16r74a0,16r7494,16r7492,16r7495,16r74a1,16r750b,16r7580,
16r762f,16r762d,16r7631,16r763d,16r7633,16r763c,16r7635,16r7632,
16r7630,16r76bb,16r76e6,16r779a,16r779d,16r77a1,16r779c,16r779b,
16r77a2,16r77a3,16r7795,16r7799,16r7797,16r78dd,16r78e9,16r78e5,
16r78ea,16r78de,16r78e3,16r78db,16r78e1,16r78e2,16r78ed,16r78df,
16r78e0,16r79a4,16r7a44,16r7a48,16r7a47,16r7ab6,16r7ab8,16r7ab5,
16r7ab1,16r7ab7,16r7bde,16r7be3,16r7be7,16r7bdd,16r7bd5,16r7be5,
16r7bda,16r7be8,16r7bf9,16r7bd4,16r7bea,16r7be2,16r7bdc,16r7beb,
16r7bd8,16r7bdf,16r7cd2,16r7cd4,16r7cd7,16r7cd0,16r7cd1,16r7e12,
16r7e21,16r7e17,16r7e0c,16r7e1f,16r7e20,16r7e13,16r7e0e,16r7e1c,
16r7e15,16r7e1a,16r7e22,16r7e0b,16r7e0f,16r7e16,16r7e0d,16r7e14,
16r7e25,16r7e24,16r7f43,16r7f7b,16r7f7c,16r7f7a,16r7fb1,16r7fef,
16r802a,16r8029,16r806c,16r81b1,16r81a6,16r81ae,16r81b9,16r81b5,
16r81ab,16r81b0,16r81ac,16r81b4,16r81b2,16r81b7,16r81a7,16r81f2,
16r8255,16r8256,16r8257,16r8556,16r8545,16r856b,16r854d,16r8553,
16r8561,16r8558,16r8540,16r8546,16r8564,16r8541,16r8562,16r8544,
16r8551,16r8547,16r8563,16r853e,16r855b,16r8571,16r854e,16r856e,
16r8575,16r8555,16r8567,16r8560,16r858c,16r8566,16r855d,16r8554,
16r8565,16r856c,16r8663,16r8665,16r8664,16r879b,16r878f,16r8797,
16r8793,16r8792,16r8788,16r8781,16r8796,16r8798,16r8779,16r8787,
16r87a3,16r8785,16r8790,16r8791,16r879d,16r8784,16r8794,16r879c,
16r879a,16r8789,16r891e,16r8926,16r8930,16r892d,16r892e,16r8927,
16r8931,16r8922,16r8929,16r8923,16r892f,16r892c,16r891f,16r89f1,
16r8ae0,16r8ae2,16r8af2,16r8af4,16r8af5,16r8add,16r8b14,16r8ae4,
16r8adf,16r8af0,16r8ac8,16r8ade,16r8ae1,16r8ae8,16r8aff,16r8aef,
16r8afb,16r8c91,16r8c92,16r8c90,16r8cf5,16r8cee,16r8cf1,16r8cf0,
16r8cf3,16r8d6c,16r8d6e,16r8da5,16r8da7,16r8e33,16r8e3e,16r8e38,
16r8e40,16r8e45,16r8e36,16r8e3c,16r8e3d,16r8e41,16r8e30,16r8e3f,
16r8ebd,16r8f36,16r8f2e,16r8f35,16r8f32,16r8f39,16r8f37,16r8f34,
16r9076,16r9079,16r907b,16r9086,16r90fa,16r9133,16r9135,16r9136,
16r9193,16r9190,16r9191,16r918d,16r918f,16r9327,16r931e,16r9308,
16r931f,16r9306,16r930f,16r937a,16r9338,16r933c,16r931b,16r9323,
16r9312,16r9301,16r9346,16r932d,16r930e,16r930d,16r92cb,16r931d,
16r92fa,16r9325,16r9313,16r92f9,16r92f7,16r9334,16r9302,16r9324,
16r92ff,16r9329,16r9339,16r9335,16r932a,16r9314,16r930c,16r930b,
16r92fe,16r9309,16r9300,16r92fb,16r9316,16r95bc,16r95cd,16r95be,
16r95b9,16r95ba,16r95b6,16r95bf,16r95b5,16r95bd,16r96a9,16r96d4,
16r970b,16r9712,16r9710,16r9799,16r9797,16r9794,16r97f0,16r97f8,
16r9835,16r982f,16r9832,16r9924,16r991f,16r9927,16r9929,16r999e,
16r99ee,16r99ec,16r99e5,16r99e4,16r99f0,16r99e3,16r99ea,16r99e9,
16r99e7,16r9ab9,16r9abf,16r9ab4,16r9abb,16r9af6,16r9afa,16r9af9,
16r9af7,16r9b33,16r9b80,16r9b85,16r9b87,16r9b7c,16r9b7e,16r9b7b,
16r9b82,16r9b93,16r9b92,16r9b90,16r9b7a,16r9b95,16r9b7d,16r9b88,
16r9d25,16r9d17,16r9d20,16r9d1e,16r9d14,16r9d29,16r9d1d,16r9d18,
16r9d22,16r9d10,16r9d19,16r9d1f,16r9e88,16r9e86,16r9e87,16r9eae,
16r9ead,16r9ed5,16r9ed6,16r9efa,16r9f12,16r9f3d,16r5126,16r5125,
16r5122,16r5124,16r5120,16r5129,16r52f4,16r5693,16r568c,16r568d,
16r5686,16r5684,16r5683,16r567e,16r5682,16r567f,16r5681,16r58d6,
16r58d4,16r58cf,16r58d2,16r5b2d,16r5b25,16r5b32,16r5b23,16r5b2c,
16r5b27,16r5b26,16r5b2f,16r5b2e,16r5b7b,16r5bf1,16r5bf2,16r5db7,
16r5e6c,16r5e6a,16r5fbe,16r5fbb,16r61c3,16r61b5,16r61bc,16r61e7,
16r61e0,16r61e5,16r61e4,16r61e8,16r61de,16r64ef,16r64e9,16r64e3,
16r64eb,16r64e4,16r64e8,16r6581,16r6580,16r65b6,16r65da,16r66d2,
16r6a8d,16r6a96,16r6a81,16r6aa5,16r6a89,16r6a9f,16r6a9b,16r6aa1,
16r6a9e,16r6a87,16r6a93,16r6a8e,16r6a95,16r6a83,16r6aa8,16r6aa4,
16r6a91,16r6a7f,16r6aa6,16r6a9a,16r6a85,16r6a8c,16r6a92,16r6b5b,
16r6bad,16r6c09,16r6fcc,16r6fa9,16r6ff4,16r6fd4,16r6fe3,16r6fdc,
16r6fed,16r6fe7,16r6fe6,16r6fde,16r6ff2,16r6fdd,16r6fe2,16r6fe8,
16r71e1,16r71f1,16r71e8,16r71f2,16r71e4,16r71f0,16r71e2,16r7373,
16r736e,16r736f,16r7497,16r74b2,16r74ab,16r7490,16r74aa,16r74ad,
16r74b1,16r74a5,16r74af,16r7510,16r7511,16r7512,16r750f,16r7584,
16r7643,16r7648,16r7649,16r7647,16r76a4,16r76e9,16r77b5,16r77ab,
16r77b2,16r77b7,16r77b6,16r77b4,16r77b1,16r77a8,16r77f0,16r78f3,
16r78fd,16r7902,16r78fb,16r78fc,16r78f2,16r7905,16r78f9,16r78fe,
16r7904,16r79ab,16r79a8,16r7a5c,16r7a5b,16r7a56,16r7a58,16r7a54,
16r7a5a,16r7abe,16r7ac0,16r7ac1,16r7c05,16r7c0f,16r7bf2,16r7c00,
16r7bff,16r7bfb,16r7c0e,16r7bf4,16r7c0b,16r7bf3,16r7c02,16r7c09,
16r7c03,16r7c01,16r7bf8,16r7bfd,16r7c06,16r7bf0,16r7bf1,16r7c10,
16r7c0a,16r7ce8,16r7e2d,16r7e3c,16r7e42,16r7e33,16r9848,16r7e38,
16r7e2a,16r7e49,16r7e40,16r7e47,16r7e29,16r7e4c,16r7e30,16r7e3b,
16r7e36,16r7e44,16r7e3a,16r7f45,16r7f7f,16r7f7e,16r7f7d,16r7ff4,
16r7ff2,16r802c,16r81bb,16r81c4,16r81cc,16r81ca,16r81c5,16r81c7,
16r81bc,16r81e9,16r825b,16r825a,16r825c,16r8583,16r8580,16r858f,
16r85a7,16r8595,16r85a0,16r858b,16r85a3,16r857b,16r85a4,16r859a,
16r859e,16r8577,16r857c,16r8589,16r85a1,16r857a,16r8578,16r8557,
16r858e,16r8596,16r8586,16r858d,16r8599,16r859d,16r8581,16r85a2,
16r8582,16r8588,16r8585,16r8579,16r8576,16r8598,16r8590,16r859f,
16r8668,16r87be,16r87aa,16r87ad,16r87c5,16r87b0,16r87ac,16r87b9,
16r87b5,16r87bc,16r87ae,16r87c9,16r87c3,16r87c2,16r87cc,16r87b7,
16r87af,16r87c4,16r87ca,16r87b4,16r87b6,16r87bf,16r87b8,16r87bd,
16r87de,16r87b2,16r8935,16r8933,16r893c,16r893e,16r8941,16r8952,
16r8937,16r8942,16r89ad,16r89af,16r89ae,16r89f2,16r89f3,16r8b1e,
16r8b18,16r8b16,16r8b11,16r8b05,16r8b0b,16r8b22,16r8b0f,16r8b12,
16r8b15,16r8b07,16r8b0d,16r8b08,16r8b06,16r8b1c,16r8b13,16r8b1a,
16r8c4f,16r8c70,16r8c72,16r8c71,16r8c6f,16r8c95,16r8c94,16r8cf9,
16r8d6f,16r8e4e,16r8e4d,16r8e53,16r8e50,16r8e4c,16r8e47,16r8f43,
16r8f40,16r9085,16r907e,16r9138,16r919a,16r91a2,16r919b,16r9199,
16r919f,16r91a1,16r919d,16r91a0,16r93a1,16r9383,16r93af,16r9364,
16r9356,16r9347,16r937c,16r9358,16r935c,16r9376,16r9349,16r9350,
16r9351,16r9360,16r936d,16r938f,16r934c,16r936a,16r9379,16r9357,
16r9355,16r9352,16r934f,16r9371,16r9377,16r937b,16r9361,16r935e,
16r9363,16r9367,16r9380,16r934e,16r9359,16r95c7,16r95c0,16r95c9,
16r95c3,16r95c5,16r95b7,16r96ae,16r96b0,16r96ac,16r9720,16r971f,
16r9718,16r971d,16r9719,16r979a,16r97a1,16r979c,16r979e,16r979d,
16r97d5,16r97d4,16r97f1,16r9841,16r9844,16r984a,16r9849,16r9845,
16r9843,16r9925,16r992b,16r992c,16r992a,16r9933,16r9932,16r992f,
16r992d,16r9931,16r9930,16r9998,16r99a3,16r99a1,16r9a02,16r99fa,
16r99f4,16r99f7,16r99f9,16r99f8,16r99f6,16r99fb,16r99fd,16r99fe,
16r99fc,16r9a03,16r9abe,16r9afe,16r9afd,16r9b01,16r9afc,16r9b48,
16r9b9a,16r9ba8,16r9b9e,16r9b9b,16r9ba6,16r9ba1,16r9ba5,16r9ba4,
16r9b86,16r9ba2,16r9ba0,16r9baf,16r9d33,16r9d41,16r9d67,16r9d36,
16r9d2e,16r9d2f,16r9d31,16r9d38,16r9d30,16r9d45,16r9d42,16r9d43,
16r9d3e,16r9d37,16r9d40,16r9d3d,16r7ff5,16r9d2d,16r9e8a,16r9e89,
16r9e8d,16r9eb0,16r9ec8,16r9eda,16r9efb,16r9eff,16r9f24,16r9f23,
16r9f22,16r9f54,16r9fa0,16r5131,16r512d,16r512e,16r5698,16r569c,
16r5697,16r569a,16r569d,16r5699,16r5970,16r5b3c,16r5c69,16r5c6a,
16r5dc0,16r5e6d,16r5e6e,16r61d8,16r61df,16r61ed,16r61ee,16r61f1,
16r61ea,16r61f0,16r61eb,16r61d6,16r61e9,16r64ff,16r6504,16r64fd,
16r64f8,16r6501,16r6503,16r64fc,16r6594,16r65db,16r66da,16r66db,
16r66d8,16r6ac5,16r6ab9,16r6abd,16r6ae1,16r6ac6,16r6aba,16r6ab6,
16r6ab7,16r6ac7,16r6ab4,16r6aad,16r6b5e,16r6bc9,16r6c0b,16r7007,
16r700c,16r700d,16r7001,16r7005,16r7014,16r700e,16r6fff,16r7000,
16r6ffb,16r7026,16r6ffc,16r6ff7,16r700a,16r7201,16r71ff,16r71f9,
16r7203,16r71fd,16r7376,16r74b8,16r74c0,16r74b5,16r74c1,16r74be,
16r74b6,16r74bb,16r74c2,16r7514,16r7513,16r765c,16r7664,16r7659,
16r7650,16r7653,16r7657,16r765a,16r76a6,16r76bd,16r76ec,16r77c2,
16r77ba,16r78ff,16r790c,16r7913,16r7914,16r7909,16r7910,16r7912,
16r7911,16r79ad,16r79ac,16r7a5f,16r7c1c,16r7c29,16r7c19,16r7c20,
16r7c1f,16r7c2d,16r7c1d,16r7c26,16r7c28,16r7c22,16r7c25,16r7c30,
16r7e5c,16r7e50,16r7e56,16r7e63,16r7e58,16r7e62,16r7e5f,16r7e51,
16r7e60,16r7e57,16r7e53,16r7fb5,16r7fb3,16r7ff7,16r7ff8,16r8075,
16r81d1,16r81d2,16r81d0,16r825f,16r825e,16r85b4,16r85c6,16r85c0,
16r85c3,16r85c2,16r85b3,16r85b5,16r85bd,16r85c7,16r85c4,16r85bf,
16r85cb,16r85ce,16r85c8,16r85c5,16r85b1,16r85b6,16r85d2,16r8624,
16r85b8,16r85b7,16r85be,16r8669,16r87e7,16r87e6,16r87e2,16r87db,
16r87eb,16r87ea,16r87e5,16r87df,16r87f3,16r87e4,16r87d4,16r87dc,
16r87d3,16r87ed,16r87d8,16r87e3,16r87a4,16r87d7,16r87d9,16r8801,
16r87f4,16r87e8,16r87dd,16r8953,16r894b,16r894f,16r894c,16r8946,
16r8950,16r8951,16r8949,16r8b2a,16r8b27,16r8b23,16r8b33,16r8b30,
16r8b35,16r8b47,16r8b2f,16r8b3c,16r8b3e,16r8b31,16r8b25,16r8b37,
16r8b26,16r8b36,16r8b2e,16r8b24,16r8b3b,16r8b3d,16r8b3a,16r8c42,
16r8c75,16r8c99,16r8c98,16r8c97,16r8cfe,16r8d04,16r8d02,16r8d00,
16r8e5c,16r8e62,16r8e60,16r8e57,16r8e56,16r8e5e,16r8e65,16r8e67,
16r8e5b,16r8e5a,16r8e61,16r8e5d,16r8e69,16r8e54,16r8f46,16r8f47,
16r8f48,16r8f4b,16r9128,16r913a,16r913b,16r913e,16r91a8,16r91a5,
16r91a7,16r91af,16r91aa,16r93b5,16r938c,16r9392,16r93b7,16r939b,
16r939d,16r9389,16r93a7,16r938e,16r93aa,16r939e,16r93a6,16r9395,
16r9388,16r9399,16r939f,16r938d,16r93b1,16r9391,16r93b2,16r93a4,
16r93a8,16r93b4,16r93a3,16r93a5,16r95d2,16r95d3,16r95d1,16r96b3,
16r96d7,16r96da,16r5dc2,16r96df,16r96d8,16r96dd,16r9723,16r9722,
16r9725,16r97ac,16r97ae,16r97a8,16r97ab,16r97a4,16r97aa,16r97a2,
16r97a5,16r97d7,16r97d9,16r97d6,16r97d8,16r97fa,16r9850,16r9851,
16r9852,16r98b8,16r9941,16r993c,16r993a,16r9a0f,16r9a0b,16r9a09,
16r9a0d,16r9a04,16r9a11,16r9a0a,16r9a05,16r9a07,16r9a06,16r9ac0,
16r9adc,16r9b08,16r9b04,16r9b05,16r9b29,16r9b35,16r9b4a,16r9b4c,
16r9b4b,16r9bc7,16r9bc6,16r9bc3,16r9bbf,16r9bc1,16r9bb5,16r9bb8,
16r9bd3,16r9bb6,16r9bc4,16r9bb9,16r9bbd,16r9d5c,16r9d53,16r9d4f,
16r9d4a,16r9d5b,16r9d4b,16r9d59,16r9d56,16r9d4c,16r9d57,16r9d52,
16r9d54,16r9d5f,16r9d58,16r9d5a,16r9e8e,16r9e8c,16r9edf,16r9f01,
16r9f00,16r9f16,16r9f25,16r9f2b,16r9f2a,16r9f29,16r9f28,16r9f4c,
16r9f55,16r5134,16r5135,16r5296,16r52f7,16r53b4,16r56ab,16r56ad,
16r56a6,16r56a7,16r56aa,16r56ac,16r58da,16r58dd,16r58db,16r5912,
16r5b3d,16r5b3e,16r5b3f,16r5dc3,16r5e70,16r5fbf,16r61fb,16r6507,
16r6510,16r650d,16r6509,16r650c,16r650e,16r6584,16r65de,16r65dd,
16r66de,16r6ae7,16r6ae0,16r6acc,16r6ad1,16r6ad9,16r6acb,16r6adf,
16r6adc,16r6ad0,16r6aeb,16r6acf,16r6acd,16r6ade,16r6b60,16r6bb0,
16r6c0c,16r7019,16r7027,16r7020,16r7016,16r702b,16r7021,16r7022,
16r7023,16r7029,16r7017,16r7024,16r701c,16r702a,16r720c,16r720a,
16r7207,16r7202,16r7205,16r72a5,16r72a6,16r72a4,16r72a3,16r72a1,
16r74cb,16r74c5,16r74b7,16r74c3,16r7516,16r7660,16r77c9,16r77ca,
16r77c4,16r77f1,16r791d,16r791b,16r7921,16r791c,16r7917,16r791e,
16r79b0,16r7a67,16r7a68,16r7c33,16r7c3c,16r7c39,16r7c2c,16r7c3b,
16r7cec,16r7cea,16r7e76,16r7e75,16r7e78,16r7e70,16r7e77,16r7e6f,
16r7e7a,16r7e72,16r7e74,16r7e68,16r7f4b,16r7f4a,16r7f83,16r7f86,
16r7fb7,16r7ffd,16r7ffe,16r8078,16r81d7,16r81d5,16r8264,16r8261,
16r8263,16r85eb,16r85f1,16r85ed,16r85d9,16r85e1,16r85e8,16r85da,
16r85d7,16r85ec,16r85f2,16r85f8,16r85d8,16r85df,16r85e3,16r85dc,
16r85d1,16r85f0,16r85e6,16r85ef,16r85de,16r85e2,16r8800,16r87fa,
16r8803,16r87f6,16r87f7,16r8809,16r880c,16r880b,16r8806,16r87fc,
16r8808,16r87ff,16r880a,16r8802,16r8962,16r895a,16r895b,16r8957,
16r8961,16r895c,16r8958,16r895d,16r8959,16r8988,16r89b7,16r89b6,
16r89f6,16r8b50,16r8b48,16r8b4a,16r8b40,16r8b53,16r8b56,16r8b54,
16r8b4b,16r8b55,16r8b51,16r8b42,16r8b52,16r8b57,16r8c43,16r8c77,
16r8c76,16r8c9a,16r8d06,16r8d07,16r8d09,16r8dac,16r8daa,16r8dad,
16r8dab,16r8e6d,16r8e78,16r8e73,16r8e6a,16r8e6f,16r8e7b,16r8ec2,
16r8f52,16r8f51,16r8f4f,16r8f50,16r8f53,16r8fb4,16r9140,16r913f,
16r91b0,16r91ad,16r93de,16r93c7,16r93cf,16r93c2,16r93da,16r93d0,
16r93f9,16r93ec,16r93cc,16r93d9,16r93a9,16r93e6,16r93ca,16r93d4,
16r93ee,16r93e3,16r93d5,16r93c4,16r93ce,16r93c0,16r93d2,16r93e7,
16r957d,16r95da,16r95db,16r96e1,16r9729,16r972b,16r972c,16r9728,
16r9726,16r97b3,16r97b7,16r97b6,16r97dd,16r97de,16r97df,16r985c,
16r9859,16r985d,16r9857,16r98bf,16r98bd,16r98bb,16r98be,16r9948,
16r9947,16r9943,16r99a6,16r99a7,16r9a1a,16r9a15,16r9a25,16r9a1d,
16r9a24,16r9a1b,16r9a22,16r9a20,16r9a27,16r9a23,16r9a1e,16r9a1c,
16r9a14,16r9ac2,16r9b0b,16r9b0a,16r9b0e,16r9b0c,16r9b37,16r9bea,
16r9beb,16r9be0,16r9bde,16r9be4,16r9be6,16r9be2,16r9bf0,16r9bd4,
16r9bd7,16r9bec,16r9bdc,16r9bd9,16r9be5,16r9bd5,16r9be1,16r9bda,
16r9d77,16r9d81,16r9d8a,16r9d84,16r9d88,16r9d71,16r9d80,16r9d78,
16r9d86,16r9d8b,16r9d8c,16r9d7d,16r9d6b,16r9d74,16r9d75,16r9d70,
16r9d69,16r9d85,16r9d73,16r9d7b,16r9d82,16r9d6f,16r9d79,16r9d7f,
16r9d87,16r9d68,16r9e94,16r9e91,16r9ec0,16r9efc,16r9f2d,16r9f40,
16r9f41,16r9f4d,16r9f56,16r9f57,16r9f58,16r5337,16r56b2,16r56b5,
16r56b3,16r58e3,16r5b45,16r5dc6,16r5dc7,16r5eee,16r5eef,16r5fc0,
16r5fc1,16r61f9,16r6517,16r6516,16r6515,16r6513,16r65df,16r66e8,
16r66e3,16r66e4,16r6af3,16r6af0,16r6aea,16r6ae8,16r6af9,16r6af1,
16r6aee,16r6aef,16r703c,16r7035,16r702f,16r7037,16r7034,16r7031,
16r7042,16r7038,16r703f,16r703a,16r7039,16r7040,16r703b,16r7033,
16r7041,16r7213,16r7214,16r72a8,16r737d,16r737c,16r74ba,16r76ab,
16r76aa,16r76be,16r76ed,16r77cc,16r77ce,16r77cf,16r77cd,16r77f2,
16r7925,16r7923,16r7927,16r7928,16r7924,16r7929,16r79b2,16r7a6e,
16r7a6c,16r7a6d,16r7af7,16r7c49,16r7c48,16r7c4a,16r7c47,16r7c45,
16r7cee,16r7e7b,16r7e7e,16r7e81,16r7e80,16r7fba,16r7fff,16r8079,
16r81db,16r81d9,16r820b,16r8268,16r8269,16r8622,16r85ff,16r8601,
16r85fe,16r861b,16r8600,16r85f6,16r8604,16r8609,16r8605,16r860c,
16r85fd,16r8819,16r8810,16r8811,16r8817,16r8813,16r8816,16r8963,
16r8966,16r89b9,16r89f7,16r8b60,16r8b6a,16r8b5d,16r8b68,16r8b63,
16r8b65,16r8b67,16r8b6d,16r8dae,16r8e86,16r8e88,16r8e84,16r8f59,
16r8f56,16r8f57,16r8f55,16r8f58,16r8f5a,16r908d,16r9143,16r9141,
16r91b7,16r91b5,16r91b2,16r91b3,16r940b,16r9413,16r93fb,16r9420,
16r940f,16r9414,16r93fe,16r9415,16r9410,16r9428,16r9419,16r940d,
16r93f5,16r9400,16r93f7,16r9407,16r940e,16r9416,16r9412,16r93fa,
16r9409,16r93f8,16r940a,16r93ff,16r93fc,16r940c,16r93f6,16r9411,
16r9406,16r95de,16r95e0,16r95df,16r972e,16r972f,16r97b9,16r97bb,
16r97fd,16r97fe,16r9860,16r9862,16r9863,16r985f,16r98c1,16r98c2,
16r9950,16r994e,16r9959,16r994c,16r994b,16r9953,16r9a32,16r9a34,
16r9a31,16r9a2c,16r9a2a,16r9a36,16r9a29,16r9a2e,16r9a38,16r9a2d,
16r9ac7,16r9aca,16r9ac6,16r9b10,16r9b12,16r9b11,16r9c0b,16r9c08,
16r9bf7,16r9c05,16r9c12,16r9bf8,16r9c40,16r9c07,16r9c0e,16r9c06,
16r9c17,16r9c14,16r9c09,16r9d9f,16r9d99,16r9da4,16r9d9d,16r9d92,
16r9d98,16r9d90,16r9d9b,16r9da0,16r9d94,16r9d9c,16r9daa,16r9d97,
16r9da1,16r9d9a,16r9da2,16r9da8,16r9d9e,16r9da3,16r9dbf,16r9da9,
16r9d96,16r9da6,16r9da7,16r9e99,16r9e9b,16r9e9a,16r9ee5,16r9ee4,
16r9ee7,16r9ee6,16r9f30,16r9f2e,16r9f5b,16r9f60,16r9f5e,16r9f5d,
16r9f59,16r9f91,16r513a,16r5139,16r5298,16r5297,16r56c3,16r56bd,
16r56be,16r5b48,16r5b47,16r5dcb,16r5dcf,16r5ef1,16r61fd,16r651b,
16r6b02,16r6afc,16r6b03,16r6af8,16r6b00,16r7043,16r7044,16r704a,
16r7048,16r7049,16r7045,16r7046,16r721d,16r721a,16r7219,16r737e,
16r7517,16r766a,16r77d0,16r792d,16r7931,16r792f,16r7c54,16r7c53,
16r7cf2,16r7e8a,16r7e87,16r7e88,16r7e8b,16r7e86,16r7e8d,16r7f4d,
16r7fbb,16r8030,16r81dd,16r8618,16r862a,16r8626,16r861f,16r8623,
16r861c,16r8619,16r8627,16r862e,16r8621,16r8620,16r8629,16r861e,
16r8625,16r8829,16r881d,16r881b,16r8820,16r8824,16r881c,16r882b,
16r884a,16r896d,16r8969,16r896e,16r896b,16r89fa,16r8b79,16r8b78,
16r8b45,16r8b7a,16r8b7b,16r8d10,16r8d14,16r8daf,16r8e8e,16r8e8c,
16r8f5e,16r8f5b,16r8f5d,16r9146,16r9144,16r9145,16r91b9,16r943f,
16r943b,16r9436,16r9429,16r943d,16r943c,16r9430,16r9439,16r942a,
16r9437,16r942c,16r9440,16r9431,16r95e5,16r95e4,16r95e3,16r9735,
16r973a,16r97bf,16r97e1,16r9864,16r98c9,16r98c6,16r98c0,16r9958,
16r9956,16r9a39,16r9a3d,16r9a46,16r9a44,16r9a42,16r9a41,16r9a3a,
16r9a3f,16r9acd,16r9b15,16r9b17,16r9b18,16r9b16,16r9b3a,16r9b52,
16r9c2b,16r9c1d,16r9c1c,16r9c2c,16r9c23,16r9c28,16r9c29,16r9c24,
16r9c21,16r9db7,16r9db6,16r9dbc,16r9dc1,16r9dc7,16r9dca,16r9dcf,
16r9dbe,16r9dc5,16r9dc3,16r9dbb,16r9db5,16r9dce,16r9db9,16r9dba,
16r9dac,16r9dc8,16r9db1,16r9dad,16r9dcc,16r9db3,16r9dcd,16r9db2,
16r9e7a,16r9e9c,16r9eeb,16r9eee,16r9eed,16r9f1b,16r9f18,16r9f1a,
16r9f31,16r9f4e,16r9f65,16r9f64,16r9f92,16r4eb9,16r56c6,16r56c5,
16r56cb,16r5971,16r5b4b,16r5b4c,16r5dd5,16r5dd1,16r5ef2,16r6521,
16r6520,16r6526,16r6522,16r6b0b,16r6b08,16r6b09,16r6c0d,16r7055,
16r7056,16r7057,16r7052,16r721e,16r721f,16r72a9,16r737f,16r74d8,
16r74d5,16r74d9,16r74d7,16r766d,16r76ad,16r7935,16r79b4,16r7a70,
16r7a71,16r7c57,16r7c5c,16r7c59,16r7c5b,16r7c5a,16r7cf4,16r7cf1,
16r7e91,16r7f4f,16r7f87,16r81de,16r826b,16r8634,16r8635,16r8633,
16r862c,16r8632,16r8636,16r882c,16r8828,16r8826,16r882a,16r8825,
16r8971,16r89bf,16r89be,16r89fb,16r8b7e,16r8b84,16r8b82,16r8b86,
16r8b85,16r8b7f,16r8d15,16r8e95,16r8e94,16r8e9a,16r8e92,16r8e90,
16r8e96,16r8e97,16r8f60,16r8f62,16r9147,16r944c,16r9450,16r944a,
16r944b,16r944f,16r9447,16r9445,16r9448,16r9449,16r9446,16r973f,
16r97e3,16r986a,16r9869,16r98cb,16r9954,16r995b,16r9a4e,16r9a53,
16r9a54,16r9a4c,16r9a4f,16r9a48,16r9a4a,16r9a49,16r9a52,16r9a50,
16r9ad0,16r9b19,16r9b2b,16r9b3b,16r9b56,16r9b55,16r9c46,16r9c48,
16r9c3f,16r9c44,16r9c39,16r9c33,16r9c41,16r9c3c,16r9c37,16r9c34,
16r9c32,16r9c3d,16r9c36,16r9ddb,16r9dd2,16r9dde,16r9dda,16r9dcb,
16r9dd0,16r9ddc,16r9dd1,16r9ddf,16r9de9,16r9dd9,16r9dd8,16r9dd6,
16r9df5,16r9dd5,16r9ddd,16r9eb6,16r9ef0,16r9f35,16r9f33,16r9f32,
16r9f42,16r9f6b,16r9f95,16r9fa2,16r513d,16r5299,16r58e8,16r58e7,
16r5972,16r5b4d,16r5dd8,16r882f,16r5f4f,16r6201,16r6203,16r6204,
16r6529,16r6525,16r6596,16r66eb,16r6b11,16r6b12,16r6b0f,16r6bca,
16r705b,16r705a,16r7222,16r7382,16r7381,16r7383,16r7670,16r77d4,
16r7c67,16r7c66,16r7e95,16r826c,16r863a,16r8640,16r8639,16r863c,
16r8631,16r863b,16r863e,16r8830,16r8832,16r882e,16r8833,16r8976,
16r8974,16r8973,16r89fe,16r8b8c,16r8b8e,16r8b8b,16r8b88,16r8c45,
16r8d19,16r8e98,16r8f64,16r8f63,16r91bc,16r9462,16r9455,16r945d,
16r9457,16r945e,16r97c4,16r97c5,16r9800,16r9a56,16r9a59,16r9b1e,
16r9b1f,16r9b20,16r9c52,16r9c58,16r9c50,16r9c4a,16r9c4d,16r9c4b,
16r9c55,16r9c59,16r9c4c,16r9c4e,16r9dfb,16r9df7,16r9def,16r9de3,
16r9deb,16r9df8,16r9de4,16r9df6,16r9de1,16r9dee,16r9de6,16r9df2,
16r9df0,16r9de2,16r9dec,16r9df4,16r9df3,16r9de8,16r9ded,16r9ec2,
16r9ed0,16r9ef2,16r9ef3,16r9f06,16r9f1c,16r9f38,16r9f37,16r9f36,
16r9f43,16r9f4f,16r9f71,16r9f70,16r9f6e,16r9f6f,16r56d3,16r56cd,
16r5b4e,16r5c6d,16r652d,16r66ed,16r66ee,16r6b13,16r705f,16r7061,
16r705d,16r7060,16r7223,16r74db,16r74e5,16r77d5,16r7938,16r79b7,
16r79b6,16r7c6a,16r7e97,16r7f89,16r826d,16r8643,16r8838,16r8837,
16r8835,16r884b,16r8b94,16r8b95,16r8e9e,16r8e9f,16r8ea0,16r8e9d,
16r91be,16r91bd,16r91c2,16r946b,16r9468,16r9469,16r96e5,16r9746,
16r9743,16r9747,16r97c7,16r97e5,16r9a5e,16r9ad5,16r9b59,16r9c63,
16r9c67,16r9c66,16r9c62,16r9c5e,16r9c60,16r9e02,16r9dfe,16r9e07,
16r9e03,16r9e06,16r9e05,16r9e00,16r9e01,16r9e09,16r9dff,16r9dfd,
16r9e04,16r9ea0,16r9f1e,16r9f46,16r9f74,16r9f75,16r9f76,16r56d4,
16r652e,16r65b8,16r6b18,16r6b19,16r6b17,16r6b1a,16r7062,16r7226,
16r72aa,16r77d8,16r77d9,16r7939,16r7c69,16r7c6b,16r7cf6,16r7e9a,
16r7e98,16r7e9b,16r7e99,16r81e0,16r81e1,16r8646,16r8647,16r8648,
16r8979,16r897a,16r897c,16r897b,16r89ff,16r8b98,16r8b99,16r8ea5,
16r8ea4,16r8ea3,16r946e,16r946d,16r946f,16r9471,16r9473,16r9749,
16r9872,16r995f,16r9c68,16r9c6e,16r9c6d,16r9e0b,16r9e0d,16r9e10,
16r9e0f,16r9e12,16r9e11,16r9ea1,16r9ef5,16r9f09,16r9f47,16r9f78,
16r9f7b,16r9f7a,16r9f79,16r571e,16r7066,16r7c6f,16r883c,16r8db2,
16r8ea6,16r91c3,16r9474,16r9478,16r9476,16r9475,16r9a60,16r9c74,
16r9c73,16r9c71,16r9c75,16r9e14,16r9e13,16r9ef6,16r9f0a,16r9fa4,
16r7068,16r7065,16r7cf7,16r866a,16r883e,16r883d,16r883f,16r8b9e,
16r8c9c,16r8ea9,16r8ec9,16r974b,16r9873,16r9874,16r98cc,16r9961,
16r99ab,16r9a64,16r9a66,16r9a67,16r9b24,16r9e15,16r9e17,16r9f48,
16r6207,16r6b1e,16r7227,16r864c,16r8ea8,16r9482,16r9480,16r9481,
16r9a69,16r9a68,16r9b2e,16r9e19,16r7229,16r864b,16r8b9f,16r9483,
16r9c79,16r9eb7,16r7675,16r9a6b,16r9c7a,16r9e1d,16r7069,16r706a,
16r9ea4,16r9f7e,16r9f49,16r9f98,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
};
