# generate the GB2312 character set converter data file
implement GenGB;

include "sys.m";
include "draw.m";

GBDATA : con "/lib/convcs/gb2312";

GenGB : module {
	init : fn (ctxt : ref Draw->Context, args : list of string);
};

init(nil : ref Draw->Context, nil : list of string)
{
	sys := load Sys Sys->PATH;
	fd := sys->create(GBDATA, Sys->OWRITE, 8r644);
	if (fd == nil) {
		sys->print("cannot create %s: %r\n", GBDATA);
		return;
	}
	s := "";
	for (i := 0; i < len tabgb; i++)
		s[len s] = tabgb[i];

	buf := array of byte s;
	for (i = 0; i < len buf;) {
		towrite := Sys->ATOMICIO;
		if (len buf - i < Sys->ATOMICIO)
			towrite = len buf -i;
		n := sys->write(fd, buf[i:], towrite);
		if (n <= 0) {
			sys->print("error writing %s: %r", GBDATA);
			return;
		}
		i += n;
	}
}


ERRchar : con 16rFFFD;

tabgb := array [] of {
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r3000,16r3001,16r3002,
16r30fb,16r02c9,16r02c7,16r00a8,16r3003,16r3005,16r2015,16r301c,
16r2225,16r2026,16r2018,16r2019,16r201c,16r201d,16r3014,16r3015,
16r3008,16r3009,16r300a,16r300b,16r300c,16r300d,16r300e,16r300f,
16r3016,16r3017,16r3010,16r3011,16r00b1,16r00d7,16r00f7,16r2236,
16r2227,16r2228,16r2211,16r220f,16r222a,16r2229,16r2208,16r2237,
16r221a,16r22a5,16r2225,16r2220,16r2312,16r2299,16r222b,16r222e,
16r2261,16r224c,16r2248,16r223d,16r221d,16r2260,16r226e,16r226f,
16r2264,16r2265,16r221e,16r2235,16r2234,16r2642,16r2640,16r00b0,
16r2032,16r2033,16r2103,16rff04,16r00a4,16rffe0,16rffe1,16r2030,
16r00a7,16r2116,16r2606,16r2605,16r25cb,16r25cf,16r25ce,16r25c7,
16r25c6,16r25a1,16r25a0,16r25b3,16r25b2,16r203b,16r2192,16r2190,
16r2191,16r2193,16r3013,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r2488,16r2489,16r248a,16r248b,16r248c,16r248d,16r248e,
16r248f,16r2490,16r2491,16r2492,16r2493,16r2494,16r2495,16r2496,
16r2497,16r2498,16r2499,16r249a,16r249b,16r2474,16r2475,16r2476,
16r2477,16r2478,16r2479,16r247a,16r247b,16r247c,16r247d,16r247e,
16r247f,16r2480,16r2481,16r2482,16r2483,16r2484,16r2485,16r2486,
16r2487,16r2460,16r2461,16r2462,16r2463,16r2464,16r2465,16r2466,
16r2467,16r2468,16r2469,ERRchar,ERRchar,16r3220,16r3221,16r3222,
16r3223,16r3224,16r3225,16r3226,16r3227,16r3228,16r3229,ERRchar,
ERRchar,16r2160,16r2161,16r2162,16r2163,16r2164,16r2165,16r2166,
16r2167,16r2168,16r2169,16r216a,16r216b,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16rff01,16rff02,16rff03,
16rffe5,16rff05,16rff06,16rff07,16rff08,16rff09,16rff0a,16rff0b,
16rff0c,16rff0d,16rff0e,16rff0f,16rff10,16rff11,16rff12,16rff13,
16rff14,16rff15,16rff16,16rff17,16rff18,16rff19,16rff1a,16rff1b,
16rff1c,16rff1d,16rff1e,16rff1f,16rff20,16rff21,16rff22,16rff23,
16rff24,16rff25,16rff26,16rff27,16rff28,16rff29,16rff2a,16rff2b,
16rff2c,16rff2d,16rff2e,16rff2f,16rff30,16rff31,16rff32,16rff33,
16rff34,16rff35,16rff36,16rff37,16rff38,16rff39,16rff3a,16rff3b,
16rff3c,16rff3d,16rff3e,16rff3f,16rff40,16rff41,16rff42,16rff43,
16rff44,16rff45,16rff46,16rff47,16rff48,16rff49,16rff4a,16rff4b,
16rff4c,16rff4d,16rff4e,16rff4f,16rff50,16rff51,16rff52,16rff53,
16rff54,16rff55,16rff56,16rff57,16rff58,16rff59,16rff5a,16rff5b,
16rff5c,16rff5d,16rffe3,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r3041,16r3042,16r3043,16r3044,16r3045,16r3046,16r3047,
16r3048,16r3049,16r304a,16r304b,16r304c,16r304d,16r304e,16r304f,
16r3050,16r3051,16r3052,16r3053,16r3054,16r3055,16r3056,16r3057,
16r3058,16r3059,16r305a,16r305b,16r305c,16r305d,16r305e,16r305f,
16r3060,16r3061,16r3062,16r3063,16r3064,16r3065,16r3066,16r3067,
16r3068,16r3069,16r306a,16r306b,16r306c,16r306d,16r306e,16r306f,
16r3070,16r3071,16r3072,16r3073,16r3074,16r3075,16r3076,16r3077,
16r3078,16r3079,16r307a,16r307b,16r307c,16r307d,16r307e,16r307f,
16r3080,16r3081,16r3082,16r3083,16r3084,16r3085,16r3086,16r3087,
16r3088,16r3089,16r308a,16r308b,16r308c,16r308d,16r308e,16r308f,
16r3090,16r3091,16r3092,16r3093,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r30a1,16r30a2,16r30a3,
16r30a4,16r30a5,16r30a6,16r30a7,16r30a8,16r30a9,16r30aa,16r30ab,
16r30ac,16r30ad,16r30ae,16r30af,16r30b0,16r30b1,16r30b2,16r30b3,
16r30b4,16r30b5,16r30b6,16r30b7,16r30b8,16r30b9,16r30ba,16r30bb,
16r30bc,16r30bd,16r30be,16r30bf,16r30c0,16r30c1,16r30c2,16r30c3,
16r30c4,16r30c5,16r30c6,16r30c7,16r30c8,16r30c9,16r30ca,16r30cb,
16r30cc,16r30cd,16r30ce,16r30cf,16r30d0,16r30d1,16r30d2,16r30d3,
16r30d4,16r30d5,16r30d6,16r30d7,16r30d8,16r30d9,16r30da,16r30db,
16r30dc,16r30dd,16r30de,16r30df,16r30e0,16r30e1,16r30e2,16r30e3,
16r30e4,16r30e5,16r30e6,16r30e7,16r30e8,16r30e9,16r30ea,16r30eb,
16r30ec,16r30ed,16r30ee,16r30ef,16r30f0,16r30f1,16r30f2,16r30f3,
16r30f4,16r30f5,16r30f6,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r0391,16r0392,16r0393,16r0394,16r0395,16r0396,16r0397,
16r0398,16r0399,16r039a,16r039b,16r039c,16r039d,16r039e,16r039f,
16r03a0,16r03a1,16r03a3,16r03a4,16r03a5,16r03a6,16r03a7,16r03a8,
16r03a9,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r03b1,16r03b2,16r03b3,16r03b4,16r03b5,16r03b6,16r03b7,
16r03b8,16r03b9,16r03ba,16r03bb,16r03bc,16r03bd,16r03be,16r03bf,
16r03c0,16r03c1,16r03c3,16r03c4,16r03c5,16r03c6,16r03c7,16r03c8,
16r03c9,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r0410,16r0411,16r0412,
16r0413,16r0414,16r0415,16r0401,16r0416,16r0417,16r0418,16r0419,
16r041a,16r041b,16r041c,16r041d,16r041e,16r041f,16r0420,16r0421,
16r0422,16r0423,16r0424,16r0425,16r0426,16r0427,16r0428,16r0429,
16r042a,16r042b,16r042c,16r042d,16r042e,16r042f,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r0430,16r0431,16r0432,
16r0433,16r0434,16r0435,16r0451,16r0436,16r0437,16r0438,16r0439,
16r043a,16r043b,16r043c,16r043d,16r043e,16r043f,16r0440,16r0441,
16r0442,16r0443,16r0444,16r0445,16r0446,16r0447,16r0448,16r0449,
16r044a,16r044b,16r044c,16r044d,16r044e,16r044f,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r0101,16r00e1,16r01ce,16r00e0,16r0113,16r00e9,16r011b,
16r00e8,16r012b,16r00ed,16r01d0,16r00ec,16r014d,16r00f3,16r01d2,
16r00f2,16r016b,16r00fa,16r01d4,16r00f9,16r01d6,16r01d8,16r01da,
16r01dc,16r00fc,16r00ea,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r3105,16r3106,16r3107,
16r3108,16r3109,16r310a,16r310b,16r310c,16r310d,16r310e,16r310f,
16r3110,16r3111,16r3112,16r3113,16r3114,16r3115,16r3116,16r3117,
16r3118,16r3119,16r311a,16r311b,16r311c,16r311d,16r311e,16r311f,
16r3120,16r3121,16r3122,16r3123,16r3124,16r3125,16r3126,16r3127,
16r3128,16r3129,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
16r2500,16r2501,16r2502,16r2503,16r2504,16r2505,16r2506,16r2507,
16r2508,16r2509,16r250a,16r250b,16r250c,16r250d,16r250e,16r250f,
16r2510,16r2511,16r2512,16r2513,16r2514,16r2515,16r2516,16r2517,
16r2518,16r2519,16r251a,16r251b,16r251c,16r251d,16r251e,16r251f,
16r2520,16r2521,16r2522,16r2523,16r2524,16r2525,16r2526,16r2527,
16r2528,16r2529,16r252a,16r252b,16r252c,16r252d,16r252e,16r252f,
16r2530,16r2531,16r2532,16r2533,16r2534,16r2535,16r2536,16r2537,
16r2538,16r2539,16r253a,16r253b,16r253c,16r253d,16r253e,16r253f,
16r2540,16r2541,16r2542,16r2543,16r2544,16r2545,16r2546,16r2547,
16r2548,16r2549,16r254a,16r254b,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r554a,16r963f,16r57c3,16r6328,16r54ce,16r5509,16r54c0,
16r7691,16r764c,16r853c,16r77ee,16r827e,16r788d,16r7231,16r9698,
16r978d,16r6c28,16r5b89,16r4ffa,16r6309,16r6697,16r5cb8,16r80fa,
16r6848,16r80ae,16r6602,16r76ce,16r51f9,16r6556,16r71ac,16r7ff1,
16r8884,16r50b2,16r5965,16r61ca,16r6fb3,16r82ad,16r634c,16r6252,
16r53ed,16r5427,16r7b06,16r516b,16r75a4,16r5df4,16r62d4,16r8dcb,
16r9776,16r628a,16r8019,16r575d,16r9738,16r7f62,16r7238,16r767d,
16r67cf,16r767e,16r6446,16r4f70,16r8d25,16r62dc,16r7a17,16r6591,
16r73ed,16r642c,16r6273,16r822c,16r9881,16r677f,16r7248,16r626e,
16r62cc,16r4f34,16r74e3,16r534a,16r529e,16r7eca,16r90a6,16r5e2e,
16r6886,16r699c,16r8180,16r7ed1,16r68d2,16r78c5,16r868c,16r9551,
16r508d,16r8c24,16r82de,16r80de,16r5305,16r8912,16r5265,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r8584,16r96f9,16r4fdd,
16r5821,16r9971,16r5b9d,16r62b1,16r62a5,16r66b4,16r8c79,16r9c8d,
16r7206,16r676f,16r7891,16r60b2,16r5351,16r5317,16r8f88,16r80cc,
16r8d1d,16r94a1,16r500d,16r72c8,16r5907,16r60eb,16r7119,16r88ab,
16r5954,16r82ef,16r672c,16r7b28,16r5d29,16r7ef7,16r752d,16r6cf5,
16r8e66,16r8ff8,16r903c,16r9f3b,16r6bd4,16r9119,16r7b14,16r5f7c,
16r78a7,16r84d6,16r853d,16r6bd5,16r6bd9,16r6bd6,16r5e01,16r5e87,
16r75f9,16r95ed,16r655d,16r5f0a,16r5fc5,16r8f9f,16r58c1,16r81c2,
16r907f,16r965b,16r97ad,16r8fb9,16r7f16,16r8d2c,16r6241,16r4fbf,
16r53d8,16r535e,16r8fa8,16r8fa9,16r8fab,16r904d,16r6807,16r5f6a,
16r8198,16r8868,16r9cd6,16r618b,16r522b,16r762a,16r5f6c,16r658c,
16r6fd2,16r6ee8,16r5bbe,16r6448,16r5175,16r51b0,16r67c4,16r4e19,
16r79c9,16r997c,16r70b3,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r75c5,16r5e76,16r73bb,16r83e0,16r64ad,16r62e8,16r94b5,
16r6ce2,16r535a,16r52c3,16r640f,16r94c2,16r7b94,16r4f2f,16r5e1b,
16r8236,16r8116,16r818a,16r6e24,16r6cca,16r9a73,16r6355,16r535c,
16r54fa,16r8865,16r57e0,16r4e0d,16r5e03,16r6b65,16r7c3f,16r90e8,
16r6016,16r64e6,16r731c,16r88c1,16r6750,16r624d,16r8d22,16r776c,
16r8e29,16r91c7,16r5f69,16r83dc,16r8521,16r9910,16r53c2,16r8695,
16r6b8b,16r60ed,16r60e8,16r707f,16r82cd,16r8231,16r4ed3,16r6ca7,
16r85cf,16r64cd,16r7cd9,16r69fd,16r66f9,16r8349,16r5395,16r7b56,
16r4fa7,16r518c,16r6d4b,16r5c42,16r8e6d,16r63d2,16r53c9,16r832c,
16r8336,16r67e5,16r78b4,16r643d,16r5bdf,16r5c94,16r5dee,16r8be7,
16r62c6,16r67f4,16r8c7a,16r6400,16r63ba,16r8749,16r998b,16r8c17,
16r7f20,16r94f2,16r4ea7,16r9610,16r98a4,16r660c,16r7316,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r573a,16r5c1d,16r5e38,
16r957f,16r507f,16r80a0,16r5382,16r655e,16r7545,16r5531,16r5021,
16r8d85,16r6284,16r949e,16r671d,16r5632,16r6f6e,16r5de2,16r5435,
16r7092,16r8f66,16r626f,16r64a4,16r63a3,16r5f7b,16r6f88,16r90f4,
16r81e3,16r8fb0,16r5c18,16r6668,16r5ff1,16r6c89,16r9648,16r8d81,
16r886c,16r6491,16r79f0,16r57ce,16r6a59,16r6210,16r5448,16r4e58,
16r7a0b,16r60e9,16r6f84,16r8bda,16r627f,16r901e,16r9a8b,16r79e4,
16r5403,16r75f4,16r6301,16r5319,16r6c60,16r8fdf,16r5f1b,16r9a70,
16r803b,16r9f7f,16r4f88,16r5c3a,16r8d64,16r7fc5,16r65a5,16r70bd,
16r5145,16r51b2,16r866b,16r5d07,16r5ba0,16r62bd,16r916c,16r7574,
16r8e0c,16r7a20,16r6101,16r7b79,16r4ec7,16r7ef8,16r7785,16r4e11,
16r81ed,16r521d,16r51fa,16r6a71,16r53a8,16r8e87,16r9504,16r96cf,
16r6ec1,16r9664,16r695a,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r7840,16r50a8,16r77d7,16r6410,16r89e6,16r5904,16r63e3,
16r5ddd,16r7a7f,16r693d,16r4f20,16r8239,16r5598,16r4e32,16r75ae,
16r7a97,16r5e62,16r5e8a,16r95ef,16r521b,16r5439,16r708a,16r6376,
16r9524,16r5782,16r6625,16r693f,16r9187,16r5507,16r6df3,16r7eaf,
16r8822,16r6233,16r7ef0,16r75b5,16r8328,16r78c1,16r96cc,16r8f9e,
16r6148,16r74f7,16r8bcd,16r6b64,16r523a,16r8d50,16r6b21,16r806a,
16r8471,16r56f1,16r5306,16r4ece,16r4e1b,16r51d1,16r7c97,16r918b,
16r7c07,16r4fc3,16r8e7f,16r7be1,16r7a9c,16r6467,16r5d14,16r50ac,
16r8106,16r7601,16r7cb9,16r6dec,16r7fe0,16r6751,16r5b58,16r5bf8,
16r78cb,16r64ae,16r6413,16r63aa,16r632b,16r9519,16r642d,16r8fbe,
16r7b54,16r7629,16r6253,16r5927,16r5446,16r6b79,16r50a3,16r6234,
16r5e26,16r6b86,16r4ee3,16r8d37,16r888b,16r5f85,16r902e,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r6020,16r803d,16r62c5,
16r4e39,16r5355,16r90f8,16r63b8,16r80c6,16r65e6,16r6c2e,16r4f46,
16r60ee,16r6de1,16r8bde,16r5f39,16r86cb,16r5f53,16r6321,16r515a,
16r8361,16r6863,16r5200,16r6363,16r8e48,16r5012,16r5c9b,16r7977,
16r5bfc,16r5230,16r7a3b,16r60bc,16r9053,16r76d7,16r5fb7,16r5f97,
16r7684,16r8e6c,16r706f,16r767b,16r7b49,16r77aa,16r51f3,16r9093,
16r5824,16r4f4e,16r6ef4,16r8fea,16r654c,16r7b1b,16r72c4,16r6da4,
16r7fdf,16r5ae1,16r62b5,16r5e95,16r5730,16r8482,16r7b2c,16r5e1d,
16r5f1f,16r9012,16r7f14,16r98a0,16r6382,16r6ec7,16r7898,16r70b9,
16r5178,16r975b,16r57ab,16r7535,16r4f43,16r7538,16r5e97,16r60e6,
16r5960,16r6dc0,16r6bbf,16r7889,16r53fc,16r96d5,16r51cb,16r5201,
16r6389,16r540a,16r9493,16r8c03,16r8dcc,16r7239,16r789f,16r8776,
16r8fed,16r8c0d,16r53e0,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r4e01,16r76ef,16r53ee,16r9489,16r9876,16r9f0e,16r952d,
16r5b9a,16r8ba2,16r4e22,16r4e1c,16r51ac,16r8463,16r61c2,16r52a8,
16r680b,16r4f97,16r606b,16r51bb,16r6d1e,16r515c,16r6296,16r6597,
16r9661,16r8c46,16r9017,16r75d8,16r90fd,16r7763,16r6bd2,16r728a,
16r72ec,16r8bfb,16r5835,16r7779,16r8d4c,16r675c,16r9540,16r809a,
16r5ea6,16r6e21,16r5992,16r7aef,16r77ed,16r953b,16r6bb5,16r65ad,
16r7f0e,16r5806,16r5151,16r961f,16r5bf9,16r58a9,16r5428,16r8e72,
16r6566,16r987f,16r56e4,16r949d,16r76fe,16r9041,16r6387,16r54c6,
16r591a,16r593a,16r579b,16r8eb2,16r6735,16r8dfa,16r8235,16r5241,
16r60f0,16r5815,16r86fe,16r5ce8,16r9e45,16r4fc4,16r989d,16r8bb9,
16r5a25,16r6076,16r5384,16r627c,16r904f,16r9102,16r997f,16r6069,
16r800c,16r513f,16r8033,16r5c14,16r9975,16r6d31,16r4e8c,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r8d30,16r53d1,16r7f5a,
16r7b4f,16r4f10,16r4e4f,16r9600,16r6cd5,16r73d0,16r85e9,16r5e06,
16r756a,16r7ffb,16r6a0a,16r77fe,16r9492,16r7e41,16r51e1,16r70e6,
16r53cd,16r8fd4,16r8303,16r8d29,16r72af,16r996d,16r6cdb,16r574a,
16r82b3,16r65b9,16r80aa,16r623f,16r9632,16r59a8,16r4eff,16r8bbf,
16r7eba,16r653e,16r83f2,16r975e,16r5561,16r98de,16r80a5,16r532a,
16r8bfd,16r5420,16r80ba,16r5e9f,16r6cb8,16r8d39,16r82ac,16r915a,
16r5429,16r6c1b,16r5206,16r7eb7,16r575f,16r711a,16r6c7e,16r7c89,
16r594b,16r4efd,16r5fff,16r6124,16r7caa,16r4e30,16r5c01,16r67ab,
16r8702,16r5cf0,16r950b,16r98ce,16r75af,16r70fd,16r9022,16r51af,
16r7f1d,16r8bbd,16r5949,16r51e4,16r4f5b,16r5426,16r592b,16r6577,
16r80a4,16r5b75,16r6276,16r62c2,16r8f90,16r5e45,16r6c1f,16r7b26,
16r4f0f,16r4fd8,16r670d,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r6d6e,16r6daa,16r798f,16r88b1,16r5f17,16r752b,16r629a,
16r8f85,16r4fef,16r91dc,16r65a7,16r812f,16r8151,16r5e9c,16r8150,
16r8d74,16r526f,16r8986,16r8d4b,16r590d,16r5085,16r4ed8,16r961c,
16r7236,16r8179,16r8d1f,16r5bcc,16r8ba3,16r9644,16r5987,16r7f1a,
16r5490,16r5676,16r560e,16r8be5,16r6539,16r6982,16r9499,16r76d6,
16r6e89,16r5e72,16r7518,16r6746,16r67d1,16r7aff,16r809d,16r8d76,
16r611f,16r79c6,16r6562,16r8d63,16r5188,16r521a,16r94a2,16r7f38,
16r809b,16r7eb2,16r5c97,16r6e2f,16r6760,16r7bd9,16r768b,16r9ad8,
16r818f,16r7f94,16r7cd5,16r641e,16r9550,16r7a3f,16r544a,16r54e5,
16r6b4c,16r6401,16r6208,16r9e3d,16r80f3,16r7599,16r5272,16r9769,
16r845b,16r683c,16r86e4,16r9601,16r9694,16r94ec,16r4e2a,16r5404,
16r7ed9,16r6839,16r8ddf,16r8015,16r66f4,16r5e9a,16r7fb9,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r57c2,16r803f,16r6897,
16r5de5,16r653b,16r529f,16r606d,16r9f9a,16r4f9b,16r8eac,16r516c,
16r5bab,16r5f13,16r5de9,16r6c5e,16r62f1,16r8d21,16r5171,16r94a9,
16r52fe,16r6c9f,16r82df,16r72d7,16r57a2,16r6784,16r8d2d,16r591f,
16r8f9c,16r83c7,16r5495,16r7b8d,16r4f30,16r6cbd,16r5b64,16r59d1,
16r9f13,16r53e4,16r86ca,16r9aa8,16r8c37,16r80a1,16r6545,16r987e,
16r56fa,16r96c7,16r522e,16r74dc,16r5250,16r5be1,16r6302,16r8902,
16r4e56,16r62d0,16r602a,16r68fa,16r5173,16r5b98,16r51a0,16r89c2,
16r7ba1,16r9986,16r7f50,16r60ef,16r704c,16r8d2f,16r5149,16r5e7f,
16r901b,16r7470,16r89c4,16r572d,16r7845,16r5f52,16r9f9f,16r95fa,
16r8f68,16r9b3c,16r8be1,16r7678,16r6842,16r67dc,16r8dea,16r8d35,
16r523d,16r8f8a,16r6eda,16r68cd,16r9505,16r90ed,16r56fd,16r679c,
16r88f9,16r8fc7,16r54c8,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r9ab8,16r5b69,16r6d77,16r6c26,16r4ea5,16r5bb3,16r9a87,
16r9163,16r61a8,16r90af,16r97e9,16r542b,16r6db5,16r5bd2,16r51fd,
16r558a,16r7f55,16r7ff0,16r64bc,16r634d,16r65f1,16r61be,16r608d,
16r710a,16r6c57,16r6c49,16r592f,16r676d,16r822a,16r58d5,16r568e,
16r8c6a,16r6beb,16r90dd,16r597d,16r8017,16r53f7,16r6d69,16r5475,
16r559d,16r8377,16r83cf,16r6838,16r79be,16r548c,16r4f55,16r5408,
16r76d2,16r8c89,16r9602,16r6cb3,16r6db8,16r8d6b,16r8910,16r9e64,
16r8d3a,16r563f,16r9ed1,16r75d5,16r5f88,16r72e0,16r6068,16r54fc,
16r4ea8,16r6a2a,16r8861,16r6052,16r8f70,16r54c4,16r70d8,16r8679,
16r9e3f,16r6d2a,16r5b8f,16r5f18,16r7ea2,16r5589,16r4faf,16r7334,
16r543c,16r539a,16r5019,16r540e,16r547c,16r4e4e,16r5ffd,16r745a,
16r58f6,16r846b,16r80e1,16r8774,16r72d0,16r7cca,16r6e56,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r5f27,16r864e,16r552c,
16r62a4,16r4e92,16r6caa,16r6237,16r82b1,16r54d7,16r534e,16r733e,
16r6ed1,16r753b,16r5212,16r5316,16r8bdd,16r69d0,16r5f8a,16r6000,
16r6dee,16r574f,16r6b22,16r73af,16r6853,16r8fd8,16r7f13,16r6362,
16r60a3,16r5524,16r75ea,16r8c62,16r7115,16r6da3,16r5ba6,16r5e7b,
16r8352,16r614c,16r9ec4,16r78fa,16r8757,16r7c27,16r7687,16r51f0,
16r60f6,16r714c,16r6643,16r5e4c,16r604d,16r8c0e,16r7070,16r6325,
16r8f89,16r5fbd,16r6062,16r86d4,16r56de,16r6bc1,16r6094,16r6167,
16r5349,16r60e0,16r6666,16r8d3f,16r79fd,16r4f1a,16r70e9,16r6c47,
16r8bb3,16r8bf2,16r7ed8,16r8364,16r660f,16r5a5a,16r9b42,16r6d51,
16r6df7,16r8c41,16r6d3b,16r4f19,16r706b,16r83b7,16r6216,16r60d1,
16r970d,16r8d27,16r7978,16r51fb,16r573e,16r57fa,16r673a,16r7578,
16r7a3d,16r79ef,16r7b95,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r808c,16r9965,16r8ff9,16r6fc0,16r8ba5,16r9e21,16r59ec,
16r7ee9,16r7f09,16r5409,16r6781,16r68d8,16r8f91,16r7c4d,16r96c6,
16r53ca,16r6025,16r75be,16r6c72,16r5373,16r5ac9,16r7ea7,16r6324,
16r51e0,16r810a,16r5df1,16r84df,16r6280,16r5180,16r5b63,16r4f0e,
16r796d,16r5242,16r60b8,16r6d4e,16r5bc4,16r5bc2,16r8ba1,16r8bb0,
16r65e2,16r5fcc,16r9645,16r5993,16r7ee7,16r7eaa,16r5609,16r67b7,
16r5939,16r4f73,16r5bb6,16r52a0,16r835a,16r988a,16r8d3e,16r7532,
16r94be,16r5047,16r7a3c,16r4ef7,16r67b6,16r9a7e,16r5ac1,16r6b7c,
16r76d1,16r575a,16r5c16,16r7b3a,16r95f4,16r714e,16r517c,16r80a9,
16r8270,16r5978,16r7f04,16r8327,16r68c0,16r67ec,16r78b1,16r7877,
16r62e3,16r6361,16r7b80,16r4fed,16r526a,16r51cf,16r8350,16r69db,
16r9274,16r8df5,16r8d31,16r89c1,16r952e,16r7bad,16r4ef6,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r5065,16r8230,16r5251,
16r996f,16r6e10,16r6e85,16r6da7,16r5efa,16r50f5,16r59dc,16r5c06,
16r6d46,16r6c5f,16r7586,16r848b,16r6868,16r5956,16r8bb2,16r5320,
16r9171,16r964d,16r8549,16r6912,16r7901,16r7126,16r80f6,16r4ea4,
16r90ca,16r6d47,16r9a84,16r5a07,16r56bc,16r6405,16r94f0,16r77eb,
16r4fa5,16r811a,16r72e1,16r89d2,16r997a,16r7f34,16r7ede,16r527f,
16r6559,16r9175,16r8f7f,16r8f83,16r53eb,16r7a96,16r63ed,16r63a5,
16r7686,16r79f8,16r8857,16r9636,16r622a,16r52ab,16r8282,16r6854,
16r6770,16r6377,16r776b,16r7aed,16r6d01,16r7ed3,16r89e3,16r59d0,
16r6212,16r85c9,16r82a5,16r754c,16r501f,16r4ecb,16r75a5,16r8beb,
16r5c4a,16r5dfe,16r7b4b,16r65a4,16r91d1,16r4eca,16r6d25,16r895f,
16r7d27,16r9526,16r4ec5,16r8c28,16r8fdb,16r9773,16r664b,16r7981,
16r8fd1,16r70ec,16r6d78,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r5c3d,16r52b2,16r8346,16r5162,16r830e,16r775b,16r6676,
16r9cb8,16r4eac,16r60ca,16r7cbe,16r7cb3,16r7ecf,16r4e95,16r8b66,
16r666f,16r9888,16r9759,16r5883,16r656c,16r955c,16r5f84,16r75c9,
16r9756,16r7adf,16r7ade,16r51c0,16r70af,16r7a98,16r63ea,16r7a76,
16r7ea0,16r7396,16r97ed,16r4e45,16r7078,16r4e5d,16r9152,16r53a9,
16r6551,16r65e7,16r81fc,16r8205,16r548e,16r5c31,16r759a,16r97a0,
16r62d8,16r72d9,16r75bd,16r5c45,16r9a79,16r83ca,16r5c40,16r5480,
16r77e9,16r4e3e,16r6cae,16r805a,16r62d2,16r636e,16r5de8,16r5177,
16r8ddd,16r8e1e,16r952f,16r4ff1,16r53e5,16r60e7,16r70ac,16r5267,
16r6350,16r9e43,16r5a1f,16r5026,16r7737,16r5377,16r7ee2,16r6485,
16r652b,16r6289,16r6398,16r5014,16r7235,16r89c9,16r51b3,16r8bc0,
16r7edd,16r5747,16r83cc,16r94a7,16r519b,16r541b,16r5cfb,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r4fca,16r7ae3,16r6d5a,
16r90e1,16r9a8f,16r5580,16r5496,16r5361,16r54af,16r5f00,16r63e9,
16r6977,16r51ef,16r6168,16r520a,16r582a,16r52d8,16r574e,16r780d,
16r770b,16r5eb7,16r6177,16r7ce0,16r625b,16r6297,16r4ea2,16r7095,
16r8003,16r62f7,16r70e4,16r9760,16r5777,16r82db,16r67ef,16r68f5,
16r78d5,16r9897,16r79d1,16r58f3,16r54b3,16r53ef,16r6e34,16r514b,
16r523b,16r5ba2,16r8bfe,16r80af,16r5543,16r57a6,16r6073,16r5751,
16r542d,16r7a7a,16r6050,16r5b54,16r63a7,16r62a0,16r53e3,16r6263,
16r5bc7,16r67af,16r54ed,16r7a9f,16r82e6,16r9177,16r5e93,16r88e4,
16r5938,16r57ae,16r630e,16r8de8,16r80ef,16r5757,16r7b77,16r4fa9,
16r5feb,16r5bbd,16r6b3e,16r5321,16r7b50,16r72c2,16r6846,16r77ff,
16r7736,16r65f7,16r51b5,16r4e8f,16r76d4,16r5cbf,16r7aa5,16r8475,
16r594e,16r9b41,16r5080,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r9988,16r6127,16r6e83,16r5764,16r6606,16r6346,16r56f0,
16r62ec,16r6269,16r5ed3,16r9614,16r5783,16r62c9,16r5587,16r8721,
16r814a,16r8fa3,16r5566,16r83b1,16r6765,16r8d56,16r84dd,16r5a6a,
16r680f,16r62e6,16r7bee,16r9611,16r5170,16r6f9c,16r8c30,16r63fd,
16r89c8,16r61d2,16r7f06,16r70c2,16r6ee5,16r7405,16r6994,16r72fc,
16r5eca,16r90ce,16r6717,16r6d6a,16r635e,16r52b3,16r7262,16r8001,
16r4f6c,16r59e5,16r916a,16r70d9,16r6d9d,16r52d2,16r4e50,16r96f7,
16r956d,16r857e,16r78ca,16r7d2f,16r5121,16r5792,16r64c2,16r808b,
16r7c7b,16r6cea,16r68f1,16r695e,16r51b7,16r5398,16r68a8,16r7281,
16r9ece,16r7bf1,16r72f8,16r79bb,16r6f13,16r7406,16r674e,16r91cc,
16r9ca4,16r793c,16r8389,16r8354,16r540f,16r6817,16r4e3d,16r5389,
16r52b1,16r783e,16r5386,16r5229,16r5088,16r4f8b,16r4fd0,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r75e2,16r7acb,16r7c92,
16r6ca5,16r96b6,16r529b,16r7483,16r54e9,16r4fe9,16r8054,16r83b2,
16r8fde,16r9570,16r5ec9,16r601c,16r6d9f,16r5e18,16r655b,16r8138,
16r94fe,16r604b,16r70bc,16r7ec3,16r7cae,16r51c9,16r6881,16r7cb1,
16r826f,16r4e24,16r8f86,16r91cf,16r667e,16r4eae,16r8c05,16r64a9,
16r804a,16r50da,16r7597,16r71ce,16r5be5,16r8fbd,16r6f66,16r4e86,
16r6482,16r9563,16r5ed6,16r6599,16r5217,16r88c2,16r70c8,16r52a3,
16r730e,16r7433,16r6797,16r78f7,16r9716,16r4e34,16r90bb,16r9cde,
16r6dcb,16r51db,16r8d41,16r541d,16r62ce,16r73b2,16r83f1,16r96f6,
16r9f84,16r94c3,16r4f36,16r7f9a,16r51cc,16r7075,16r9675,16r5cad,
16r9886,16r53e6,16r4ee4,16r6e9c,16r7409,16r69b4,16r786b,16r998f,
16r7559,16r5218,16r7624,16r6d41,16r67f3,16r516d,16r9f99,16r804b,
16r5499,16r7b3c,16r7abf,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r9686,16r5784,16r62e2,16r9647,16r697c,16r5a04,16r6402,
16r7bd3,16r6f0f,16r964b,16r82a6,16r5362,16r9885,16r5e90,16r7089,
16r63b3,16r5364,16r864f,16r9c81,16r9e93,16r788c,16r9732,16r8def,
16r8d42,16r9e7f,16r6f5e,16r7984,16r5f55,16r9646,16r622e,16r9a74,
16r5415,16r94dd,16r4fa3,16r65c5,16r5c65,16r5c61,16r7f15,16r8651,
16r6c2f,16r5f8b,16r7387,16r6ee4,16r7eff,16r5ce6,16r631b,16r5b6a,
16r6ee6,16r5375,16r4e71,16r63a0,16r7565,16r62a1,16r8f6e,16r4f26,
16r4ed1,16r6ca6,16r7eb6,16r8bba,16r841d,16r87ba,16r7f57,16r903b,
16r9523,16r7ba9,16r9aa1,16r88f8,16r843d,16r6d1b,16r9a86,16r7edc,
16r5988,16r9ebb,16r739b,16r7801,16r8682,16r9a6c,16r9a82,16r561b,
16r5417,16r57cb,16r4e70,16r9ea6,16r5356,16r8fc8,16r8109,16r7792,
16r9992,16r86ee,16r6ee1,16r8513,16r66fc,16r6162,16r6f2b,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r8c29,16r8292,16r832b,
16r76f2,16r6c13,16r5fd9,16r83bd,16r732b,16r8305,16r951a,16r6bdb,
16r77db,16r94c6,16r536f,16r8302,16r5192,16r5e3d,16r8c8c,16r8d38,
16r4e48,16r73ab,16r679a,16r6885,16r9176,16r9709,16r7164,16r6ca1,
16r7709,16r5a92,16r9541,16r6bcf,16r7f8e,16r6627,16r5bd0,16r59b9,
16r5a9a,16r95e8,16r95f7,16r4eec,16r840c,16r8499,16r6aac,16r76df,
16r9530,16r731b,16r68a6,16r5b5f,16r772f,16r919a,16r9761,16r7cdc,
16r8ff7,16r8c1c,16r5f25,16r7c73,16r79d8,16r89c5,16r6ccc,16r871c,
16r5bc6,16r5e42,16r68c9,16r7720,16r7ef5,16r5195,16r514d,16r52c9,
16r5a29,16r7f05,16r9762,16r82d7,16r63cf,16r7784,16r85d0,16r79d2,
16r6e3a,16r5e99,16r5999,16r8511,16r706d,16r6c11,16r62bf,16r76bf,
16r654f,16r60af,16r95fd,16r660e,16r879f,16r9e23,16r94ed,16r540d,
16r547d,16r8c2c,16r6478,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r6479,16r8611,16r6a21,16r819c,16r78e8,16r6469,16r9b54,
16r62b9,16r672b,16r83ab,16r58a8,16r9ed8,16r6cab,16r6f20,16r5bde,
16r964c,16r8c0b,16r725f,16r67d0,16r62c7,16r7261,16r4ea9,16r59c6,
16r6bcd,16r5893,16r66ae,16r5e55,16r52df,16r6155,16r6728,16r76ee,
16r7766,16r7267,16r7a46,16r62ff,16r54ea,16r5450,16r94a0,16r90a3,
16r5a1c,16r7eb3,16r6c16,16r4e43,16r5976,16r8010,16r5948,16r5357,
16r7537,16r96be,16r56ca,16r6320,16r8111,16r607c,16r95f9,16r6dd6,
16r5462,16r9981,16r5185,16r5ae9,16r80fd,16r59ae,16r9713,16r502a,
16r6ce5,16r5c3c,16r62df,16r4f60,16r533f,16r817b,16r9006,16r6eba,
16r852b,16r62c8,16r5e74,16r78be,16r64b5,16r637b,16r5ff5,16r5a18,
16r917f,16r9e1f,16r5c3f,16r634f,16r8042,16r5b7d,16r556e,16r954a,
16r954d,16r6d85,16r60a8,16r67e0,16r72de,16r51dd,16r5b81,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r62e7,16r6cde,16r725b,
16r626d,16r94ae,16r7ebd,16r8113,16r6d53,16r519c,16r5f04,16r5974,
16r52aa,16r6012,16r5973,16r6696,16r8650,16r759f,16r632a,16r61e6,
16r7cef,16r8bfa,16r54e6,16r6b27,16r9e25,16r6bb4,16r85d5,16r5455,
16r5076,16r6ca4,16r556a,16r8db4,16r722c,16r5e15,16r6015,16r7436,
16r62cd,16r6392,16r724c,16r5f98,16r6e43,16r6d3e,16r6500,16r6f58,
16r76d8,16r78d0,16r76fc,16r7554,16r5224,16r53db,16r4e53,16r5e9e,
16r65c1,16r802a,16r80d6,16r629b,16r5486,16r5228,16r70ae,16r888d,
16r8dd1,16r6ce1,16r5478,16r80da,16r57f9,16r88f4,16r8d54,16r966a,
16r914d,16r4f69,16r6c9b,16r55b7,16r76c6,16r7830,16r62a8,16r70f9,
16r6f8e,16r5f6d,16r84ec,16r68da,16r787c,16r7bf7,16r81a8,16r670b,
16r9e4f,16r6367,16r78b0,16r576f,16r7812,16r9739,16r6279,16r62ab,
16r5288,16r7435,16r6bd7,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r5564,16r813e,16r75b2,16r76ae,16r5339,16r75de,16r50fb,
16r5c41,16r8b6c,16r7bc7,16r504f,16r7247,16r9a97,16r98d8,16r6f02,
16r74e2,16r7968,16r6487,16r77a5,16r62fc,16r9891,16r8d2b,16r54c1,
16r8058,16r4e52,16r576a,16r82f9,16r840d,16r5e73,16r51ed,16r74f6,
16r8bc4,16r5c4f,16r5761,16r6cfc,16r9887,16r5a46,16r7834,16r9b44,
16r8feb,16r7c95,16r5256,16r6251,16r94fa,16r4ec6,16r8386,16r8461,
16r83e9,16r84b2,16r57d4,16r6734,16r5703,16r666e,16r6d66,16r8c31,
16r66dd,16r7011,16r671f,16r6b3a,16r6816,16r621a,16r59bb,16r4e03,
16r51c4,16r6f06,16r67d2,16r6c8f,16r5176,16r68cb,16r5947,16r6b67,
16r7566,16r5d0e,16r8110,16r9f50,16r65d7,16r7948,16r7941,16r9a91,
16r8d77,16r5c82,16r4e5e,16r4f01,16r542f,16r5951,16r780c,16r5668,
16r6c14,16r8fc4,16r5f03,16r6c7d,16r6ce3,16r8bab,16r6390,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r6070,16r6d3d,16r7275,
16r6266,16r948e,16r94c5,16r5343,16r8fc1,16r7b7e,16r4edf,16r8c26,
16r4e7e,16r9ed4,16r94b1,16r94b3,16r524d,16r6f5c,16r9063,16r6d45,
16r8c34,16r5811,16r5d4c,16r6b20,16r6b49,16r67aa,16r545b,16r8154,
16r7f8c,16r5899,16r8537,16r5f3a,16r62a2,16r6a47,16r9539,16r6572,
16r6084,16r6865,16r77a7,16r4e54,16r4fa8,16r5de7,16r9798,16r64ac,
16r7fd8,16r5ced,16r4fcf,16r7a8d,16r5207,16r8304,16r4e14,16r602f,
16r7a83,16r94a6,16r4fb5,16r4eb2,16r79e6,16r7434,16r52e4,16r82b9,
16r64d2,16r79bd,16r5bdd,16r6c81,16r9752,16r8f7b,16r6c22,16r503e,
16r537f,16r6e05,16r64ce,16r6674,16r6c30,16r60c5,16r9877,16r8bf7,
16r5e86,16r743c,16r7a77,16r79cb,16r4e18,16r90b1,16r7403,16r6c42,
16r56da,16r914b,16r6cc5,16r8d8b,16r533a,16r86c6,16r66f2,16r8eaf,
16r5c48,16r9a71,16r6e20,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r53d6,16r5a36,16r9f8b,16r8da3,16r53bb,16r5708,16r98a7,
16r6743,16r919b,16r6cc9,16r5168,16r75ca,16r62f3,16r72ac,16r5238,
16r529d,16r7f3a,16r7094,16r7638,16r5374,16r9e4a,16r69b7,16r786e,
16r96c0,16r88d9,16r7fa4,16r7136,16r71c3,16r5189,16r67d3,16r74e4,
16r58e4,16r6518,16r56b7,16r8ba9,16r9976,16r6270,16r7ed5,16r60f9,
16r70ed,16r58ec,16r4ec1,16r4eba,16r5fcd,16r97e7,16r4efb,16r8ba4,
16r5203,16r598a,16r7eab,16r6254,16r4ecd,16r65e5,16r620e,16r8338,
16r84c9,16r8363,16r878d,16r7194,16r6eb6,16r5bb9,16r7ed2,16r5197,
16r63c9,16r67d4,16r8089,16r8339,16r8815,16r5112,16r5b7a,16r5982,
16r8fb1,16r4e73,16r6c5d,16r5165,16r8925,16r8f6f,16r962e,16r854a,
16r745e,16r9510,16r95f0,16r6da6,16r82e5,16r5f31,16r6492,16r6d12,
16r8428,16r816e,16r9cc3,16r585e,16r8d5b,16r4e09,16r53c1,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r4f1e,16r6563,16r6851,
16r55d3,16r4e27,16r6414,16r9a9a,16r626b,16r5ac2,16r745f,16r8272,
16r6da9,16r68ee,16r50e7,16r838e,16r7802,16r6740,16r5239,16r6c99,
16r7eb1,16r50bb,16r5565,16r715e,16r7b5b,16r6652,16r73ca,16r82eb,
16r6749,16r5c71,16r5220,16r717d,16r886b,16r95ea,16r9655,16r64c5,
16r8d61,16r81b3,16r5584,16r6c55,16r6247,16r7f2e,16r5892,16r4f24,
16r5546,16r8d4f,16r664c,16r4e0a,16r5c1a,16r88f3,16r68a2,16r634e,
16r7a0d,16r70e7,16r828d,16r52fa,16r97f6,16r5c11,16r54e8,16r90b5,
16r7ecd,16r5962,16r8d4a,16r86c7,16r820c,16r820d,16r8d66,16r6444,
16r5c04,16r6151,16r6d89,16r793e,16r8bbe,16r7837,16r7533,16r547b,
16r4f38,16r8eab,16r6df1,16r5a20,16r7ec5,16r795e,16r6c88,16r5ba1,
16r5a76,16r751a,16r80be,16r614e,16r6e17,16r58f0,16r751f,16r7525,
16r7272,16r5347,16r7ef3,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r7701,16r76db,16r5269,16r80dc,16r5723,16r5e08,16r5931,
16r72ee,16r65bd,16r6e7f,16r8bd7,16r5c38,16r8671,16r5341,16r77f3,
16r62fe,16r65f6,16r4ec0,16r98df,16r8680,16r5b9e,16r8bc6,16r53f2,
16r77e2,16r4f7f,16r5c4e,16r9a76,16r59cb,16r5f0f,16r793a,16r58eb,
16r4e16,16r67ff,16r4e8b,16r62ed,16r8a93,16r901d,16r52bf,16r662f,
16r55dc,16r566c,16r9002,16r4ed5,16r4f8d,16r91ca,16r9970,16r6c0f,
16r5e02,16r6043,16r5ba4,16r89c6,16r8bd5,16r6536,16r624b,16r9996,
16r5b88,16r5bff,16r6388,16r552e,16r53d7,16r7626,16r517d,16r852c,
16r67a2,16r68b3,16r6b8a,16r6292,16r8f93,16r53d4,16r8212,16r6dd1,
16r758f,16r4e66,16r8d4e,16r5b70,16r719f,16r85af,16r6691,16r66d9,
16r7f72,16r8700,16r9ecd,16r9f20,16r5c5e,16r672f,16r8ff0,16r6811,
16r675f,16r620d,16r7ad6,16r5885,16r5eb6,16r6570,16r6f31,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r6055,16r5237,16r800d,
16r6454,16r8870,16r7529,16r5e05,16r6813,16r62f4,16r971c,16r53cc,
16r723d,16r8c01,16r6c34,16r7761,16r7a0e,16r542e,16r77ac,16r987a,
16r821c,16r8bf4,16r7855,16r6714,16r70c1,16r65af,16r6495,16r5636,
16r601d,16r79c1,16r53f8,16r4e1d,16r6b7b,16r8086,16r5bfa,16r55e3,
16r56db,16r4f3a,16r4f3c,16r9972,16r5df3,16r677e,16r8038,16r6002,
16r9882,16r9001,16r5b8b,16r8bbc,16r8bf5,16r641c,16r8258,16r64de,
16r55fd,16r82cf,16r9165,16r4fd7,16r7d20,16r901f,16r7c9f,16r50f3,
16r5851,16r6eaf,16r5bbf,16r8bc9,16r8083,16r9178,16r849c,16r7b97,
16r867d,16r968b,16r968f,16r7ee5,16r9ad3,16r788e,16r5c81,16r7a57,
16r9042,16r96a7,16r795f,16r5b59,16r635f,16r7b0b,16r84d1,16r68ad,
16r5506,16r7f29,16r7410,16r7d22,16r9501,16r6240,16r584c,16r4ed6,
16r5b83,16r5979,16r5854,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r736d,16r631e,16r8e4b,16r8e0f,16r80ce,16r82d4,16r62ac,
16r53f0,16r6cf0,16r915e,16r592a,16r6001,16r6c70,16r574d,16r644a,
16r8d2a,16r762b,16r6ee9,16r575b,16r6a80,16r75f0,16r6f6d,16r8c2d,
16r8c08,16r5766,16r6bef,16r8892,16r78b3,16r63a2,16r53f9,16r70ad,
16r6c64,16r5858,16r642a,16r5802,16r68e0,16r819b,16r5510,16r7cd6,
16r5018,16r8eba,16r6dcc,16r8d9f,16r70eb,16r638f,16r6d9b,16r6ed4,
16r7ee6,16r8404,16r6843,16r9003,16r6dd8,16r9676,16r8ba8,16r5957,
16r7279,16r85e4,16r817e,16r75bc,16r8a8a,16r68af,16r5254,16r8e22,
16r9511,16r63d0,16r9898,16r8e44,16r557c,16r4f53,16r66ff,16r568f,
16r60d5,16r6d95,16r5243,16r5c49,16r5929,16r6dfb,16r586b,16r7530,
16r751c,16r606c,16r8214,16r8146,16r6311,16r6761,16r8fe2,16r773a,
16r8df3,16r8d34,16r94c1,16r5e16,16r5385,16r542c,16r70c3,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r6c40,16r5ef7,16r505c,
16r4ead,16r5ead,16r633a,16r8247,16r901a,16r6850,16r916e,16r77b3,
16r540c,16r94dc,16r5f64,16r7ae5,16r6876,16r6345,16r7b52,16r7edf,
16r75db,16r5077,16r6295,16r5934,16r900f,16r51f8,16r79c3,16r7a81,
16r56fe,16r5f92,16r9014,16r6d82,16r5c60,16r571f,16r5410,16r5154,
16r6e4d,16r56e2,16r63a8,16r9893,16r817f,16r8715,16r892a,16r9000,
16r541e,16r5c6f,16r81c0,16r62d6,16r6258,16r8131,16r9e35,16r9640,
16r9a6e,16r9a7c,16r692d,16r59a5,16r62d3,16r553e,16r6316,16r54c7,
16r86d9,16r6d3c,16r5a03,16r74e6,16r889c,16r6b6a,16r5916,16r8c4c,
16r5f2f,16r6e7e,16r73a9,16r987d,16r4e38,16r70f7,16r5b8c,16r7897,
16r633d,16r665a,16r7696,16r60cb,16r5b9b,16r5a49,16r4e07,16r8155,
16r6c6a,16r738b,16r4ea1,16r6789,16r7f51,16r5f80,16r65fa,16r671b,
16r5fd8,16r5984,16r5a01,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r5dcd,16r5fae,16r5371,16r97e6,16r8fdd,16r6845,16r56f4,
16r552f,16r60df,16r4e3a,16r6f4d,16r7ef4,16r82c7,16r840e,16r59d4,
16r4f1f,16r4f2a,16r5c3e,16r7eac,16r672a,16r851a,16r5473,16r754f,
16r80c3,16r5582,16r9b4f,16r4f4d,16r6e2d,16r8c13,16r5c09,16r6170,
16r536b,16r761f,16r6e29,16r868a,16r6587,16r95fb,16r7eb9,16r543b,
16r7a33,16r7d0a,16r95ee,16r55e1,16r7fc1,16r74ee,16r631d,16r8717,
16r6da1,16r7a9d,16r6211,16r65a1,16r5367,16r63e1,16r6c83,16r5deb,
16r545c,16r94a8,16r4e4c,16r6c61,16r8bec,16r5c4b,16r65e0,16r829c,
16r68a7,16r543e,16r5434,16r6bcb,16r6b66,16r4e94,16r6342,16r5348,
16r821e,16r4f0d,16r4fae,16r575e,16r620a,16r96fe,16r6664,16r7269,
16r52ff,16r52a1,16r609f,16r8bef,16r6614,16r7199,16r6790,16r897f,
16r7852,16r77fd,16r6670,16r563b,16r5438,16r9521,16r727a,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r7a00,16r606f,16r5e0c,
16r6089,16r819d,16r5915,16r60dc,16r7184,16r70ef,16r6eaa,16r6c50,
16r7280,16r6a84,16r88ad,16r5e2d,16r4e60,16r5ab3,16r559c,16r94e3,
16r6d17,16r7cfb,16r9699,16r620f,16r7ec6,16r778e,16r867e,16r5323,
16r971e,16r8f96,16r6687,16r5ce1,16r4fa0,16r72ed,16r4e0b,16r53a6,
16r590f,16r5413,16r6380,16r9528,16r5148,16r4ed9,16r9c9c,16r7ea4,
16r54b8,16r8d24,16r8854,16r8237,16r95f2,16r6d8e,16r5f26,16r5acc,
16r663e,16r9669,16r73b0,16r732e,16r53bf,16r817a,16r9985,16r7fa1,
16r5baa,16r9677,16r9650,16r7ebf,16r76f8,16r53a2,16r9576,16r9999,
16r7bb1,16r8944,16r6e58,16r4e61,16r7fd4,16r7965,16r8be6,16r60f3,
16r54cd,16r4eab,16r9879,16r5df7,16r6a61,16r50cf,16r5411,16r8c61,
16r8427,16r785d,16r9704,16r524a,16r54ee,16r56a3,16r9500,16r6d88,
16r5bb5,16r6dc6,16r6653,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r5c0f,16r5b5d,16r6821,16r8096,16r5578,16r7b11,16r6548,
16r6954,16r4e9b,16r6b47,16r874e,16r978b,16r534f,16r631f,16r643a,
16r90aa,16r659c,16r80c1,16r8c10,16r5199,16r68b0,16r5378,16r87f9,
16r61c8,16r6cc4,16r6cfb,16r8c22,16r5c51,16r85aa,16r82af,16r950c,
16r6b23,16r8f9b,16r65b0,16r5ffb,16r5fc3,16r4fe1,16r8845,16r661f,
16r8165,16r7329,16r60fa,16r5174,16r5211,16r578b,16r5f62,16r90a2,
16r884c,16r9192,16r5e78,16r674f,16r6027,16r59d3,16r5144,16r51f6,
16r80f8,16r5308,16r6c79,16r96c4,16r718a,16r4f11,16r4fee,16r7f9e,
16r673d,16r55c5,16r9508,16r79c0,16r8896,16r7ee3,16r589f,16r620c,
16r9700,16r865a,16r5618,16r987b,16r5f90,16r8bb8,16r84c4,16r9157,
16r53d9,16r65ed,16r5e8f,16r755c,16r6064,16r7d6e,16r5a7f,16r7eea,
16r7eed,16r8f69,16r55a7,16r5ba3,16r60ac,16r65cb,16r7384,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r9009,16r7663,16r7729,
16r7eda,16r9774,16r859b,16r5b66,16r7a74,16r96ea,16r8840,16r52cb,
16r718f,16r5faa,16r65ec,16r8be2,16r5bfb,16r9a6f,16r5de1,16r6b89,
16r6c5b,16r8bad,16r8baf,16r900a,16r8fc5,16r538b,16r62bc,16r9e26,
16r9e2d,16r5440,16r4e2b,16r82bd,16r7259,16r869c,16r5d16,16r8859,
16r6daf,16r96c5,16r54d1,16r4e9a,16r8bb6,16r7109,16r54bd,16r9609,
16r70df,16r6df9,16r76d0,16r4e25,16r7814,16r8712,16r5ca9,16r5ef6,
16r8a00,16r989c,16r960e,16r708e,16r6cbf,16r5944,16r63a9,16r773c,
16r884d,16r6f14,16r8273,16r5830,16r71d5,16r538c,16r781a,16r96c1,
16r5501,16r5f66,16r7130,16r5bb4,16r8c1a,16r9a8c,16r6b83,16r592e,
16r9e2f,16r79e7,16r6768,16r626c,16r4f6f,16r75a1,16r7f8a,16r6d0b,
16r9633,16r6c27,16r4ef0,16r75d2,16r517b,16r6837,16r6f3e,16r9080,
16r8170,16r5996,16r7476,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r6447,16r5c27,16r9065,16r7a91,16r8c23,16r59da,16r54ac,
16r8200,16r836f,16r8981,16r8000,16r6930,16r564e,16r8036,16r7237,
16r91ce,16r51b6,16r4e5f,16r9875,16r6396,16r4e1a,16r53f6,16r66f3,
16r814b,16r591c,16r6db2,16r4e00,16r58f9,16r533b,16r63d6,16r94f1,
16r4f9d,16r4f0a,16r8863,16r9890,16r5937,16r9057,16r79fb,16r4eea,
16r80f0,16r7591,16r6c82,16r5b9c,16r59e8,16r5f5d,16r6905,16r8681,
16r501a,16r5df2,16r4e59,16r77e3,16r4ee5,16r827a,16r6291,16r6613,
16r9091,16r5c79,16r4ebf,16r5f79,16r81c6,16r9038,16r8084,16r75ab,
16r4ea6,16r88d4,16r610f,16r6bc5,16r5fc6,16r4e49,16r76ca,16r6ea2,
16r8be3,16r8bae,16r8c0a,16r8bd1,16r5f02,16r7ffc,16r7fcc,16r7ece,
16r8335,16r836b,16r56e0,16r6bb7,16r97f3,16r9634,16r59fb,16r541f,
16r94f6,16r6deb,16r5bc5,16r996e,16r5c39,16r5f15,16r9690,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r5370,16r82f1,16r6a31,
16r5a74,16r9e70,16r5e94,16r7f28,16r83b9,16r8424,16r8425,16r8367,
16r8747,16r8fce,16r8d62,16r76c8,16r5f71,16r9896,16r786c,16r6620,
16r54df,16r62e5,16r4f63,16r81c3,16r75c8,16r5eb8,16r96cd,16r8e0a,
16r86f9,16r548f,16r6cf3,16r6d8c,16r6c38,16r607f,16r52c7,16r7528,
16r5e7d,16r4f18,16r60a0,16r5fe7,16r5c24,16r7531,16r90ae,16r94c0,
16r72b9,16r6cb9,16r6e38,16r9149,16r6709,16r53cb,16r53f3,16r4f51,
16r91c9,16r8bf1,16r53c8,16r5e7c,16r8fc2,16r6de4,16r4e8e,16r76c2,
16r6986,16r865e,16r611a,16r8206,16r4f59,16r4fde,16r903e,16r9c7c,
16r6109,16r6e1d,16r6e14,16r9685,16r4e88,16r5a31,16r96e8,16r4e0e,
16r5c7f,16r79b9,16r5b87,16r8bed,16r7fbd,16r7389,16r57df,16r828b,
16r90c1,16r5401,16r9047,16r55bb,16r5cea,16r5fa1,16r6108,16r6b32,
16r72f1,16r80b2,16r8a89,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r6d74,16r5bd3,16r88d5,16r9884,16r8c6b,16r9a6d,16r9e33,
16r6e0a,16r51a4,16r5143,16r57a3,16r8881,16r539f,16r63f4,16r8f95,
16r56ed,16r5458,16r5706,16r733f,16r6e90,16r7f18,16r8fdc,16r82d1,
16r613f,16r6028,16r9662,16r66f0,16r7ea6,16r8d8a,16r8dc3,16r94a5,
16r5cb3,16r7ca4,16r6708,16r60a6,16r9605,16r8018,16r4e91,16r90e7,
16r5300,16r9668,16r5141,16r8fd0,16r8574,16r915d,16r6655,16r97f5,
16r5b55,16r531d,16r7838,16r6742,16r683d,16r54c9,16r707e,16r5bb0,
16r8f7d,16r518d,16r5728,16r54b1,16r6512,16r6682,16r8d5e,16r8d43,
16r810f,16r846c,16r906d,16r7cdf,16r51ff,16r85fb,16r67a3,16r65e9,
16r6fa1,16r86a4,16r8e81,16r566a,16r9020,16r7682,16r7076,16r71e5,
16r8d23,16r62e9,16r5219,16r6cfd,16r8d3c,16r600e,16r589e,16r618e,
16r66fe,16r8d60,16r624e,16r55b3,16r6e23,16r672d,16r8f67,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r94e1,16r95f8,16r7728,
16r6805,16r69a8,16r548b,16r4e4d,16r70b8,16r8bc8,16r6458,16r658b,
16r5b85,16r7a84,16r503a,16r5be8,16r77bb,16r6be1,16r8a79,16r7c98,
16r6cbe,16r76cf,16r65a9,16r8f97,16r5d2d,16r5c55,16r8638,16r6808,
16r5360,16r6218,16r7ad9,16r6e5b,16r7efd,16r6a1f,16r7ae0,16r5f70,
16r6f33,16r5f20,16r638c,16r6da8,16r6756,16r4e08,16r5e10,16r8d26,
16r4ed7,16r80c0,16r7634,16r969c,16r62db,16r662d,16r627e,16r6cbc,
16r8d75,16r7167,16r7f69,16r5146,16r8087,16r53ec,16r906e,16r6298,
16r54f2,16r86f0,16r8f99,16r8005,16r9517,16r8517,16r8fd9,16r6d59,
16r73cd,16r659f,16r771f,16r7504,16r7827,16r81fb,16r8d1e,16r9488,
16r4fa6,16r6795,16r75b9,16r8bca,16r9707,16r632f,16r9547,16r9635,
16r84b8,16r6323,16r7741,16r5f81,16r72f0,16r4e89,16r6014,16r6574,
16r62ef,16r6b63,16r653f,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r5e27,16r75c7,16r90d1,16r8bc1,16r829d,16r679d,16r652f,
16r5431,16r8718,16r77e5,16r80a2,16r8102,16r6c41,16r4e4b,16r7ec7,
16r804c,16r76f4,16r690d,16r6b96,16r6267,16r503c,16r4f84,16r5740,
16r6307,16r6b62,16r8dbe,16r53ea,16r65e8,16r7eb8,16r5fd7,16r631a,
16r63b7,16r81f3,16r81f4,16r7f6e,16r5e1c,16r5cd9,16r5236,16r667a,
16r79e9,16r7a1a,16r8d28,16r7099,16r75d4,16r6ede,16r6cbb,16r7a92,
16r4e2d,16r76c5,16r5fe0,16r949f,16r8877,16r7ec8,16r79cd,16r80bf,
16r91cd,16r4ef2,16r4f17,16r821f,16r5468,16r5dde,16r6d32,16r8bcc,
16r7ca5,16r8f74,16r8098,16r5e1a,16r5492,16r76b1,16r5b99,16r663c,
16r9aa4,16r73e0,16r682a,16r86db,16r6731,16r732a,16r8bf8,16r8bdb,
16r9010,16r7af9,16r70db,16r716e,16r62c4,16r77a9,16r5631,16r4e3b,
16r8457,16r67f1,16r52a9,16r86c0,16r8d2e,16r94f8,16r7b51,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r4f4f,16r6ce8,16r795d,
16r9a7b,16r6293,16r722a,16r62fd,16r4e13,16r7816,16r8f6c,16r64b0,
16r8d5a,16r7bc6,16r6869,16r5e84,16r88c5,16r5986,16r649e,16r58ee,
16r72b6,16r690e,16r9525,16r8ffd,16r8d58,16r5760,16r7f00,16r8c06,
16r51c6,16r6349,16r62d9,16r5353,16r684c,16r7422,16r8301,16r914c,
16r5544,16r7740,16r707c,16r6d4a,16r5179,16r54a8,16r8d44,16r59ff,
16r6ecb,16r6dc4,16r5b5c,16r7d2b,16r4ed4,16r7c7d,16r6ed3,16r5b50,
16r81ea,16r6e0d,16r5b57,16r9b03,16r68d5,16r8e2a,16r5b97,16r7efc,
16r603b,16r7eb5,16r90b9,16r8d70,16r594f,16r63cd,16r79df,16r8db3,
16r5352,16r65cf,16r7956,16r8bc5,16r963b,16r7ec4,16r94bb,16r7e82,
16r5634,16r9189,16r6700,16r7f6a,16r5c0a,16r9075,16r6628,16r5de6,
16r4f50,16r67de,16r505a,16r4f5c,16r5750,16r5ea7,ERRchar,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r4e8d,16r4e0c,16r5140,16r4e10,16r5eff,16r5345,16r4e15,
16r4e98,16r4e1e,16r9b32,16r5b6c,16r5669,16r4e28,16r79ba,16r4e3f,
16r5315,16r4e47,16r592d,16r723b,16r536e,16r6c10,16r56df,16r80e4,
16r9997,16r6bd3,16r777e,16r9f17,16r4e36,16r4e9f,16r9f10,16r4e5c,
16r4e69,16r4e93,16r8288,16r5b5b,16r556c,16r560f,16r4ec4,16r538d,
16r539d,16r53a3,16r53a5,16r53ae,16r9765,16r8d5d,16r531a,16r53f5,
16r5326,16r532e,16r533e,16r8d5c,16r5366,16r5363,16r5202,16r5208,
16r520e,16r522d,16r5233,16r523f,16r5240,16r524c,16r525e,16r5261,
16r525c,16r84af,16r527d,16r5282,16r5281,16r5290,16r5293,16r5182,
16r7f54,16r4ebb,16r4ec3,16r4ec9,16r4ec2,16r4ee8,16r4ee1,16r4eeb,
16r4ede,16r4f1b,16r4ef3,16r4f22,16r4f64,16r4ef5,16r4f25,16r4f27,
16r4f09,16r4f2b,16r4f5e,16r4f67,16r6538,16r4f5a,16r4f5d,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r4f5f,16r4f57,16r4f32,
16r4f3d,16r4f76,16r4f74,16r4f91,16r4f89,16r4f83,16r4f8f,16r4f7e,
16r4f7b,16r4faa,16r4f7c,16r4fac,16r4f94,16r4fe6,16r4fe8,16r4fea,
16r4fc5,16r4fda,16r4fe3,16r4fdc,16r4fd1,16r4fdf,16r4ff8,16r5029,
16r504c,16r4ff3,16r502c,16r500f,16r502e,16r502d,16r4ffe,16r501c,
16r500c,16r5025,16r5028,16r507e,16r5043,16r5055,16r5048,16r504e,
16r506c,16r507b,16r50a5,16r50a7,16r50a9,16r50ba,16r50d6,16r5106,
16r50ed,16r50ec,16r50e6,16r50ee,16r5107,16r510b,16r4edd,16r6c3d,
16r4f58,16r4f65,16r4fce,16r9fa0,16r6c46,16r7c74,16r516e,16r5dfd,
16r9ec9,16r9998,16r5181,16r5914,16r52f9,16r530d,16r8a07,16r5310,
16r51eb,16r5919,16r5155,16r4ea0,16r5156,16r4eb3,16r886e,16r88a4,
16r4eb5,16r8114,16r88d2,16r7980,16r5b34,16r8803,16r7fb8,16r51ab,
16r51b1,16r51bd,16r51bc,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r51c7,16r5196,16r51a2,16r51a5,16r8ba0,16r8ba6,16r8ba7,
16r8baa,16r8bb4,16r8bb5,16r8bb7,16r8bc2,16r8bc3,16r8bcb,16r8bcf,
16r8bce,16r8bd2,16r8bd3,16r8bd4,16r8bd6,16r8bd8,16r8bd9,16r8bdc,
16r8bdf,16r8be0,16r8be4,16r8be8,16r8be9,16r8bee,16r8bf0,16r8bf3,
16r8bf6,16r8bf9,16r8bfc,16r8bff,16r8c00,16r8c02,16r8c04,16r8c07,
16r8c0c,16r8c0f,16r8c11,16r8c12,16r8c14,16r8c15,16r8c16,16r8c19,
16r8c1b,16r8c18,16r8c1d,16r8c1f,16r8c20,16r8c21,16r8c25,16r8c27,
16r8c2a,16r8c2b,16r8c2e,16r8c2f,16r8c32,16r8c33,16r8c35,16r8c36,
16r5369,16r537a,16r961d,16r9622,16r9621,16r9631,16r962a,16r963d,
16r963c,16r9642,16r9649,16r9654,16r965f,16r9667,16r966c,16r9672,
16r9674,16r9688,16r968d,16r9697,16r96b0,16r9097,16r909b,16r909d,
16r9099,16r90ac,16r90a1,16r90b4,16r90b3,16r90b6,16r90ba,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r90b8,16r90b0,16r90cf,
16r90c5,16r90be,16r90d0,16r90c4,16r90c7,16r90d3,16r90e6,16r90e2,
16r90dc,16r90d7,16r90db,16r90eb,16r90ef,16r90fe,16r9104,16r9122,
16r911e,16r9123,16r9131,16r912f,16r9139,16r9143,16r9146,16r520d,
16r5942,16r52a2,16r52ac,16r52ad,16r52be,16r54ff,16r52d0,16r52d6,
16r52f0,16r53df,16r71ee,16r77cd,16r5ef4,16r51f5,16r51fc,16r9b2f,
16r53b6,16r5f01,16r755a,16r5def,16r574c,16r57a9,16r57a1,16r587e,
16r58bc,16r58c5,16r58d1,16r5729,16r572c,16r572a,16r5733,16r5739,
16r572e,16r572f,16r575c,16r573b,16r5742,16r5769,16r5785,16r576b,
16r5786,16r577c,16r577b,16r5768,16r576d,16r5776,16r5773,16r57ad,
16r57a4,16r578c,16r57b2,16r57cf,16r57a7,16r57b4,16r5793,16r57a0,
16r57d5,16r57d8,16r57da,16r57d9,16r57d2,16r57b8,16r57f4,16r57ef,
16r57f8,16r57e4,16r57dd,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r580b,16r580d,16r57fd,16r57ed,16r5800,16r581e,16r5819,
16r5844,16r5820,16r5865,16r586c,16r5881,16r5889,16r589a,16r5880,
16r99a8,16r9f19,16r61ff,16r8279,16r827d,16r827f,16r828f,16r828a,
16r82a8,16r8284,16r828e,16r8291,16r8297,16r8299,16r82ab,16r82b8,
16r82be,16r82b0,16r82c8,16r82ca,16r82e3,16r8298,16r82b7,16r82ae,
16r82cb,16r82cc,16r82c1,16r82a9,16r82b4,16r82a1,16r82aa,16r829f,
16r82c4,16r82ce,16r82a4,16r82e1,16r8309,16r82f7,16r82e4,16r830f,
16r8307,16r82dc,16r82f4,16r82d2,16r82d8,16r830c,16r82fb,16r82d3,
16r8311,16r831a,16r8306,16r8314,16r8315,16r82e0,16r82d5,16r831c,
16r8351,16r835b,16r835c,16r8308,16r8392,16r833c,16r8334,16r8331,
16r839b,16r835e,16r832f,16r834f,16r8347,16r8343,16r835f,16r8340,
16r8317,16r8360,16r832d,16r833a,16r8333,16r8366,16r8365,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r8368,16r831b,16r8369,
16r836c,16r836a,16r836d,16r836e,16r83b0,16r8378,16r83b3,16r83b4,
16r83a0,16r83aa,16r8393,16r839c,16r8385,16r837c,16r83b6,16r83a9,
16r837d,16r83b8,16r837b,16r8398,16r839e,16r83a8,16r83ba,16r83bc,
16r83c1,16r8401,16r83e5,16r83d8,16r5807,16r8418,16r840b,16r83dd,
16r83fd,16r83d6,16r841c,16r8438,16r8411,16r8406,16r83d4,16r83df,
16r840f,16r8403,16r83f8,16r83f9,16r83ea,16r83c5,16r83c0,16r8426,
16r83f0,16r83e1,16r845c,16r8451,16r845a,16r8459,16r8473,16r8487,
16r8488,16r847a,16r8489,16r8478,16r843c,16r8446,16r8469,16r8476,
16r848c,16r848e,16r8431,16r846d,16r84c1,16r84cd,16r84d0,16r84e6,
16r84bd,16r84d3,16r84ca,16r84bf,16r84ba,16r84e0,16r84a1,16r84b9,
16r84b4,16r8497,16r84e5,16r84e3,16r850c,16r750d,16r8538,16r84f0,
16r8539,16r851f,16r853a,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r8556,16r853b,16r84ff,16r84fc,16r8559,16r8548,16r8568,
16r8564,16r855e,16r857a,16r77a2,16r8543,16r8572,16r857b,16r85a4,
16r85a8,16r8587,16r858f,16r8579,16r85ae,16r859c,16r8585,16r85b9,
16r85b7,16r85b0,16r85d3,16r85c1,16r85dc,16r85ff,16r8627,16r8605,
16r8629,16r8616,16r863c,16r5efe,16r5f08,16r593c,16r5941,16r8037,
16r5955,16r595a,16r5958,16r530f,16r5c22,16r5c25,16r5c2c,16r5c34,
16r624c,16r626a,16r629f,16r62bb,16r62ca,16r62da,16r62d7,16r62ee,
16r6322,16r62f6,16r6339,16r634b,16r6343,16r63ad,16r63f6,16r6371,
16r637a,16r638e,16r63b4,16r636d,16r63ac,16r638a,16r6369,16r63ae,
16r63bc,16r63f2,16r63f8,16r63e0,16r63ff,16r63c4,16r63de,16r63ce,
16r6452,16r63c6,16r63be,16r6445,16r6441,16r640b,16r641b,16r6420,
16r640c,16r6426,16r6421,16r645e,16r6484,16r646d,16r6496,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r647a,16r64b7,16r64b8,
16r6499,16r64ba,16r64c0,16r64d0,16r64d7,16r64e4,16r64e2,16r6509,
16r6525,16r652e,16r5f0b,16r5fd2,16r7519,16r5f11,16r535f,16r53f1,
16r53fd,16r53e9,16r53e8,16r53fb,16r5412,16r5416,16r5406,16r544b,
16r5452,16r5453,16r5454,16r5456,16r5443,16r5421,16r5457,16r5459,
16r5423,16r5432,16r5482,16r5494,16r5477,16r5471,16r5464,16r549a,
16r549b,16r5484,16r5476,16r5466,16r549d,16r54d0,16r54ad,16r54c2,
16r54b4,16r54d2,16r54a7,16r54a6,16r54d3,16r54d4,16r5472,16r54a3,
16r54d5,16r54bb,16r54bf,16r54cc,16r54d9,16r54da,16r54dc,16r54a9,
16r54aa,16r54a4,16r54dd,16r54cf,16r54de,16r551b,16r54e7,16r5520,
16r54fd,16r5514,16r54f3,16r5522,16r5523,16r550f,16r5511,16r5527,
16r552a,16r5567,16r558f,16r55b5,16r5549,16r556d,16r5541,16r5555,
16r553f,16r5550,16r553c,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r5537,16r5556,16r5575,16r5576,16r5577,16r5533,16r5530,
16r555c,16r558b,16r55d2,16r5583,16r55b1,16r55b9,16r5588,16r5581,
16r559f,16r557e,16r55d6,16r5591,16r557b,16r55df,16r55bd,16r55be,
16r5594,16r5599,16r55ea,16r55f7,16r55c9,16r561f,16r55d1,16r55eb,
16r55ec,16r55d4,16r55e6,16r55dd,16r55c4,16r55ef,16r55e5,16r55f2,
16r55f3,16r55cc,16r55cd,16r55e8,16r55f5,16r55e4,16r8f94,16r561e,
16r5608,16r560c,16r5601,16r5624,16r5623,16r55fe,16r5600,16r5627,
16r562d,16r5658,16r5639,16r5657,16r562c,16r564d,16r5662,16r5659,
16r565c,16r564c,16r5654,16r5686,16r5664,16r5671,16r566b,16r567b,
16r567c,16r5685,16r5693,16r56af,16r56d4,16r56d7,16r56dd,16r56e1,
16r56f5,16r56eb,16r56f9,16r56ff,16r5704,16r570a,16r5709,16r571c,
16r5e0f,16r5e19,16r5e14,16r5e11,16r5e31,16r5e3b,16r5e3c,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r5e37,16r5e44,16r5e54,
16r5e5b,16r5e5e,16r5e61,16r5c8c,16r5c7a,16r5c8d,16r5c90,16r5c96,
16r5c88,16r5c98,16r5c99,16r5c91,16r5c9a,16r5c9c,16r5cb5,16r5ca2,
16r5cbd,16r5cac,16r5cab,16r5cb1,16r5ca3,16r5cc1,16r5cb7,16r5cc4,
16r5cd2,16r5ce4,16r5ccb,16r5ce5,16r5d02,16r5d03,16r5d27,16r5d26,
16r5d2e,16r5d24,16r5d1e,16r5d06,16r5d1b,16r5d58,16r5d3e,16r5d34,
16r5d3d,16r5d6c,16r5d5b,16r5d6f,16r5d5d,16r5d6b,16r5d4b,16r5d4a,
16r5d69,16r5d74,16r5d82,16r5d99,16r5d9d,16r8c73,16r5db7,16r5dc5,
16r5f73,16r5f77,16r5f82,16r5f87,16r5f89,16r5f8c,16r5f95,16r5f99,
16r5f9c,16r5fa8,16r5fad,16r5fb5,16r5fbc,16r8862,16r5f61,16r72ad,
16r72b0,16r72b4,16r72b7,16r72b8,16r72c3,16r72c1,16r72ce,16r72cd,
16r72d2,16r72e8,16r72ef,16r72e9,16r72f2,16r72f4,16r72f7,16r7301,
16r72f3,16r7303,16r72fa,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r72fb,16r7317,16r7313,16r7321,16r730a,16r731e,16r731d,
16r7315,16r7322,16r7339,16r7325,16r732c,16r7338,16r7331,16r7350,
16r734d,16r7357,16r7360,16r736c,16r736f,16r737e,16r821b,16r5925,
16r98e7,16r5924,16r5902,16r9963,16r9967,16r9968,16r9969,16r996a,
16r996b,16r996c,16r9974,16r9977,16r997d,16r9980,16r9984,16r9987,
16r998a,16r998d,16r9990,16r9991,16r9993,16r9994,16r9995,16r5e80,
16r5e91,16r5e8b,16r5e96,16r5ea5,16r5ea0,16r5eb9,16r5eb5,16r5ebe,
16r5eb3,16r8d53,16r5ed2,16r5ed1,16r5edb,16r5ee8,16r5eea,16r81ba,
16r5fc4,16r5fc9,16r5fd6,16r5fcf,16r6003,16r5fee,16r6004,16r5fe1,
16r5fe4,16r5ffe,16r6005,16r6006,16r5fea,16r5fed,16r5ff8,16r6019,
16r6035,16r6026,16r601b,16r600f,16r600d,16r6029,16r602b,16r600a,
16r603f,16r6021,16r6078,16r6079,16r607b,16r607a,16r6042,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r606a,16r607d,16r6096,
16r609a,16r60ad,16r609d,16r6083,16r6092,16r608c,16r609b,16r60ec,
16r60bb,16r60b1,16r60dd,16r60d8,16r60c6,16r60da,16r60b4,16r6120,
16r6126,16r6115,16r6123,16r60f4,16r6100,16r610e,16r612b,16r614a,
16r6175,16r61ac,16r6194,16r61a7,16r61b7,16r61d4,16r61f5,16r5fdd,
16r96b3,16r95e9,16r95eb,16r95f1,16r95f3,16r95f5,16r95f6,16r95fc,
16r95fe,16r9603,16r9604,16r9606,16r9608,16r960a,16r960b,16r960c,
16r960d,16r960f,16r9612,16r9615,16r9616,16r9617,16r9619,16r961a,
16r4e2c,16r723f,16r6215,16r6c35,16r6c54,16r6c5c,16r6c4a,16r6ca3,
16r6c85,16r6c90,16r6c94,16r6c8c,16r6c68,16r6c69,16r6c74,16r6c76,
16r6c86,16r6ca9,16r6cd0,16r6cd4,16r6cad,16r6cf7,16r6cf8,16r6cf1,
16r6cd7,16r6cb2,16r6ce0,16r6cd6,16r6cfa,16r6ceb,16r6cee,16r6cb1,
16r6cd3,16r6cef,16r6cfe,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r6d39,16r6d27,16r6d0c,16r6d43,16r6d48,16r6d07,16r6d04,
16r6d19,16r6d0e,16r6d2b,16r6d4d,16r6d2e,16r6d35,16r6d1a,16r6d4f,
16r6d52,16r6d54,16r6d33,16r6d91,16r6d6f,16r6d9e,16r6da0,16r6d5e,
16r6d93,16r6d94,16r6d5c,16r6d60,16r6d7c,16r6d63,16r6e1a,16r6dc7,
16r6dc5,16r6dde,16r6e0e,16r6dbf,16r6de0,16r6e11,16r6de6,16r6ddd,
16r6dd9,16r6e16,16r6dab,16r6e0c,16r6dae,16r6e2b,16r6e6e,16r6e4e,
16r6e6b,16r6eb2,16r6e5f,16r6e86,16r6e53,16r6e54,16r6e32,16r6e25,
16r6e44,16r6edf,16r6eb1,16r6e98,16r6ee0,16r6f2d,16r6ee2,16r6ea5,
16r6ea7,16r6ebd,16r6ebb,16r6eb7,16r6ed7,16r6eb4,16r6ecf,16r6e8f,
16r6ec2,16r6e9f,16r6f62,16r6f46,16r6f47,16r6f24,16r6f15,16r6ef9,
16r6f2f,16r6f36,16r6f4b,16r6f74,16r6f2a,16r6f09,16r6f29,16r6f89,
16r6f8d,16r6f8c,16r6f78,16r6f72,16r6f7c,16r6f7a,16r6fd1,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r6fc9,16r6fa7,16r6fb9,
16r6fb6,16r6fc2,16r6fe1,16r6fee,16r6fde,16r6fe0,16r6fef,16r701a,
16r7023,16r701b,16r7039,16r7035,16r704f,16r705e,16r5b80,16r5b84,
16r5b95,16r5b93,16r5ba5,16r5bb8,16r752f,16r9a9e,16r6434,16r5be4,
16r5bee,16r8930,16r5bf0,16r8e47,16r8b07,16r8fb6,16r8fd3,16r8fd5,
16r8fe5,16r8fee,16r8fe4,16r8fe9,16r8fe6,16r8ff3,16r8fe8,16r9005,
16r9004,16r900b,16r9026,16r9011,16r900d,16r9016,16r9021,16r9035,
16r9036,16r902d,16r902f,16r9044,16r9051,16r9052,16r9050,16r9068,
16r9058,16r9062,16r905b,16r66b9,16r9074,16r907d,16r9082,16r9088,
16r9083,16r908b,16r5f50,16r5f57,16r5f56,16r5f58,16r5c3b,16r54ab,
16r5c50,16r5c59,16r5b71,16r5c63,16r5c66,16r7fbc,16r5f2a,16r5f29,
16r5f2d,16r8274,16r5f3c,16r9b3b,16r5c6e,16r5981,16r5983,16r598d,
16r59a9,16r59aa,16r59a3,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r5997,16r59ca,16r59ab,16r599e,16r59a4,16r59d2,16r59b2,
16r59af,16r59d7,16r59be,16r5a05,16r5a06,16r59dd,16r5a08,16r59e3,
16r59d8,16r59f9,16r5a0c,16r5a09,16r5a32,16r5a34,16r5a11,16r5a23,
16r5a13,16r5a40,16r5a67,16r5a4a,16r5a55,16r5a3c,16r5a62,16r5a75,
16r80ec,16r5aaa,16r5a9b,16r5a77,16r5a7a,16r5abe,16r5aeb,16r5ab2,
16r5ad2,16r5ad4,16r5ab8,16r5ae0,16r5ae3,16r5af1,16r5ad6,16r5ae6,
16r5ad8,16r5adc,16r5b09,16r5b17,16r5b16,16r5b32,16r5b37,16r5b40,
16r5c15,16r5c1c,16r5b5a,16r5b65,16r5b73,16r5b51,16r5b53,16r5b62,
16r9a75,16r9a77,16r9a78,16r9a7a,16r9a7f,16r9a7d,16r9a80,16r9a81,
16r9a85,16r9a88,16r9a8a,16r9a90,16r9a92,16r9a93,16r9a96,16r9a98,
16r9a9b,16r9a9c,16r9a9d,16r9a9f,16r9aa0,16r9aa2,16r9aa3,16r9aa5,
16r9aa7,16r7e9f,16r7ea1,16r7ea3,16r7ea5,16r7ea8,16r7ea9,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r7ead,16r7eb0,16r7ebe,
16r7ec0,16r7ec1,16r7ec2,16r7ec9,16r7ecb,16r7ecc,16r7ed0,16r7ed4,
16r7ed7,16r7edb,16r7ee0,16r7ee1,16r7ee8,16r7eeb,16r7eee,16r7eef,
16r7ef1,16r7ef2,16r7f0d,16r7ef6,16r7efa,16r7efb,16r7efe,16r7f01,
16r7f02,16r7f03,16r7f07,16r7f08,16r7f0b,16r7f0c,16r7f0f,16r7f11,
16r7f12,16r7f17,16r7f19,16r7f1c,16r7f1b,16r7f1f,16r7f21,16r7f22,
16r7f23,16r7f24,16r7f25,16r7f26,16r7f27,16r7f2a,16r7f2b,16r7f2c,
16r7f2d,16r7f2f,16r7f30,16r7f31,16r7f32,16r7f33,16r7f35,16r5e7a,
16r757f,16r5ddb,16r753e,16r9095,16r738e,16r7391,16r73ae,16r73a2,
16r739f,16r73cf,16r73c2,16r73d1,16r73b7,16r73b3,16r73c0,16r73c9,
16r73c8,16r73e5,16r73d9,16r987c,16r740a,16r73e9,16r73e7,16r73de,
16r73ba,16r73f2,16r740f,16r742a,16r745b,16r7426,16r7425,16r7428,
16r7430,16r742e,16r742c,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r741b,16r741a,16r7441,16r745c,16r7457,16r7455,16r7459,
16r7477,16r746d,16r747e,16r749c,16r748e,16r7480,16r7481,16r7487,
16r748b,16r749e,16r74a8,16r74a9,16r7490,16r74a7,16r74d2,16r74ba,
16r97ea,16r97eb,16r97ec,16r674c,16r6753,16r675e,16r6748,16r6769,
16r67a5,16r6787,16r676a,16r6773,16r6798,16r67a7,16r6775,16r67a8,
16r679e,16r67ad,16r678b,16r6777,16r677c,16r67f0,16r6809,16r67d8,
16r680a,16r67e9,16r67b0,16r680c,16r67d9,16r67b5,16r67da,16r67b3,
16r67dd,16r6800,16r67c3,16r67b8,16r67e2,16r680e,16r67c1,16r67fd,
16r6832,16r6833,16r6860,16r6861,16r684e,16r6862,16r6844,16r6864,
16r6883,16r681d,16r6855,16r6866,16r6841,16r6867,16r6840,16r683e,
16r684a,16r6849,16r6829,16r68b5,16r688f,16r6874,16r6877,16r6893,
16r686b,16r68c2,16r696e,16r68fc,16r691f,16r6920,16r68f9,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r6924,16r68f0,16r690b,
16r6901,16r6957,16r68e3,16r6910,16r6971,16r6939,16r6960,16r6942,
16r695d,16r6984,16r696b,16r6980,16r6998,16r6978,16r6934,16r69cc,
16r6987,16r6988,16r69ce,16r6989,16r6966,16r6963,16r6979,16r699b,
16r69a7,16r69bb,16r69ab,16r69ad,16r69d4,16r69b1,16r69c1,16r69ca,
16r69df,16r6995,16r69e0,16r698d,16r69ff,16r6a2f,16r69ed,16r6a17,
16r6a18,16r6a65,16r69f2,16r6a44,16r6a3e,16r6aa0,16r6a50,16r6a5b,
16r6a35,16r6a8e,16r6a79,16r6a3d,16r6a28,16r6a58,16r6a7c,16r6a91,
16r6a90,16r6aa9,16r6a97,16r6aab,16r7337,16r7352,16r6b81,16r6b82,
16r6b87,16r6b84,16r6b92,16r6b93,16r6b8d,16r6b9a,16r6b9b,16r6ba1,
16r6baa,16r8f6b,16r8f6d,16r8f71,16r8f72,16r8f73,16r8f75,16r8f76,
16r8f78,16r8f77,16r8f79,16r8f7a,16r8f7c,16r8f7e,16r8f81,16r8f82,
16r8f84,16r8f87,16r8f8b,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r8f8d,16r8f8e,16r8f8f,16r8f98,16r8f9a,16r8ece,16r620b,
16r6217,16r621b,16r621f,16r6222,16r6221,16r6225,16r6224,16r622c,
16r81e7,16r74ef,16r74f4,16r74ff,16r750f,16r7511,16r7513,16r6534,
16r65ee,16r65ef,16r65f0,16r660a,16r6619,16r6772,16r6603,16r6615,
16r6600,16r7085,16r66f7,16r661d,16r6634,16r6631,16r6636,16r6635,
16r8006,16r665f,16r6654,16r6641,16r664f,16r6656,16r6661,16r6657,
16r6677,16r6684,16r668c,16r66a7,16r669d,16r66be,16r66db,16r66dc,
16r66e6,16r66e9,16r8d32,16r8d33,16r8d36,16r8d3b,16r8d3d,16r8d40,
16r8d45,16r8d46,16r8d48,16r8d49,16r8d47,16r8d4d,16r8d55,16r8d59,
16r89c7,16r89ca,16r89cb,16r89cc,16r89ce,16r89cf,16r89d0,16r89d1,
16r726e,16r729f,16r725d,16r7266,16r726f,16r727e,16r727f,16r7284,
16r728b,16r728d,16r728f,16r7292,16r6308,16r6332,16r63b0,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r643f,16r64d8,16r8004,
16r6bea,16r6bf3,16r6bfd,16r6bf5,16r6bf9,16r6c05,16r6c07,16r6c06,
16r6c0d,16r6c15,16r6c18,16r6c19,16r6c1a,16r6c21,16r6c29,16r6c24,
16r6c2a,16r6c32,16r6535,16r6555,16r656b,16r724d,16r7252,16r7256,
16r7230,16r8662,16r5216,16r809f,16r809c,16r8093,16r80bc,16r670a,
16r80bd,16r80b1,16r80ab,16r80ad,16r80b4,16r80b7,16r80e7,16r80e8,
16r80e9,16r80ea,16r80db,16r80c2,16r80c4,16r80d9,16r80cd,16r80d7,
16r6710,16r80dd,16r80eb,16r80f1,16r80f4,16r80ed,16r810d,16r810e,
16r80f2,16r80fc,16r6715,16r8112,16r8c5a,16r8136,16r811e,16r812c,
16r8118,16r8132,16r8148,16r814c,16r8153,16r8174,16r8159,16r815a,
16r8171,16r8160,16r8169,16r817c,16r817d,16r816d,16r8167,16r584d,
16r5ab5,16r8188,16r8182,16r8191,16r6ed5,16r81a3,16r81aa,16r81cc,
16r6726,16r81ca,16r81bb,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r81c1,16r81a6,16r6b24,16r6b37,16r6b39,16r6b43,16r6b46,
16r6b59,16r98d1,16r98d2,16r98d3,16r98d5,16r98d9,16r98da,16r6bb3,
16r5f40,16r6bc2,16r89f3,16r6590,16r9f51,16r6593,16r65bc,16r65c6,
16r65c4,16r65c3,16r65cc,16r65ce,16r65d2,16r65d6,16r7080,16r709c,
16r7096,16r709d,16r70bb,16r70c0,16r70b7,16r70ab,16r70b1,16r70e8,
16r70ca,16r7110,16r7113,16r7116,16r712f,16r7131,16r7173,16r715c,
16r7168,16r7145,16r7172,16r714a,16r7178,16r717a,16r7198,16r71b3,
16r71b5,16r71a8,16r71a0,16r71e0,16r71d4,16r71e7,16r71f9,16r721d,
16r7228,16r706c,16r7118,16r7166,16r71b9,16r623e,16r623d,16r6243,
16r6248,16r6249,16r793b,16r7940,16r7946,16r7949,16r795b,16r795c,
16r7953,16r795a,16r7962,16r7957,16r7960,16r796f,16r7967,16r797a,
16r7985,16r798a,16r799a,16r79a7,16r79b3,16r5fd1,16r5fd0,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r603c,16r605d,16r605a,
16r6067,16r6041,16r6059,16r6063,16r60ab,16r6106,16r610d,16r615d,
16r61a9,16r619d,16r61cb,16r61d1,16r6206,16r8080,16r807f,16r6c93,
16r6cf6,16r6dfc,16r77f6,16r77f8,16r7800,16r7809,16r7817,16r7818,
16r7811,16r65ab,16r782d,16r781c,16r781d,16r7839,16r783a,16r783b,
16r781f,16r783c,16r7825,16r782c,16r7823,16r7829,16r784e,16r786d,
16r7856,16r7857,16r7826,16r7850,16r7847,16r784c,16r786a,16r789b,
16r7893,16r789a,16r7887,16r789c,16r78a1,16r78a3,16r78b2,16r78b9,
16r78a5,16r78d4,16r78d9,16r78c9,16r78ec,16r78f2,16r7905,16r78f4,
16r7913,16r7924,16r791e,16r7934,16r9f9b,16r9ef9,16r9efb,16r9efc,
16r76f1,16r7704,16r770d,16r76f9,16r7707,16r7708,16r771a,16r7722,
16r7719,16r772d,16r7726,16r7735,16r7738,16r7750,16r7751,16r7747,
16r7743,16r775a,16r7768,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r7762,16r7765,16r777f,16r778d,16r777d,16r7780,16r778c,
16r7791,16r779f,16r77a0,16r77b0,16r77b5,16r77bd,16r753a,16r7540,
16r754e,16r754b,16r7548,16r755b,16r7572,16r7579,16r7583,16r7f58,
16r7f61,16r7f5f,16r8a48,16r7f68,16r7f74,16r7f71,16r7f79,16r7f81,
16r7f7e,16r76cd,16r76e5,16r8832,16r9485,16r9486,16r9487,16r948b,
16r948a,16r948c,16r948d,16r948f,16r9490,16r9494,16r9497,16r9495,
16r949a,16r949b,16r949c,16r94a3,16r94a4,16r94ab,16r94aa,16r94ad,
16r94ac,16r94af,16r94b0,16r94b2,16r94b4,16r94b6,16r94b7,16r94b8,
16r94b9,16r94ba,16r94bc,16r94bd,16r94bf,16r94c4,16r94c8,16r94c9,
16r94ca,16r94cb,16r94cc,16r94cd,16r94ce,16r94d0,16r94d1,16r94d2,
16r94d5,16r94d6,16r94d7,16r94d9,16r94d8,16r94db,16r94de,16r94df,
16r94e0,16r94e2,16r94e4,16r94e5,16r94e7,16r94e8,16r94ea,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r94e9,16r94eb,16r94ee,
16r94ef,16r94f3,16r94f4,16r94f5,16r94f7,16r94f9,16r94fc,16r94fd,
16r94ff,16r9503,16r9502,16r9506,16r9507,16r9509,16r950a,16r950d,
16r950e,16r950f,16r9512,16r9513,16r9514,16r9515,16r9516,16r9518,
16r951b,16r951d,16r951e,16r951f,16r9522,16r952a,16r952b,16r9529,
16r952c,16r9531,16r9532,16r9534,16r9536,16r9537,16r9538,16r953c,
16r953e,16r953f,16r9542,16r9535,16r9544,16r9545,16r9546,16r9549,
16r954c,16r954e,16r954f,16r9552,16r9553,16r9554,16r9556,16r9557,
16r9558,16r9559,16r955b,16r955e,16r955f,16r955d,16r9561,16r9562,
16r9564,16r9565,16r9566,16r9567,16r9568,16r9569,16r956a,16r956b,
16r956c,16r956f,16r9571,16r9572,16r9573,16r953a,16r77e7,16r77ec,
16r96c9,16r79d5,16r79ed,16r79e3,16r79eb,16r7a06,16r5d47,16r7a03,
16r7a02,16r7a1e,16r7a14,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r7a39,16r7a37,16r7a51,16r9ecf,16r99a5,16r7a70,16r7688,
16r768e,16r7693,16r7699,16r76a4,16r74de,16r74e0,16r752c,16r9e20,
16r9e22,16r9e28,16r9e29,16r9e2a,16r9e2b,16r9e2c,16r9e32,16r9e31,
16r9e36,16r9e38,16r9e37,16r9e39,16r9e3a,16r9e3e,16r9e41,16r9e42,
16r9e44,16r9e46,16r9e47,16r9e48,16r9e49,16r9e4b,16r9e4c,16r9e4e,
16r9e51,16r9e55,16r9e57,16r9e5a,16r9e5b,16r9e5c,16r9e5e,16r9e63,
16r9e66,16r9e67,16r9e68,16r9e69,16r9e6a,16r9e6b,16r9e6c,16r9e71,
16r9e6d,16r9e73,16r7592,16r7594,16r7596,16r75a0,16r759d,16r75ac,
16r75a3,16r75b3,16r75b4,16r75b8,16r75c4,16r75b1,16r75b0,16r75c3,
16r75c2,16r75d6,16r75cd,16r75e3,16r75e8,16r75e6,16r75e4,16r75eb,
16r75e7,16r7603,16r75f1,16r75fc,16r75ff,16r7610,16r7600,16r7605,
16r760c,16r7617,16r760a,16r7625,16r7618,16r7615,16r7619,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r761b,16r763c,16r7622,
16r7620,16r7640,16r762d,16r7630,16r763f,16r7635,16r7643,16r763e,
16r7633,16r764d,16r765e,16r7654,16r765c,16r7656,16r766b,16r766f,
16r7fca,16r7ae6,16r7a78,16r7a79,16r7a80,16r7a86,16r7a88,16r7a95,
16r7aa6,16r7aa0,16r7aac,16r7aa8,16r7aad,16r7ab3,16r8864,16r8869,
16r8872,16r887d,16r887f,16r8882,16r88a2,16r88c6,16r88b7,16r88bc,
16r88c9,16r88e2,16r88ce,16r88e3,16r88e5,16r88f1,16r891a,16r88fc,
16r88e8,16r88fe,16r88f0,16r8921,16r8919,16r8913,16r891b,16r890a,
16r8934,16r892b,16r8936,16r8941,16r8966,16r897b,16r758b,16r80e5,
16r76b2,16r76b4,16r77dc,16r8012,16r8014,16r8016,16r801c,16r8020,
16r8022,16r8025,16r8026,16r8027,16r8029,16r8028,16r8031,16r800b,
16r8035,16r8043,16r8046,16r804d,16r8052,16r8069,16r8071,16r8983,
16r9878,16r9880,16r9883,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r9889,16r988c,16r988d,16r988f,16r9894,16r989a,16r989b,
16r989e,16r989f,16r98a1,16r98a2,16r98a5,16r98a6,16r864d,16r8654,
16r866c,16r866e,16r867f,16r867a,16r867c,16r867b,16r86a8,16r868d,
16r868b,16r86ac,16r869d,16r86a7,16r86a3,16r86aa,16r8693,16r86a9,
16r86b6,16r86c4,16r86b5,16r86ce,16r86b0,16r86ba,16r86b1,16r86af,
16r86c9,16r86cf,16r86b4,16r86e9,16r86f1,16r86f2,16r86ed,16r86f3,
16r86d0,16r8713,16r86de,16r86f4,16r86df,16r86d8,16r86d1,16r8703,
16r8707,16r86f8,16r8708,16r870a,16r870d,16r8709,16r8723,16r873b,
16r871e,16r8725,16r872e,16r871a,16r873e,16r8748,16r8734,16r8731,
16r8729,16r8737,16r873f,16r8782,16r8722,16r877d,16r877e,16r877b,
16r8760,16r8770,16r874c,16r876e,16r878b,16r8753,16r8763,16r877c,
16r8764,16r8759,16r8765,16r8793,16r87af,16r87a8,16r87d2,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r87c6,16r8788,16r8785,
16r87ad,16r8797,16r8783,16r87ab,16r87e5,16r87ac,16r87b5,16r87b3,
16r87cb,16r87d3,16r87bd,16r87d1,16r87c0,16r87ca,16r87db,16r87ea,
16r87e0,16r87ee,16r8816,16r8813,16r87fe,16r880a,16r881b,16r8821,
16r8839,16r883c,16r7f36,16r7f42,16r7f44,16r7f45,16r8210,16r7afa,
16r7afd,16r7b08,16r7b03,16r7b04,16r7b15,16r7b0a,16r7b2b,16r7b0f,
16r7b47,16r7b38,16r7b2a,16r7b19,16r7b2e,16r7b31,16r7b20,16r7b25,
16r7b24,16r7b33,16r7b3e,16r7b1e,16r7b58,16r7b5a,16r7b45,16r7b75,
16r7b4c,16r7b5d,16r7b60,16r7b6e,16r7b7b,16r7b62,16r7b72,16r7b71,
16r7b90,16r7ba6,16r7ba7,16r7bb8,16r7bac,16r7b9d,16r7ba8,16r7b85,
16r7baa,16r7b9c,16r7ba2,16r7bab,16r7bb4,16r7bd1,16r7bc1,16r7bcc,
16r7bdd,16r7bda,16r7be5,16r7be6,16r7bea,16r7c0c,16r7bfe,16r7bfc,
16r7c0f,16r7c16,16r7c0b,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r7c1f,16r7c2a,16r7c26,16r7c38,16r7c41,16r7c40,16r81fe,
16r8201,16r8202,16r8204,16r81ec,16r8844,16r8221,16r8222,16r8223,
16r822d,16r822f,16r8228,16r822b,16r8238,16r823b,16r8233,16r8234,
16r823e,16r8244,16r8249,16r824b,16r824f,16r825a,16r825f,16r8268,
16r887e,16r8885,16r8888,16r88d8,16r88df,16r895e,16r7f9d,16r7f9f,
16r7fa7,16r7faf,16r7fb0,16r7fb2,16r7c7c,16r6549,16r7c91,16r7c9d,
16r7c9c,16r7c9e,16r7ca2,16r7cb2,16r7cbc,16r7cbd,16r7cc1,16r7cc7,
16r7ccc,16r7ccd,16r7cc8,16r7cc5,16r7cd7,16r7ce8,16r826e,16r66a8,
16r7fbf,16r7fce,16r7fd5,16r7fe5,16r7fe1,16r7fe6,16r7fe9,16r7fee,
16r7ff3,16r7cf8,16r7d77,16r7da6,16r7dae,16r7e47,16r7e9b,16r9eb8,
16r9eb4,16r8d73,16r8d84,16r8d94,16r8d91,16r8db1,16r8d67,16r8d6d,
16r8c47,16r8c49,16r914a,16r9150,16r914e,16r914f,16r9164,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r9162,16r9161,16r9170,
16r9169,16r916f,16r917d,16r917e,16r9172,16r9174,16r9179,16r918c,
16r9185,16r9190,16r918d,16r9191,16r91a2,16r91a3,16r91aa,16r91ad,
16r91ae,16r91af,16r91b5,16r91b4,16r91ba,16r8c55,16r9e7e,16r8db8,
16r8deb,16r8e05,16r8e59,16r8e69,16r8db5,16r8dbf,16r8dbc,16r8dba,
16r8dc4,16r8dd6,16r8dd7,16r8dda,16r8dde,16r8dce,16r8dcf,16r8ddb,
16r8dc6,16r8dec,16r8df7,16r8df8,16r8de3,16r8df9,16r8dfb,16r8de4,
16r8e09,16r8dfd,16r8e14,16r8e1d,16r8e1f,16r8e2c,16r8e2e,16r8e23,
16r8e2f,16r8e3a,16r8e40,16r8e39,16r8e35,16r8e3d,16r8e31,16r8e49,
16r8e41,16r8e42,16r8e51,16r8e52,16r8e4a,16r8e70,16r8e76,16r8e7c,
16r8e6f,16r8e74,16r8e85,16r8e8f,16r8e94,16r8e90,16r8e9c,16r8e9e,
16r8c78,16r8c82,16r8c8a,16r8c85,16r8c98,16r8c94,16r659b,16r89d6,
16r89de,16r89da,16r89dc,ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,
ERRchar,16r89e5,16r89eb,16r89ef,16r8a3e,16r8b26,16r9753,16r96e9,
16r96f3,16r96ef,16r9706,16r9701,16r9708,16r970f,16r970e,16r972a,
16r972d,16r9730,16r973e,16r9f80,16r9f83,16r9f85,16r9f86,16r9f87,
16r9f88,16r9f89,16r9f8a,16r9f8c,16r9efe,16r9f0b,16r9f0d,16r96b9,
16r96bc,16r96bd,16r96ce,16r96d2,16r77bf,16r96e0,16r928e,16r92ae,
16r92c8,16r933e,16r936a,16r93ca,16r938f,16r943e,16r946b,16r9c7f,
16r9c82,16r9c85,16r9c86,16r9c87,16r9c88,16r7a23,16r9c8b,16r9c8e,
16r9c90,16r9c91,16r9c92,16r9c94,16r9c95,16r9c9a,16r9c9b,16r9c9e,
16r9c9f,16r9ca0,16r9ca1,16r9ca2,16r9ca3,16r9ca5,16r9ca6,16r9ca7,
16r9ca8,16r9ca9,16r9cab,16r9cad,16r9cae,16r9cb0,16r9cb1,16r9cb2,
16r9cb3,16r9cb4,16r9cb5,16r9cb6,16r9cb7,16r9cba,16r9cbb,16r9cbc,
16r9cbd,16r9cc4,16r9cc5,16r9cc6,16r9cc7,16r9cca,16r9ccb,ERRchar,
ERRchar,ERRchar,ERRchar,ERRchar,ERRchar,16r9ccc,16r9ccd,16r9cce,
16r9ccf,16r9cd0,16r9cd3,16r9cd4,16r9cd5,16r9cd7,16r9cd8,16r9cd9,
16r9cdc,16r9cdd,16r9cdf,16r9ce2,16r977c,16r9785,16r9791,16r9792,
16r9794,16r97af,16r97ab,16r97a3,16r97b2,16r97b4,16r9ab1,16r9ab0,
16r9ab7,16r9e58,16r9ab6,16r9aba,16r9abc,16r9ac1,16r9ac0,16r9ac5,
16r9ac2,16r9acb,16r9acc,16r9ad1,16r9b45,16r9b43,16r9b47,16r9b49,
16r9b48,16r9b4d,16r9b51,16r98e8,16r990d,16r992e,16r9955,16r9954,
16r9adf,16r9ae1,16r9ae6,16r9aef,16r9aeb,16r9afb,16r9aed,16r9af9,
16r9b08,16r9b0f,16r9b13,16r9b1f,16r9b23,16r9ebd,16r9ebe,16r7e3b,
16r9e82,16r9e87,16r9e88,16r9e8b,16r9e92,16r93d6,16r9e9d,16r9e9f,
16r9edb,16r9edc,16r9edd,16r9ee0,16r9edf,16r9ee2,16r9ee9,16r9ee7,
16r9ee5,16r9eea,16r9eef,16r9f22,16r9f2c,16r9f2f,16r9f39,16r9f37,
16r9f3d,16r9f3e,16r9f44,
};
