#include "gc.h"

/*
 * code sequences for multiply by constant
 * all sequences start with leading '0'.
 * if sequence starts with 'i', then the
 *	leading '0' is suppressed.
 * '0'	mov r0,r1
 * '1'  sub r0,r1
 * '2'	sub r1,r0
 * '3'	add r0,r1
 * '4'	add r1,r0
 * '5'	add r0,r0
 * '6'	add r1,r1
 * 'b'	lsh $2,r0
 * 'c'	lsh $3,r0
 * 'd'-'h' ...
 * 'j'	lsh $2,r1
 * 'k'-'p' ...
 */
Multab multab[] =
{
	2, "i5",
	3, "64",
	4, "i55",
	5, "664",
	6, "645",
	7, "c2",
	9, "k4",
	10, "6645",
	11, "66364",
	12, "6455",
	13, "66464",
	14, "6d2",
	15, "d2",
	17, "l4",
	18, "6d4",
	19, "64k4",
	20, "66455",
	21, "664664",
	22, "64c2",
	23, "44c2",
	24, "64c",
	25, "63k4",
	26, "64c4",
	27, "663e2",
	28, "66e2",
	29, "63e2",
	30, "6e2",
	31, "e2",
	33, "m4",
	34, "6e4",
	35, "64l4",
	36, "66e4",
	37, "664k4",
	38, "64k45",
	39, "454c2",
	40, "664c",
	41, "663k4",
	42, "644c4",
	43, "643k4",
	44, "664c4",
	45, "640d2",
	46, "64d2",
	47, "44d2",
	48, "64d",
	49, "63l4",
	50, "64d4",
	51, "640l4",
	52, "646d4",
	53, "643d4",
	54, "6636f2",
	55, "k3f2",
	56, "kf2",
	57, "k2k4",
	58, "636f2",
	59, "663f2",
	60, "66f2",
	61, "63f2",
	62, "6f2",
	63, "f2",
	65, "n4",
	66, "6f4",
	67, "64m4",
	68, "66f4",
	69, "664l4",
	70, "64l45",
	71, "k1f4",
	72, "k4c",
	73, "k4k4",
	74, "664k45",
	75, "6640d2",
	76, "664d2",
	77, "434d2",
	78, "644d2",
	79, "454d2",
	80, "664d",
	81, "663l4",
	82, "644d4",
	83, "643l4",
	84, "664d4",
	85, "6640l4",
	86, "6634l4",
	87, "6443d4",
	88, "6646d4",
	89, "6643d4",
	90, "6406e2",
	91, "643e2",
	92, "646e2",
	93, "640e2",
	94, "64e2",
	95, "44e2",
	96, "64e",
	97, "63m4",
	98, "64e4",
	99, "640m4",
	100, "646e4",
	200, "66f364",
	300, "j40jf2",
	400, "64kg4",
	500, "66h212",
	600, "64m4c4",
	700, "j4c4d2",
	800, "64lh4",
	900, "6464g4",
	1000, "63g2c",
	1100, "j4d2p4",
	1200, "64k4f2",
	1300, "j4n4b4",
	1400, "64j4g2",
	1600, "64d4e",
	1800, "p4c2",
	2000, "63g2d",
	2100, "l4b2o4",
	2200, "k4d4p4",
	2300, "6644h2",
	2400, "j4k4f4",
	2500, "j4e2d4",
	2600, "j40n4c",
	3100, "jd12p2",
	3200, "64d4f",
	3600, "6d1p2",
	3800, "e3k3g2",
	3900, "jf20n4",
	4000, "o4e2",
	4100, "66p455",
	4200, "l4c3e2",
	4300, "l4b1f4",
	4400, "64o4d4",
	4600, "k45h2",
	4700, "k3j4g2",
	4800, "j40d2f",
	5000, "l4c3m4",
	5100, "j40h2b",
	5200, "j40n4d",
	6000, "d1o3h2",
	6100, "o1l4b2",
	6200, "ke12p2",
	6400, "64d4g",
	7200, "66e1p2",
	7400, "m3m4c2",
	7600, "l4f3c2",
	7800, "kg20n4",
	8000, "63g2f",
	8100, "m2b4p4",
	8200, "66p4c",
	8700, "66f4g2",
	8900, "l3j4g4",
	9200, "k45h25",
	9600, "j40d2g",
	9800, "k4f3d4",
};

int	multabsize = sizeof(multab) / sizeof(multab[0]);
