#if 0
    Copyright 1999-2000, Silicon Graphics, Inc.
    ALL RIGHTS RESERVED

    UNPUBLISHED -- Rights reserved under the copyright laws of the United
    States.   Use of a copyright notice is precautionary only and does not
    imply publication or disclosure.

    U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
    Use, duplication or disclosure by the Government is subject to restrictions
    as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
    in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
    in similar or successor clauses in the FAR, or the DOD or NASA FAR
    Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
    2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.

    THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
    INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
    DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
    PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
    GRAPHICS, INC.
#endif

#ifndef __vs_h__
#define __vs_h__

#include <stdio.h>
#include <stdarg.h>

#include <vizserver/vsporting/vs.h>
#include <vizserver/vsporting/vsTypes.h>


#if defined(__cplusplus)
extern "C" {
#endif

typedef int vsEnum;

#ifndef SGI_O32
typedef bool vsBool;
#else
typedef unsigned int vsBool;
#endif

#ifndef TRUE
    #define TRUE 1
#endif
#ifndef FALSE
    #define FALSE 0
#endif


typedef vsUInt vsStatus;
typedef vsUInt vsLogPri;
typedef void (*vsErrorHandler)(vsLogPri pri, const char* msg, va_list args);

enum {
    // error log priorities, lower numbers have higher priority
    vsLogPriHalt	= 0,
    vsLogPriAlert       = 1,
    vsLogPriCritical    = 2,
    vsLogPriError	= 3,
    vsLogPriWarning	= 4,
    vsLogPriNotice	= 5,
    vsLogPriInfo	= 6,
    vsLogPriDebug	= 7,
    vsLogPriMask	= 0x07,

    // status types
    vsStatusTypeLib	= 0,
    vsStatusTypeOS	= 1,

    // status code mask and shift values
    vsStatusTypeMask	= 0xf0000000,
    vsStatusTypeShift	= 28,
    vsStatusValueMask	= 0x0fffffff,

    // lib type error codes
    vsErrNone		= 0,		// no error
    vsErrInval		= 1,		// invalid parameter
    vsErrNoSpace	= 2,		// no space
    vsErrEnd		= 3,
    vsErrAlready	= 4,
    vsErrNoEntry	= 5,		// entry not found, (or access denied)
    vsErrBusy		= 6,		// resource busy
    vsErrAuth		= 7,		// not authorized
    vsErrNoMem		= 8,		// not enough memory
    vsErrLimit		= 9,		// resource limits exceeded
    vsErrResource	= 10,		// not enough resources
    vsErrBadState	= 11,		// wrong state
    vsErrBadCast	= 12,		// invalid parameter cast
    vsErrNoConnection   = 13,           // no connection to server/client
    vsErrNoReservation  = 14,           // Pipe not reserved
    vsErrNoLicense      = 15,           // No License
    vsErrProtoVersion   = 16,           // Protocol version not supported
    vsErrAgain          = 17,           // Need to try again
    vsErrRejectCollabJoin = 18,         // Collaborative session join rejection
    vsErrInvalidServerModule = 19,      // Server module invalid
    vsErrNoX = 20,
    vsErrNoActiveScreens = 21
};

#define vsStatusEncode(t,v) \
	((((vsStatus)(t))<<vsStatusTypeShift) | ((v)&vsStatusValueMask))
#define vsStatusDecodeType(s) 	(((vsStatus)(sts))>>vsStatusTypeShift)
#define vsStatusDecodeValue(s)	(((vsStatus)(sts))&vsStatusValueMask)

#define vsStatusEncodeLib(v)	vsStatusEncode(vsStatusTypeLib, v)
#define vsStatusEncodeOS(v)	vsStatusEncode(vsStatusTypeOS, v)


void vsErrorSetLog(FILE* fp);
void vsErrorSetTag(const char* tag);
void vsErrorLog(vsLogPri pri, const char* msg, ...);
void vsErrorLogV(vsLogPri pri, const char* msg, va_list args);
const char* vsErrorString(vsStatus sts);

extern const vsErrorHandler vsNaiveErrorHandler;

extern const vsErrorHandler vsRobustErrorHandler;

extern const vsErrorHandler vsSilentErrorHandler;

vsBool vsPushErrorHandler(vsErrorHandler handler);

vsErrorHandler vsPopErrorHandler();
vsErrorHandler vsGetErrorHandler();

size_t vsGetErrorHandlerStackDepth();

size_t vsGetErrorHandlerMaxStackDepth();

#if defined(__cplusplus)
}
#endif

#endif
