#if 0
    Copyright 1999-2001, Silicon Graphics, Inc.
    ALL RIGHTS RESERVED

    UNPUBLISHED -- Rights reserved under the copyright laws of the United
    States.   Use of a copyright notice is precautionary only and does not
    imply publication or disclosure.

    U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
    Use, duplication or disclosure by the Government is subject to restrictions
    as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
    in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
    in similar or successor clauses in the FAR, or the DOD or NASA FAR
    Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
    1600 Amphitheatre Pkwy Mountain View, CA 94043.

    THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
    INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
    DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
    PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
    GRAPHICS, INC.
#endif

#ifndef __vsCompressor_h__
#define __vsCompressor_h__

#include <vizserver/vs.h>
#include <vizserver/vsLoadable.h>
#include <vizserver/vsFrame.h>
#include <vizserver/vsQueryType.h>

extern const char* vsGlobalCompressionVersionString;

class vsCompressor : public vsLoadable 
{

public:
    struct Info {
	char* description;		// long description of compressor
	vsBitfield compressorTypes; // compressor implementation type
	vsBitfield inputFormats;	// supported compress pixel formats
	vsBitfield inputTypes;		// supported compress component types
	vsBitfield outputFormats;	// supported expand pixel formats
	vsBitfield outputTypes;		// supported expand component types
    };

    // Creation and destruction
    virtual ~vsCompressor();

    // Querying
    virtual const Info* getInfo() const = 0;

    virtual size_t getMaxCompressedSize(const vsCmprParamArg&) = 0;

    // Compression and decompression
    virtual size_t compress(const vsCmprInputQueryArg& input,
                                  vsCmprOutputQueryArg& output) = 0;

    virtual void expand(const vsCmprInputQueryArg& input,
                              vsCmprOutputQueryArg& output) = 0;
    
    virtual void receiveMessage(const vsCmprParamArg& msg) = 0;	
protected:
    // Creation and destruction
    vsCompressor();


#define vsCompressorDeclare \
    public: const vsCompressor::Info* getInfo() const;

#define vsCompressorImplement(_class, _infoPtr, _desc) \
    vsLoadableImplement(vsCompressor, _class, _desc) \
    const vsCompressor::Info* _class::getInfo() const { return _infoPtr; }

};

#endif
