#if 0
    Copyright 1999-2000, Silicon Graphics, Inc.
    ALL RIGHTS RESERVED

    UNPUBLISHED -- Rights reserved under the copyright laws of the United
    States.   Use of a copyright notice is precautionary only and does not
    imply publication or disclosure.

    U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
    Use, duplication or disclosure by the Government is subject to restrictions
    as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
    in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
    in similar or successor clauses in the FAR, or the DOD or NASA FAR
    Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
    2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.

    THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
    INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
    DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
    PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
    GRAPHICS, INC.
#endif

#ifndef __vsFrame_h__
#define __vsFrame_h__

#include <vizserver/vs.h>
#include <vizserver/vsQueryType.h>


class vsFieldInfo;
class vsFrameInfo : public vsCmprQueryParamType, 
                    public vsCmprFieldNameFrameQueryType {
public:

    // Query Information functions for field information
    virtual size_t getNumOfFields() const;

    vsBool isQueryTypeSupported(vsQueryTypes::Base name) const;
    vsBool isParamTypeSupported(vsParamTypes::Base) const;
	
    inline vsCmprParamTypesQueryParams getParamName() const 
    { return vsCmprParamTypes::FrameInfo; }

};

class vsFrameData : public vsCmprQueryParamType,
                    public vsCmprFieldNameFrameQueryType {
public:

    vsBool isQueryTypeSupported(vsQueryTypes::Base name) const;

    vsBool isParamTypeSupported(vsParamTypes::Base) const;
			
    inline vsCmprParamTypesQueryParams getParamName() const 
    { return vsCmprParamTypes::FrameData; }

};

class vsFramePacking : public vsCmprQueryParamType,
                      public vsCmprFieldNameFrameQueryType {
public:

    // Query Information functions for field information
    virtual size_t getNumOfFields() const;

    vsBool isQueryTypeSupported(vsQueryTypes::Base name) const;

    vsBool isParamTypeSupported(vsParamTypes::Base) const;
			
    inline vsCmprParamTypesQueryParams getParamName() const 
    { return vsCmprParamTypes::FramePacking; }

};


class vsFieldInfo : public vsCmprParamType {
public:

    // Creating and destroying
    vsFieldInfo(vsUInt frameID, vsUInt drawableID, vsEnum fieldID,
                vsEnum format, vsEnum type, vsShort x, vsShort y, vsUShort w,
                vsUShort h);


    virtual ~vsFieldInfo();

    // Accessing a field description
    inline vsUInt getFrameID() const { return frameID; }

    inline vsUInt getDrawableID() const { return drawableID; }

    inline vsEnum getFieldID() const { return fieldID; }

    inline vsEnum getFormat() const { return format; }

    inline vsEnum getType() const { return type; }

	inline vsShort getX() const { return x; }

    inline vsShort getY() const { return y; }

    inline vsUShort getWidth() const { return w; }

    inline vsUShort getHeight() const { return h; }
	vsBool isParamTypeSupported(vsParamTypes::Base) const;
    	
	inline vsCmprParamTypesFieldParams getParamName() const 
	{ return vsCmprParamTypes::FieldInfo; }
    
private:
    vsUInt frameID, drawableID;		// frame and drawable identifiers
    vsEnum fieldID;			// field type within frame
    vsEnum format, type;		// pixel format and component type
    vsShort x, y;			// filed offset within drawable
    vsUShort w, h;			// field size
};

class vsFieldData : public vsCmprParamType {
public:

    virtual ~vsFieldData();
    virtual vsStatus getData(void *&) const = 0;

    vsBool isParamTypeSupported(vsParamTypes::Base) const;

    inline vsCmprParamTypesFieldParams getParamName() const 
        { return vsCmprParamTypes::FieldData; }

};

class vsFieldPacking : public vsCmprParamType {
public:

    // Creating and destroying
    vsFieldPacking(vsBool topdown, vsInt padding);

    virtual ~vsFieldPacking();

    virtual vsBool getTopdown() const {return topdown;}
    virtual int getPadding() const {return padding;}

    vsBool isParamTypeSupported(vsParamTypes::Base) const;

    inline vsCmprParamTypesFieldParams getParamName() const 
        { return vsCmprParamTypes::FieldPacking; }

private:
    vsInt padding;		// 
    vsBool topdown;
};

extern vsUInt vsFieldPixelBytes(vsEnum format, vsEnum type);

#endif
