#if 0
    Copyright 1999-2000, Silicon Graphics, Inc.
    ALL RIGHTS RESERVED

    UNPUBLISHED -- Rights reserved under the copyright laws of the United
    States.   Use of a copyright notice is precautionary only and does not
    imply publication or disclosure.

    U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
    Use, duplication or disclosure by the Government is subject to restrictions
    as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
    in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
    in similar or successor clauses in the FAR, or the DOD or NASA FAR
    Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
    2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.

    THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
    INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
    DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
    PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
    GRAPHICS, INC.
#endif

#ifndef __vsLoadable_h__
#define __vsLoadable_h__

#include <vizserver/vsporting/vsLoadable.h>


class vsLoadableDSO;
struct vsLoadableTypeRec;
class vsLoadableTypeBase;

class vsLoadable {
protected:

    // Creation and destruction
    vsLoadable();

    virtual ~vsLoadable();

private:
    friend class vsLoadableTypeBase;
    vsLoadableDSO* dso;
    void loadableInit(vsLoadableDSO*);
};

class vsLoadableTypeImplBase {
public:

    // Creation and destruction
    vsLoadableTypeImplBase();

    virtual ~vsLoadableTypeImplBase();

    // Usage
    virtual vsLoadable* create() const = 0;
};


template <class LoadableClass>
class vsLoadableTypeImpl : public vsLoadableTypeImplBase {
public:

    // Creation and destruction
    vsLoadableTypeImpl() { }

    ~vsLoadableTypeImpl() { }

    // Usage
    vsLoadable* create() const { return new LoadableClass; }
};

class vsLoadableRegist{
 public:
  
  vsLoadableRegist(char* _sig, char* _class);
  
  ~vsLoadableRegist();

};

// define the signature for a loadable object class
#define vsLoadableSignFixedName		"_SIGNATURE_"
#define vsLoadableSignPrefixName(_sig)	#_sig vsLoadableSignFixedName
#define vsLoadableSign(_sig, _name)	_sig ## _SIGNATURE_ ## _name
#define vsLoadableSignature(_sig, _name, _desc) \
    VS_DSO_EXPORT char vsLoadableSign(_sig, _name)[] = _desc;

#define vsLoadableTypeImplSuffix        "_TYPEIMPL"
#define vsLoadableTypeImplName(_c)      _c ## _TYPEIMPL

#define vsLoadableImplement(_sig, _class, _desc) \
    vsLoadableSignature(_sig, _class, _desc) \
    VS_DSO_EXPORT vsLoadableRegist vsLoadableRegistrator_ ## _class(#_sig, #_class); \
    VS_DSO_EXPORT vsLoadableTypeImpl<_class> vsLoadableTypeImplName(_class);
#endif

