#if 0
    Copyright 1999-2000, Silicon Graphics, Inc.
    ALL RIGHTS RESERVED

    UNPUBLISHED -- Rights reserved under the copyright laws of the United
    States.   Use of a copyright notice is precautionary only and does not
    imply publication or disclosure.

    U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
    Use, duplication or disclosure by the Government is subject to restrictions
    as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
    in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
    in similar or successor clauses in the FAR, or the DOD or NASA FAR
    Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
    2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.

    THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
    INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
    DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
    PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
    GRAPHICS, INC.
#endif

#ifndef __vsLock_h__
#define __vsLock_h__

#include <vizserver/vsporting/vsLock.h>

#include <vizserver/vs.h>

class vsLock {
public:

    // Creation and destruction
    vsLock();

    ~vsLock();

    /* Copy Constructor */
    vsLock(const vsLock& copy);
    
    // Usage
    vsBool lock();

    vsBool trylock();

    vsBool unlock();

    // Queries
    vsBool isLocked();

private:
    /* do not allow = */
    vsLock& operator=(const vsLock& ) { return *this; }

    SEM_T mutex;
    unsigned int locker;
    int count;
};


class vsSemaphore {
public:

    // Creation and destruction
    vsSemaphore(int value=1);

    /* Copy Constructor */
    vsSemaphore(const vsSemaphore& copy);
    
    ~vsSemaphore();

    // Usage
    vsBool wait();

    vsBool trywait();

    vsBool post();

    // Queries
    int getValue();

private:
    /* do not allow = */
    vsSemaphore& operator=(const vsSemaphore& ) { return *this; }

    SEM_T semaphore;
    int _value;
};


class vsMutex {
public:

    vsMutex(vsLock& lock_) : lock(lock_) { lock.lock(); }

    ~vsMutex() { lock.unlock(); }

private:
    vsLock& lock;
};


class vsBarrier {
public:

    // Creation and destruction
    vsBarrier(unsigned int level);

    ~vsBarrier();

    // Usage
    void enter();

private:
    vsLock lock;
    vsSemaphore sema;
    unsigned int entered, level;
};

#endif
