#ifndef __vsQueryType_h__
#define __vsQueryType_h__
/*
**  This work is held in copyright as an unpublished work by Silicon
**  Graphics, Inc. All rights reserved.
*/

#include <vizserver/vs.h>
#include <vizserver/vsporting/vsQueryType.h>
#include <assert.h>

#define vsFieldMask(_type)		(1<<(_type))

struct vsFieldTypes {
    enum Fields {
        Color          = 0,
        ColorLeft      = 0,
        ColorRight     = 1,
        Depth          = 2,
        DepthLeft      = 2,
        DepthRight     = 3,
        Count          = 4
    };

    enum Masks {
        Mask           = 0x0000ffff,
        ColorMask      = vsFieldMask(Color),
        ColorLeftMask  = vsFieldMask(ColorLeft),
        ColorRightMask = vsFieldMask(ColorRight),
        DepthMask      = vsFieldMask(Depth),
        DepthLeftMask  = vsFieldMask(DepthLeft),
        DepthRightMask = vsFieldMask(DepthRight),

        // compositor layer identifier (future)
        CompIDMask     = 0xffff0000,
        CompIDShift    = 16
    };
};

struct vsFieldPixelFormats {
    enum Format {
        // field pixel formats
        Index     = 1,
        L         = 2,
        LA        = 3,
        RGB       = 4,
        RGBA      = 5,
        Depth     = 6,
        ARGB      = 7,
        BGR       = 8,
        ABGR      = 9,
        BGRA      = 10
    };
        
    enum Masks {
        IndexMask = vsFieldMask(Index),
        LMask     = vsFieldMask(L),
        LAMask    = vsFieldMask(LA),
        RGBMask   = vsFieldMask(RGB),
        RGBAMask  = vsFieldMask(RGBA),
        DepthMask = vsFieldMask(Depth),
        ARGBMask  = vsFieldMask(ARGB),
        BGRMask   = vsFieldMask(BGR),
        ABGRMask  = vsFieldMask(ABGR),
        BGRAMask  = vsFieldMask(BGRA),

        AnyFormatMask = 0x000007fe
    };
};

struct vsFieldPixelTypes {
    enum Type {
        Byte                 = 2,
        UByte                = 3,
        Short                = 4,
        UShort               = 5,
        Int                  = 6,
        UInt                 = 7,
        Float                = 8,
        UByte_332            = 9,
        UShort_4444          = 10,
        UShort_5551          = 11,
        UInt_8888            = 12,
        UInt_10_10_10_2	     = 13,
        UShort_565           = 14
    }; 

    // for backward compatibility - not documented anymore
    enum LSBOrderBit {
        LSBLastBit           = 0,
        LSBFirstBit          = 1,
                
        LSBOrderShift        = 31                
    };        

    enum Masks {
        ByteMask             = vsFieldMask(Byte),
        UByteMask            = vsFieldMask(UByte),
        ShortMask            = vsFieldMask(Short),
        UShortMask           = vsFieldMask(UShort),
        IntMask	             = vsFieldMask(Int),
        UIntMask             = vsFieldMask(UInt),
        FloatMask            = vsFieldMask(Float),
        UByte_332_Mask	     = vsFieldMask(UByte_332),
        UShort_4444_Mask     = vsFieldMask(UShort_4444),
        UShort_5551_Mask     = vsFieldMask(UShort_5551),
        UInt_8888_Mask       = vsFieldMask(UInt_8888),
        UInt_10_10_10_2_Mask = vsFieldMask(UInt_10_10_10_2),
        UShort_565_Mask      = vsFieldMask(UShort_565),
        
        // for backward compatibility
        PixelTypeMask        = ~(vsFieldMask(LSBOrderShift)),
        LSBOrderMask         = vsFieldMask(LSBOrderShift)
    };
};

struct vsCompressorModuleTypes {
    enum Type {
        // types for compression implementation information
        ThreadSafe   = 0x1,
        ThreadUnsafe = 0x2,
        InterFrame   = 0x4
    };
    enum Capabilities {
        CompressFlipImage       = 0x100,
        CompressScanLinePadding = 0x200,
        CompressAllCapabilities = 0x300,

        ExpandFlipImage       = 0x1000,
        ExpandScanLinePadding = 0x2000,
        ExpandAllCapabilities = 0x3000
    };
};

/*These are the base accessor types for query containers.
  NameAccessor and BaseAccessor are the only supported ones
  at the moment. 
*/
 
struct vsQueryTypes {
    enum Base {
        BaseAccessor      = 0x00000000,
        NameAccessor      = 0x00000001,
        ArrayAccessor     = 0x00000002,
        NameArrayAccessor = 0x00000003
    };
};

/* These are the compression related query types.  The class
   names for the actual object are simple found be prepending
   a "vs" in front of the type name. 
*/
    
struct vsCmprQueryTypes {
    enum QueryParams {
        NoQueryParam     = 0x00000000,
        FrameInfo        = 0x00001010,
        FrameData        = 0x00001011,
        FramePacking     = 0x00001012
    };

    enum QueryMessages {
        NoQueryMessage   = 0x00000000,
        StreamMessage    = 0x00001020
    };
};

struct vsParamTypes {
    enum Base {
        NoParam          = 0x00000000,
        CmprParam        = 0x00001101,
        CmprQueryParam   = 0x00001102,				
        CmprQueryMessage = 0x00001103
    };
};		

struct vsCmprParamTypes {
    enum AllParams {
        NoParam             = 0x00000000,
        FieldInfoParam      = 0x00001101,
        FieldDataParam      = 0x00001102,
        FieldPackingParam   = 0x00001104,
        FrameInfoParam      = 0x00001010,
        FrameDataParam      = 0x00001011,
        FramePackingParam   = 0x00001012,
        StreamMessageParam  = 0x00001020
    };
    
    enum FieldParams {
        NoFieldParam   = 0x00000000,
        FieldInfo      = 0x00001101,
        FieldData      = 0x00001102,
        FieldPacking   = 0x00001104
    };

    enum QueryParams {
        NoQueryParam   = 0x00000000,
        FrameInfo      = 0x00001010,
        FrameData      = 0x00001011,
        FramePacking   = 0x00001104
    };

    enum QueryMessages {
        NoQueryMessage = 0x00000000,
        StreamMessage  = 0x00001020
    };	
};
		
struct vsStreamMessageParams {
    enum Base {
        FrameInfo = vsCmprParamTypes::FrameInfo		
    };
};

struct vsFrameInfoParams {
    enum Base {
        FieldInfo = vsCmprParamTypes::FieldInfo
    };
};

struct vsFrameDataParams {
    enum Base {
        FieldData = vsCmprParamTypes::FieldData
    };
};

	
		
class vsParamTypeCls;

// Query types are container interfaces.  They hold other query types and param
// types. They hold specific methods of access, useful for accessing parameters
	
class vsQueryTypeBaseCls {
public:
    virtual vsBool isQueryTypeSupported(vsQueryTypes::Base name) const = 0;
    virtual ~vsQueryTypeBaseCls() { }
};


template <class QueryClass, class QueryTypeEnum>
class vsQueryTypeNameAccessorCls : public vsQueryTypeBaseCls {

public:
    virtual QueryClass getTypeName() const = 0;
    virtual vsStatus getParam(QueryTypeEnum name, vsParamTypeCls*& param) const = 0;
    virtual vsBool isParamPresent(QueryTypeEnum name) const = 0;
    virtual ~vsQueryTypeNameAccessorCls() { }
};

class vsParamTypeCls {
public:
    virtual vsBool isParamTypeSupported(vsParamTypes::Base name) const = 0;

    virtual ~vsParamTypeCls() { }
};

template <class ParamGroup>
class vsCmprParamTypeCls : public vsParamTypeCls {
public:
    virtual ParamGroup getParamName() const = 0;
    virtual ~vsCmprParamTypeCls() { }
};

typedef vsQueryTypes::Base vsQueryTypesBase;
typedef vsCmprQueryTypes::QueryParams vsCmprQueryTypesParams;
typedef vsCmprQueryTypes::QueryMessages vsCmprQueryTypesMessages;
typedef vsCmprParamTypes::QueryParams vsCmprParamTypesQueryParams;
typedef vsCmprParamTypes::QueryMessages vsCmprParamTypesQueryMessages;
typedef vsCmprParamTypes::FieldParams vsCmprParamTypesFieldParams;
typedef vsCmprParamTypes::AllParams vsCmprParamTypesBaseParams;
typedef vsParamTypes::Base vsParamTypesBase;

typedef vsQueryTypeNameAccessorCls<vsQueryTypesBase,vsCmprQueryTypesParams> 
        vsCmprInputQueryArg;
typedef vsQueryTypeNameAccessorCls<vsQueryTypesBase,vsCmprQueryTypesParams> 
        vsCmprOutputQueryArg;
typedef vsQueryTypeNameAccessorCls<vsQueryTypesBase,vsCmprParamTypesBaseParams> 
        vsCmprParamArg;

typedef vsCmprParamTypeCls<vsCmprParamTypesFieldParams> vsCmprParamType;
typedef vsCmprParamTypeCls<vsCmprParamTypesQueryParams> vsCmprQueryParamType;
typedef vsCmprParamTypeCls<vsCmprParamTypesQueryMessages> vsCmprQueryMessageType;

typedef vsQueryTypeNameAccessorCls<vsCmprQueryTypesParams,vsFieldTypes::Fields>
        vsCmprFieldNameFrameQueryType;
typedef vsQueryTypeNameAccessorCls<vsCmprQueryTypesMessages, vsCmprParamTypesQueryParams>
        vsCmprInfoMessageQueryType;

#endif
