#if 0
    Copyright 1999-2000, Silicon Graphics, Inc.
    ALL RIGHTS RESERVED

    UNPUBLISHED -- Rights reserved under the copyright laws of the United
    States.   Use of a copyright notice is precautionary only and does not
    imply publication or disclosure.

    U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
    Use, duplication or disclosure by the Government is subject to restrictions
    as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
    in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
    in similar or successor clauses in the FAR, or the DOD or NASA FAR
    Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
    2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.

    THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
    INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
    DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
    PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
    GRAPHICS, INC.
#endif

#ifndef __vsThread_h__
#define __vsThread_h__

#include <vizserver/vsporting/vsThread.h>

#include <vizserver/vs.h>

class vsThread {
public:

    typedef void Routine(void* arg);
    typedef unsigned int ID;
    typedef vsThreadKey Key;
	typedef void (*DataDestructor)(void*);

    // Creation and destruction
    vsThread();

    ~vsThread();

    // Usage
    vsStatus threadStart(Routine* entryPoint, void* arg);

    static ID getID();

    static void yield();

    static void threadExit();

    // Thread private data
    // XXX no key delete yet, too messy
    static vsStatus createKey(Key& key, DataDestructor destructor);

    static vsStatus setSpecific(Key key, void* data);

    static void* getSpecific(Key key);

    static unsigned int getNumProcessors();

    static int setMaxParallelThreads(unsigned int t 
        = getNumProcessors());
    
    static int getMaxParallelThreads(void);
    
    
    static void init();

    static vsBool hasPthreads()
	{ if (!threadInited) init(); return pthreadBasis; }
    
private:

	vsThreadHandle thread;
    vsBool created;

    static vsBool threadInited;
    static vsBool pthreadBasis;
};

#endif
