#ifdef LINUX
/*
**  This work is held in copyright as an unpublished work by Silicon
**  Graphics, Inc. All rights reserved.
*/

#include <sys/types.h>
#include <stdint.h>

#define _SC_NPROC_ONLN _SC_NPROCESSORS_ONLN

/* base system types */
#ifdef __ia64__
typedef long               int   int64_t;
typedef long      unsigned int  uint64_t;
#else
typedef long long          int   int64_t;
typedef long long unsigned int  uint64_t;
#endif

//typedef long               int   int32_t;
//typedef long      unsigned int  uint32_t;
typedef short              int   int16_t;
typedef short     unsigned int  uint16_t;

typedef           unsigned int    uint_t;
typedef short     unsigned int  ushort_t;
typedef           unsigned char  uchar_t;

typedef uint32_t in_addr_t;

typedef int vsSocket;

#define closesocket close

#define vsSlash '/'
#define vsEnvDel ':'

/* stdint.h contains the typedef for uint32_t */
#include <stdint.h>

/* some defines have different names on linux */
#define NGROUPS_UMAX NGROUPS_MAX

/* on irix, get_pid is a macro instead of a function, but getpid can
** still be substituted in. */
#define get_pid getpid

/* errno on linux is already the thread safe version */
#define oserror() errno

/* Prototypes */
extern uint32_t add_then_test32(uint32_t *, uint32_t);

#endif
