#ifndef WIN32
/*
**  This work is held in copyright as an unpublished work by Silicon
**  Graphics, Inc. All rights reserved.
*/
#include <sys/types.h>
#include <sys/param.h>
#include <netinet/in.h>
#include <unistd.h>
#ifndef MACINTOSH
#include <crypt.h>
#endif
#endif
#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <vizserver/vsAuth.h>

#define AUTH_MAGIC		0x6356
#define AUTH_VERSION		1
#define AUTH_TAG_USERNAME	1

class UnameAuth;
class UnameContext : public vsAuthContext {
public:
    UnameContext(const UnameAuth* auth);
    ~UnameContext();

    vsStatus init(const vsAuthFieldSet* fields);
    vsStatus init(const void* data, unsigned int length);

    vsStatus getAuthenticator(vsAuthData& data);
    vsStatus authenticate(const char* data, unsigned int length);
    vsStatus getUser(const vsAuthUser*& user);

private:
    const UnameAuth* auth;
    vsAuthData authenticator;
    vsAuthUser* user;
};


class UnameAuth : public vsAuth {
public:
    UnameAuth();
    ~UnameAuth();

    vsStatus createContext(const char* hostname, const char* service,
	    const vsAuthFieldSet* fields, vsAuthContext*& context) const;
    vsStatus createContext(const char* service, const void* data,
	    unsigned int length, vsAuthContext*& context) const;

protected:
    vsStatus addFields(vsAuthFieldSet*& fields) const;

};


vsAuthImplement(UnameAuth, "AUTH-USERNAME")


struct DataMsgHeader {
    ushort_t magic;
    ushort_t version;

    void serialize(char*& buf)
	{
	    ushort_t v = htons(magic);
	    memcpy(buf, &v, sizeof(v));
	    buf += sizeof(v);
	    v = htons(version);
	    memcpy(buf, &v, sizeof(v));
	    buf += sizeof(v);
	}
    void deserialize(const char*& buf)
	{
	    memcpy(&magic, buf, sizeof(magic));
	    magic = ntohs(magic);
	    buf += sizeof(magic);

	    memcpy(&version, buf, sizeof(version));
	    version = ntohs(version);
	    buf += sizeof(version);
	}
};


struct DataTagHeader {
    ushort_t tag;
    ushort_t length;

    void serialize(char*& buf)
	{
	    ushort_t v = htons(tag);
	    memcpy(buf, &v, sizeof(v));
	    buf += sizeof(v);

	    v = htons(length);
	    memcpy(buf, &v, sizeof(v));
	    buf += sizeof(v);
	}
    void deserialize(const char*& buf)
	{
	    memcpy(&tag, buf, sizeof(tag));
	    tag = ntohs(tag);
	    buf += sizeof(tag);

	    memcpy(&length, buf, sizeof(length));
	    length = ntohs(length);
	    buf += sizeof(length);
	}
};


UnameContext::UnameContext(const UnameAuth* auth_)
    : auth(auth_)
{
}


UnameContext::~UnameContext()
{
}


vsStatus
UnameContext::init(const vsAuthFieldSet* fields)
{
    vsAuthField* userField = NULL;

    for (int i = 0; i < fields->getFieldCount(); i++) {
	vsAuthField* f = fields->getField(i);
	if (strcmp(f->getName(), "User") == 0)
	    userField = f;
    }
    assert(userField);

    unsigned long len =
	sizeof(DataMsgHeader) +
	sizeof(DataTagHeader) +
		(userField->getValue() ? strlen(userField->getValue()) : 0);

    char* data = new char[len];
    char* dp = data;

    DataMsgHeader hdr;
    hdr.magic = AUTH_MAGIC;
    hdr.version = AUTH_VERSION;
    hdr.serialize(dp);

    DataTagHeader tag;
    tag.tag = AUTH_TAG_USERNAME;
    tag.length = userField->getValue() ?
	    (unsigned short)strlen(userField->getValue()) : 0;
    tag.serialize(dp);
    if (userField->getValue() && tag.length > 0) 
	memcpy(dp, userField->getValue(), tag.length);

#if !defined(WIN32) && !defined(MACINTOSH)   
    user = createUser(getuid());
#endif
    authenticator.init(data, (unsigned int)len);

    return vsErrNone;
}

vsStatus
UnameContext::init(const void* data, unsigned int length)
{
    const char* dp = (const char*)data;

    DataMsgHeader hdr;
    hdr.deserialize(dp);
    if (hdr.magic != AUTH_MAGIC || hdr.version != AUTH_VERSION)
	return vsErrAuth;

    char* userName = NULL;

    DataTagHeader tag;
    tag.deserialize(dp);

    if (tag.tag == AUTH_TAG_USERNAME) {
        if (tag.length > 0 && tag.length < 32) {
            userName = (char *)malloc(tag.length+1);
	    memcpy(userName, dp, tag.length);
	    userName[tag.length] = '\0';
	} else {
            return vsErrAuth;
        }
    } else {
        return vsErrAuth;
    }

    if (userName == NULL)
	return vsErrAuth;

    user = createUser(userName);
    if (user == NULL) {
        free (userName);
	return vsErrAuth;
    }

    free (userName);

    return vsErrNone;
}


vsStatus
UnameContext::getAuthenticator(vsAuthData& data)
{
    data = authenticator;
    return vsErrNone;
}


vsStatus
UnameContext::authenticate(const char* /*data*/, unsigned int /*length*/)
{
    return vsErrNone;
}


vsStatus
UnameContext::getUser(const vsAuthUser*& user_)
{
    if (user == NULL)
	return vsErrInval;

    user_ = user; 
    return vsErrNone;
}


UnameAuth::UnameAuth()
{
}


UnameAuth::~UnameAuth()
{
}


vsStatus
UnameAuth::createContext(const char* /*hostname*/, const char* /*service*/,
	const vsAuthFieldSet* fields, vsAuthContext*& context) const
{
    UnameContext* pc = new UnameContext(this);

    vsStatus sts;
    if ((sts = pc->init(fields)) != vsErrNone) {
	delete pc;
	return sts;
    }
    context = pc;
    return vsErrNone;
}


vsStatus
UnameAuth::createContext(const char* /*service*/, const void* data,
	unsigned int length, vsAuthContext*& context) const
{
    UnameContext* pc = new UnameContext(this);

    vsStatus sts;
    if ((sts = pc->init(data, length)) != vsErrNone) {
	delete pc;
	return sts;
    }
    context = pc;
    return vsErrNone;
}


vsStatus
UnameAuth::addFields(vsAuthFieldSet*& fieldSet) const
{
    char* name;
#if defined(WIN32)
	unsigned long nsize = 0;
	GetUserName( name, &nsize );
	name = new char[nsize];
	if( !GetUserName( name, &nsize ) )
	{
		free(name);
		name = NULL;
	}
#else
    struct passwd* pwd = getpwuid(getuid());
    if (pwd != NULL)
	{
		name = (char *)malloc((unsigned int)strlen(pwd->pw_name)+1);
		strcpy(name, pwd->pw_name);
    }
	else
		name = NULL;
#endif
    fieldSet->appendField(new vsAuthField("User", name));
    //fieldSet->appendField(new vsAuthField("Say something bad", NULL, TRUE));
    //fieldSet->appendField(new vsAuthField("Why to connect ?", "because..."));

    if (name != NULL)
      free (name);

    return vsAuth::addFields(fieldSet);
}
