#if 0
    Copyright 1999-2000, Silicon Graphics, Inc.
    ALL RIGHTS RESERVED

    UNPUBLISHED -- Rights reserved under the copyright laws of the United
    States.   Use of a copyright notice is precautionary only and does not
    imply publication or disclosure.

    U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
    Use, duplication or disclosure by the Government is subject to restrictions
    as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
    in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
    in similar or successor clauses in the FAR, or the DOD or NASA FAR
    Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
    2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.

    THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
    INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
    DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
    PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
    GRAPHICS, INC.
#endif

#include <vizserver/vs.h>
#include <vizserver/vsCompressor.h>
#include <vizserver/vsFrame.h>
#include <string.h>
#include <assert.h>
#include <stdio.h>

// The following is a simple implementation of a vsCompressor that
// can serve as the basis for more complex compressors. The bulk of
// the work is in the compress and expand code. As implemented, this
// compressor has no effect on the input. It simply copies the
// field to the compressed data buffer when compressing. Vice versa
// on decompress.
//
#define PARAMCAST (vsParamTypeCls*&)

class NOPCompressor : public vsCompressor {
public:
    //All compressors need this declaration
    vsCompressorDeclare

    virtual size_t getMaxCompressedSize(const vsCmprParamArg& fieldInfo);

    virtual size_t compress(const vsCmprInputQueryArg& input,
                                  vsCmprOutputQueryArg& output);

    virtual void expand(const vsCmprInputQueryArg& input,
                              vsCmprOutputQueryArg& output);

    virtual void receiveMessage(const vsCmprParamArg& /*msg*/) { };	
};


// This is the Compressor Info block required of all compressors
static NOPCompressor::Info nopInfo = {
    (char*)"NOP compressor",
    vsCompressorModuleTypes::ThreadSafe,		
    // The following is the set of supported input pixel formats/types
    vsFieldPixelFormats::RGBAMask,
    vsFieldPixelTypes::UByteMask,

    // The following iss the set of supported output pixel formats/types
    vsFieldPixelFormats::RGBAMask,
    vsFieldPixelTypes::UByteMask,
};


// This macro generates the code needed for the dynamic loading
// mechanism of OpenGL Vizserver.
vsCompressorImplement(NOPCompressor, &nopInfo, "NOP")


size_t
NOPCompressor::getMaxCompressedSize(const vsCmprParamArg& input)
{
    if (input.isParamPresent(vsCmprParamTypes::FieldInfoParam)){
        vsFieldInfo* info = NULL;
	if (input.getParam(vsCmprParamTypes::FieldInfoParam,PARAMCAST info) == vsErrNone) {
            if (info->getParamName() == vsCmprParamTypes::FieldInfo) {
                int bpp = vsFieldPixelBytes(info->getFormat(),info->getType());
                return info->getWidth()*info->getHeight()*bpp;
            }
        }
    }

    assert(!"nopCompressor::getMaxCompressedSize - isParamPresent failed");
    return 0;
}


size_t
NOPCompressor::compress(const vsCmprInputQueryArg& input,
                              vsCmprOutputQueryArg& output)
{
    vsFrameInfo* frameInfo;
    vsFrameData* frameData;
    vsFrameData* outFrameData;
    vsFieldInfo* inFieldInfo;
    vsFieldData* inFieldData;
    vsFieldData* outFieldData;

    vsStatus stsFrInfo = input.getParam(vsCmprQueryTypes::FrameInfo,
                                        PARAMCAST frameInfo);

    vsStatus stsFrData = input.getParam(vsCmprQueryTypes::FrameData,
                                        PARAMCAST frameData);

    vsStatus stsOutFrData = output.getParam(vsCmprQueryTypes::FrameData,
                                        PARAMCAST outFrameData);

    if ((stsFrInfo != vsErrNone) || 
        (stsFrData != vsErrNone) || 
        (stsOutFrData != vsErrNone)) {
        fprintf(stderr, "nopCompressor - couldn't retrieve FrameInfo " 
                        "and FrameData parameters.\n");
        return 0;
    }

    vsStatus stsInFInfo = frameInfo->getParam(vsFieldTypes::Color,
                                           PARAMCAST inFieldInfo);
    vsStatus stsInFData = frameData->getParam(vsFieldTypes::Color,
                                           PARAMCAST inFieldData);
    vsStatus stsOutFData = outFrameData->getParam(vsFieldTypes::Color,
                                           PARAMCAST outFieldData);

    if ((stsInFInfo != vsErrNone) || 
        (stsInFData != vsErrNone) || 
        (stsOutFData != vsErrNone)) {
        fprintf(stderr, "nopCompressor - couldn't retrieve FieldInfo "
                        "and FieldData parameters.\n");
        return 0;
    }

    int bpp = vsFieldPixelBytes(inFieldInfo->getFormat(), 
                                inFieldInfo->getType());

    int size = inFieldInfo->getWidth() * inFieldInfo->getHeight() * bpp;

    void *in = NULL, *out = NULL;
    inFieldData->getData(in);
    outFieldData->getData(out);

    // "compress" the data
    memcpy(out, in, size);

    return size;
}


void
NOPCompressor::expand(const vsCmprInputQueryArg& input,
                            vsCmprOutputQueryArg& output)
{
    vsFrameInfo* frameInfo;
    vsFrameData* frameData;
    vsFrameData* outFrameData;
    vsFieldInfo* inFieldInfo;
    vsFieldData* inFieldData;
    vsFieldData* outFieldData;

    vsStatus stsFrInfo = input.getParam(vsCmprQueryTypes::FrameInfo,
                                        PARAMCAST frameInfo);

    vsStatus stsFrData = input.getParam(vsCmprQueryTypes::FrameData,
                                        PARAMCAST frameData);

    vsStatus stsOutFrData = output.getParam(vsCmprQueryTypes::FrameData,
                                        PARAMCAST outFrameData);

    if ((stsFrInfo != vsErrNone) ||
        (stsFrData != vsErrNone) ||
        (stsOutFrData != vsErrNone)) {
        fprintf(stderr, "nopCompressor - couldn't retrieve FrameInfo "
                        "and FrameData parameters.\n");
        return;
    }

    vsStatus stsInFInfo = frameInfo->getParam(vsFieldTypes::Color,
                                           PARAMCAST inFieldInfo);
    vsStatus stsInFData = frameData->getParam(vsFieldTypes::Color,
                                           PARAMCAST inFieldData);
    vsStatus stsOutFData = outFrameData->getParam(vsFieldTypes::Color,
                                           PARAMCAST outFieldData);

    if ((stsInFInfo != vsErrNone) ||
        (stsInFData != vsErrNone) ||
        (stsOutFData != vsErrNone)) {
        fprintf(stderr, "nopCompressor - couldn't retrieve FieldInfo "
                        "and FieldData parameters.\n");
        return;
    }

    int bpp = vsFieldPixelBytes(inFieldInfo->getFormat(),
                                inFieldInfo->getType());

    int size = inFieldInfo->getWidth() * inFieldInfo->getHeight() * bpp;

    void *in = NULL, *out = NULL;
    inFieldData->getData(in);
    outFieldData->getData(out);

    // "decompress" the data
    memcpy(out, in, size);
}
