#ifndef lint
static char *uportid = "@(#)kd_mode.c	3.0 Microport Rev 2.3 10/1/87";
#endif

/*	uport!mike Tue Sep 22 15:46:29 PDT 1987
 *	Created. (changed kd_mode.c and kd_mode.h into kd_mode.c & kd_setup.c
 */

#include "sys/kd_mode.h"

/* these are the allowed modes to be requested */
int kd_numegamodes = 18;	/* includes hercmode */
int kd_numcgamodes = 8;
int kd_egahercmode = 17;
int kd_cgahercmode = 17;
int kd_extm = 2;	/* offset from basic to extended memory */
int kd_ecd = 0x13;	/* offset from basic to enhanced color display */

#define	USEBIOS	1	/* use BIOS listing as opposed to IBM tech ref. */

struct biosinitdata kd_egamode0 = { 40, 24, 8, 0x800,
    0x0B, 0x03, 0x00, 0x03,					/* sequencer */
    0x23,							/* misc */
    0x37, 0x27, 0x2D, 0x37, 0x31, 0x15, 0x04, 0x11, 		/* crt */
    0x00, 0x07, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00, 
    0xE1, 0x24, 0xC7, 0x14, 0x08, 0xE0, 0xF0, 0xA3, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11,	/* attr */
    0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x08, 0x00, 0x0F, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0E, 0x00, 0xFF	/* graph */
};

struct biosinitdata kd_egamode1 = { 40, 24, 8, 0x800,
    0x0B, 0x03, 0x00, 0x03,					/* sequencer */
    0x23,							/* misc */
    0x37, 0x27, 0x2D, 0x37, 0x31, 0x15, 0x04, 0x11,  		/* crt */
    0x00, 0x07, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00, 
    0xE1, 0x24, 0xC7, 0x14, 0x08, 0xE0, 0xF0, 0xA3, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11, /* attr */
    0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x08, 0x00, 0x0F, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0E, 0x00, 0xFF	/* graph */
};

struct biosinitdata kd_egamode2 = { 80, 24, 8, 0x1000,
    0x01, 0x03, 0x00, 0x03,					/* sequencer */
    0x23,							/* misc */
    0x70, 0x4F, 0x5C, 0x2F, 0x5F, 0x07, 0x04, 0x11,		/* crt */
    0x00, 0x07, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00, 
    0xE1, 0x24, 0xC7, 0x28, 0x08, 0xE0, 0xF0, 0xA3, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11,	/* attr */
    0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x08, 0x00, 0x0F, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0E, 0x00, 0xFF	/* graph */
};

struct biosinitdata kd_egamode3 = { 80, 24, 8, 0x1000,
    0x01, 0x03,  0x00,  0x03,					/* sequencer */
    0x23,							/* misc */
    0x70, 0x4F, 0x5C, 0x2F, 0x5F, 0x07, 0x04, 0x11, 		/* crt */
    0x00, 0x07, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00, 
    0xE1, 0x24, 0xC7, 0x28, 0x08, 0xE0, 0xF0, 0xA3, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11, /* attr */
    0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x08, 0x00, 0x0F, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0E, 0x00, 0xFF	/* graph */
};

struct biosinitdata kd_egamode4 = { 40, 24, 8, 0x4000,
    0x0B, 0x03, 0x00, 0x02,					/* sequencer */
    0x23,							/* misc */
    0x37, 0x27, 0x2D, 0x37, 0x30, 0x14, 0x04, 0x11, 		/* crt */
    0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xE1, 0x24, 0xC7, 0x14, 0x00, 0xE0, 0xF0, 0xA2, 0xFF,
    0x00, 0x13, 0x15, 0x17, 0x02, 0x04, 0x06, 0x07, 0x10, 0x11, /* attr */
    0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x01, 0x00, 0x03, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0F, 0x00, 0xFF	/* graph */
};

struct biosinitdata kd_egamode5 = { 40, 24, 8, 0x4000,
    0x0B, 0x03, 0x00, 0x02,					/* sequencer */
    0x23,							/* misc */
    0x37, 0x27, 0x2D, 0x37, 0x30, 0x14, 0x04, 0x11, 		/* crt */
    0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xE1, 0x24, 0xC7, 0x14, 0x00, 0xE0, 0xF0, 0xA2, 0xFF,
    0x00, 0x13, 0x15, 0x17, 0x02, 0x04, 0x06, 0x07, 0x10, 0x11, /* attr */
    0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x01, 0x00, 0x03, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0F, 0x00, 0xFF 	/* graph */
};

struct biosinitdata kd_egamode6 = { 80, 24, 8, 0x4000,
    0x01, 0x01, 0x00, 0x06,					/* sequencer */
    0x23,							/* misc */
    0x70, 0x4F, 0x59, 0x2D, 0x5E, 0x06, 0x04, 0x11, 		/* crt */
    0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xE0, 0x23, 0xC7, 0x28, 0x00, 0xDF, 0xEF, 0xC2, 0xFF,
    0x00, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,	/* attr */
#ifdef	USEBIOS
    0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x01, 0x00, 0x01, 0x00,
#else	/* use book */
    0x17, 0x17, 0x17, 0x17, 0x17, 0x18, 0x01, 0x00, 0x01, 0x00,
#endif
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x00, 0xFF	/* graph */
};

struct biosinitdata kd_egamode7 = { 80, 24, 14, 0x1000,
    0x00, 0x03, 0x00, 0x03,					/* sequencer */
    0xA6,							/* misc */
    0x60, 0x4F, 0x56, 0x3A, 0x51, 0x60, 0x70, 0x1F, 		/* crt */
    0x00, 0x0D, 0x0B, 0x0C, 0x00, 0x00, 0x00, 0x00,
    0x5E, 0x2E, 0x5D, 0x28, 0x0D, 0x5E, 0x6E, 0xA3, 0xFF,
    0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0x18, /* attr */
#ifdef	USEBIOS
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0E, 0x00, 0x0F, 0x08,
#else	/* use book */
    0x18, 0x18, 0x18, 0x18, 0x18, 0x17, 0x0E, 0x00, 0x0F, 0x00,
#endif
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0A, 0x00, 0xFF	/* graph */
};

struct biosinitdata kd_egamodeB = { 80, 24, 8, 0x1000,
    0x01, 0x04, 0x00, 0x07, 					/* sequencer */
    0x23,							/* misc */
    0x70, 0x4F, 0x5C, 0x2F, 0x5F, 0x07, 0x04, 0x11, 		/* crt */
    0x00, 0x07, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00,
    0xE1, 0x24, 0xC7, 0x28, 0x08, 0xE0, 0xF0, 0xA3, 0xFF,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* attr */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xFF 	/* graph */
};

struct biosinitdata kd_egamodeC = { 80, 24, 14, 0x1000,
    0x00, 0x04, 0x00, 0x07,					/* sequencer */
    0xA6,							/* misc */
    0x60, 0x4F, 0x56, 0x3A, 0x51, 0x60, 0x70, 0x1F, 		/* crt */
    0x00, 0x0D, 0x0B, 0x0C, 0x00, 0x00, 0x00, 0x00,
    0x5E, 0x2E, 0x5D, 0x28, 0x0D, 0x5E, 0x6E, 0xA3, 0xFF,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* attr */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x0F, 0x08,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xFF 	/* graph */
};

struct biosinitdata kd_egamodeD = { 40, 24, 8, 0x2000,
    0x0B, 0x0F, 0x00, 0x06,					/* sequencer */
    0x23,							/* misc */
    0x37, 0x27, 0x2D, 0x37, 0x30, 0x14, 0x04, 0x11, 		/* crt */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xE1, 0x24, 0xC7, 0x14, 0x00, 0xE0, 0xF0, 0xE3, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11, /* attr */
    0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x01, 0x00, 0x0F, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0F, 0xFF	/* graph */
};

struct biosinitdata kd_egamodeE = { 80, 24, 8, 0x4000,
    0x01, 0x0F, 0x00, 0x06,					/* sequencer */
    0x23,							/* misc */
#ifdef	USEBIOS
    0x70, 0x4F, 0x56, 0x2D, 0x5E, 0x06, 0x04, 0x11, 		/* crt */
#else	/* use book */
    0x70, 0x4F, 0x59, 0x2D, 0x5E, 0x06, 0x04, 0x11, 		/* crt */
#endif
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xE0, 0x23, 0xC7, 0x28, 0x00, 0xDF, 0xEF, 0xE3, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11, /* attr */
#ifdef	USEBIOS
    0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x01, 0x00, 0x0F, 0x00,
#else	/* use book */
    0x12, 0x13, 0x14, 0x15, 0x16, 0x00, 0x01, 0x00, 0x0F, 0x00,
#endif	
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0F, 0xFF	/* graph */
};

struct biosinitdata kd_egamodeF = { 80, 24, 14, 0x8000,
    0x05, 0x0F, 0x00, 0x00,					/* sequencer */
    0xA2,							/* misc */
    0x60, 0x4F, 0x56, 0x1A, 0x50, 0xE0, 0x70, 0x1F, 		/* crt */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x5E, 0x2E, 0x5D, 0x14, 0x0D, 0x5E, 0x6E, 0x8B, 0xFF,
    0x00, 0x08, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x08, /* attr */
    0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x0B, 0x00, 0x05, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x07, 0x0F, 0xFF	/* graph */
};

struct biosinitdata kd_egamode10 = { 80, 24, 14, 0x8000,
    0x05, 0x0F, 0x00, 0x00,					/* sequencer */
    0xA7,							/* misc */
    0x5B, 0x4F, 0x53, 0x17, 0x50, 0xBA, 0x6C, 0x1F, 		/* crt */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x5E, 0x2B, 0x5D, 0x14, 0x0F, 0x5F, 0x0A, 0x8B, 0xFF,
    0x00, 0x01, 0x00, 0x00, 0x04, 0x07, 0x00, 0x00, 0x00, 0x01, /* attr */
#ifdef	USEBIOS
    0x00, 0x00, 0x04, 0x07, 0x00, 0x00, 0x0B, 0x00, 0x05, 0x00,
#else	/* use book */
    0x00, 0x00, 0x04, 0x07, 0x00, 0x00, 0x01, 0x00, 0x05, 0x00,
#endif				/* USEBIOS */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x07, 0x0F, 0xFF	/* graph */
};

struct biosinitdata kd_egamodeMF = { 80, 24, 14, 0x8000,
    0x01, 0x0F, 0x00, 0x06, 					/* sequencer */
    0xA2,							/* misc */
    0x60, 0x4F, 0x56, 0x3A, 0x50, 0x60, 0x70, 0x1F, 		/* crt */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x5E, 0x2E, 0x5D, 0x28, 0x0D, 0x5E, 0x6E, 0xE3, 0xFF,
    0x00, 0x08, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x08, /* attr */
#ifdef	USEBIOS
    0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x0B, 0x00, 0x05, 0x00,
#else	/* use book */
    0x00, 0x00, 0x00, 0x18, 0x00, 0x3F, 0x0B, 0x00, 0x05, 0x00,
#endif	/* USEBIOS */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0F, 0xFF	/* graph */
};

struct biosinitdata kd_egamodeM10 = { 80, 24, 14, 0x8000,
    0x01, 0x0F, 0x00, 0x06,					/* sequencer */
    0xA7,							/* misc */
    0x5B, 0x4F, 0x53, 0x37, 0x52, 0x00, 0x6C, 0x1F, 		/* crt */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x5E, 0x2B, 0x5D, 0x28, 0x0F, 0x5F, 0x0A, 0xE3, 0xFF,
#ifdef	USEBIOS
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39, /* attr */
#else	/* use book */
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x38, 0x39,
#endif	/* USEBIOS */
    0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x01, 0x00, 0x0F, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0F, 0xFF	/* graph */
};

struct biosinitdata kd_egamodeE0 = { 40, 24, 14, 0x800,
    0x0B, 0x03, 0x00, 0x03,					/* sequencer */
    0xA7,							/* misc */
    0x2D, 0x27, 0x2B, 0x2D, 0x28, 0x6D, 0x6C, 0x1F,		/* crt */
    0x00, 0x0D, 0x0B, 0x0C, 0x00, 0x00, 0x00, 0x00,
    0x5E, 0x2B, 0x5D, 0x14, 0x0F, 0x5E, 0x0A, 0xA3, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,	/* attr */
    0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x08, 0x00, 0x0F, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0E, 0x00, 0xFF	/* graph */
};

struct biosinitdata kd_egamodeE1 = { 40, 24, 14, 0x800,
    0x0B, 0x03, 0x00, 0x03,					/* sequencer */
    0xA7,							/* misc */
    0x2D, 0x27, 0x2B, 0x2D, 0x28, 0x6D, 0x6C, 0x1F,		/* crt */
    0x00, 0x0D, 0x0B, 0x0C, 0x00, 0x00, 0x00, 0x00,
    0x5E, 0x2B, 0x5D, 0x14, 0x0F, 0x5E, 0x0A, 0xA3, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,	/* attr */
    0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x08, 0x00, 0x0F, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0E, 0x00, 0xFF	/* graph */
};

struct biosinitdata kd_egamodeE2 = { 80, 24, 14, 0x1000,
    0x01, 0x03, 0x00, 0x03,					/* sequencer */
    0xA7,							/* misc */
    0x5B, 0x4F, 0x53, 0x37, 0x51, 0x5B, 0x6C, 0x1F, 		/* crt */
    0x00, 0x0D, 0x0B, 0x0C, 0x00, 0x00, 0x00, 0x00,
    0x5E, 0x2B, 0x5D, 0x28, 0x0F, 0x5E, 0x0A, 0xA3, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
    0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x08, 0x00, 0x0F, 0x00,	/* attr */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0E, 0x00, 0xFF 	/* graph */
};

struct biosinitdata kd_egamodeE3 = { 80, 24, 14, 0x1000,
    0x01, 0x03, 0x00, 0x03,					/* sequencer */
    0xA7,							/* misc */
    0x5B, 0x4F, 0x53, 0x37, 0x51, 0x5B, 0x6C, 0x1F, 		/* crt */
    0x00, 0x0D, 0x0B, 0x0C, 0x00, 0x00, 0x00, 0x00,
    0x5E, 0x2B, 0x5D, 0x28, 0x0F, 0x5E, 0x0A, 0xA3, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,	/* attr */
    0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x08, 0x00, 0x0F, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0E,  0x00, 0xFF	/* graph */
};

struct biosinitdata kd_egamodeHERC = {  80, 24, 14, 0x8000,
    0x01, 0x0F, 0x00, 0x06,					/* sequencer */
    0xA7,							/* misc */
    0x5B, 0x4F, 0x53, 0x37, 0x51, 0x5B, 0x6C, 0x1F,		/* crt */
    0x00, 0x0D, 0x0B, 0x0C, 0x00, 0x00, 0x00, 0x00,
    0x5E, 0x2B, 0x5D, 0x28, 0x0F, 0x5E, 0x0A, 0xA3, 0xFF,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39, /* attr */
    0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x08, 0x00, 0x0F, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0F, 0xFF	/* graph */
};

struct biosinitdata *kd_egamodes [] = {
    &kd_egamode0,			/* mode 0 - cga 40x24 */
    &kd_egamode1,			/* mode 1 - cga 40x24 */
    &kd_egamode2,			/* mode 2 - cga 80x24 */
    &kd_egamode3,			/* mode 3 - cga 80x24 */
    &kd_egamode4,			/* mode 4 - cga graph */
    &kd_egamode5,			/* mode 5 - cga graph */
    &kd_egamode6,			/* mode 6 - cga graph */
    &kd_egamode7,			/* mode 7 - mono */
    (struct biosinitdata *) 0,		/* mode 8 - not used */
    (struct biosinitdata *) 0,		/* mode 9 - not used */
    (struct biosinitdata *) 0,		/* mode A - not used */
    &kd_egamodeB,			/* mode B - initialize 1 */
    &kd_egamodeC,			/* mode C - initialize 2 */
    &kd_egamodeD,			/* mode D - mono */
    &kd_egamodeE,			/* mode E - mono */
    &kd_egamodeF,			/* mode F - mono */
    &kd_egamode10,			/* mode 10 - mono */
    &kd_egamodeMF,			/* mode 11 - mode F  > 16k */
    &kd_egamodeM10,			/* mode 12 - mode 10 > 16k */
    &kd_egamodeE0,			/* mode 13 - mode 0 ECD */
    &kd_egamodeE1,			/* mode 14 - mode 1 ECD */
    &kd_egamodeE2,			/* mode 15 - mode 2 ECD */
    &kd_egamodeE3,			/* mode 16 - mode 3 ECD */
    &kd_egamodeHERC			/* mode 17 - HERC */
};

unsigned char cga40_crtc [CGA_NUMCTLREGS] = {	
	0x38,0x28,0x2d,0x0A,0x1F,0x06,0x19,	/* mode 0 */
	0x1C,0x02,0x07,0x06,0x07,		/* 40x25 mode on a color card */
	0x00,0x00,0x00,0x00
};

unsigned char cga80_crtc [CGA_NUMCTLREGS] = {	
	0x71,0x50,0x5A,0x0A,0x1F,0x06,0x19,	/* mode 2 */
	0x1C,0x02,0x07,0x06,0x07,		/* 80x25 mode on a color card */
	0x00,0x00,0x00,0x00
};

unsigned char cgagfx_crtc [CGA_NUMCTLREGS] = {
	0x38,0x28,0x2d,0x0A,0x7F,0x06,0x64,	/* modes 4, 5, and 6 */
	0x70,0x02,0x01,0x00,0x00,		/* bit-mapped mode on a cga */
	0x00,0x00,0x00,0x00
};

unsigned char ma_crtc [CGA_NUMCTLREGS] = {	/* mode 7: 80x25 on mono card */
	0x61,0x50,0x52,0x0F,0x19,0x06,0x19,
	0x19,0x02,0x0D,0x0B,0x0C,
	0x00,0x00,0x00,0x00
};

/* Initialization values for each of the CGA modes */
unsigned char *cga_crtc [] = {
    cga40_crtc,  cga40_crtc,  cga80_crtc,  cga80_crtc,
    cgagfx_crtc, cgagfx_crtc, cgagfx_crtc, ma_crtc
};

unsigned char herc_crtc [CGA_NUMCTLREGS] = { /* mode 12: herc bit-map on mono */
    0x35,0x2d,0x2e,7,0x5b,2,0x57,0x57,2,3,0,0,0,0,0,0
};

int cga_mode [] = {		/* mode reg values for modes */
#ifndef	ATMERGE
    0x2C, 0x28, 0x2D, 0x29, 0x2A, 0x2E, 0x1E, 0x29,	/*  0.. 7 */
#else
    0x2C, 0x28, 0x2D, 0x29, 0x2E, 0x2A, 0x1E, 0x29,
#endif
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/*  8.. F */
    0x00, 0x00, 0x00, 0x2C, 0x28, 0x2D, 0x29, 0x0B	/* 10..17 */
};
int sw_mode [] = {	  /* modes to step through for DOS screen */
    0x2C, 0x28, 0x2D, 0x29, 0x2E, 0x2A, 0x1E
};
#define	SWMODES (sizeof(sw_mode)/sizeof(int))

/* Change this, code CGA & EGA attrs separately and interpret for CGA & EGA */
int cga_colr [] = {			/* color reg values for modes */
    0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x00,	/*  0.. 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/*  8.. F */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00	/* 10..17 */
};

/* === */
