/*REXX*/
/*
 *  Command line wrapper to set up the Qt environment
 *  Generated on 18 May 2006 15:31:07
 */

QMAKESPEC   = 'os2-g++'
QTDIR       = '/DEV/qt/trunk'

GCC_PATH        = 'u:\usr'

trace off
address 'cmd'
'@echo off'
'set EMXOMFLD_TYPE=VAC308'
if (RxFuncQuery('SysBootDrive')) then do
    call RxFuncAdd 'SysBootDrive', 'RexxUtil', 'SysBootDrive'
    call RxFuncAdd 'SysSetPriority', 'RexxUtil', 'SysSetPriority'
end

/* determine the default DEBUG value using .qtos2config */
DEBUG = 0
do while (lines(QTDIR'\.qtos2config') > 0)
    line = strip(linein(QTDIR'\.qtos2config'))
    if (word(line, 1) == 'CONFIG') then
        if (wordpos('debug', line, 3) > 0) then DEBUG = 1
end

/* parse command line */
parse arg arg1 args
arg1 = translate(arg1)
if (arg1 == 'D' | arg1 == 'DEBUG') then DEBUG = 1
else if (arg1 == 'R' | arg1 == 'RELEASE') then DEBUG = 0
else parse arg args

/* setup the GCC environment */
/*'call' GCC_PATH'\bin\gccenv.cmd' GCC_PATH 'VAC308'*/

call value 'QMAKESPEC', QMAKESPEC, 'OS2ENVIRONMENT'
call value 'QTDIR', QTDIR, 'OS2ENVIRONMENT'

if (\DEBUG) then do
    /* releae versions come first */
    call AddPathEnv 'PATH', QTDIR'\bin'
    call AddPathEnv 'PATH', QTDIR'\bin\debug'
    call AddPathEnv 'BEGINLIBPATH', QTDIR'\bin'
    call AddPathEnv 'BEGINLIBPATH', QTDIR'\bin\debug'
end
else do
    /* debug versions come first */
    call AddPathEnv 'PATH', QTDIR'\bin\debug'
    call AddPathEnv 'PATH', QTDIR'\bin'
    call AddPathEnv 'BEGINLIBPATH', QTDIR'\bin\debug'
    call AddPathEnv 'BEGINLIBPATH', QTDIR'\bin'
end

call value 'MAKESHELL', SysBootDrive()'\os2\cmd.exe', 'OS2ENVIRONMENT'

call AddPathEnv 'PATH','u:\moztools', 1
call AddPathEnv 'PATH','u:\qtilink', 1
call AddPathEnv 'BEGINLIBPATH','u:\moztools', 1
call AddPathEnv 'BEGINLIBPATH','u:\qtilink', 1

/*
 * set this to allow for direct linking with DLLs
 * without first making import libraries
 */
call AddPathEnv 'LIBRARY_PATH', SysBootDrive()'\OS2\DLL'
call AddPathEnv 'LIBRARY_PATH', SysBootDrive()'\MPTN\DLL'

/*
 * set our our priority class to IDLE so prevent GCC from eating
 * 100% of CPU load on single-processor machines
 */
call SysSetPriority 1, 0

/* pass arguments to the command shell */
'cmd /c' args
exit rc


/* some useful stuff */

AddPathVar: procedure expose (Globals)
    parse arg name, path, prepend, environment
    if (path == '') then return
    if (verify(path, ' +', 'M') > 0) then path = '"'path'"'
    prepend = (prepend == 1)
    os2Env = (translate(environment) == 'OS2ENVIRONMENT')
    if (os2Env) then do
        extLibPath = (translate(name) == 'BEGINLIBPATH' | translate(name) == 'ENDLIBPATH')
        if (extLibPath) then cur = SysQueryExtLibPath(left(name, 1))
        else cur = value(name,, environment)
    end
    else cur = value(name)
    l = length(path)
    p = pos(translate(path), translate(cur))
    cb = ''; ca = ''
    found = (p > 0)
    if (found) then do
        if (p > 1) then cb = substr(cur, p - 1, 1)
        if (p + l <= length(cur)) then ca = substr(cur, p + l, 1)
        found = (cb == '' | cb == ';') & (ca == '' | ca == ';')
    end
    if (found) then do
        if (\prepend) then return
        if (ca == ';') then l = l + 1
        cur = delstr(cur, p, l)
    end
    if (prepend) then do
        if (left(cur, 1) \== ';') then cur = ';'cur
        cur = path||cur
    end
    else do
        if (cur \== '' & right(cur, 1) \== ';') then cur = cur';'
        cur = cur||path
    end
    if (os2Env) then do
        if (extLibPath) then call SysSetExtLibPath cur, left(name, 1)
        else call value name, cur, environment
    end
    else call value name, cur
    return
AddPathEnv: procedure expose (Globals)
    parse arg name, path, prepend
    call AddPathVar name, path, prepend, 'OS2ENVIRONMENT'
    return

